/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.Gameplay.GameScreen;
import com.HUD.Base.Font;
import com.HUD.Base.Keyboard;
import com.HUD.Base.TextView;
import com.HUD.MyCanvas.MyCanvas;
import com.Rendering.Fps;
import com.Rendering.Graphics3D;
import com.Rendering.Meshes.Mesh;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;

public class DialogScreen
extends MyCanvas {
    private Graphics3D g3d;
    private TextView textView;
    private Keyboard keyboard = new Keyboard(this);
    private Main main;
    private GameScreen gs;
    private int index = 0;
    private String[] dialog;
    private boolean scrollDown = false;
    private boolean scrollUp = false;

    public DialogScreen(Font font, Graphics3D g3d, Main main, GameScreen gs) {
        this.g3d = g3d;
        this.main = main;
        this.gs = gs;
    }

    public DialogScreen(String text, Font font, Graphics3D g3d, Main main, GameScreen gs) {
        this.set(text, font, g3d, main, gs);
    }

    public void set(String text, Font font, Graphics3D g3d, Main main, GameScreen gs) {
        this.keyboard.reset();
        this.g3d = g3d;
        this.main = main;
        this.gs = gs;
        this.index = 0;
        this.dialog = Mesh.cutOnStrings(text, '@');
        for (int i = 0; i < this.dialog.length; ++i) {
            String s = this.dialog[i];
            if (s.charAt(0) == '\n') {
                s = s.substring(1, s.length());
            }
            if (s.charAt(s.length() - 1) == '\n') {
                s = s.substring(0, s.length() - 1);
            }
            this.dialog[i] = s;
        }
        int h = (int)((float)this.getHeight() / 3.5f);
        if (h < font.height() * 3) {
            h = font.height() * 3;
        }
        this.textView = new TextView(this.dialog[0], g3d.getWidth() - 20, h, font);
    }

    protected final void keyReleased(int keyCode) {
        if (keyCode == this.keyboard.SOFT_LEFT) {
            this.keyboard.keyReleased(this.keyboard.FIRE);
            return;
        }
        this.keyboard.keyReleased(keyCode);
    }

    protected final void keyPressed(int keyCode) {
        if (keyCode == this.keyboard.SOFT_LEFT) {
            this.keyboard.keyPressed(this.keyboard.FIRE);
            return;
        }
        this.keyboard.keyPressed(keyCode);
    }

    protected final void mousePressed(int x, int y) {
        this.keyboard.keyPressed(this.keyboard.FIRE);
    }

    protected final void mouseReleased(int x, int y) {
        this.keyboard.keyReleased(this.keyboard.FIRE);
    }

    protected final void mouseScrollUp() {
        this.scrollUp = true;
    }

    protected final void mouseScrollDown() {
        this.scrollDown = true;
    }

    private boolean nextText() {
        if (this.index + 1 < this.dialog.length) {
            ++this.index;
            this.textView.setString(this.dialog[this.index]);
            this.textView.setY(0);
            return true;
        }
        return false;
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int sy = this.getHeight() / 2 - this.g3d.getnHeight() / 2;
        g.setColor(255, 255, 255);
        this.g3d.flush(g, 0, sy);
        int x = (this.getWidth() - this.textView.getWidth()) / 2;
        int y = this.getHeight() - this.textView.getHeight() - Main.bcks.getHeight() - 4;
        Main.drawBckDialog(g, y, this.textView.getHeight() + y);
        this.textView.paint(g, x, y);
        if (this.textView.getTextHeight() > this.textView.getHeight()) {
            g.setColor(0);
            g.fillTriangle(this.getWidth() - 14, y + this.textView.getHeight() - 14, this.getWidth(), y + this.textView.getHeight() - 14, this.getWidth() - 5, y + this.textView.getHeight());
            g.setColor(255, 255, 255);
            g.fillTriangle(this.getWidth() - 12, y + this.textView.getHeight() - 12, this.getWidth() - 2, y + this.textView.getHeight() - 12, this.getWidth() - 7, y + this.textView.getHeight() - 2);
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.step();
    }

    private void step() {
        if (this.keyboard.down()) {
            this.textView.move(-3);
        }
        if (this.keyboard.up()) {
            this.textView.move(3);
        }
        if (this.scrollDown) {
            this.textView.move(-7);
        }
        if (this.scrollUp) {
            this.textView.move(7);
        }
        this.scrollDown = false;
        this.scrollUp = false;
        if (this.keyboard.fire()) {
            this.keyboard.reset();
            if (!this.nextText()) {
                this.gs.start();
                this.gs.paused = false;
                Fps.reset();
                Main.setCurrent(this.gs);
                Fps.reset();
                return;
            }
        }
        this.repaint();
    }
}

