/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.Collision.Height;
import code.Collision.HeightComputer;
import code.Collision.Ray;
import code.Collision.RayCast;
import code.Collision.SphereCast;
import code.Gameplay.Map.Light;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.RoomObject;
import code.HUD.DeveloperMenu;
import code.Math.MathUtils2;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.BoundingBox;
import code.Rendering.Meshes.ColorLightedPolygon3V;
import code.Rendering.Meshes.ColorLightedPolygon4V;
import code.Rendering.Meshes.LightedPolygon3V;
import code.Rendering.Meshes.LightedPolygon4V;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.MultyTexture;
import code.Rendering.RenderObject;
import code.Rendering.Vertex;
import code.utils.Main;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Room {
    private final int id;
    private final int rid;
    private Mesh[][] mesh;
    private BoundingBox[][] bbmesh;
    public Mesh fullMesh = null;
    private Mesh[][] renderMesh;
    private BoundingBox[][] bbrenderMesh;
    private final int minx;
    private final int maxx;
    private final int minz;
    private final int maxz;
    private final int miny;
    private final int maxy;
    private boolean openSky;
    private Portal[] portals;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public String[] stepSound = null;
    public String jumpSound = null;
    public static int chunkSize;
    public static int chunkSizeRender;
    public String reverb;
    private Vector objects = new Vector();
    public Light[] lights;

    public Room(Mesh meshs, int id) {
        Object[] tmp;
        this.rid = id;
        this.id = id;
        this.minx = meshs.minX();
        this.maxx = meshs.maxX();
        this.minz = meshs.minZ();
        this.maxz = meshs.maxZ();
        this.miny = meshs.minY();
        this.maxy = meshs.maxY();
        this.fullMesh = meshs;
        if (chunkSize > 0) {
            tmp = this.cut(meshs, chunkSize, false);
            this.mesh = (Mesh[][])tmp[0];
            this.bbmesh = (BoundingBox[][])tmp[1];
        }
        if (chunkSizeRender > 0) {
            tmp = this.cut(meshs, chunkSizeRender, true);
            this.renderMesh = (Mesh[][])tmp[0];
            this.bbrenderMesh = (BoundingBox[][])tmp[1];
            if (this.renderMesh.length <= 2 || this.renderMesh[0].length <= 2) {
                this.renderMesh = null;
                this.bbrenderMesh = null;
            }
        }
        this.openSky = this.openSkyTest();
    }

    private Object[] cut(Mesh mesh, int size, boolean dontCopyUsed) {
        int minxx = this.minx;
        int maxxx = this.maxx;
        int minzz = this.minz;
        int maxzz = this.maxz;
        maxxx -= minxx;
        maxzz -= minzz;
        minzz = 0;
        minxx = 0;
        int sizex = maxxx - minxx;
        int sizez = maxzz - minzz;
        int mapw = sizex / size + 1;
        int maph = sizez / size + 1;
        Mesh[][] map = new Mesh[mapw][maph];
        BoundingBox[][] bbmap = new BoundingBox[mapw][maph];
        Object[] out = new Object[]{map, bbmap};
        Vector bufVer = new Vector(mesh.getVertices().length);
        Vector bufPol = new Vector(mesh.getPolygons().length);
        int[] polsCount = new int[]{mesh.getPolygons().length};
        RenderObject[] pols = new RenderObject[polsCount[0]];
        System.arraycopy(mesh.getPolygons(), 0, pols, 0, pols.length);
        Vertex[] verts = mesh.getVertices();
        for (int i = 0; i < verts.length; ++i) {
            verts[i].rz = -1;
        }
        for (int z = 0; z < maph; ++z) {
            for (int x = 0; x < mapw; ++x) {
                for (int i = bufVer.size() - 1; i >= 0; --i) {
                    ((Vertex)bufVer.elementAt((int)i)).rz = -1;
                }
                bufVer.removeAllElements();
                bufPol.removeAllElements();
                Room.getPolygonsInSquare(x * size + this.minx, z * size + this.minz, size, pols, bufVer, bufPol, polsCount, dontCopyUsed);
                Object[] nVertexs = new Vertex[bufVer.size()];
                bufVer.copyInto(nVertexs);
                Object[] nPolygons = new RenderObject[bufPol.size()];
                bufPol.copyInto(nPolygons);
                map[x][z] = new Mesh((Vertex[])nVertexs, (RenderObject[])nPolygons);
                map[x][z].setTexture(mesh.getTexture());
                bbmap[x][z] = new BoundingBox(map[x][z]);
            }
        }
        return out;
    }

    private static void getPolygonsInSquare(int x1, int z1, int size, RenderObject[] polygons, Vector putVer, Vector putPol, int[] polsCountArr, boolean dontCopyUsed) {
        int polsCount = polsCountArr[0];
        for (int i = 0; i < polsCount; ++i) {
            RenderObject pol;
            RenderObject el = polygons[i];
            if (!Room.ifItersectsSquare(el, x1, z1, size)) continue;
            if (dontCopyUsed || Room.ifInsideSquare(el, x1, z1, size)) {
                polygons[i] = polygons[polsCount - 1];
                polygons[polsCount - 1] = el;
                --polsCount;
                --i;
            }
            putPol.addElement(el);
            if (el instanceof Polygon4V) {
                pol = (Polygon4V)el;
                if (pol.a.rz == -1) {
                    pol.a.rz = 1;
                    putVer.addElement(pol.a);
                }
                if (pol.b.rz == -1) {
                    pol.b.rz = 1;
                    putVer.addElement(pol.b);
                }
                if (pol.c.rz == -1) {
                    pol.c.rz = 1;
                    putVer.addElement(pol.c);
                }
                if (pol.d.rz != -1) continue;
                pol.d.rz = 1;
                putVer.addElement(pol.d);
                continue;
            }
            if (!(el instanceof Polygon3V)) continue;
            pol = (Polygon3V)el;
            if (((Polygon3V)pol).a.rz == -1) {
                ((Polygon3V)pol).a.rz = 1;
                putVer.addElement(((Polygon3V)pol).a);
            }
            if (((Polygon3V)pol).b.rz == -1) {
                ((Polygon3V)pol).b.rz = 1;
                putVer.addElement(((Polygon3V)pol).b);
            }
            if (((Polygon3V)pol).c.rz != -1) continue;
            ((Polygon3V)pol).c.rz = 1;
            putVer.addElement(((Polygon3V)pol).c);
        }
        polsCountArr[0] = polsCount;
    }

    private static boolean ifItersectsSquare(RenderObject el, int x, int z, int size) {
        if (el instanceof Polygon4V) {
            Polygon4V pol = (Polygon4V)el;
            int minx = Math.min(pol.a.x, Math.min(pol.b.x, Math.min(pol.c.x, pol.d.x)));
            int minz = Math.min(pol.a.z, Math.min(pol.b.z, Math.min(pol.c.z, pol.d.z)));
            int maxx = Math.max(pol.a.x, Math.max(pol.b.x, Math.max(pol.c.x, pol.d.x)));
            int maxz = Math.max(pol.a.z, Math.max(pol.b.z, Math.max(pol.c.z, pol.d.z)));
            return Room.ifItersectsSquare(x, z, size, minx, minz, maxx, maxz);
        }
        if (el instanceof Polygon3V) {
            Polygon3V pol = (Polygon3V)el;
            int minx = Math.min(pol.a.x, Math.min(pol.b.x, pol.c.x));
            int minz = Math.min(pol.a.z, Math.min(pol.b.z, pol.c.z));
            int maxx = Math.max(pol.a.x, Math.max(pol.b.x, pol.c.x));
            int maxz = Math.max(pol.a.z, Math.max(pol.b.z, pol.c.z));
            return Room.ifItersectsSquare(x, z, size, minx, minz, maxx, maxz);
        }
        return false;
    }

    private static boolean ifInsideSquare(RenderObject el, int x, int z, int size) {
        if (el instanceof Polygon4V) {
            Polygon4V pol = (Polygon4V)el;
            int minx = Math.min(pol.a.x, Math.min(pol.b.x, Math.min(pol.c.x, pol.d.x)));
            int minz = Math.min(pol.a.z, Math.min(pol.b.z, Math.min(pol.c.z, pol.d.z)));
            int maxx = Math.max(pol.a.x, Math.max(pol.b.x, Math.max(pol.c.x, pol.d.x)));
            int maxz = Math.max(pol.a.z, Math.max(pol.b.z, Math.max(pol.c.z, pol.d.z)));
            return Room.ifInsideSquare(x, z, size, minx, minz, maxx, maxz);
        }
        if (el instanceof Polygon3V) {
            Polygon3V pol = (Polygon3V)el;
            int minx = Math.min(pol.a.x, Math.min(pol.b.x, pol.c.x));
            int minz = Math.min(pol.a.z, Math.min(pol.b.z, pol.c.z));
            int maxx = Math.max(pol.a.x, Math.max(pol.b.x, pol.c.x));
            int maxz = Math.max(pol.a.z, Math.max(pol.b.z, pol.c.z));
            return Room.ifInsideSquare(x, z, size, minx, minz, maxx, maxz);
        }
        return false;
    }

    private static boolean ifItersectsSquare(int x, int z, int size, int minx, int minz, int maxx, int maxz) {
        return minx <= x + size && minz <= z + size && maxx >= x && maxz >= z;
    }

    private static boolean ifInsideSquare(int x, int z, int size, int minx, int minz, int maxx, int maxz) {
        return minx > x && minz > z && maxx < x + size && maxz < z + size;
    }

    private boolean openSkyTest() {
        int cx = (this.maxx + this.minx) / 2;
        int cz = (this.maxz + this.minz) / 2;
        int cy = (this.maxy * 2 + this.miny * 4) / 6;
        Mesh testMesh = this.fullMesh;
        if (this.mesh != null) {
            int xx = (cx - this.minx) / chunkSize;
            int zz = (cz - this.minz) / chunkSize;
            if (xx >= this.mesh.length || xx < 0) {
                return true;
            }
            if (zz >= this.mesh[0].length || zz < 0) {
                return true;
            }
            testMesh = this.mesh[xx][zz];
        }
        RenderObject[] pols = testMesh.getPolygons();
        for (int i = 0; i < pols.length; ++i) {
            RenderObject pol;
            RenderObject obj = pols[i];
            if (!Room.isPointOnPolygon(cx, cz, obj) || obj.ny <= 2048) continue;
            int centerY = 0;
            if (obj instanceof Polygon4V) {
                pol = (Polygon4V)obj;
                centerY = (pol.a.y + pol.b.y + pol.c.y + pol.d.y) / 4;
            } else if (obj instanceof Polygon3V) {
                pol = (Polygon3V)obj;
                centerY = (((Polygon3V)pol).a.y + ((Polygon3V)pol).b.y + ((Polygon3V)pol).c.y) / 3;
            }
            if (cy > centerY) continue;
            return false;
        }
        return true;
    }

    public final void destroy() {
        this.mesh = null;
        this.fullMesh = null;
        this.bbmesh = null;
        this.renderMesh = null;
        this.bbrenderMesh = null;
        if (this.portals != null) {
            for (int var1 = 0; var1 < this.portals.length; ++var1) {
                this.portals[var1].destroy();
                this.portals[var1] = null;
            }
        }
        this.portals = null;
    }

    public final void setPortals(Portal[] portals) {
        this.portals = portals;
    }

    public final void addPortal(Portal portal) {
        Portal[] ports = new Portal[this.portals.length + 1];
        for (int i = 0; i < this.portals.length; ++i) {
            ports[i] = this.portals[i];
        }
        ports[i + 1] = portal;
        this.portals = null;
        this.portals = ports;
        System.gc();
    }

    public final Portal[] getPortals() {
        return this.portals;
    }

    public final Mesh getMesh() {
        return this.fullMesh;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean isOpenSky() {
        return this.openSky;
    }

    public final void setViewport(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public final void addViewport(int x1, int y1, int x2, int y2) {
        if (x1 < this.x1) {
            this.x1 = x1;
        }
        if (y1 < this.y1) {
            this.y1 = y1;
        }
        if (x2 > this.x2) {
            this.x2 = x2;
        }
        if (y2 > this.y2) {
            this.y2 = y2;
        }
    }

    public final boolean viewportContains(int x1, int y1, int x2, int y2) {
        return x1 < this.x2 && y1 < this.y2 && x2 >= this.x1 && y2 >= this.y1;
    }

    public final void render(DirectX7 g3d, int x, int z) {
        this.fullMesh.getTexture().updateAnimation();
        if (this.renderMesh != null) {
            int xx = (x - this.minx) / chunkSizeRender - 1;
            int zstart = (z - this.minz) / chunkSizeRender - 1;
            int xend = (x - this.minx) / chunkSizeRender + 1;
            int zend = (z - this.minz) / chunkSizeRender + 1;
            if (xx > this.renderMesh.length - 1) {
                return;
            }
            if (zstart > this.renderMesh[0].length - 1) {
                return;
            }
            if (xend < 0) {
                return;
            }
            if (zend < 0) {
                return;
            }
            xend = Math.min(Math.max(xend, 0), this.renderMesh.length - 1);
            zstart = Math.min(Math.max(zstart, 0), this.renderMesh[0].length - 1);
            zend = Math.min(Math.max(zend, 0), this.renderMesh[0].length - 1);
            for (xx = Math.min(Math.max(xx, 0), this.renderMesh.length - 1); xx <= xend; ++xx) {
                for (int zz = zstart; zz <= zend; ++zz) {
                    if (!this.bbrenderMesh[xx][zz].isVisible(g3d, this.x1, this.y1, this.x2, this.y2)) continue;
                    g3d.transformAndProjectVertices(this.renderMesh[xx][zz], g3d.getInvCamera());
                    g3d.addMesh(this.renderMesh[xx][zz], this.x1, this.y1, this.x2, this.y2);
                    this.renderMesh[xx][zz].applySz();
                }
            }
        } else {
            g3d.transformAndProjectVertices(this.fullMesh, g3d.getInvCamera());
            g3d.addMesh(this.fullMesh, this.x1, this.y1, this.x2, this.y2);
            this.fullMesh.applySz();
        }
    }

    public final void renderObjects(DirectX7 g3d) {
        this.renderObjects(g3d, this.x1, this.y1, this.x2, this.y2);
    }

    public final void renderObjects(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        for (int i = 0; i < this.objects.size(); ++i) {
            RoomObject obj = (RoomObject)this.objects.elementAt(i);
            obj.render(g3d, x1, y1, x2, y2);
        }
    }

    public final void rayCast(Ray ray) {
        if (this.mesh != null) {
            Vector3D start = ray.getStart();
            Vector3D end = ray.getDir();
            int minx = (Math.min(start.x, start.x + end.x) - this.minx) / chunkSize;
            int minz = (Math.min(start.z, start.z + end.z) - this.minz) / chunkSize;
            int maxx = (Math.max(start.x, start.x + end.x) - this.minx) / chunkSize;
            int maxz = (Math.max(start.z, start.z + end.z) - this.minz) / chunkSize;
            minx = Math.min(Math.max(minx, 0), this.mesh.length - 1);
            minz = Math.min(Math.max(minz, 0), this.mesh[0].length - 1);
            maxx = Math.min(Math.max(maxx, 0), this.mesh.length - 1);
            maxz = Math.min(Math.max(maxz, 0), this.mesh[0].length - 1);
            for (int xx = minx; xx <= maxx; ++xx) {
                for (int zz = minz; zz <= maxz; ++zz) {
                    RayCast.rayCast(this.mesh[xx][zz], ray, this.rid);
                }
            }
        } else {
            RayCast.rayCast(this.fullMesh, ray, this.rid);
        }
    }

    public final boolean sphereCast(Vector3D pos, int rad) {
        boolean collision = false;
        if (this.mesh != null) {
            int xx = 0;
            int zz = 0;
            int zstart = 0;
            int xend = this.mesh.length - 1;
            int zend = this.mesh[0].length - 1;
            xx = (pos.x - rad - this.minx) / chunkSize;
            zstart = (pos.z - rad - this.minz) / chunkSize;
            xend = (pos.x + rad - this.minx) / chunkSize;
            zend = (pos.z + rad - this.minz) / chunkSize;
            if (xx > this.mesh.length - 1) {
                return false;
            }
            if (zstart > this.mesh[0].length - 1) {
                return false;
            }
            if (xend < 0) {
                return false;
            }
            if (zend < 0) {
                return false;
            }
            xend = Math.min(Math.max(xend, 0), this.mesh.length - 1);
            zstart = Math.min(Math.max(zstart, 0), this.mesh[0].length - 1);
            zend = Math.min(Math.max(zend, 0), this.mesh[0].length - 1);
            for (xx = Math.min(Math.max(xx, 0), this.mesh.length - 1); xx <= xend; ++xx) {
                for (zz = zstart; zz <= zend; ++zz) {
                    collision |= pos.x + rad >= this.bbmesh[xx][zz].minx && pos.z + rad >= this.bbmesh[xx][zz].minz && pos.x - rad <= this.bbmesh[xx][zz].maxx && pos.z - rad <= this.bbmesh[xx][zz].maxz ? SphereCast.sphereCast(this.mesh[xx][zz], pos, rad) : false;
                }
            }
        } else {
            collision |= pos.x + rad >= this.minx && pos.z + rad >= this.minz && pos.x - rad <= this.maxx && pos.z - rad <= this.maxz ? SphereCast.sphereCast(this.fullMesh, pos, rad) : false;
        }
        return collision;
    }

    public final boolean isPointInRoomBox(int x, int y, int z) {
        return x >= this.minx && z >= this.minz && y >= this.miny && x <= this.maxx && z <= this.maxz && (this.openSky || y <= this.maxy);
    }

    public final int isPointOnMesh(int x, int y, int z) {
        if (!this.isPointInRoomBox(x, y, z)) {
            return -1;
        }
        Mesh testMesh = this.fullMesh;
        if (this.mesh != null) {
            int xx = (x - this.minx) / chunkSize;
            int zz = (z - this.minz) / chunkSize;
            if (xx >= this.mesh.length || xx < 0) {
                return -1;
            }
            if (zz >= this.mesh[0].length || zz < 0) {
                return -1;
            }
            testMesh = this.mesh[xx][zz];
        }
        RenderObject[] pols = testMesh.getPolygons();
        for (int i = 0; i < pols.length; ++i) {
            if (!Room.isPointOnPolygon(x, y, z, pols[i])) continue;
            return i;
        }
        return -1;
    }

    public void computeHeight(Height height) {
        Vector3D pos = height.getPosition();
        if (this.mesh != null) {
            int xx = (pos.x - this.minx) / chunkSize;
            int zz = (pos.z - this.minz) / chunkSize;
            if (xx >= this.mesh.length || xx < 0) {
                return;
            }
            if (zz >= this.mesh[0].length || zz < 0) {
                return;
            }
            if (HeightComputer.isPointAABBCollision(pos.x, pos.z, this.bbmesh[xx][zz].minx - 500, this.bbmesh[xx][zz].maxx + 500, this.bbmesh[xx][zz].minz - 500, this.bbmesh[xx][zz].maxz + 500)) {
                HeightComputer.computeHeight(this.mesh[xx][zz], height);
            }
        } else if (HeightComputer.isPointAABBCollision(pos.x, pos.z, this.minx - 500, this.maxx + 500, this.minz - 500, this.maxz + 500)) {
            HeightComputer.computeHeight(this.fullMesh, height);
        }
    }

    private static boolean isPointOnPolygon(int x, int z, RenderObject obj) {
        if (obj instanceof Polygon4V) {
            Polygon4V p = (Polygon4V)obj;
            Vertex v1 = p.a;
            Vertex v2 = p.b;
            Vertex v3 = p.c;
            Vertex v4 = p.d;
            return MathUtils2.isPointOnPolygon(x, z, v1.x, v1.z, v2.x, v2.z, v3.x, v3.z, v4.x, v4.z, p.ny);
        }
        if (obj instanceof Polygon3V) {
            Polygon3V p = (Polygon3V)obj;
            Vertex v1 = p.a;
            Vertex v2 = p.b;
            Vertex v3 = p.c;
            return MathUtils2.isPointOnPolygon(x, z, v1.x, v1.z, v2.x, v2.z, v3.x, v3.z, p.ny);
        }
        return false;
    }

    private static boolean isPointOnPolygon(int x, int y, int z, RenderObject obj) {
        if (obj instanceof Polygon4V) {
            Polygon4V p = (Polygon4V)obj;
            if (p.ny >= 0) {
                return false;
            }
            Vertex v1 = p.a;
            Vertex v2 = p.b;
            Vertex v3 = p.c;
            Vertex v4 = p.d;
            if (MathUtils2.computePolygonY(v1, p.nx, p.ny, p.nz, x, y, z) <= y) {
                return MathUtils2.isPointOnPolygon(x, z, v4.x, v4.z, v3.x, v3.z, v2.x, v2.z, v1.x, v1.z);
            }
            return false;
        }
        if (obj instanceof Polygon3V) {
            Polygon3V p = (Polygon3V)obj;
            if (p.ny >= 0) {
                return false;
            }
            Vertex v1 = p.a;
            Vertex v2 = p.b;
            Vertex v3 = p.c;
            if (MathUtils2.computePolygonY(v1, p.nx, p.ny, p.nz, x, y, z) <= y) {
                return MathUtils2.isPointOnPolygon(x, z, v3.x, v3.z, v2.x, v2.z, v1.x, v1.z);
            }
            return false;
        }
        return false;
    }

    public final int getMinX() {
        return this.minx;
    }

    public final int getMaxZ() {
        return this.maxz;
    }

    public final int getMinZ() {
        return this.minz;
    }

    public final int getMaxX() {
        return this.maxx;
    }

    public final int getMinY() {
        return this.miny;
    }

    public final int getMaxY() {
        return this.maxy;
    }

    public boolean isOnRoom(int x, int y) {
        return x <= this.x2 + 10 && x >= this.x1 - 10 && y <= this.y2 + 10 && y >= this.y1 - 10;
    }

    public void addObject(RoomObject obj) {
        if (!this.objects.contains(obj)) {
            this.objects.addElement(obj);
        } else if (DeveloperMenu.debugMode) {
            System.out.println("Room: \u0442\u0430\u043a\u043e\u0439 \u043e\u0431\u044c\u0435\u043a\u0442 \u0443\u0436\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f");
        }
    }

    public void removeObject(RoomObject obj) {
        boolean remove = this.objects.removeElement(obj);
        if (!remove && DeveloperMenu.debugMode) {
            System.out.println("Room: \u0442\u0430\u043a\u043e\u0433\u043e \u043e\u0431\u044c\u0435\u043a\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e");
        }
    }

    public Vector getObjects() {
        return this.objects;
    }

    public void getObjects(Vector buf) {
        for (int i = 0; i < this.objects.size(); ++i) {
            RoomObject obj = (RoomObject)this.objects.elementAt(i);
            if (buf.contains(obj)) continue;
            buf.addElement(obj);
        }
    }

    public static Mesh[] loadMeshes(String file, float scaleX, float scaleY, float scaleZ) {
        return Room.loadMeshes(file, scaleX, scaleY, scaleZ, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mesh[] loadMeshes(String file, float scaleX, float scaleY, float scaleZ, MultyTexture mt) {
        Mesh[] meshes = null;
        InputStream is = null;
        FilterInputStream dis = null;
        ByteArrayInputStream bais = null;
        try {
            is = new Object().getClass().getResourceAsStream(file);
            dis = new DataInputStream(is);
            byte[] data = new byte[dis.available()];
            ((DataInputStream)dis).read(data);
            dis.close();
            bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            meshes = new Mesh[((DataInputStream)dis).readInt()];
            for (int i = 0; i < meshes.length; ++i) {
                meshes[i] = Room.createFrom3d(file, (DataInputStream)dis, scaleX, scaleY, scaleZ, mt);
            }
        }
        catch (Exception ex) {
            System.err.println("ERROR in Loader.Load: " + ex);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception ex) {}
            try {
                bais.close();
            }
            catch (Exception ex) {}
        }
        return meshes;
    }

    private static Mesh createFrom3d(String file, DataInputStream is, float scaleX, float scaleY, float scaleZ, MultyTexture mt) throws Exception {
        int i;
        Vertex[] verts = new Vertex[is.readShort()];
        for (int i2 = 0; i2 < verts.length; ++i2) {
            int x = (int)((float)is.readShort() * scaleX);
            int y = (int)((float)is.readShort() * scaleY);
            int z = (int)((float)is.readShort() * scaleZ);
            verts[i2] = new Vertex(x, y, z);
        }
        Polygon3V[] pols3v = new Polygon3V[is.readShort()];
        short mat = 0;
        for (int i3 = 0; i3 < pols3v.length; ++i3) {
            short va = is.readShort();
            if (va == Short.MIN_VALUE) {
                mat = is.readShort();
                va = is.readShort();
            }
            short vb = is.readShort();
            short vc = is.readShort();
            byte au = is.readByte();
            byte av = is.readByte();
            byte bu = is.readByte();
            byte bv = is.readByte();
            byte cu = is.readByte();
            byte cv = is.readByte();
            Vertex a = verts[va];
            Vertex b = verts[vb];
            Vertex c = verts[vc];
            pols3v[i3] = DirectX7.standartDrawmode == 9 && Main.fogQ >= 1 ? new LightedPolygon3V(c, b, a, cu, cv, bu, bv, au, av) : (DirectX7.standartDrawmode == 13 && Main.fogQ >= 1 ? new ColorLightedPolygon3V(c, b, a, cu, cv, bu, bv, au, av) : new Polygon3V(c, b, a, cu, cv, bu, bv, au, av));
            pols3v[i3].tex = (byte)mat;
        }
        Polygon4V[] pols4v = new Polygon4V[is.readShort()];
        mat = 0;
        for (int i4 = 0; i4 < pols4v.length; ++i4) {
            short va = is.readShort();
            if (va == Short.MIN_VALUE) {
                mat = is.readShort();
                va = is.readShort();
            }
            short vb = is.readShort();
            short vc = is.readShort();
            short vd = is.readShort();
            byte au = is.readByte();
            byte av = is.readByte();
            byte bu = is.readByte();
            byte bv = is.readByte();
            byte cu = is.readByte();
            byte cv = is.readByte();
            byte du = is.readByte();
            byte dv = is.readByte();
            Vertex a = verts[va];
            Vertex b = verts[vb];
            Vertex c = verts[vc];
            Vertex d = verts[vd];
            pols4v[i4] = DirectX7.standartDrawmode == 9 && Main.fogQ >= 1 ? new LightedPolygon4V(d, c, b, a, du, dv, cu, cv, bu, bv, au, av) : (DirectX7.standartDrawmode == 13 && Main.fogQ >= 1 ? new ColorLightedPolygon4V(d, c, b, a, du, dv, cu, cv, bu, bv, au, av) : new Polygon4V(d, c, b, a, du, dv, cu, cv, bu, bv, au, av));
            pols4v[i4].tex = (byte)mat;
        }
        RenderObject[] var30 = new RenderObject[pols3v.length + pols4v.length];
        int pols = 0;
        for (i = 0; i < pols3v.length; ++i) {
            var30[pols] = pols3v[i];
            ++pols;
        }
        for (i = 0; i < pols4v.length; ++i) {
            var30[pols] = pols4v[i];
            ++pols;
        }
        System.out.println("Mesh [" + file + "] \u0432\u0435\u0440\u0448\u0438\u043d: " + verts.length + " \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u043e\u0432: " + var30.length);
        return new Mesh(verts, var30, mt);
    }

    public void paint(Graphics g, int x, int y) {
        g.setColor(65280);
        g.drawRect(x + this.x1, y + this.y1, this.x2 - this.x1 - 1, this.y2 - this.y1 - 1);
        g.setColor(0xFFFFFF);
    }

    static {
        chunkSizeRender = 0;
    }
}

