/*
 * Decompiled with CFR 0.152.
 */
package com.Gameplay;

import com.AI.Player;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Weapon;
import com.HUD.Base.Font;
import com.HUD.GUIScreen;
import com.Rendering.Fps;
import com.Rendering.Meshes.Mesh;
import com.misc.Main;
import com.misc.Stringer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Shop
extends GUIScreen {
    public static int weapon_count = 0;
    public static String[] files;
    public static int[] prices;
    public static String[] bckFiles;
    public static int[] bckPrices;
    private Main main;
    private GameScreen gameScreen;
    private Player player;
    public static int index;
    public static int[] items;
    public static int[] allitems;
    private Image iconItem;
    private Image iconPatron;
    private static boolean proportionalShop;
    public static int[] defaultArsenal;

    public static void initShop() {
        int pos = 0;
        Stringer settings = Main.settings;
        String file = Mesh.getStringFromResource("/weapons.txt");
        if (settings.getString("DEFAULT_ARSENAL") != null) {
            defaultArsenal = Mesh.cutOnInts(settings.getString("DEFAULT_ARSENAL"), ',', ';');
        } else if (file != null) {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = 0;
        } else {
            defaultArsenal = new int[1];
            Shop.defaultArsenal[0] = -1;
        }
        if (file != null) {
            int i;
            int len;
            weapon_count = len = Mesh.cutOnStrings(file, '[').length + 1;
            allitems = new int[len];
            for (i = 0; i < len; ++i) {
                Shop.allitems[i] = i;
            }
            items = new int[len];
            for (i = 0; i < len; ++i) {
                Shop.items[i] = i;
            }
            files = new String[len];
            prices = new int[len];
            bckFiles = new String[len];
            bckPrices = new int[len];
            int sel = 0;
            while (file.indexOf(91) >= 0) {
                pos = file.indexOf(91);
                int endpos = file.indexOf(93);
                String objectType = file.substring(pos + 1, endpos);
                String object = file.substring(endpos + 1);
                if ((endpos = object.indexOf(91)) >= 0) {
                    file = object.substring(endpos);
                    object = object.substring(0, endpos - 1);
                }
                Stringer obj = new Stringer(object);
                Shop.files[sel] = obj.getString("SHOP_IMAGE");
                Shop.prices[sel] = obj.getInt("PRICE");
                Shop.bckFiles[sel] = obj.getString("SHOP_IMAGE");
                Shop.bckPrices[sel] = obj.getInt("PRICE");
                ++sel;
                if (endpos >= 0) continue;
                break;
            }
        } else {
            int i;
            weapon_count = 2;
            allitems = new int[2];
            for (i = 0; i < 2; ++i) {
                Shop.allitems[i] = i;
            }
            items = new int[2];
            for (i = 0; i < 2; ++i) {
                Shop.items[i] = i;
            }
            files = new String[2];
            prices = new int[2];
            bckFiles = new String[2];
            bckPrices = new int[2];
        }
        Shop.files[Shop.files.length - 1] = Main.shop_medkit;
        Shop.prices[Shop.files.length - 1] = settings.getInt("PRICE_MEDICINE_CHEST");
        Shop.bckFiles[Shop.files.length - 1] = Main.shop_medkit;
        Shop.bckPrices[Shop.files.length - 1] = settings.getInt("PRICE_MEDICINE_CHEST");
        if (settings.getString("SHOP_PROPORTIONAL") != null && settings.getInt("SHOP_PROPORTIONAL") == 0) {
            proportionalShop = false;
        }
    }

    public Shop(Main main, GameScreen gameScreen, Player player) {
        this.main = main;
        this.gameScreen = gameScreen;
        this.player = player;
        Stringer var5 = Main.getGameText$6783a6a7();
        this.set(Main.getFont(), var5.getString2("BUY"), var5.getString2("BACK"));
        this.iconPatron = this.createImage2(Main.shop_patron);
        this.reset();
    }

    public final void destroy() {
        super.destroy();
        this.iconPatron = null;
        this.iconItem = null;
        this.player = null;
    }

    private void reset() {
        this.iconItem = null;
        String path = files[index];
        if (Main.getGameText().getString2(path) != null) {
            path = Main.getGameText().getString2(path);
        }
        if (proportionalShop) {
            this.iconItem = this.createImage(path);
            return;
        }
        try {
            this.iconItem = Arsenal.resize(Image.createImage((String)path), this.getWidth(), this.getHeight());
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + files[index]);
            return;
        }
    }

    private Image createImage(String file) {
        try {
            return Arsenal.resize(Image.createImage((String)file), (float)this.getWidth() / 240.0f, (float)this.getHeight() / 320.0f);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    private Image createImage2(String file) {
        try {
            int h = this.getHeight();
            int w = this.getWidth();
            if (w < h) {
                return Arsenal.resize(Image.createImage((String)file), (float)w / 240.0f, (float)w / 240.0f);
            }
            return Arsenal.resize(Image.createImage((String)file), (float)h / 320.0f, (float)h / 320.0f);
        }
        catch (Exception var2) {
            System.out.println("ERROR create image " + file);
            return null;
        }
    }

    private int price() {
        return index == files.length - 1 ? prices[index] : (this.isNotPurchased() ? prices[index] : (this.isPurchased() && this.isPatron() ? prices[index] / 3 : Short.MAX_VALUE));
    }

    private boolean isAvailableAidKit() {
        return index == files.length - 1 && this.player.getHp() == 100 ? false : this.player.getMoney() >= this.price();
    }

    private boolean isNotPurchased() {
        Weapon[] var1 = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && var1[index] == null;
    }

    private boolean isPatron() {
        Weapon[] var1 = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && var1[index] != null && var1[Shop.index].patronbuy;
    }

    private boolean isPurchased() {
        Weapon[] var1 = Arsenal.getWeapons();
        return index >= 0 && index < files.length - 1 && var1[index] != null;
    }

    protected final void paint(Graphics g) {
        int var2 = this.getWidth();
        int var3 = this.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, var2, var3);
        int var4 = var3 / 8;
        int var5 = var3 - (var4 << 1);
        var5 -= var5 % 15;
        Stringer var6 = Main.getGameText$6783a6a7();
        if (this.isAvailableAidKit()) {
            this.setLeftSoft(var6.getString2("BUY"));
        } else {
            this.setLeftSoft(var6.getString2("NOTENOUGHMONEY"));
        }
        var4 = var2 / 34;
        var5 = var3 / 34;
        if (!Main.verticalShopScroll) {
            this.drawArrow(g, 4, var3 / 4, var4 + 4, var3 / 4 - var5 / 2, var4 + 4, var3 / 4 + var5 / 2);
            this.drawArrow(g, var2 - 4, var3 / 4, var2 - 4 - var4, var3 / 4 - var5 / 2, var2 - 4 - var4, var3 / 4 + var5 / 2);
        }
        Font var8 = this.getFont();
        Stringer var7 = Main.getGameText$6783a6a7();
        var8.drawString(g, var7.getString2("MONEY") + ":" + this.player.getMoney(), var2 - 2, 2, 24);
        g.drawImage(this.iconItem, var2 / 2, var3 / 2, 3);
        if (this.isPurchased() && this.isPatron()) {
            g.drawImage(this.iconPatron, var2 / 2 - this.iconItem.getWidth() / 2, var3 / 2 + this.iconItem.getHeight() / 2, 36);
        }
        if (var7.getString2("CENA") != null) {
            var8.drawString(g, var7.getString2("CENA") + ":" + this.price(), this.getWidth() / 2, this.getHeight() / 2 + this.iconItem.getHeight() / 2 + 2, 17);
        }
        this.drawSoftKeys(g);
    }

    private void drawArrow(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        int var8 = Math.min(y1, Math.min(y2, y3));
        int var9 = Math.max(y1, Math.max(y2, y3));
        int var10 = (var9 - var8) / 3;
        for (int var11 = 0; var11 < var10; ++var11) {
            int var12;
            if (this.isAvailableAidKit()) {
                var12 = Math.min(255, var11 * 255 / var10);
                g.setColor(var12, var12, var12);
            } else {
                var12 = Math.min(255, var11 * 255 / var10);
                g.setColor(var12, 0, 0);
            }
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
        }
    }

    private static void drawGrid(Graphics g, int var1, int var2, int var3, int var4, int var5, int red, int green, int blue) {
        var1 = var3 / 15;
        var5 = var4 / 15;
        blue = (var3 + 0) / 2;
        int var9 = (var2 + var4) / 2;
        int var10 = (Math.abs(blue) + Math.abs(var9 - var2)) / 2;
        for (int var11 = var2; var11 < var2 + var4; var11 += var5) {
            for (int var12 = 0; var12 < var3 + 0; var12 += var1) {
                int var13 = (Math.abs(blue - var12) + Math.abs(var9 - var11)) / 2;
                if (var13 < 0) {
                    var13 = 0;
                }
                if (var13 > var10) {
                    var13 = var10;
                }
                var13 = var10 - var13;
                int var14 = red * var13 / var10;
                int var15 = green * var13 / var10;
                var13 = var13 * 0 / var10;
                g.setColor(var14, var15, var13);
                g.drawRect(var12, var11, var1, var5);
            }
        }
    }

    protected final void onRightSoftKey() {
        try {
            this.destroy();
            System.gc();
            Thread.sleep(50L);
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
        Fps.reset();
        this.gameScreen.start();
        Main.setCurrent(this.gameScreen);
        this.gameScreen = null;
    }

    protected final void onLeftSoftKey() {
        if (this.isAvailableAidKit()) {
            if (this.isNotPurchased()) {
                Weapon[] var1 = Arsenal.getWeapons();
                this.player.pay(this.price());
                var1[Shop.index] = Stringer.createWeapon(index);
                var1[index].setAmmo(100);
                if (Arsenal.current != -1 && Arsenal.currentWeapon().getDamageValue() < Arsenal.weapons[index].getDamageValue()) {
                    Arsenal.current = index;
                }
                this.repaint();
            } else if (this.isPurchased() && this.isPatron()) {
                Weapon[] var1 = Arsenal.getWeapons();
                this.player.pay(this.price());
                var1[index].addAmmo(100);
                this.repaint();
            } else if (index == files.length - 1) {
                this.player.pay(this.price());
                this.player.setHp(100);
                this.repaint();
            }
        }
    }

    protected final void onKey6() {
        if (Main.verticalShopScroll) {
            return;
        }
        ++index;
        index %= files.length;
        if (!this.isContains()) {
            this.onKey6();
            return;
        }
        this.reset();
        this.repaint();
    }

    protected final void onKey4() {
        if (Main.verticalShopScroll) {
            return;
        }
        if (--index < 0) {
            index += files.length;
        }
        if (!this.isContains()) {
            this.onKey4();
            return;
        }
        this.reset();
        this.repaint();
    }

    protected final void onKey8() {
        if (!Main.verticalShopScroll) {
            return;
        }
        ++index;
        index %= files.length;
        if (!this.isContains()) {
            this.onKey8();
            return;
        }
        this.reset();
        this.repaint();
    }

    protected final void onKey2() {
        if (!Main.verticalShopScroll) {
            return;
        }
        if (--index < 0) {
            index += files.length;
        }
        if (!this.isContains()) {
            this.onKey2();
            return;
        }
        this.reset();
        this.repaint();
    }

    private boolean isContains() {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != index) continue;
            return true;
        }
        return false;
    }

    static {
        index = 0;
        proportionalShop = true;
        defaultArsenal = null;
    }
}

