/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering;

import com.Rendering.Graphics3D;
import com.Rendering.RawImage;
import javax.microedition.lcdui.Image;

public class Texture {
    public boolean perspectiveCorrection;
    public int widthBIT;
    public int interp;
    public RawImage rImg;
    public Texture mip = null;
    public byte drawmode = Graphics3D.fog;
    public int addsz = 0;
    public boolean alphaMixing = false;

    Texture() {
    }

    private Texture(Image img, int interpz) {
        this.perspectiveCorrection = false;
        int w = img.getWidth();
        int h = img.getHeight();
        this.widthBIT = Texture.widthToBIT(w);
        int[] pixels = new int[w * h];
        this.interp = interpz;
        img.getRGB(pixels, 0, w, 0, 0, w, h);
        this.prepareAlpha(pixels);
        this.rImg = new RawImage(pixels, w, h);
        this.drawmode = Graphics3D.fog;
    }

    public Texture(RawImage ri, boolean perspectiveCorrection2) {
        this.perspectiveCorrection = perspectiveCorrection2;
        this.widthBIT = Texture.widthToBIT(ri.w);
        this.prepareAlpha(ri.img);
        this.rImg = ri;
        this.drawmode = Graphics3D.fog;
    }

    public void destroy() {
        this.rImg = null;
        this.mip = null;
    }

    private static int widthToBIT(int w) {
        for (int var1 = 0; var1 < 32; ++var1) {
            if (w >> var1 != 1 || 1 << var1 != w) continue;
            return var1;
        }
        return 0;
    }

    public int[] getPixels() {
        return this.rImg.img;
    }

    public int getInterp() {
        return this.interp;
    }

    public byte getDrawMode() {
        return this.drawmode;
    }

    public void setDrawMode(byte dr) {
        this.drawmode = dr;
        if (this.mip != null) {
            this.mip.setDrawMode(dr);
        }
    }

    public void setInterp(int i) {
        this.interp = i;
    }

    public void setPerspectiveCorrection(boolean perspectiveCorrection) {
        this.perspectiveCorrection = perspectiveCorrection;
        if (this.mip != null) {
            this.mip.setPerspectiveCorrection(perspectiveCorrection);
        }
    }

    public static Texture createTexture(String file) {
        try {
            int type = -1;
            String format = file;
            format = format.substring(format.indexOf(46) - 3, format.indexOf(46)).trim();
            if (format.compareTo("pix") == 0) {
                type = 0;
            }
            if (format.compareTo("int") == 0) {
                type = 1;
            }
            return new Texture(Image.createImage((String)file), type);
        }
        catch (Exception var2) {
            System.err.println("ERROR in createTexture " + file + ": " + var2);
            return null;
        }
    }

    private final void prepareAlpha(int[] pix) {
        for (int i = 0; i < pix.length; ++i) {
            int alpha;
            int col = pix[i];
            if ((col & 0xFF000000) == 0) {
                pix[i] = 0;
            }
            if ((alpha = pix[i] >> 24 & 0xFF) <= 0 || alpha >= 255) continue;
            this.alphaMixing = true;
        }
    }
}

