/*
 * Decompiled with CFR 0.152.
 */
package com.Math;

import com.Math.MathUtils;
import com.Math.Vector3D;

public final class Matrix {
    private static final short[] sin = new short[360];
    private static final short[] cos = new short[360];
    public static int fp = 14;
    public static int FP = 1 << fp;
    public int m00 = FP;
    public int m01 = 0;
    public int m02 = 0;
    public int m03 = 0;
    public int m10 = 0;
    public int m11 = FP;
    public int m12 = 0;
    public int m13 = 0;
    public int m20 = 0;
    public int m21 = 0;
    public int m22 = FP;
    public int m23 = 0;

    public final void setIdentity() {
        this.m00 = FP;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = FP;
        this.m12 = 0;
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = 0;
        this.m22 = FP;
        this.m23 = 0;
    }

    public final void set(Matrix m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
    }

    public final void set(int mm00, int mm01, int mm02, int mm03, int mm10, int mm11, int mm12, int mm13, int mm20, int mm21, int mm22, int mm23) {
        this.m00 = mm00;
        this.m01 = mm01;
        this.m02 = mm02;
        this.m03 = mm03;
        this.m10 = mm10;
        this.m11 = mm11;
        this.m12 = mm12;
        this.m13 = mm13;
        this.m20 = mm20;
        this.m21 = mm21;
        this.m22 = mm22;
        this.m23 = mm23;
    }

    public void getPosition(Vector3D v) {
        v.set(this.m03, this.m13, this.m23);
    }

    public final void invert() {
        long var1 = ((long)this.m00 * (long)this.m03 >> fp) + ((long)this.m10 * (long)this.m13 >> fp) + ((long)this.m20 * (long)this.m23 >> fp);
        long var3 = ((long)this.m01 * (long)this.m03 >> fp) + ((long)this.m11 * (long)this.m13 >> fp) + ((long)this.m21 * (long)this.m23 >> fp);
        long var5 = ((long)this.m02 * (long)this.m03 >> fp) + ((long)this.m12 * (long)this.m13 >> fp) + ((long)this.m22 * (long)this.m23 >> fp);
        this.m03 = (int)(-var1);
        this.m13 = (int)(-var3);
        this.m23 = (int)(-var5);
        int var7 = this.m01;
        this.m01 = this.m10;
        this.m10 = var7;
        var7 = this.m02;
        this.m02 = this.m20;
        this.m20 = var7;
        var7 = this.m12;
        this.m12 = this.m21;
        this.m21 = var7;
    }

    private static int fixDegree(int degree) {
        while (degree < 0) {
            degree += 360;
        }
        while (degree >= 360) {
            degree -= 360;
        }
        return degree;
    }

    public final void setRotX(int degree) {
        degree = Matrix.fixDegree(degree);
        this.m00 = FP;
        this.m01 = 0;
        this.m02 = 0;
        this.m03 = 0;
        this.m10 = 0;
        this.m11 = cos[degree];
        this.m12 = -sin[degree];
        this.m13 = 0;
        this.m20 = 0;
        this.m21 = sin[degree];
        this.m22 = cos[degree];
        this.m23 = 0;
    }

    public final void mul(Matrix m) {
        this.mul(this, m);
    }

    public final void mul(Matrix m2, Matrix m1) {
        long var10000 = m2.m00 * m1.m00 + m2.m01 * m1.m10 + m2.m02 * m1.m20;
        long var10001 = m2.m03;
        long var3 = var10000 + 0L >> fp;
        var10000 = m2.m00 * m1.m01 + m2.m01 * m1.m11 + m2.m02 * m1.m21;
        var10001 = m2.m03;
        long var5 = var10000 + 0L >> fp;
        var10000 = m2.m00 * m1.m02 + m2.m01 * m1.m12 + m2.m02 * m1.m22;
        var10001 = m2.m03;
        long var7 = var10000 + 0L >> fp;
        long var9 = (long)m2.m00 * (long)m1.m03 + (long)m2.m01 * (long)m1.m13 + (long)m2.m02 * (long)m1.m23 + ((long)m2.m03 << fp) >> fp;
        var10000 = m2.m10 * m1.m00 + m2.m11 * m1.m10 + m2.m12 * m1.m20;
        var10001 = m2.m13;
        long var11 = var10000 + 0L >> fp;
        var10000 = m2.m10 * m1.m01 + m2.m11 * m1.m11 + m2.m12 * m1.m21;
        var10001 = m2.m13;
        long var13 = var10000 + 0L >> fp;
        var10000 = m2.m10 * m1.m02 + m2.m11 * m1.m12 + m2.m12 * m1.m22;
        var10001 = m2.m13;
        long var15 = var10000 + 0L >> fp;
        long var17 = (long)m2.m10 * (long)m1.m03 + (long)m2.m11 * (long)m1.m13 + (long)m2.m12 * (long)m1.m23 + ((long)m2.m13 << fp) >> fp;
        var10000 = m2.m20 * m1.m00 + m2.m21 * m1.m10 + m2.m22 * m1.m20;
        var10001 = m2.m23;
        long var19 = var10000 + 0L >> fp;
        var10000 = m2.m20 * m1.m01 + m2.m21 * m1.m11 + m2.m22 * m1.m21;
        var10001 = m2.m23;
        long var21 = var10000 + 0L >> fp;
        var10000 = m2.m20 * m1.m02 + m2.m21 * m1.m12 + m2.m22 * m1.m22;
        var10001 = m2.m23;
        long var23 = var10000 + 0L >> fp;
        long var25 = (long)m2.m20 * (long)m1.m03 + (long)m2.m21 * (long)m1.m13 + (long)m2.m22 * (long)m1.m23 + ((long)m2.m23 << fp) >> fp;
        this.m00 = (int)var3;
        this.m01 = (int)var5;
        this.m02 = (int)var7;
        this.m03 = (int)var9;
        this.m10 = (int)var11;
        this.m11 = (int)var13;
        this.m12 = (int)var15;
        this.m13 = (int)var17;
        this.m20 = (int)var19;
        this.m21 = (int)var21;
        this.m22 = (int)var23;
        this.m23 = (int)var25;
    }

    public final void rotY(int degree) {
        degree = Matrix.fixDegree(degree);
        short var2 = cos[degree];
        short var8 = sin[degree];
        int var3 = this.m00 * var2 + this.m20 * var8 >> fp;
        int var4 = this.m01 * var2 + this.m21 * var8 >> fp;
        int var5 = this.m02 * var2 + this.m22 * var8 >> fp;
        int var6 = this.m20 * var2 - this.m00 * var8 >> fp;
        int var7 = this.m21 * var2 - this.m01 * var8 >> fp;
        degree = this.m22 * var2 - this.m02 * var8 >> fp;
        this.m00 = var3;
        this.m01 = var4;
        this.m02 = var5;
        this.m20 = var6;
        this.m21 = var7;
        this.m22 = degree;
    }

    public final void setPosition(int x, int y, int z) {
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
    }

    public final void setPosition(Vector3D pos) {
        this.m03 = pos.x;
        this.m13 = pos.y;
        this.m23 = pos.z;
    }

    public final void addPosition(Vector3D pos) {
        this.m03 += pos.x;
        this.m13 += pos.y;
        this.m23 += pos.z;
    }

    public final void subPosition(int x, int y, int z) {
        this.m03 -= x;
        this.m13 -= y;
        this.m23 -= z;
    }

    public final void addPosition(int x, int y, int z) {
        this.m03 += x;
        this.m13 += y;
        this.m23 += z;
    }

    public final void setSide(int x, int y, int z) {
        this.m00 = x;
        this.m10 = y;
        this.m20 = z;
    }

    public final void setUp(int x, int y, int z) {
        this.m01 = x;
        this.m11 = y;
        this.m21 = z;
    }

    public final void setDir(int x, int y, int z) {
        this.m02 = x;
        this.m12 = y;
        this.m22 = z;
    }

    public void translate(int x, int y, int z) {
        if (x != 0) {
            this.m03 += this.m00 * x >> fp;
            this.m13 += this.m10 * x >> fp;
            this.m23 += this.m20 * x >> fp;
        }
        if (y != 0) {
            this.m03 += this.m01 * y >> fp;
            this.m13 += this.m11 * y >> fp;
            this.m23 += this.m21 * y >> fp;
        }
        if (z != 0) {
            this.m03 += this.m02 * z >> fp;
            this.m13 += this.m12 * z >> fp;
            this.m23 += this.m22 * z >> fp;
        }
    }

    public int getRotZ() {
        int rt = MathUtils.getAnglez(0, 0, -this.m02, -this.m22);
        rt = MathUtils.fixDegree(rt);
        return rt;
    }

    public int getRotZHQ() {
        int rt = MathUtils.getAnglezHQ(0, 0, -this.m02, -this.m22);
        return rt;
    }

    static {
        for (int var0 = 0; var0 < 360; ++var0) {
            Matrix.sin[var0] = (short)(Math.sin(Math.toRadians(var0)) * (double)FP);
            Matrix.cos[var0] = (short)(Math.cos(Math.toRadians(var0)) * (double)FP);
        }
    }
}

