/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;

public class ColorLightedPolygon4V
extends Polygon4V {
    public volatile int ar;
    public volatile int ag;
    public volatile int ab;
    public volatile int br;
    public volatile int bg;
    public volatile int bb;
    public volatile int cr;
    public volatile int cg;
    public volatile int cb;
    public volatile int dr;
    public volatile int dg;
    public volatile int db;
    private static int q;
    private static int sz2;
    private static int sizex;
    private static int sizey;
    private static int sizeu;
    private static int sizev;
    private static int addmip;
    private static int fog;

    public ColorLightedPolygon4V(ColorLightedPolygon4V p) {
        super(p);
        this.ar = p.ar;
        this.ag = p.ag;
        this.ab = p.ab;
        this.br = p.br;
        this.bg = p.bg;
        this.bb = p.bb;
        this.cr = p.cr;
        this.cg = p.cg;
        this.cb = p.cb;
        this.dr = p.dr;
        this.dg = p.dg;
        this.db = p.db;
    }

    public ColorLightedPolygon4V(Vertex a2, Vertex b2, Vertex c2, Vertex d2, byte au, byte av, byte bu, byte bv, byte cu, byte cv, byte du, byte dv) {
        super(a2, b2, c2, d2, au, av, bu, bv, cu, cv, du, dv);
        this.db = 255;
        this.dg = 255;
        this.dr = 255;
        this.cb = 255;
        this.cg = 255;
        this.cr = 255;
        this.bb = 255;
        this.bg = 255;
        this.br = 255;
        this.ab = 255;
        this.ag = 255;
        this.ar = 255;
    }

    public final void render(DirectX7 g3d, Texture texture) {
        boolean pers;
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = ColorLightedPolygon4V.size(this.a.sx, this.b.sx, this.c.sx, this.d.sx);
        sizey = ColorLightedPolygon4V.size(this.a.sy, this.b.sy, this.c.sy, this.d.sy);
        int[] al = this.getLight(this.a, this.ar, this.ag, this.ab, g3d);
        int[] bl = this.getLight(this.b, this.br, this.bg, this.bb, g3d);
        int[] cl = this.getLight(this.c, this.cr, this.cg, this.cb, g3d);
        int[] dl = this.getLight(this.d, this.dr, this.dg, this.db, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = q > 999 ? 2 : 3;
                if ((sizex + sizey >> 1) * addmip < (sizeu = ColorLightedPolygon4V.size(this.au, this.bu, this.cu, this.du) * texture.rImg.w >> 8) + (sizev = ColorLightedPolygon4V.size(this.av, this.bv, this.cv, this.dv) * texture.rImg.h >> 8)) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu >>= 1) + (sizev >>= 1)) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        boolean bl2 = texture.perspectiveCorrection && (sizex > 70 - (Main.persQ < 3 ? 0 : 20) || sizey > 100 - (Main.persQ < 3 ? 0 : 30)) && Main.persQ != 0 || Main.persQ == 4 ? true : (pers = false);
        if (pers) {
            if (this.a.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingPers.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, q, al[0], bl[0], dl[0], al[1], bl[1], dl[1], al[2], bl[2], dl[2], this.nx, this.ny, this.nz);
            }
            if (this.c.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingPers.paint(g3d, texture, this.b, this.bu, this.bv, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, q, bl[0], cl[0], dl[0], bl[1], cl[1], dl[1], bl[2], cl[2], dl[2], this.nx, this.ny, this.nz);
            }
        } else {
            if (this.a.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, al[0], bl[0], dl[0], al[1], bl[1], dl[1], al[2], bl[2], dl[2], this.nx, this.ny, this.nz);
            }
            if (this.c.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingAffine.paint(g3d, texture, this.b, this.bu, this.bv, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, fog, sz2, bl[0], cl[0], dl[0], bl[1], cl[1], dl[1], bl[2], cl[2], dl[2], this.nx, this.ny, this.nz);
            }
        }
    }

    public final void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au, this.av, this.b, this.bu, this.bv, this.d, this.du, this.dv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, this.ar, this.br, this.dr, this.ag, this.bg, this.dg, this.ab, this.bb, this.db, this.nx, this.ny, this.nz);
        TexturingAffine.paint(g3d, texture, this.b, this.bu, this.bv, this.c, this.cu, this.cv, this.d, this.du, this.dv, DirectX7.fogc, texture.drawmode, sz2, this.br, this.cr, this.dr, this.bg, this.cg, this.dg, this.bb, this.cb, this.db, this.nx, this.ny, this.nz);
    }

    private static int size(int a, int b, int c, int d) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        int max = c > d ? c : d;
        return max - min;
    }

    private static final int min(int a, int b, int c, int d) {
        int t;
        if (a == b || b == d || b == c || d == c) {
            return ColorLightedPolygon4V.min(a, c, d);
        }
        if (a == c) {
            return ColorLightedPolygon4V.min(a, b, d);
        }
        if (a == d) {
            return ColorLightedPolygon4V.min(a, b, c);
        }
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        return min;
    }

    private static final int min(int a, int b, int c) {
        if (a == b || b == c) {
            return a < c ? a : c;
        }
        if (a == c) {
            return a < b ? a : b;
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }
}

