/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import ru.antares.utils.DebugEx;
import ru.antares.utils.PointXY;
import ru.antares.utils.Rect;

public class BubbleField {
    public static final int TOTAL_BUBBLE_COUNT = 7;
    public static final int BUBBLE_PRIZE_IMAGE_FIRST_INDEX = 7;
    public static final int BUBBLE_PRIZE_IMAGE_LAST_INDEX = 13;
    public static final int BUBBLE_MULTICOLOR_IMAGE_INDEX = 14;
    public static final int BUBBLE_BOMB_IMAGE_INDEX = 15;
    public static final int BUBBLE_WALL_INDEX_LEFT = 16;
    public static final int BUBBLE_WALL_INDEX_CENTER = 17;
    public static final int BUBBLE_WALL_INDEX_RIGHT = 18;
    public static final int BUBBLE_DEAD_ANIMATON_INDEX = 19;
    public static final int BUBBLE_ENDDEAD_ANIMATON_INDEX = 23;
    public static final int BUBBLE_DEAD_SPEED = 2;
    public static final int SCORE_FOR_DEAD_BUBBLE = 15;
    public static final int SCORE_FOR_FALL_BUBBLE = 25;
    public static final int SCORE_FOR_EMPTY_ROW = 100;
    public static final int BUBBLE_BOMB_DETONATION_ARRAY_SIZE = 14;
    public static final int[][] BUBBLE_BOMB_DETONATION_ARRAY_1 = new int[][]{{0, 2}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}, {-2, 0}, {-1, 0}, {1, 0}, {2, 0}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {0, -2}};
    public static final int[][] BUBBLE_BOMB_DETONATION_ARRAY_2 = new int[][]{{0, 2}, {-1, 1}, {0, 1}, {1, 1}, {2, 1}, {-2, 0}, {-1, 0}, {1, 0}, {2, 0}, {-1, -1}, {0, -1}, {1, -1}, {2, -1}, {0, -2}};
    public static final int FALL_BUBBLE_BEGIN_SPEED = 0;
    public static final int FALL_BUBBLE_ACCELERATION_FR = 7000;
    public static final int SHOW_NEXT_BONUS_DELAY = 5;
    private int addNextBonusTime = 0;
    public static final int PUZZLE_SHOW_NEXT_LEVEL_TEXT_DELAY = 80;
    private int showLevelInfoDelay = -1;
    private int fieldGameX = 0;
    private int fieldGameY = 0;
    private int fieldWidth = 0;
    private int fieldHeight = 0;
    private int bubbleWidth = 0;
    private int bubbleHeight = 0;
    private int bubbleRadius = 0;
    private int bubblesDX = 12;
    private int bubblesDY = 12;
    private int totalBubbleCount = 0;
    private int bubbleInRow = 0;
    private int rows = 11;
    private int[][] bubbles;
    private boolean[][] bubblesFlags;
    private int firstRowWithBubbles = 0;
    private int rowWithBubbles = 0;
    private boolean[] rowOffset;
    public int randBubblesCount = 0;
    public int[] randBubbles;
    private Graphics gameCanvas;
    private MainGame mainGame;
    private Rect displayRect;
    public int phizBubblesCount = 0;
    public Bubble[] phizBubbles;
    private Rect tempRect;
    private Random rand = new Random();
    private Vector deadBubblesVector;
    private int curDeadBubbleIndex = 19;
    private int curBubbleDeadState = 2;
    public int playerScore = -1;
    private int newPlayerScore = 0;
    private Font scoreFont = Font.getFont((int)64, (int)1, (int)8);
    private Font levelInfoFont = Font.getFont((int)64, (int)1, (int)0);

    BubbleField() {
    }

    public boolean loadPhizBubbles(int n) {
        this.phizBubblesCount = n;
        this.phizBubbles = new Bubble[n];
        this.tempRect = new Rect();
        int n2 = 0;
        while (n2 < n) {
            this.phizBubbles[n2] = new Bubble();
            if (!this.phizBubbles[n2].loadBubble("/images/balls/ball_" + n2 + ".png", n2, 0, 0, 0, 0)) {
                DebugEx.debugOut("loading bubble fail i=" + n2);
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean createBubblesMap(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.totalBubbleCount = 0;
        this.bubbleInRow = n;
        this.rows = n2;
        this.showLevelInfoDelay = -1;
        this.resetCurPlayerScore();
        try {
            int n8;
            this.bubbles = new int[n][n2];
            this.bubblesFlags = new boolean[n][n2];
            this.rowOffset = new boolean[n2];
            this.randBubblesCount = n4;
            this.randBubbles = new int[this.randBubblesCount];
            int n9 = 0;
            while (n9 < n) {
                this.bubbles[n9][0] = 17;
                this.bubblesFlags[n9][0] = false;
                ++n9;
            }
            this.bubbles[0][0] = 16;
            this.bubbles[n - 1][0] = 18;
            this.rowOffset[0] = false;
            boolean bl = true;
            int n10 = 1;
            while (n10 < n2) {
                n8 = 0;
                while (n8 < n) {
                    this.bubbles[n8][n10] = -1;
                    this.bubblesFlags[n8][n10] = true;
                    ++n8;
                }
                this.rowOffset[n10] = bl;
                bl = !bl;
                ++n10;
            }
            this.firstRowWithBubbles = 0;
            this.rowWithBubbles = 0;
            n8 = 0;
            while (n8 < n3) {
                this.addRandomRow();
                ++n8;
            }
            int[] nArray = new int[7];
            int n11 = -1;
            int n12 = 1;
            int n13 = 1;
            int n14 = 1;
            if (this.mainGame.gameDifficulty > 0) {
                int n15 = 0;
                while (n15 < this.randBubblesCount) {
                    int n16 = Math.abs(this.rand.nextInt()) % 10;
                    if (n16 == 8) {
                        if (n13 > n7) {
                            --n15;
                        } else {
                            this.randBubbles[n15] = 14;
                            ++n13;
                        }
                    } else if (n16 == 9) {
                        if (n12 > n6) {
                            --n15;
                        } else {
                            this.randBubbles[n15] = 15;
                            ++n12;
                        }
                    } else {
                        int n17;
                        if (n16 == 7) {
                            if (n14 > n5) {
                                --n15;
                            } else {
                                n16 = 7 + Math.abs(this.rand.nextInt()) % 7;
                                ++n14;
                            }
                        }
                        if ((n17 = n16 % 7) != n11) {
                            if (n17 >= 0 && n17 < 7) {
                                int n18 = n17;
                                nArray[n18] = nArray[n18] + 1;
                            }
                            if (n11 < 0) {
                                n11 = n17;
                            } else if (nArray[n11] < nArray[n17]) {
                                n11 = n17;
                            }
                            this.randBubbles[n15] = n16;
                        } else {
                            --n15;
                        }
                    }
                    ++n15;
                }
            } else {
                int n19 = 0;
                while (n19 < this.randBubblesCount) {
                    int n20 = Math.abs(this.rand.nextInt()) % 9;
                    if (n20 == 7) {
                        if (n13 > n7) {
                            --n19;
                        } else {
                            this.randBubbles[n19] = 14;
                            ++n13;
                        }
                    } else if (n20 == 8) {
                        if (n12 > n6) {
                            --n19;
                        } else {
                            this.randBubbles[n19] = 15;
                            ++n12;
                        }
                    } else {
                        int n21 = n20 % 7;
                        if (n21 != n11) {
                            if (n21 >= 0 && n21 < 7) {
                                int n22 = n21;
                                nArray[n22] = nArray[n22] + 1;
                            }
                            if (n11 < 0) {
                                n11 = n21;
                            } else if (nArray[n11] < nArray[n21]) {
                                n11 = n21;
                            }
                            this.randBubbles[n19] = n20;
                        } else {
                            --n19;
                        }
                    }
                    ++n19;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugEx.debugOut("Err create bubbles array");
            return false;
        }
        return true;
    }

    public boolean saveCurBubblesMap(boolean bl) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"LastBubbleFieldMap", (boolean)true);
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"LastBubbleFieldMap");
            if (bl) {
                return true;
            }
            recordStore = RecordStore.openRecordStore((String)"LastBubbleFieldMap", (boolean)true);
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Saving Player Score");
            byte[] byArray = ("" + this.playerScore).getBytes();
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Saving Player Score");
            byArray = new byte[]{(byte)this.mainGame.gameMode, (byte)this.mainGame.gameDifficulty, (byte)this.mainGame.gameLevel, (byte)this.firstRowWithBubbles, (byte)this.rowWithBubbles, (byte)this.mainGame.gunExModeFireCount, (byte)this.totalBubbleCount, (byte)this.mainGame.gameState};
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Saving Bubbles Map");
            byArray = new byte[this.rows * this.bubbleInRow * 2 + 2];
            byArray[0] = (byte)this.bubbleInRow;
            byArray[1] = (byte)this.rows;
            int n = 2;
            int n2 = 0;
            while (n2 < this.rows) {
                int n3 = 0;
                while (n3 < this.bubbleInRow) {
                    byArray[n++] = (byte)this.bubbles[n3][n2];
                    byArray[n++] = (byte)(this.bubblesFlags[n3][n2] ? 1 : 0);
                    ++n3;
                }
                ++n2;
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Saving Bubbles Offsets");
            byArray = new byte[this.rows];
            n = 0;
            int n4 = 0;
            while (n4 < this.rows) {
                byArray[n++] = (byte)(this.rowOffset[n4] ? 1 : 0);
                ++n4;
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Saving Rand Bubbles Arr");
            byArray = new byte[this.randBubblesCount + 2];
            byArray[0] = (byte)this.mainGame.bubbleGun.curRandBubble;
            byArray[1] = (byte)this.randBubblesCount;
            n = 2;
            int n5 = 0;
            while (n5 < this.randBubblesCount) {
                byArray[n++] = (byte)this.randBubbles[n5];
                ++n5;
            }
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Save. Rec in store=" + recordStore.getNumRecords());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error loading game.");
            return false;
        }
        return true;
    }

    public boolean loadCurBubblesMap() {
        RecordStore recordStore = null;
        this.showLevelInfoDelay = -1;
        try {
            DebugEx.debugOut("Opening Save Game Store.");
            recordStore = RecordStore.openRecordStore((String)"LastBubbleFieldMap", (boolean)true);
            DebugEx.debugOut("Load. Rec in store=" + recordStore.getNumRecords());
            if (recordStore.getNumRecords() < 5) {
                DebugEx.debugOut("Not all data saved");
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                    DebugEx.debugOut("Error close game stote.");
                }
                return false;
            }
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Loading Player Score");
            byte[] byArray = recordStore.getRecord(1);
            if (byArray.length <= 0) {
                DebugEx.debugOut("Error recev saved data.");
                throw new Exception();
            }
            String string = new String(byArray);
            try {
                this.newPlayerScore = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DebugEx.debugOut("This is not a Interger:" + string);
                throw new Exception();
            }
            DebugEx.debugOut("Loading Game Param");
            byArray = recordStore.getRecord(2);
            if (byArray.length < 8) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.mainGame.gameMode = byArray[0];
            this.mainGame.gameDifficulty = byArray[1];
            this.mainGame.gameLevel = byArray[2];
            this.firstRowWithBubbles = byArray[3];
            this.rowWithBubbles = byArray[4];
            this.mainGame.gunExModeFireCount = byArray[5];
            this.totalBubbleCount = byArray[6];
            this.mainGame.gameState = byArray[7];
            DebugEx.debugOut("Loading Bubble Map");
            byArray = recordStore.getRecord(3);
            if (byArray.length < 3) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.bubbleInRow = byArray[0];
            this.rows = byArray[1];
            this.bubbles = new int[this.bubbleInRow][this.rows];
            this.bubblesFlags = new boolean[this.bubbleInRow][this.rows];
            if (byArray.length < this.bubbleInRow * this.rows * 2 + 2) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            int n = 2;
            int n2 = 0;
            while (n2 < this.rows) {
                int n3 = 0;
                while (n3 < this.bubbleInRow) {
                    this.bubbles[n3][n2] = byArray[n++];
                    this.bubblesFlags[n3][n2] = byArray[n++] != 0;
                    ++n3;
                }
                ++n2;
            }
            DebugEx.debugOut("Load Bubbles Offsets");
            byArray = recordStore.getRecord(4);
            if (byArray.length < this.rows) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.rowOffset = new boolean[this.rows];
            n = 0;
            int n4 = 0;
            while (n4 < this.rows) {
                this.rowOffset[n4] = byArray[n++] != 0;
                ++n4;
            }
            DebugEx.debugOut("Loading Rand Bubbles Array");
            byArray = recordStore.getRecord(5);
            recordStore.closeRecordStore();
            if (byArray.length <= 2) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.mainGame.bubbleGun.curRandBubble = byArray[0];
            this.randBubblesCount = byArray[1];
            this.randBubbles = new int[this.randBubblesCount];
            n = 2;
            int n5 = 0;
            while (n5 < this.randBubblesCount) {
                this.randBubbles[n5] = byArray[n++];
                ++n5;
            }
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error loading game.");
            return false;
        }
        return true;
    }

    public boolean loadBubblesMap(int n, int n2, int n3) {
        String string = "/level/" + n + "/" + n2 + ".dat";
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string));
        int n4 = 0;
        boolean bl = false;
        char[] cArray = new char[100];
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        this.firstRowWithBubbles = 0;
        this.rowWithBubbles = 0;
        this.totalBubbleCount = 0;
        this.showLevelInfoDelay = -1;
        do {
            boolean bl2 = false;
            int n8 = 0;
            do {
                try {
                    byte by = dataInputStream.readByte();
                    if (by < 0) {
                        bl = true;
                        DebugEx.debugOut("EOF");
                        continue;
                    }
                    if (by == 13) {
                        by = dataInputStream.readByte();
                        bl2 = true;
                        continue;
                    }
                    if (by == 32) {
                        bl2 = true;
                        continue;
                    }
                    cArray[n8++] = (char)by;
                }
                catch (IOException iOException) {
                    bl = true;
                }
            } while (!bl && !bl2);
            if (!bl && bl2 && n8 > 0) {
                int n9;
                int n10;
                int n11;
                cArray[n8++] = '\u0000';
                String string2 = new String(cArray).trim();
                if (n4 == 0) {
                    try {
                        this.bubbleInRow = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        DebugEx.debugOut("This is not a Interger:" + string2);
                        return false;
                    }
                }
                if (n4 == 1) {
                    try {
                        this.bubbles = new int[this.bubbleInRow][this.rows];
                        this.bubblesFlags = new boolean[this.bubbleInRow][this.rows];
                        this.rowOffset = new boolean[this.rows];
                        n11 = 0;
                        while (n11 < this.bubbleInRow) {
                            this.bubbles[n11][0] = 17;
                            this.bubblesFlags[n11][0] = false;
                            ++n11;
                        }
                        this.bubbles[0][0] = 16;
                        this.bubbles[this.bubbleInRow - 1][0] = 18;
                        this.rowOffset[0] = false;
                        boolean bl3 = true;
                        n10 = 1;
                        while (n10 < this.rows) {
                            n9 = 0;
                            while (n9 < this.bubbleInRow) {
                                this.bubbles[n9][n10] = -1;
                                this.bubblesFlags[n9][n10] = true;
                                ++n9;
                            }
                            this.rowOffset[n10] = bl3;
                            bl3 = !bl3;
                            ++n10;
                        }
                    }
                    catch (Exception exception) {
                        DebugEx.debugOut("Err create bubbles array");
                        return false;
                    }
                    n7 = 1;
                } else if (n4 > 1 && n7 == 1) {
                    if (string2.compareTo("$") == 0) {
                        n7 = 2;
                        this.rowWithBubbles = n5 - 1;
                        DebugEx.debugOut(" array=" + this.rowWithBubbles);
                    } else if (string2.compareTo("-") == 0) {
                        this.bubbles[n6][n5] = -1;
                    } else {
                        ++this.totalBubbleCount;
                        try {
                            this.bubbles[n6][n5] = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            DebugEx.debugOut("This is not a Interger:" + string2);
                            return false;
                        }
                    }
                    if (++n6 >= this.bubbleInRow) {
                        ++n5;
                        n6 = 0;
                    }
                } else if (n4 > 1 && n7 == 2) {
                    this.randBubblesCount = n11 = string2.length();
                    if (this.randBubblesCount > 0) {
                        if (this.randBubblesCount < n3) {
                            this.randBubblesCount = n3;
                        }
                        this.randBubbles = new int[this.randBubblesCount];
                        int[] nArray = new int[7];
                        n10 = -1;
                        int n12 = 0;
                        while (n12 < this.randBubblesCount) {
                            if (n12 < n11) {
                                try {
                                    this.randBubbles[n12] = Character.digit(string2.charAt(n12), 10);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    DebugEx.debugOut("This is not a Interger:" + string2);
                                    return false;
                                }
                            } else {
                                n9 = Math.abs(this.rand.nextInt()) % 7;
                                if (n9 != n10) {
                                    if (n9 >= 0 && n9 < 7) {
                                        int n13 = n9;
                                        nArray[n13] = nArray[n13] + 1;
                                    }
                                    if (n10 < 0) {
                                        n10 = n9;
                                    } else if (nArray[n10] < nArray[n9]) {
                                        n10 = n9;
                                    }
                                    this.randBubbles[n12] = n9;
                                } else {
                                    --n12;
                                }
                            }
                            ++n12;
                        }
                    }
                    n7 = 0;
                }
            }
            ++n4;
        } while (!bl);
        return true;
    }

    public boolean connectFieldData(MainGame mainGame) {
        if (mainGame == null) {
            return false;
        }
        this.mainGame = mainGame;
        this.gameCanvas = mainGame.gameCanvas;
        return true;
    }

    public boolean createField(Rect rect) {
        if (this.bubbleInRow <= 0 || this.phizBubblesCount <= 0) {
            return false;
        }
        this.bubbleWidth = this.phizBubbles[0].rect.width;
        this.bubbleHeight = this.phizBubbles[0].rect.height;
        this.bubbleRadius = this.phizBubbles[0].rect.getRadius();
        this.bubblesDX = this.bubbleRadius * 2 + 2;
        this.bubblesDY = 8660 * (this.bubbleRadius * 2 + 2) / 10000;
        this.fieldWidth = this.bubblesDX * this.bubbleInRow + this.bubblesDX / 2 + 2;
        this.fieldHeight = this.bubblesDY * this.rows + this.bubblesDY / 2;
        if (this.fieldWidth <= 0 || this.fieldHeight <= 0) {
            return false;
        }
        this.fieldGameX = rect.x + rect.width / 2 - this.fieldWidth / 2;
        if (this.fieldGameX <= 0) {
            this.fieldGameX = 1;
        }
        this.fieldGameY = rect.y + rect.height - this.fieldHeight;
        this.displayRect = new Rect(this.fieldGameX, this.fieldGameY, this.fieldWidth, this.fieldHeight);
        try {
            this.deadBubblesVector = new Vector();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isGameOwer() {
        return this.rowWithBubbles >= this.rows - 1;
    }

    public boolean isPlayerWin() {
        return this.totalBubbleCount == 0;
    }

    public Rect getFieldRect() {
        return this.displayRect;
    }

    public PointXY getBubbleXY(int n, int n2) {
        int n3 = 0;
        n3 = this.rowOffset[n2] ? this.fieldGameX + 1 + (this.bubbleWidth + 1) / 2 + this.bubblesDX * n : this.fieldGameX + 1 + this.bubblesDX * n;
        return new PointXY(n3, this.fieldGameY + 1 + this.bubblesDY * n2);
    }

    public int getFirstRowBotY() {
        return this.fieldGameY + 1 + this.bubblesDY * (this.firstRowWithBubbles + 1);
    }

    public Rect getBubbleRect(int n, int n2) {
        int n3 = 0;
        n3 = this.rowOffset[n2] ? this.fieldGameX + 1 + (this.bubbleWidth + 1) / 2 + this.bubblesDX * n : this.fieldGameX + 1 + this.bubblesDX * n;
        return new Rect(n3, this.fieldGameY + 1 + this.bubblesDY * n2, this.bubblesDX - 1, this.bubblesDY - 1);
    }

    public PointXY getBubbleOffset(int n, int n2) {
        int n3 = (n2 - this.fieldGameY - 1) / this.bubblesDY;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.rows) {
            n3 = this.rows - 1;
        }
        int n4 = 0;
        n4 = this.rowOffset[n3] ? (n - this.fieldGameX - 1 - (this.bubbleWidth + 1) / 2) / this.bubblesDX : (n - this.fieldGameX - 1) / this.bubblesDX;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= this.bubbleInRow) {
            n4 = this.bubbleInRow - 1;
        }
        return new PointXY(n4, n3);
    }

    public void redrawAllField() {
        int n = -1;
        int n2 = 0;
        while (n2 <= this.rowWithBubbles) {
            int n3 = 0;
            while (n3 < this.bubbleInRow) {
                n = this.bubbles[n3][n2];
                if (n >= 0 && n < 100) {
                    Bubble bubble = this.phizBubbles[n];
                    bubble.setXY(this.getBubbleXY(n3, n2));
                    bubble.drawBubble(this.gameCanvas);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public boolean testBubbleStick(Bubble bubble, boolean bl) {
        int n;
        int n2;
        int n3;
        PointXY pointXY;
        Rect rect = new Rect(bubble.rect.x, bubble.rect.y, this.bubblesDX, this.bubblesDY);
        PointXY pointXY2 = rect.getLower();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Object var9_9 = null;
        Rect rect2 = null;
        int n4 = -1;
        PointXY pointXY3 = this.getBubbleOffset(rect.x, rect.y);
        int n5 = this.bubbles[pointXY3.x][pointXY3.y];
        if (n5 >= 0 && n5 < this.phizBubblesCount && rect.intersectRound(this.getBubbleRect(pointXY3.x, pointXY3.y))) {
            bl2 = true;
            n4 = n5;
        }
        PointXY pointXY4 = this.getBubbleOffset(pointXY2.x, rect.y);
        int n6 = this.bubbles[pointXY4.x][pointXY4.y];
        if (!bl2 && n6 >= 0 && n6 < this.phizBubblesCount && rect.intersectRound(this.getBubbleRect(pointXY4.x, pointXY4.y))) {
            bl2 = true;
            n4 = n6;
        }
        PointXY pointXY5 = this.getBubbleOffset(rect.x, pointXY2.y);
        int n7 = this.bubbles[pointXY5.x][pointXY5.y];
        if (!bl2 && n7 >= 0 && n7 < this.phizBubblesCount && rect.intersectRound(rect2 = this.getBubbleRect(pointXY5.x, pointXY5.y))) {
            bl2 = true;
            n4 = n7;
        }
        PointXY pointXY6 = this.getBubbleOffset(pointXY2.x, pointXY2.y);
        int n8 = this.bubbles[pointXY6.x][pointXY6.y];
        if (!bl2 && n8 >= 0 && n8 < this.phizBubblesCount && rect.intersectRound(this.getBubbleRect(pointXY6.x, pointXY6.y))) {
            bl2 = true;
            n4 = n8;
        }
        if (!bl2) {
            return false;
        }
        int n9 = -1;
        int n10 = Integer.MAX_VALUE;
        if (n5 < 0) {
            pointXY = this.getBubbleXY(pointXY3.x, pointXY3.y);
            n3 = pointXY.x - rect.x;
            n2 = pointXY.y - rect.y;
            n = n3 * n3 + n2 * n2;
            if (n < n10) {
                n9 = 0;
                n10 = n;
            }
        }
        if (n6 < 0) {
            pointXY = this.getBubbleXY(pointXY4.x, pointXY4.y);
            n3 = pointXY.x - rect.x;
            n2 = pointXY.y - rect.y;
            n = n3 * n3 + n2 * n2;
            if (n < n10) {
                n9 = 1;
                n10 = n;
            }
        }
        if (n7 < 0) {
            pointXY = this.getBubbleXY(pointXY5.x, pointXY5.y);
            n3 = pointXY.x - rect.x;
            n2 = pointXY.y - rect.y;
            n = n3 * n3 + n2 * n2;
            if (n < n10) {
                n9 = 2;
                n10 = n;
            }
        }
        if (n8 < 0) {
            pointXY = this.getBubbleXY(pointXY6.x, pointXY6.y);
            n3 = pointXY.x - rect.x;
            n2 = pointXY.y - rect.y;
            n = n3 * n3 + n2 * n2;
            if (n < n10) {
                n9 = 3;
                n10 = n;
            }
        }
        switch (n9) {
            case 0: {
                if (bubble.phizBubbleIndex == 14) {
                    bubble.phizBubbleIndex = n4 <= 13 ? n4 % 7 : Math.abs(this.rand.nextInt()) % 7;
                    bubble.img = this.phizBubbles[bubble.phizBubbleIndex].img;
                }
                bubble.setXY(this.getBubbleXY(pointXY3.x, pointXY3.y));
                if (bl) {
                    this.bubbles[pointXY3.x][pointXY3.y] = bubble.phizBubbleIndex;
                    if (this.rowWithBubbles < pointXY3.y) {
                        this.rowWithBubbles = pointXY3.y;
                    }
                    this.foundDeadBubbles(pointXY3);
                    ++this.totalBubbleCount;
                }
                return true;
            }
            case 1: {
                if (bubble.phizBubbleIndex == 14) {
                    bubble.phizBubbleIndex = n4 <= 13 ? n4 % 7 : Math.abs(this.rand.nextInt()) % 7;
                    bubble.img = this.phizBubbles[bubble.phizBubbleIndex].img;
                }
                bubble.setXY(this.getBubbleXY(pointXY4.x, pointXY4.y));
                if (bl) {
                    this.bubbles[pointXY4.x][pointXY4.y] = bubble.phizBubbleIndex;
                    if (this.rowWithBubbles < pointXY4.y) {
                        this.rowWithBubbles = pointXY4.y;
                    }
                    this.foundDeadBubbles(pointXY4);
                    ++this.totalBubbleCount;
                }
                return true;
            }
            case 2: {
                if (bubble.phizBubbleIndex == 14) {
                    bubble.phizBubbleIndex = n4 <= 13 ? n4 % 7 : Math.abs(this.rand.nextInt()) % 7;
                    bubble.img = this.phizBubbles[bubble.phizBubbleIndex].img;
                }
                bubble.setXY(this.getBubbleXY(pointXY5.x, pointXY5.y));
                if (bl) {
                    this.bubbles[pointXY5.x][pointXY5.y] = bubble.phizBubbleIndex;
                    if (this.rowWithBubbles < pointXY5.y) {
                        this.rowWithBubbles = pointXY5.y;
                    }
                    this.foundDeadBubbles(pointXY5);
                    ++this.totalBubbleCount;
                }
                return true;
            }
            case 3: {
                if (bubble.phizBubbleIndex == 14) {
                    bubble.phizBubbleIndex = n4 <= 13 ? n4 % 7 : Math.abs(this.rand.nextInt()) % 7;
                    bubble.img = this.phizBubbles[bubble.phizBubbleIndex].img;
                }
                bubble.setXY(this.getBubbleXY(pointXY6.x, pointXY6.y));
                if (bl) {
                    this.bubbles[pointXY6.x][pointXY6.y] = bubble.phizBubbleIndex;
                    if (this.rowWithBubbles < pointXY6.y) {
                        this.rowWithBubbles = pointXY6.y;
                    }
                    this.foundDeadBubbles(pointXY6);
                    ++this.totalBubbleCount;
                }
                return true;
            }
        }
        return false;
    }

    public boolean addEmptyRow() {
        if (this.isGameOwer()) {
            return false;
        }
        int n = 0;
        while (n < this.bubbleInRow) {
            System.arraycopy(this.bubbles[n], 0, this.bubbles[n], 1, this.rowWithBubbles + 1);
            System.arraycopy(this.bubblesFlags[n], 0, this.bubblesFlags[n], 1, this.rowWithBubbles + 1);
            this.bubbles[n][0] = -1;
            this.bubblesFlags[n][0] = false;
            ++n;
        }
        System.arraycopy(this.rowOffset, 0, this.rowOffset, 1, this.rows - 1);
        this.rowOffset[0] = !this.rowOffset[1];
        ++this.rowWithBubbles;
        ++this.firstRowWithBubbles;
        return true;
    }

    public boolean addRandomRow() {
        if (this.isGameOwer()) {
            return false;
        }
        int n = 0;
        while (n < this.bubbleInRow) {
            System.arraycopy(this.bubbles[n], this.firstRowWithBubbles + 1, this.bubbles[n], this.firstRowWithBubbles + 2, this.rows - this.firstRowWithBubbles - 2);
            this.bubbles[n][this.firstRowWithBubbles + 1] = Math.abs(this.rand.nextInt()) % 7;
            this.bubblesFlags[n][this.firstRowWithBubbles + 1] = true;
            ++n;
        }
        System.arraycopy(this.rowOffset, this.firstRowWithBubbles + 1, this.rowOffset, this.firstRowWithBubbles + 2, this.rows - this.firstRowWithBubbles - 2);
        this.rowOffset[this.firstRowWithBubbles + 1] = !this.rowOffset[this.firstRowWithBubbles + 2];
        this.totalBubbleCount += this.bubbleInRow;
        ++this.rowWithBubbles;
        return true;
    }

    private void addDeadBubbles(int n, int n2, int n3) {
        if (n >= 0 && n < this.bubbleInRow && n2 > this.firstRowWithBubbles && n2 <= this.rowWithBubbles && n2 < this.rows && this.bubbles[n][n2] >= 0 && this.bubbles[n][n2] <= 13 && this.bubbles[n][n2] % 7 == n3) {
            this.deadBubblesVector.addElement(new PointXY(n, n2, this.bubbles[n][n2]));
            this.bubbles[n][n2] = 19;
        }
    }

    private void addDeadBombBubbles(int n, int n2) {
        if (n >= 0 && n < this.bubbleInRow && n2 > this.firstRowWithBubbles && n2 <= this.rowWithBubbles && n2 < this.rows && this.bubbles[n][n2] >= 0 && this.bubbles[n][n2] <= 13) {
            this.bubbles[n][n2] = 19;
            this.deadBubblesVector.addElement(new PointXY(n, n2));
        }
    }

    public int foundDeadBubbles(PointXY pointXY) {
        int n;
        this.deadBubblesVector.removeAllElements();
        pointXY.z = n = this.bubbles[pointXY.x][pointXY.y];
        if (n >= 7 && n <= 13) {
            n %= 7;
        }
        this.bubbles[pointXY.x][pointXY.y] = 19;
        this.deadBubblesVector.addElement(pointXY);
        if (n == 15) {
            if (this.rowOffset[pointXY.y]) {
                int n2 = 0;
                while (n2 < 14) {
                    this.addDeadBombBubbles(pointXY.x + BUBBLE_BOMB_DETONATION_ARRAY_2[n2][0], pointXY.y + BUBBLE_BOMB_DETONATION_ARRAY_2[n2][1]);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < 14) {
                    this.addDeadBombBubbles(pointXY.x + BUBBLE_BOMB_DETONATION_ARRAY_1[n3][0], pointXY.y + BUBBLE_BOMB_DETONATION_ARRAY_1[n3][1]);
                    ++n3;
                }
            }
        } else {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.deadBubblesVector.size()) {
                PointXY pointXY2 = (PointXY)this.deadBubblesVector.elementAt(n7);
                n4 = pointXY2.x - 1;
                n5 = pointXY2.x + 1;
                n6 = pointXY2.y;
                this.addDeadBubbles(n4, n6, n);
                this.addDeadBubbles(n5, n6, n);
                n6 = pointXY2.y - 1;
                n4 = pointXY2.x;
                n5 = this.rowOffset[n6] ? pointXY2.x - 1 : pointXY2.x + 1;
                this.addDeadBubbles(n4, n6, n);
                this.addDeadBubbles(n5, n6, n);
                n6 = pointXY2.y + 1;
                if (n6 < this.rows) {
                    n5 = this.rowOffset[n6] ? pointXY2.x - 1 : pointXY2.x + 1;
                    this.addDeadBubbles(n4, n6, n);
                    this.addDeadBubbles(n5, n6, n);
                }
                ++n7;
            }
            if (this.deadBubblesVector.size() < 3) {
                int n8 = 0;
                while (n8 < this.deadBubblesVector.size()) {
                    PointXY pointXY3 = (PointXY)this.deadBubblesVector.elementAt(n8);
                    this.bubbles[pointXY3.x][pointXY3.y] = pointXY3.z;
                    ++n8;
                }
                this.deadBubblesVector.removeAllElements();
            } else {
                int n9 = 0;
                while (n9 < this.deadBubblesVector.size()) {
                    PointXY pointXY4 = (PointXY)this.deadBubblesVector.elementAt(n9);
                    if (pointXY4.z >= 7 && pointXY4.z <= 13) {
                        this.mainGame.addGunExModeFireCount();
                        break;
                    }
                    ++n9;
                }
            }
        }
        return this.deadBubblesVector.size();
    }

    public int redrawDeadBubbles(Graphics graphics) {
        PointXY pointXY;
        if (this.deadBubblesVector.size() == 0) {
            return -1;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.deadBubblesVector.size()) {
            pointXY = (PointXY)this.deadBubblesVector.elementAt(n2);
            n = this.bubbles[pointXY.x][pointXY.y];
            if (n >= 0 && n < 100) {
                Bubble bubble = this.phizBubbles[n];
                bubble.setXY(this.getBubbleXY(pointXY.x, pointXY.y));
                bubble.drawBubble(graphics);
                this.bubbles[pointXY.x][pointXY.y] = this.curDeadBubbleIndex;
            }
            ++n2;
        }
        if (this.curBubbleDeadState > 0) {
            --this.curBubbleDeadState;
        } else {
            ++this.curDeadBubbleIndex;
            this.curBubbleDeadState = 2;
        }
        if (this.curDeadBubbleIndex > 23) {
            this.curDeadBubbleIndex = 19;
            this.curBubbleDeadState = 2;
            int n3 = 0;
            while (n3 < this.deadBubblesVector.size()) {
                pointXY = (PointXY)this.deadBubblesVector.elementAt(n3);
                this.bubbles[pointXY.x][pointXY.y] = -1;
                ++n3;
            }
            this.mainGame.redrawAll();
            int n4 = 0;
            while (n4 < this.deadBubblesVector.size()) {
                pointXY = (PointXY)this.deadBubblesVector.elementAt(n4);
                this.phizBubbles[0].setXY(this.getBubbleXY(pointXY.x, pointXY.y));
                this.mainGame.redrawBackBufferRect(graphics, this.phizBubbles[0].rect);
                ++n4;
            }
            boolean bl = false;
            while (this.rowWithBubbles >= this.firstRowWithBubbles) {
                int n5 = 0;
                while (n5 < this.bubbleInRow) {
                    if (this.bubbles[n5][this.rowWithBubbles] >= 0) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (bl) break;
                --this.rowWithBubbles;
            }
            this.totalBubbleCount -= this.deadBubblesVector.size();
            this.newPlayerScore += 15 * this.deadBubblesVector.size();
            this.deadBubblesVector.removeAllElements();
            return 1;
        }
        return 0;
    }

    private void addNotFallBubbles(int n, int n2) {
        if (n >= 0 && n < this.bubbleInRow && n2 > this.firstRowWithBubbles && n2 <= this.rowWithBubbles && n2 < this.rows && this.bubblesFlags[n][n2] && this.bubbles[n][n2] >= 0 && this.bubbles[n][n2] <= 13) {
            this.bubblesFlags[n][n2] = false;
            this.deadBubblesVector.addElement(new PointXY(n, n2));
        }
    }

    public int foundFallBubbles() {
        PointXY pointXY;
        this.deadBubblesVector.removeAllElements();
        int n = 0;
        while (n < this.bubbleInRow) {
            this.addNotFallBubbles(n, this.firstRowWithBubbles + 1);
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.deadBubblesVector.size()) {
            pointXY = (PointXY)this.deadBubblesVector.elementAt(n5);
            n2 = pointXY.x - 1;
            n3 = pointXY.x + 1;
            n4 = pointXY.y;
            this.addNotFallBubbles(n2, n4);
            this.addNotFallBubbles(n3, n4);
            n4 = pointXY.y - 1;
            n2 = pointXY.x;
            n3 = this.rowOffset[n4] ? pointXY.x - 1 : pointXY.x + 1;
            this.addNotFallBubbles(n2, n4);
            this.addNotFallBubbles(n3, n4);
            if (n4 < this.rows) {
                n4 = pointXY.y + 1;
                n3 = this.rowOffset[n4] ? pointXY.x - 1 : pointXY.x + 1;
                this.addNotFallBubbles(n2, n4);
                this.addNotFallBubbles(n3, n4);
            }
            ++n5;
        }
        int n6 = this.deadBubblesVector.size();
        if (this.totalBubbleCount - n6 <= 0) {
            int n7 = 0;
            while (n7 < n6) {
                pointXY = (PointXY)this.deadBubblesVector.elementAt(n7);
                this.bubblesFlags[pointXY.x][pointXY.y] = true;
                ++n7;
            }
        } else {
            this.deadBubblesVector.removeAllElements();
            int n8 = -1;
            int n9 = this.rowWithBubbles;
            while (n9 > this.firstRowWithBubbles) {
                boolean bl = true;
                int n10 = 0;
                while (n10 < this.bubbleInRow) {
                    n8 = this.bubbles[n10][n9];
                    if (n8 >= 0 && n8 < 16) {
                        if (this.bubblesFlags[n10][n9]) {
                            Bubble bubble = new Bubble(this.phizBubbles[n8]);
                            bubble.setXY(this.getBubbleXY(n10, n9));
                            bubble.setDyFR(0);
                            this.deadBubblesVector.addElement(bubble);
                            this.bubbles[n10][n9] = -1;
                        } else {
                            bl = false;
                        }
                    }
                    this.bubblesFlags[n10][n9] = true;
                    ++n10;
                }
                if (bl) {
                    --this.rowWithBubbles;
                }
                --n9;
            }
            this.totalBubbleCount -= this.deadBubblesVector.size();
            this.newPlayerScore += 25 * this.deadBubblesVector.size();
            return this.deadBubblesVector.size();
        }
        this.deadBubblesVector.removeAllElements();
        return 0;
    }

    public boolean redrawFallBubbles(Graphics graphics) {
        if (this.deadBubblesVector.size() == 0) {
            return true;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.deadBubblesVector.size()) {
            Bubble bubble = (Bubble)this.deadBubblesVector.elementAt(n2);
            if (this.displayRect.intersection(bubble.rect, this.tempRect)) {
                this.mainGame.redrawBackBufferRect(graphics, this.tempRect);
            }
            bubble.move(this.mainGame.bigFieldRect);
            bubble.setDyFR(bubble.getDyFR() + 7000);
            if (bubble.bubbleHitBotWall) {
                this.deadBubblesVector.removeElementAt(n2);
                --n2;
            } else {
                graphics.setClip(this.displayRect.x, this.displayRect.y, this.displayRect.width, this.displayRect.height);
                bubble.drawBubble(graphics);
            }
            ++n2;
        }
        return this.deadBubblesVector.size() != 0;
    }

    public void redrawCurPlayerScore(Graphics graphics, Rect rect, boolean bl) {
        if (this.playerScore == this.newPlayerScore && bl) {
            return;
        }
        this.playerScore = this.newPlayerScore;
        this.mainGame.redrawBackBufferRect(graphics, rect);
        graphics.setColor(255, 255, 255);
        String string = this.playerScore >= 1000 ? this.playerScore / 1000 + " " + this.playerScore % 1000 / 100 + this.playerScore % 100 / 10 + this.playerScore % 10 : "" + this.playerScore;
        graphics.setFont(this.scoreFont);
        graphics.drawString(string, rect.x + rect.width, rect.y, 0x10 | 8);
    }

    public void resetCurPlayerScore() {
        this.playerScore = -1;
        this.newPlayerScore = 0;
    }

    public boolean addScoreWhenPlayerWins(Graphics graphics) {
        if (this.rowWithBubbles < this.rows - 1) {
            if (this.addNextBonusTime == 0) {
                this.addNextBonusTime = 5;
                this.newPlayerScore += 100;
                ++this.rowWithBubbles;
                int n = this.fieldGameY + 1 + this.bubblesDY * this.rowWithBubbles;
                String string = "+ 100";
                graphics.setColor(0, 0, 0);
                graphics.setFont(this.scoreFont);
                graphics.drawString(string, this.displayRect.x + this.displayRect.width / 2, n, 0x10 | 1);
            } else {
                --this.addNextBonusTime;
            }
            return false;
        }
        if (this.showLevelInfoDelay < 0) {
            if (this.mainGame.gameMode == 1) {
                this.showLevelInfoDelay = 80;
                if (this.mainGame.gameLevel < 10) {
                    this.mainGame.redrawBackImageInRect(graphics, this.displayRect);
                    graphics.setFont(this.levelInfoFont);
                    graphics.setColor(0, 0, 0);
                    graphics.drawString("Level", this.displayRect.x + this.displayRect.width / 2 - 5, this.displayRect.y + this.displayRect.height / 2 - 22, 0x10 | 1);
                    graphics.drawString("" + (this.mainGame.gameLevel + 2), this.displayRect.x + this.displayRect.width / 2 + 20, this.displayRect.y + this.displayRect.height / 2 - 22, 0x10 | 1);
                    graphics.setColor(255, 255, 0);
                    graphics.drawString("Level", this.displayRect.x + this.displayRect.width / 2 - 6, this.displayRect.y + this.displayRect.height / 2 - 23, 0x10 | 1);
                    graphics.setColor(255, 0, 255);
                    graphics.drawString("" + (this.mainGame.gameLevel + 2), this.displayRect.x + this.displayRect.width / 2 + 19, this.displayRect.y + this.displayRect.height / 2 - 23, 0x10 | 1);
                    graphics.setColor(0, 0, 0);
                    graphics.drawString("Difficulty:", this.displayRect.x + this.displayRect.width / 2 + 1, this.displayRect.y + this.displayRect.height / 2 + 1, 0x10 | 1);
                    graphics.setColor(255, 48, 99);
                    graphics.drawString("Difficulty:", this.displayRect.x + this.displayRect.width / 2, this.displayRect.y + this.displayRect.height / 2, 0x10 | 1);
                    String string = "none";
                    switch (this.mainGame.gameDifficulty) {
                        case 0: {
                            string = "Easy";
                            break;
                        }
                        case 1: {
                            string = "Medium";
                            break;
                        }
                        case 2: {
                            string = "Hard";
                        }
                    }
                    graphics.setColor(0, 0, 0);
                    graphics.drawString(string, this.displayRect.x + this.displayRect.width / 2 + 1, this.displayRect.y + this.displayRect.height / 2 + 16, 0x10 | 1);
                    graphics.setColor(123, 255, 123);
                    graphics.drawString(string, this.displayRect.x + this.displayRect.width / 2, this.displayRect.y + this.displayRect.height / 2 + 15, 0x10 | 1);
                }
            } else {
                this.showLevelInfoDelay = 0;
            }
        }
        if (this.showLevelInfoDelay > 0) {
            --this.showLevelInfoDelay;
            return false;
        }
        return true;
    }
}

