/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import ru.antares.GameUtils.GameMenu;
import ru.antares.GameUtils.MenuItem;
import ru.antares.utils.DebugEx;
import ru.antares.utils.Rect;

public class MainMenu {
    public static final int STORE_SIZE = 7;
    public GameMenu menu;
    private MainGameLoop mainGameLoop;
    private int width = 128;
    private int height = 128;
    public int gameMode = 0;
    public int gameDifficulty = 0;
    public int gameLevel = 0;
    public int minPlayerScore = 1;
    public int curPlayerScore = 0;
    public boolean vibrationOn = true;
    public boolean soundOn = false;
    public boolean musicOn = true;
    public boolean startPlay = false;
    public boolean exitMenu = false;
    private int scoreSize = 0;
    private int[] playerScore;
    private String[] playerName;
    private int[] playerGameMode;
    public TextBox textBox;
    private Command okCommand;
    private CommandListener softKeyListener;
    private MenuItem[] menuItems;
    private Font menuFont1;
    private Font menuFont2;
    private Font menuFont3;
    private int curMenuState = 0;
    private Sound sound;

    public MainMenu(MainGameLoop mainGameLoop, int n, int n2) {
        this.mainGameLoop = mainGameLoop;
        this.width = n;
        this.height = n2;
    }

    public boolean createMainMenu() {
        this.menu = new GameMenu();
        this.sound = new Sound();
        if (this.menu == null || !this.menu.createMenu(new Rect(0, 0, this.width, this.height))) {
            return false;
        }
        this.playerScore = new int[7];
        this.playerName = new String[7];
        this.playerGameMode = new int[7];
        this.menuItems = new MenuItem[8];
        this.menu.addNewImage("/images/BackFieldImage.png");
        this.menu.addNewImage("/images/BorderLeft.png");
        this.menu.addNewImage("/images/BorderRight_1.png");
        this.menu.addNewImage("/images/BorderRight_2.png");
        this.menu.drawImageToBackBufTile(0, 0, 0);
        this.menu.drawImageToBackBuf(1, 0, 0, new Rect(23, 0, 7, 111));
        this.menu.drawImageToBackBuf(2, 122, 0);
        this.menu.drawImageToBackBuf(3, 126, 0);
        this.menu.fillBackBuf(new Rect(0, 115, 128, 13), 0xFFFFFF);
        this.menu.removeAllImages();
        System.gc();
        this.loadGameParam();
        this.loadPlayerScoreStore();
        this.textBox = new TextBox("Enter your name", "", 11, 0);
        this.okCommand = new Command("OK", 4, 1);
        this.textBox.addCommand(this.okCommand);
        this.softKeyListener = new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                MainMenu.this.onSoftKeyPressed(command, displayable);
            }
        };
        this.textBox.setCommandListener(this.softKeyListener);
        this.menuFont1 = Font.getFont((int)64, (int)1, (int)0);
        this.menuFont2 = Font.getFont((int)64, (int)0, (int)0);
        this.menuFont3 = Font.getFont((int)64, (int)1, (int)8);
        this.menuItems[0] = new MenuItemEx(this.menu, -1, new Rect(3, 115, 40, 13), "Select", this.menuFont2, new int[]{0}, 0, false, true, -1);
        this.menuItems[0].itemID = -1;
        this.menuItems[1] = new MenuItemEx(this.menu, -1, new Rect(98, 115, 27, 13), "Exit", this.menuFont2, new int[]{0}, 0, false, true, 1);
        this.menuItems[2] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        this.menuItems[3] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        this.menuItems[4] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        this.menuItems[5] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        this.menuItems[6] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        this.menuItems[7] = new MenuItemEx(this.menu, -1, null, null, null, null, 0, false, false);
        return true;
    }

    public void performOnKeyFire(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                MenuItem menuItem2 = this.menu.getCurActiveDynamicItem();
                if (menuItem2 == null) break;
                menuItem2.onKeyFire();
                break;
            }
            case 0: {
                this.exitMenu = true;
                DebugEx.debugOut("   Exit");
                break;
            }
            case 1: 
            case 20: {
                this.menu.resetMenu();
                this.startPlay = true;
                this.sound.stopMIDI();
                DebugEx.debugOut("   Fire Start Play");
                break;
            }
            case 2: {
                this.mainGameLoop.resetOldLoadedGame();
                this.createMenuMainMenu();
                DebugEx.debugOut("   Fire Mein Menu");
                break;
            }
            case 10: {
                this.createMenuNewGame();
                DebugEx.debugOut("   Fire Mein Menu");
                break;
            }
            case 11: {
                this.createMenuOptions();
                DebugEx.debugOut("   Fire Options");
                break;
            }
            case 12: {
                this.createMenuHighScores();
                DebugEx.debugOut("   Fire High Scores");
                break;
            }
            case 13: {
                this.createMenuInstuction1();
                DebugEx.debugOut("   Fire Instruction");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                menuItem.onKeyRight();
                break;
            }
            case 26: {
                this.createMenuMainMenu();
                break;
            }
            case 40: {
                this.createMenuEnterPlayerName();
                break;
            }
            case 41: {
                this.createMenuPlayAgain();
                break;
            }
            case 60: {
                this.createMenuInstuction2();
                break;
            }
            case 61: {
                this.createMenuInstuction1();
            }
        }
    }

    public void performOnLossFocus(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                menuItem.setItemParam(false, true, 0);
                this.menu.forceRedrawPrevActiveDynamicItem();
            }
        }
    }

    public void performOnSetFocus(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 21: {
                this.gameMode = 0;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 22: {
                this.gameMode = 1;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 23: {
                this.gameDifficulty = 0;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 24: {
                this.gameDifficulty = 1;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 25: {
                this.gameDifficulty = 2;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 30: {
                this.mainGameLoop.gameCanvas.mainGame.soundOn = this.soundOn = true;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 31: {
                this.mainGameLoop.gameCanvas.mainGame.soundOn = this.soundOn = false;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 32: {
                this.mainGameLoop.gameCanvas.mainGame.musicOn = this.musicOn = true;
                if (this.musicOn) {
                    this.sound.playMIDI(0, 255);
                }
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 33: {
                this.mainGameLoop.gameCanvas.mainGame.musicOn = this.musicOn = false;
                this.sound.stopMIDI();
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 34: {
                this.mainGameLoop.gameCanvas.mainGame.vibrationOn = this.vibrationOn = true;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 35: {
                this.mainGameLoop.gameCanvas.mainGame.vibrationOn = this.vibrationOn = false;
                menuItem.setItemParam(true, true, 1);
                this.menu.forceRedrawCurActiveDynamicItem();
            }
        }
    }

    public void performOnKeyUp(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.menu.setPrevActiveDynamicItem();
            }
        }
    }

    public void performOnKeyDown(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.menu.setNextActiveDynamicItem();
            }
        }
    }

    public void performOnKeyLeft(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 21: {
                this.menu.changeCurActiveDynamicItem(4, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 22: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 23: {
                this.menu.changeCurActiveDynamicItem(8, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 24: {
                this.menu.changeCurActiveDynamicItem(6, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 25: {
                this.menu.changeCurActiveDynamicItem(7, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 30: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 31: {
                this.menu.changeCurActiveDynamicItem(2, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 32: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 33: {
                this.menu.changeCurActiveDynamicItem(2, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 34: {
                this.menu.changeCurActiveDynamicItem(6, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 35: {
                this.menu.changeCurActiveDynamicItem(5, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
            }
        }
    }

    public void performOnKeyRight(MenuItem menuItem) {
        switch (menuItem.itemID) {
            case -1: {
                break;
            }
            case 21: {
                this.menu.changeCurActiveDynamicItem(4, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 22: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 23: {
                this.menu.changeCurActiveDynamicItem(7, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 24: {
                this.menu.changeCurActiveDynamicItem(8, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 25: {
                this.menu.changeCurActiveDynamicItem(6, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 30: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 31: {
                this.menu.changeCurActiveDynamicItem(2, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 32: {
                this.menu.changeCurActiveDynamicItem(3, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 33: {
                this.menu.changeCurActiveDynamicItem(2, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 34: {
                this.menu.changeCurActiveDynamicItem(6, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
                break;
            }
            case 35: {
                this.menu.changeCurActiveDynamicItem(5, false, true, 0);
                this.menu.forceRedrawCurActiveDynamicItem();
            }
        }
    }

    public void createMenuGreetings() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/Intro.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(0, 0, 0, 0), null, null, null, -1, true, false));
        this.menu.setActiveStaticItems(new int[]{0});
        if (this.musicOn) {
            this.sound.playMIDI(0, 255);
        }
    }

    public void createMenuMeBubbles() {
        this.menu.resetMenu();
        if (this.musicOn) {
            this.sound.playMIDI(0, 255);
        }
        this.menu.addNewImage("/images/menu/MeBubblesTitle.png");
        this.menu.addNewImage("/images/menu/MeBubblesItem.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 5, 108, 25), null, null, null, -1, true, false));
        this.menuItems[2].itemID = 1;
        this.menuItems[2].createItem(this.menu, 1, new Rect(9, 55, 111, 16), "Continue", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[2]);
        this.menuItems[3].itemID = 2;
        this.menuItems[3].createItem(this.menu, 1, new Rect(9, 75, 111, 16), "Main Menu", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[3]);
        this.menu.addNewItem(this.menuItems[0]);
        this.menuItems[1].itemID = 0;
        this.menuItems[1].setItemText("Exit");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0});
        this.menu.setActiveDynamicItems(new int[]{1, 2});
        this.menu.setCurActiveDynamicItem(0);
        this.menu.setItemIndexForSoftKeyLeft(3);
        this.menu.setItemIndexForSoftKeyRight(4);
    }

    public void createMenuMainMenu() {
        this.menu.resetMenu();
        if (this.musicOn) {
            this.sound.playMIDI(0, 255);
        }
        this.menu.addNewImage("/images/menu/MainMenuTitle.png");
        this.menu.addNewImage("/images/menu/MainMenuItem.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 5, 108, 25), null, null, new int[]{0xFFFFFF}, 0, true, false));
        this.menuItems[2].itemID = 10;
        this.menuItems[2].createItem(this.menu, 1, new Rect(9, 32, 111, 16), "New Game", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[2]);
        this.menuItems[3].itemID = 11;
        this.menuItems[3].createItem(this.menu, 1, new Rect(9, 52, 111, 16), "Options", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[3]);
        this.menuItems[4].itemID = 12;
        this.menuItems[4].createItem(this.menu, 1, new Rect(9, 72, 111, 16), "High Scores", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[4]);
        this.menuItems[5].itemID = 13;
        this.menuItems[5].createItem(this.menu, 1, new Rect(9, 92, 111, 16), "Instruction", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[5]);
        this.menu.addNewItem(this.menuItems[0]);
        this.menuItems[1].itemID = 0;
        this.menuItems[1].setItemText("Exit");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0});
        this.menu.setActiveDynamicItems(new int[]{1, 2, 3, 4});
        this.menu.setCurActiveDynamicItem(0);
        this.menu.setItemIndexForSoftKeyLeft(5);
        this.menu.setItemIndexForSoftKeyRight(6);
    }

    public void createMenuNewGame() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/NewGameTitle.png");
        this.menu.addNewImage("/images/menu/NewGameItem.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 0, 108, 20), null, null, null, -1, true, false));
        this.menuItems[2].itemID = 20;
        this.menuItems[2].createItem(this.menu, 1, new Rect(9, 28, 111, 16), "Start", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[2]);
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(10, 47, 108, 10), "game mode", this.menuFont3, new int[]{1338758}, 0, false, true));
        this.menuItems[3].itemID = 21;
        this.menuItems[3].createItem(this.menu, 1, new Rect(9, 57, 111, 16), "<  Classic  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[3]);
        this.menuItems[4].itemID = 22;
        this.menuItems[4].createItem(this.menu, 1, new Rect(9, 57, 111, 16), "<   Puzzle   >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[4]);
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(10, 79, 108, 10), "difficulty", this.menuFont3, new int[]{1338758}, 0, false, true));
        this.menuItems[5].itemID = 23;
        this.menuItems[5].createItem(this.menu, 1, new Rect(9, 89, 111, 16), "<  Easy  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[5]);
        this.menuItems[6].itemID = 24;
        this.menuItems[6].createItem(this.menu, 1, new Rect(9, 89, 111, 16), "<  Medium  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[6]);
        this.menuItems[7].itemID = 25;
        this.menuItems[7].createItem(this.menu, 1, new Rect(9, 89, 111, 16), "<  Hard  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[7]);
        this.menu.addNewItem(this.menuItems[0]);
        this.menuItems[1].itemID = 26;
        this.menuItems[1].setItemText("Back");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0, 2, 5});
        int[] nArray = new int[3];
        nArray[0] = 1;
        int n = nArray[1] = this.gameMode == 0 ? 3 : 4;
        nArray[2] = this.gameDifficulty == 0 ? 6 : (this.gameDifficulty == 1 ? 7 : 8);
        this.menu.setActiveDynamicItems(nArray);
        this.menu.setCurActiveDynamicItem(0);
        this.menu.setItemIndexForSoftKeyLeft(9);
        this.menu.setItemIndexForSoftKeyRight(10);
    }

    public void createMenuOptions() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/OptionsTitle.png");
        this.menu.addNewImage("/images/menu/OptionsItem.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 2, 108, 23), null, null, null, -1, true, false));
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(10, 36, 108, 10), "music", this.menuFont3, new int[]{1338758}, 0, false, true));
        this.menuItems[4].itemID = 32;
        this.menuItems[4].createItem(this.menu, 1, new Rect(9, 46, 111, 16), "< ON  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[4]);
        this.menuItems[5].itemID = 33;
        this.menuItems[5].createItem(this.menu, 1, new Rect(9, 46, 111, 16), "< OFF >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[5]);
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(10, 66, 108, 10), "vibration", this.menuFont3, new int[]{1338758}, 0, false, true));
        this.menuItems[6].itemID = 34;
        this.menuItems[6].createItem(this.menu, 1, new Rect(9, 76, 111, 16), "< ON  >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[6]);
        this.menuItems[7].itemID = 35;
        this.menuItems[7].createItem(this.menu, 1, new Rect(9, 76, 111, 16), "< OFF >", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[7]);
        this.menu.addNewItem(this.menuItems[0]);
        this.menuItems[1].itemID = 26;
        this.menuItems[1].setItemText("Back");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0, 1, 4});
        this.menu.setActiveDynamicItems(new int[]{this.musicOn ? 2 : 3, this.vibrationOn ? 5 : 6});
        this.menu.setCurActiveDynamicItem(0);
        this.menu.setItemIndexForSoftKeyLeft(7);
        this.menu.setItemIndexForSoftKeyRight(8);
    }

    public void createMenuYouWin(int n) {
        this.curPlayerScore = n;
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/YouWIN.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 0, 108, 100), null, null, null, -1, true, false));
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(8, 81, 108, 15), "Your score is", this.menuFont1, new int[]{0}, 0, false, true));
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(8, 96, 108, 15), n + "", this.menuFont1, new int[]{0}, 0, false, true));
        this.menuItems[2].itemID = n > this.minPlayerScore ? 40 : 41;
        this.menuItems[2].createItem(this.menu, -1, new Rect(98, 115, 27, 13), "Ok", this.menuFont2, new int[]{0}, 0, false, true, 1);
        this.menu.addNewItem(this.menuItems[2]);
        this.menu.setActiveStaticItems(new int[]{0, 1, 2});
        this.menu.setItemIndexForSoftKeyRight(3);
    }

    public void createMenuGameOwer(int n) {
        this.curPlayerScore = n;
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/GameOver.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 0, 108, 100), null, null, null, -1, true, false));
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(13, 86, 108, 15), "Your score is", this.menuFont1, new int[]{0}, 0, false, true));
        this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(10, 98, 108, 15), n + "", this.menuFont1, new int[]{0}, 0, false, true));
        this.menuItems[2].itemID = n > this.minPlayerScore ? 40 : 41;
        this.menuItems[2].createItem(this.menu, -1, new Rect(98, 115, 27, 13), "Ok", this.menuFont2, new int[]{0}, 0, false, true, 1);
        this.menu.addNewItem(this.menuItems[2]);
        this.menu.setActiveStaticItems(new int[]{0, 1, 2});
        this.menu.setItemIndexForSoftKeyRight(3);
    }

    public void createMenuEnterPlayerName() {
        DebugEx.debugOut("    enter name.");
        this.mainGameLoop.gameLoopState = 1000;
        this.mainGameLoop.display.setCurrent((Displayable)this.textBox);
    }

    public void onSoftKeyPressed(Command command, Displayable displayable) {
        if (command == this.okCommand) {
            this.addNewPlayerScore(this.textBox.getString());
            this.createMenuPlayAgain();
            this.mainGameLoop.gameLoopState = -1;
        }
    }

    public void createMenuPlayAgain() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/MeBubblesTitle.png");
        this.menu.addNewImage("/images/menu/MeBubblesItem.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 5, 108, 25), null, null, null, -1, true, false));
        this.menuItems[2].itemID = 20;
        this.menuItems[2].createItem(this.menu, 1, new Rect(9, 45, 111, 25), "Play Again", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[2]);
        this.menuItems[3].itemID = 2;
        this.menuItems[3].createItem(this.menu, 1, new Rect(9, 65, 111, 25), "Main Menu", this.menuFont1, new int[]{0, 0xFFFFFF}, 0, false, true);
        this.menu.addNewItem(this.menuItems[3]);
        this.menu.addNewItem(this.menuItems[0]);
        this.menuItems[1].itemID = 0;
        this.menuItems[1].setItemText("Exit");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0});
        this.menu.setActiveDynamicItems(new int[]{1, 2});
        this.menu.setCurActiveDynamicItem(0);
        this.menu.setItemIndexForSoftKeyLeft(3);
        this.menu.setItemIndexForSoftKeyRight(4);
    }

    public void createMenuHighScores() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/HighScoresTitle.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(10, 2, 108, 25), null, null, null, -1, true, false));
        this.menuItems[1].itemID = 26;
        this.menuItems[1].setItemText("Back");
        this.menu.addNewItem(this.menuItems[1]);
        int[] nArray = new int[this.scoreSize * 3 + 1];
        nArray[0] = 0;
        if (this.scoreSize > 0) {
            Rect rect = new Rect(10, 28, 12, 10);
            Rect rect2 = new Rect(23, 28, 62, 10);
            Rect rect3 = new Rect(86, 28, 34, 10);
            int[] nArray2 = new int[]{16211200};
            int[] nArray3 = new int[]{1614336};
            int[] nArray4 = new int[]{21958};
            int n = 2;
            int n2 = 0;
            while (n2 < this.scoreSize) {
                int[] nArray5 = n2 == 0 ? nArray2 : (n2 > 0 && n2 < 3 ? nArray3 : nArray4);
                this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(rect), n2 + 1 + ".", this.menuFont3, nArray5, 0, false, true, -1));
                this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(rect2), this.playerName[n2], this.menuFont3, nArray5, 0, false, true, -1));
                this.menu.addNewItem(new MenuItem(this.menu, -1, new Rect(rect3), "" + this.playerScore[n2], this.menuFont3, nArray5, 0, false, true, -1));
                rect.move(0, 12);
                rect2.move(0, 12);
                rect3.move(0, 12);
                nArray[n2 * 3 + 1] = n++;
                nArray[n2 * 3 + 2] = n++;
                nArray[n2 * 3 + 3] = n++;
                ++n2;
            }
        }
        this.menu.setActiveStaticItems(nArray);
        this.menu.setItemIndexForSoftKeyRight(1);
    }

    public void createMenuInstuction1() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/Instruction1.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(1, 0, 127, 112), null, null, null, -1, true, false));
        this.menuItems[2].itemID = 60;
        this.menuItems[2].createItem(this.menu, -1, new Rect(3, 115, 40, 13), "Next", this.menuFont2, new int[]{0}, 0, false, true, -1);
        this.menu.addNewItem(this.menuItems[2]);
        this.menuItems[1].itemID = 26;
        this.menuItems[1].setItemText("Back");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0});
        this.menu.setItemIndexForSoftKeyLeft(1);
        this.menu.setItemIndexForSoftKeyRight(2);
    }

    public void createMenuInstuction2() {
        this.menu.resetMenu();
        this.menu.addNewImage("/images/menu/Instruction2.png");
        this.menu.addNewItem(new MenuItem(this.menu, 0, new Rect(0, 0, 128, 115), null, null, null, -1, true, false));
        this.menuItems[2].itemID = 61;
        this.menuItems[2].createItem(this.menu, -1, new Rect(3, 115, 40, 13), "Prev", this.menuFont2, new int[]{0}, 0, false, true, -1);
        this.menu.addNewItem(this.menuItems[2]);
        this.menuItems[1].itemID = 26;
        this.menuItems[1].setItemText("Back");
        this.menu.addNewItem(this.menuItems[1]);
        this.menu.setActiveStaticItems(new int[]{0});
        this.menu.setItemIndexForSoftKeyLeft(1);
        this.menu.setItemIndexForSoftKeyRight(2);
    }

    public int getMenuState() {
        if (this.startPlay) {
            this.startPlay = false;
            return 1;
        }
        if (this.exitMenu) {
            return -1;
        }
        return 0;
    }

    public boolean saveGameParam() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"GameParamStore", (boolean)true);
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"GameParamStore");
            recordStore = RecordStore.openRecordStore((String)"GameParamStore", (boolean)true);
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Saving Game Param");
            byte[] byArray = new byte[]{(byte)this.gameMode, (byte)this.gameDifficulty, (byte)this.gameLevel, (byte)(this.vibrationOn ? 1 : 0), (byte)(this.soundOn ? 1 : 0), (byte)(this.musicOn ? 1 : 0)};
            recordStore.addRecord(byArray, 0, byArray.length);
            DebugEx.debugOut("Save. Rec in store=" + recordStore.getNumRecords());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game param stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error saving param game.");
            return false;
        }
        return true;
    }

    public boolean loadGameParam() {
        RecordStore recordStore = null;
        try {
            DebugEx.debugOut("Opening Save Game Param.");
            recordStore = RecordStore.openRecordStore((String)"GameParamStore", (boolean)true);
            DebugEx.debugOut("Load. Rec in store=" + recordStore.getNumRecords());
            if (recordStore.getNumRecords() < 1) {
                DebugEx.debugOut("Not all data saved");
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                    DebugEx.debugOut("Error close game stote.");
                }
                return false;
            }
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Loading Game Param");
            byte[] byArray = recordStore.getRecord(1);
            recordStore.closeRecordStore();
            if (byArray.length < 6) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.gameMode = byArray[0];
            this.gameDifficulty = byArray[1];
            this.gameLevel = byArray[2];
            this.vibrationOn = byArray[3] != 0;
            this.soundOn = byArray[4] != 0;
            this.musicOn = byArray[5] != 0;
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game param stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error loading game param.");
            return false;
        }
        return true;
    }

    public boolean createPlayerScoreStore(int n) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            recordStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"GameScoreStore");
            recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            DebugEx.debugOut("Create new Score Store");
            byte[] byArray = new byte[]{0};
            int n2 = 0;
            while (n2 < 8) {
                recordStore.addRecord(byArray, 0, byArray.length);
                ++n2;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game param stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error saving param game.");
            return false;
        }
        return true;
    }

    public boolean savePlayerScore() {
        RecordStore recordStore = null;
        try {
            DebugEx.debugOut("Save Players Score");
            recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            if (recordStore.getNumRecords() < 8) {
                recordStore.closeRecordStore();
                DebugEx.debugOut("No Store created.");
                if (!this.createPlayerScoreStore(7)) {
                    return false;
                }
                recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            }
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Save. scoreSize=" + this.scoreSize);
            if (this.scoreSize > 0) {
                DebugEx.debugOut("Saving All Players Score");
                byte[] byArray = new byte[]{(byte)this.scoreSize};
                recordStore.setRecord(1, byArray, 0, byArray.length);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = 0;
                while (n < this.scoreSize) {
                    byteArrayOutputStream.reset();
                    dataOutputStream.writeInt(this.playerScore[n]);
                    dataOutputStream.writeUTF(this.playerName[n]);
                    dataOutputStream.writeInt(this.playerGameMode[n]);
                    byArray = byteArrayOutputStream.toByteArray();
                    recordStore.setRecord(n + 2, byArray, 0, byArray.length);
                    ++n;
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game param stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error saving param game.");
            return false;
        }
        return true;
    }

    public boolean loadPlayerScoreStore() {
        RecordStore recordStore = null;
        try {
            DebugEx.debugOut("Opening Save Game Score.");
            recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            DebugEx.debugOut("Load. Rec in store=" + recordStore.getNumRecords());
            if (recordStore.getNumRecords() < 8) {
                recordStore.closeRecordStore();
                DebugEx.debugOut("No Store created.");
                if (!this.createPlayerScoreStore(7)) {
                    return false;
                }
                recordStore = RecordStore.openRecordStore((String)"GameScoreStore", (boolean)true);
            }
            if (recordStore == null) {
                throw new Exception();
            }
            DebugEx.debugOut("Loading Game Player Store");
            byte[] byArray = recordStore.getRecord(1);
            if (byArray.length < 1) {
                DebugEx.debugOut("Error receve saved data.");
                throw new Exception();
            }
            this.scoreSize = byArray[0];
            DebugEx.debugOut("          scoreSize=" + this.scoreSize);
            if (this.scoreSize > 0) {
                this.minPlayerScore = 2000000;
                int n = 0;
                while (n < this.scoreSize) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(n + 2));
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.playerScore[n] = dataInputStream.readInt();
                    this.playerName[n] = dataInputStream.readUTF();
                    this.playerGameMode[n] = dataInputStream.readInt();
                    if (this.minPlayerScore > this.playerScore[n]) {
                        this.minPlayerScore = this.playerScore[n];
                    }
                    ++n;
                }
                if (this.scoreSize < 7) {
                    this.minPlayerScore = 1;
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                DebugEx.debugOut("Error close game param stote.");
                return false;
            }
            exception.printStackTrace();
            DebugEx.debugOut("Error loading game param.");
            return false;
        }
        return true;
    }

    public boolean addNewPlayerScore(String string) {
        this.addNewPlayerScore(this.curPlayerScore, string, 0);
        return true;
    }

    public boolean addNewPlayerScore(int n, String string, int n2) {
        int n3 = 0;
        while (n3 < 7) {
            if (this.playerScore[n3] < n) {
                System.arraycopy(this.playerScore, n3, this.playerScore, n3 + 1, 7 - n3 - 1);
                System.arraycopy(this.playerName, n3, this.playerName, n3 + 1, 7 - n3 - 1);
                System.arraycopy(this.playerGameMode, n3, this.playerGameMode, n3 + 1, 7 - n3 - 1);
                this.playerScore[n3] = n;
                this.playerName[n3] = string;
                this.playerGameMode[n3] = n2;
                if (n3 >= this.scoreSize) {
                    this.scoreSize = n3 + 1;
                } else if (this.scoreSize < 7) {
                    ++this.scoreSize;
                }
                if (this.minPlayerScore > n) {
                    this.minPlayerScore = n;
                }
                if (this.scoreSize < 7) {
                    this.minPlayerScore = 1;
                }
                return true;
            }
            ++n3;
        }
        return false;
    }

    class MenuItemEx
    extends MenuItem {
        public MenuItemEx() {
        }

        public MenuItemEx(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2) {
            this.createItem(gameMenu, n, rect, string, font, nArray, n2, bl, bl2);
        }

        public MenuItemEx(GameMenu gameMenu, int n, Rect rect, String string, Font font, int[] nArray, int n2, boolean bl, boolean bl2, int n3) {
            this.createItem(gameMenu, n, rect, string, font, nArray, n2, bl, bl2, n3);
        }

        public void onKeyFire() {
            MainMenu.this.performOnKeyFire(this);
        }

        public void onLossFocus() {
            MainMenu.this.performOnLossFocus(this);
        }

        public void onSetFocus() {
            MainMenu.this.performOnSetFocus(this);
        }

        public void onKeyUp() {
            MainMenu.this.performOnKeyUp(this);
        }

        public void onKeyDown() {
            MainMenu.this.performOnKeyDown(this);
        }

        public void onKeyLeft() {
            MainMenu.this.performOnKeyLeft(this);
        }

        public void onKeyRight() {
            MainMenu.this.performOnKeyRight(this);
        }
    }
}

