/*
 * Decompiled with CFR 0.152.
 */
package gui;

import filter.ProgressChecker;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FilterProgressCanvas
extends Canvas
implements ProgressChecker {
    public static final int GUI_COLOR_1 = 0xAAAAFF;
    public static final int GUI_COLOR_2 = 0x8888AA;
    public static final int GUI_COLOR_TEXT = 0;
    public static final Font GUI_FONT_TEXT = Font.getFont((int)0, (int)0, (int)8);
    public static final String GUI_STRING_UNKNOWN = "?";
    public static final String GUI_STRING_FOUND = "PNGs: ";
    public static final String GUI_STRING_FOOTER = "by sdrrhmn6";
    public static final String GUI_STRING_STOP = "\u0421\u0442\u043e\u043f (*)";
    private String fileName;
    private long totalProgress = 0L;
    private long currentProgress = -1L;
    private int filesFound = 0;
    private Image screenBuffer;
    private Runnable stopAction;

    public FilterProgressCanvas() {
        if (System.getProperty("microedition.profiles").indexOf("MIDP-1") < 0) {
            this.setFullScreenMode(true);
        }
        this.screenBuffer = this.createScreenBuffer();
    }

    public void setStopAction(Runnable runnable) {
        this.stopAction = runnable;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    private Image createScreenBuffer() {
        Image image = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        Graphics graphics = image.getGraphics();
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.drawGradient(graphics, 0, 0, n, n2, 0xAAAAFF, 0x8888AA);
        graphics.setColor(0);
        graphics.drawRect(5, 5 + GUI_FONT_TEXT.getHeight() + 5, n - 10, GUI_FONT_TEXT.getHeight() + 6);
        this.drawGradient(graphics, 6, 5 + GUI_FONT_TEXT.getHeight() + 5 + 1, n - 12, GUI_FONT_TEXT.getHeight() + 4, 0x8888AA, 0xAAAAFF);
        return image;
    }

    private void drawGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            graphics.setColor(n5);
            graphics.fillRect(n, n2, n3, n4);
        } else {
            int n7 = n5 >> 16 & 0xFF;
            int n8 = n5 >> 8 & 0xFF;
            int n9 = n5 & 0xFF;
            int n10 = n6 >> 16 & 0xFF;
            int n11 = n6 >> 8 & 0xFF;
            int n12 = n6 & 0xFF;
            for (int i = 0; i < n4; ++i) {
                graphics.setColor(n7 + (n10 - n7) * i / n4, n8 + (n11 - n8) * i / n4, n9 + (n12 - n9) * i / n4);
                graphics.drawLine(n, n2 + i, n + n3, n2 + i);
            }
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.screenBuffer, 0, 0, 20);
        int n = this.getWidth();
        int n2 = this.getHeight();
        String string = this.fileName != null ? this.fileName : GUI_STRING_UNKNOWN;
        graphics.setColor(0);
        graphics.setFont(GUI_FONT_TEXT);
        graphics.drawString(string, (n - GUI_FONT_TEXT.stringWidth(string)) / 2, 5, 20);
        if (this.currentProgress > 0L && this.totalProgress > 0L) {
            long l = Math.min(this.totalProgress, this.currentProgress);
            int n3 = (int)(l * 10000L / this.totalProgress);
            this.drawGradient(graphics, 6, 5 + GUI_FONT_TEXT.getHeight() + 5 + 1, (int)((long)(n - 12) * l / this.totalProgress), GUI_FONT_TEXT.getHeight() + 4, 0xAAAAFF, 0x8888AA);
            String string2 = new StringBuffer(7).append(n3 / 100).append('.').append(n3 % 100).append('%').toString();
            graphics.drawString(string2, (n - GUI_FONT_TEXT.stringWidth(string2)) / 2, 5 + GUI_FONT_TEXT.getHeight() + 5 + 3, 20);
        } else {
            graphics.drawString(GUI_STRING_UNKNOWN, (n - GUI_FONT_TEXT.stringWidth(GUI_STRING_UNKNOWN)) / 2, 5 + GUI_FONT_TEXT.getHeight() + 5 + 3, 20);
        }
        String string3 = new StringBuffer(16).append(GUI_STRING_FOUND).append(this.filesFound).toString();
        graphics.drawString(string3, 5, 21 + GUI_FONT_TEXT.getHeight() * 2, 20);
        graphics.drawString(GUI_STRING_FOOTER, n - GUI_FONT_TEXT.stringWidth(GUI_STRING_FOOTER) - 2, n2 - GUI_FONT_TEXT.getHeight() - 2, 20);
        graphics.drawString(GUI_STRING_STOP, 2, n2 - GUI_FONT_TEXT.getHeight() - 2, 20);
    }

    public void keyPressed(int n) {
        if (n == 42 && this.stopAction != null) {
            this.stopAction.run();
        }
    }

    public void setTotalProgress(long l) {
        long l2 = this.totalProgress;
        this.totalProgress = l;
        if (l2 != this.totalProgress) {
            this.repaint();
        }
    }

    public void setCurrentProgress(long l) {
        long l2 = this.currentProgress;
        this.currentProgress = l;
        if (l2 != this.currentProgress) {
            this.repaint();
        }
    }

    public void incrementProgress(int n) {
        if (n > 0) {
            this.currentProgress += (long)n;
            this.repaint();
        }
    }

    public void resetProgress() {
        this.filesFound = 0;
        this.currentProgress = -1L;
        this.totalProgress = 0L;
    }

    public void incrementAdditional() {
        ++this.filesFound;
        this.repaint();
    }
}

