/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ProgressChecker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class FileFilter {
    public static final int BUFFER_SIZE = 8192;
    public static final int STREAM_WAIT_TIME = 128;
    private byte[] unchecked;
    private int uncheckedLength;
    private int maxEndLength = -1;
    private byte[] buffer = new byte[8192];
    private int bufferLength = 0;
    private int bufferOffset = 0;
    private Vector[] signatures = new Vector[256];
    private InputStream in = null;
    private ProgressChecker progressChecker;
    private String currentType = null;
    private byte[] currentEnd = null;
    private int toEnd = -1;

    public void setProgressChecker(ProgressChecker progressChecker) {
        this.progressChecker = progressChecker;
    }

    public void addSignature(String string, byte[] byArray, byte[] byArray2) {
        if (this.in != null) {
            throw new IllegalStateException("input is not completed");
        }
        if (string == null || byArray == null || byArray2 == null) {
            throw new NullPointerException("fuck you");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        Vector<Object> vector = this.signatures[byArray[0] & 0xFF];
        if (vector == null) {
            this.signatures[byArray[0] & 0xFF] = vector = new Vector<Object>();
        }
        vector.addElement(string);
        vector.addElement(byArray);
        vector.addElement(byArray2);
        if (this.maxEndLength < 0 || this.maxEndLength < byArray2.length) {
            this.maxEndLength = byArray2.length;
        }
    }

    public void resetSignatures() {
        if (this.in != null) {
            throw new IllegalStateException("input is not completed");
        }
        for (int i = 0; i < this.signatures.length; ++i) {
            this.signatures[i] = null;
        }
    }

    public void startFilter(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("input stream is null");
        }
        this.in = inputStream;
        if (this.maxEndLength >= 0) {
            if (this.unchecked == null) {
                this.unchecked = new byte[this.maxEndLength];
            } else {
                int n;
                for (n = this.unchecked.length; n < this.maxEndLength; n <<= 1) {
                }
                if (n != this.unchecked.length) {
                    this.unchecked = new byte[n];
                }
            }
        }
    }

    public boolean checkNext() throws IOException {
        block0: while (true) {
            this.reserveData(this.buffer.length >> 1);
            if (this.bufferLength - this.bufferOffset == 0) {
                return false;
            }
            while (true) {
                if (this.bufferOffset >= this.bufferLength) continue block0;
                Vector vector = this.signatures[this.buffer[this.bufferOffset] & 0xFF];
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement().toString();
                        byte[] byArray = (byte[])enumeration.nextElement();
                        byte[] byArray2 = (byte[])enumeration.nextElement();
                        if (!this.reserveData(byArray.length) || !this.compareData(byArray, 0, this.buffer, this.bufferOffset, byArray.length)) continue;
                        this.currentType = string;
                        this.currentEnd = byArray2;
                        this.checkForEndSignature(this.bufferOffset);
                        return true;
                    }
                }
                ++this.bufferOffset;
            }
            break;
        }
    }

    private boolean compareData(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (byArray[n++] == byArray2[n2++] && --n3 > 0) {
        }
        return n3 == 0;
    }

    private boolean reserveData(int n) throws IOException {
        int n2;
        if (this.buffer.length - this.bufferOffset < n) {
            if (n > this.buffer.length) {
                for (n2 = this.buffer.length; n2 < n; n2 <<= 1) {
                }
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buffer, this.bufferOffset, byArray, 0, this.bufferLength - this.bufferOffset);
                this.buffer = byArray;
                this.bufferLength -= this.bufferOffset;
                this.bufferOffset = 0;
            } else {
                System.arraycopy(this.buffer, this.bufferOffset, this.buffer, 0, this.bufferLength - this.bufferOffset);
                this.bufferLength -= this.bufferOffset;
                this.bufferOffset = 0;
            }
        }
        n2 = 0;
        int n3 = this.bufferLength;
        while (this.bufferLength - this.bufferOffset < n) {
            int n4;
            if (this.uncheckedLength > 0) {
                n4 = n - (this.bufferLength - this.bufferOffset);
                if (this.uncheckedLength < n4) {
                    n4 = this.uncheckedLength;
                }
                System.arraycopy(this.unchecked, 0, this.buffer, this.bufferLength, n4);
                System.arraycopy(this.unchecked, n4, this.unchecked, 0, this.unchecked.length - n4);
                this.bufferLength += n4;
                this.uncheckedLength -= n4;
                n2 += n4;
                continue;
            }
            n4 = this.in.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
            if (n4 < 0) break;
            if (n4 == 0) {
                try {
                    Thread.sleep(128L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.bufferLength += n4;
            n2 += n4;
            if (this.progressChecker == null) continue;
            this.progressChecker.incrementProgress(n4);
        }
        this.checkForEndSignature(n3);
        return this.bufferLength - this.bufferOffset >= n;
    }

    private void checkForEndSignature(int n) throws IOException {
        int n2 = this.bufferLength - n;
        if (this.currentType != null && this.toEnd < 0) {
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                if (i + n + this.currentEnd.length > this.bufferLength && this.currentEnd.length > this.uncheckedLength && (n4 = this.in.read(this.unchecked, this.uncheckedLength, this.unchecked.length - this.uncheckedLength)) >= 0) {
                    if (n4 == 0) {
                        try {
                            Thread.sleep(128L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        this.uncheckedLength += n4;
                        if (this.progressChecker != null) {
                            this.progressChecker.incrementProgress(n4);
                        }
                    }
                }
                n4 = 0;
                n4 = n + i + this.currentEnd.length > this.bufferLength ? (this.uncheckedLength >= (n3 = n + i + this.currentEnd.length - this.bufferLength) ? (this.compareData(this.currentEnd, 0, this.buffer, n + i, this.currentEnd.length - n3) && this.compareData(this.currentEnd, this.currentEnd.length - n3, this.unchecked, 0, n3) ? 1 : 0) : 0) : (int)(this.compareData(this.currentEnd, 0, this.buffer, n + i, this.currentEnd.length) ? 1 : 0);
                if (n4 == 0) continue;
                this.toEnd = n - this.bufferOffset + i + this.currentEnd.length;
                return;
            }
        }
    }

    public void resetInput() {
        this.in = null;
        this.bufferLength = 0;
        this.bufferOffset = 0;
    }

    public void copyToOutput(OutputStream outputStream) throws IOException {
        while (this.currentType == null) {
            if (this.checkNext()) continue;
            return;
        }
        boolean bl = false;
        while (this.toEnd != 0 && !bl) {
            this.reserveData(this.buffer.length >> 1);
            boolean bl2 = bl = this.bufferLength - this.bufferOffset == 0;
            int n = this.toEnd < 0 ? this.bufferLength - this.bufferOffset : (this.toEnd < this.bufferLength - this.bufferOffset ? this.toEnd : this.bufferLength - this.bufferOffset);
            outputStream.write(this.buffer, this.bufferOffset, n);
            this.bufferOffset += n;
            if (this.toEnd < 0) continue;
            this.toEnd -= n;
        }
        if (this.toEnd == 0) {
            this.toEnd = -1;
            this.currentType = null;
            this.currentEnd = null;
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.resetInput();
        this.currentType = null;
        this.currentEnd = null;
    }
}

