/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class FileWatcher
implements CommandListener,
Runnable {
    public static final Command OK_COMMAND = new Command("\u041e\u043a", 4, 1);
    public static final Command SUBDIR_COMMAND = new Command("\u0412\u0432\u0435\u0440\u0445", 2, 2);
    public static final Image FOLDER_IMAGE = FileWatcher.loadImage("/res/dir.png");
    public static final Image UNKNOWN_IMAGE = FileWatcher.loadImage("/res/unk.png");
    public static final Image PNG_IMAGE = FileWatcher.loadImage("/res/jpg.png");
    public static final String STORE_NAME = "JPGFilter_filew_path";
    private Vector indexes = new Vector();
    private RecordStore store;
    private Display display;
    private Runnable exit;
    private String path;
    private String file;
    private String message;
    private List list;
    private Alert error;
    private int currentIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWatcher(Display display) {
        this.display = display;
        this.error = new Alert("\u041e\u0448\u0438\u0431\u043a\u0430 !....", "", null, AlertType.ERROR);
        this.error.addCommand(OK_COMMAND);
        this.error.setCommandListener((CommandListener)this);
        try {
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            if (this.store.getNumRecords() > 0) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.store.getRecord(1)));
                this.indexes.removeAllElements();
                this.path = dataInputStream.readUTF();
                int n = dataInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    this.indexes.addElement(new Integer(dataInputStream.readInt()));
                }
                this.currentIndex = dataInputStream.readInt();
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.message = recordStoreException.getMessage();
            this.message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 . \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0432 \u0446\u0435\u043b\u044f\u0445 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f.\n" + "code.Part : " + this.getClass().getName() + "\n" + ((Object)((Object)recordStoreException)).getClass().getName() + (this.message != null ? " : " + this.message : "");
        }
        catch (IOException iOException) {
            System.out.println("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435! \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a.");
        }
        finally {
            if (this.store != null) {
                try {
                    this.store.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
            this.store = null;
        }
    }

    public void setExitAction(Runnable runnable) {
        this.exit = runnable;
    }

    public String getFileName() {
        return this.file;
    }

    public void showWatcher() {
        new Thread(this).start();
    }

    public void run() {
        this.showWatcherThis();
    }

    private void showWatcherThis() {
        if (this.path != null && !this.path.endsWith("/")) {
            this.file = this.path;
            this.openChild(null);
            if (this.exit != null) {
                this.exit.run();
            }
            return;
        }
        this.file = null;
        if (this.list == null) {
            this.list = this.buildList();
            if (this.currentIndex >= 0) {
                try {
                    this.list.setSelectedIndex(this.currentIndex, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.message == null) {
            this.display.setCurrent((Displayable)this.list);
        } else {
            this.error.setString(this.message);
            this.message = null;
            this.display.setCurrent(this.error, (Displayable)this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List buildList() {
        Object[] objectArray = null;
        try {
            Class.forName("javax.microedition.io.file.FileConnection");
            Vector vector = new Vector();
            Enumeration enumeration = null;
            if (this.path == null || this.path.length() == 0) {
                enumeration = FileSystemRegistry.listRoots();
            } else {
                FileConnection fileConnection = null;
                try {
                    fileConnection = (FileConnection)Connector.open((String)("file:///" + this.path));
                    enumeration = fileConnection.list("*", true);
                }
                catch (Exception exception) {
                    this.path = null;
                    enumeration = FileSystemRegistry.listRoots();
                }
                finally {
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (int i = objectArray.length >> 1; i > 0; i >>= 1) {
            for (int j = i; j < objectArray.length; ++j) {
                int n;
                void var5_13 = objectArray[n];
                for (n = j; n >= i && this.compareNames((String)objectArray[n - i], (String)var5_13) > 0; n -= i) {
                    objectArray[n] = objectArray[n - i];
                }
                objectArray[n] = var5_13;
            }
        }
        Image[] imageArray = new Image[objectArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            imageArray[i] = objectArray[i].endsWith("/") ? FOLDER_IMAGE : (((String)objectArray[i]).endsWith(".jpg") || ((String)objectArray[i]).endsWith(".JPG") ? PNG_IMAGE : UNKNOWN_IMAGE);
        }
        List list = new List("\u0441\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432", 3, (String[])objectArray, imageArray);
        list.addCommand(SUBDIR_COMMAND);
        list.setCommandListener((CommandListener)this);
        return list;
    }

    private int compareNames(String string, String string2) {
        if (string.endsWith("/")) {
            if (string2.endsWith("/")) {
                return string.compareTo(string2);
            }
            return -1;
        }
        if (string2.endsWith("/")) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private String bytes2String(byte[] byArray) {
        if ((byArray.length & 1) != 0) {
            throw new IllegalArgumentException("\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length >> 1; ++i) {
            stringBuffer.append((char)((byArray[i << 1] & 0xFF) << 8 | byArray[(i << 1) + 1] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private byte[] string2Bytes(String string) {
        byte[] byArray = new byte[string.length() << 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i << 1] = (byte)(string.charAt(i) >> 8);
            byArray[(i << 1) + 1] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public boolean openChild(String string) {
        if (string == null) {
            if (this.path == null || this.path.length() == 0) {
                return false;
            }
            int n = this.path.lastIndexOf(47, this.path.length() - 2);
            if (n < 0) {
                this.path = null;
                return true;
            }
            this.path = this.path.substring(0, n + 1);
            return true;
        }
        this.path = this.path == null ? string : this.path + string;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unalloc() {
        if (this.list != null) {
            this.currentIndex = this.list.getSelectedIndex();
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            this.store = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            if (this.path != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeUTF(this.path);
                dataOutputStream.writeInt(this.indexes.size());
                for (int i = 0; i < this.indexes.size(); ++i) {
                    dataOutputStream.writeInt((Integer)this.indexes.elementAt(i));
                }
                dataOutputStream.writeInt(this.currentIndex);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.store.addRecord(byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.message = recordStoreException.getMessage();
            this.message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435 . \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u0432 \u0446\u0435\u043b\u044f\u0445 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f.\n" + "code.Part : " + this.getClass().getName() + ((Object)((Object)recordStoreException)).getClass().getName() + (this.message != null ? " : " + this.message : "");
        }
        catch (IOException iOException) {
            System.out.println("warning! an i/o exception has been ocurred while writing filewatcher settings");
        }
        finally {
            if (this.store != null) {
                try {
                    this.store.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
            this.store = null;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.list) {
            if (command == List.SELECT_COMMAND) {
                int n = this.list.getSelectedIndex();
                if (n >= 0 && n < this.list.size() && this.openChild(this.list.getString(n))) {
                    this.storeIndex(n);
                    if (this.path.endsWith("/")) {
                        this.list = null;
                    }
                    this.currentIndex = -1;
                    this.showWatcher();
                }
            } else if (command == SUBDIR_COMMAND) {
                if (this.path == null) {
                    if (this.exit != null) {
                        this.exit.run();
                    }
                } else if (this.openChild(null)) {
                    this.list = null;
                    this.currentIndex = this.restoreIndex();
                    this.showWatcher();
                }
            }
        }
        if (displayable == this.error && command == OK_COMMAND) {
            if (this.list != null) {
                this.currentIndex = -1;
                this.showWatcher();
            } else if (this.exit != null) {
                this.exit.run();
            }
        }
    }

    private void storeIndex(int n) {
        this.indexes.addElement(new Integer(n));
    }

    private int restoreIndex() {
        if (this.indexes.size() == 0) {
            return 0;
        }
        int n = (Integer)this.indexes.lastElement();
        this.indexes.setSize(this.indexes.size() - 1);
        return n;
    }

    private static Image loadImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }
}

