/*
 * Decompiled with CFR 0.152.
 */
package SoundMachine;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.midlet.MIDlet;

public class SoundGeneratorCanvas
extends Canvas {
    private int wd;
    private int ht;
    private int[] nota;
    private int keyp = -1;
    private int basetone = 72;
    private int tono = 72;
    private int key = 0;
    private int octava = 0;
    private int semitono = 0;
    private int volumen = 80;
    private int lang = 1;
    private boolean sost = true;
    private String msg = "";
    private String[] notas;
    private boolean help = false;
    private boolean about = false;
    private String error = "";
    private MIDlet parent;
    private Player mp;
    private int instrument = -1;

    public SoundGeneratorCanvas(MIDlet m) {
        this.parent = m;
        this.wd = this.getWidth();
        this.ht = this.getHeight();
        this.notas = new String[20];
        this.nota = new int[200];
        this.setLanguage(1);
        this.setScale(0);
    }

    public void setInstrument(int inst) {
        this.instrument = inst;
    }

    public void setLanguage(boolean sost) {
        this.setLanguage(this.lang, sost);
    }

    public void setLanguage(int lang) {
        this.setLanguage(lang, this.sost);
    }

    public void setLanguage(int lang, boolean sost) {
        this.sost = sost;
        this.lang = lang;
        if (lang == 0 && sost) {
            this.notas[0] = "Do";
            this.notas[1] = "Do#";
            this.notas[2] = "Re";
            this.notas[3] = "Re#";
            this.notas[4] = "Mi";
            this.notas[5] = "Fa";
            this.notas[6] = "Fa#";
            this.notas[7] = "Sol";
            this.notas[8] = "Sol#";
            this.notas[9] = "La";
            this.notas[10] = "La#";
            this.notas[11] = "Si";
            this.notas[12] = "Do";
        }
        if (lang == 0 && !sost) {
            this.notas[0] = "Do";
            this.notas[1] = "Reb";
            this.notas[2] = "Re";
            this.notas[3] = "Mib";
            this.notas[4] = "Mi";
            this.notas[5] = "Fa";
            this.notas[6] = "Solb";
            this.notas[7] = "Sol";
            this.notas[8] = "Lab";
            this.notas[9] = "La";
            this.notas[10] = "Sib";
            this.notas[11] = "Si";
            this.notas[12] = "Do";
        }
        if (lang == 1 && sost) {
            this.notas[0] = "C";
            this.notas[1] = "C#";
            this.notas[2] = "D";
            this.notas[3] = "D#";
            this.notas[4] = "E";
            this.notas[5] = "F";
            this.notas[6] = "F#";
            this.notas[7] = "G";
            this.notas[8] = "G#";
            this.notas[9] = "A";
            this.notas[10] = "A#";
            this.notas[11] = "B";
            this.notas[12] = "C";
        }
        if (lang == 1 && !sost) {
            this.notas[0] = "C";
            this.notas[1] = "Db";
            this.notas[2] = "D";
            this.notas[3] = "Eb";
            this.notas[4] = "E";
            this.notas[5] = "F";
            this.notas[6] = "Gb";
            this.notas[7] = "G";
            this.notas[8] = "Ab";
            this.notas[9] = "A";
            this.notas[10] = "Bb";
            this.notas[11] = "B";
            this.notas[12] = "C";
        }
    }

    public void showHelp() {
        this.help = true;
        this.repaint();
    }

    public void showAbout() {
        this.about = true;
        this.repaint();
    }

    public void moveVolume(int dif) {
        this.volumen += dif;
        if (this.volumen > 100) {
            this.volumen = 100;
        }
        if (this.volumen < 20) {
            this.volumen = 20;
        }
        this.repaint();
    }

    public int w(int sz) {
        return this.wd * sz / 1000;
    }

    public int h(int sz) {
        return this.ht * sz / 1000;
    }

    public void paint(Graphics g) {
        g.setColor(75, 150, 225);
        g.fillRect(0, 0, this.w(1000), this.h(1000));
        g.setColor(64, 128, 196);
        g.fillRect(0, this.h(800), this.w(1000), this.h(1000));
        g.setColor(0, 0, 128);
        g.drawRect(1, 1, this.w(1000) - 2, this.h(1000) - 2);
        g.drawRect(this.w(333), 1, this.w(333), this.h(1000) - 2);
        g.drawRect(1, this.h(200), this.w(1000) - 2, this.h(200));
        g.drawRect(1, this.h(600), this.w(1000) - 2, this.h(200));
        g.drawRect(0, 0, this.w(1000), this.h(800));
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (this.keyp == x * 3 + y) {
                    g.setColor(85, 170, 255);
                    g.fillRect(this.w(y * 333) + 2, this.h(x * 200) + 2, this.w(333) - 3, this.h(200) - 3);
                }
                g.setColor(255, 255, 255);
                if (x < 3) {
                    g.drawString(String.valueOf(x * 3 + y + 1), this.w(333) + this.w(333) * y, this.h(200) + this.h(200) * x, 40);
                }
                g.setColor(128, 0, 0);
                g.drawString(this.notas[(this.basetone + this.nota[x * 3 + y] + this.octava + this.semitono + 120) % 12], this.w(166) + this.w(333) * y, this.h(20) + this.h(200) * x, 17);
            }
        }
        g.setColor(255, 255, 255);
        g.drawString("*", this.w(333) + this.w(333) * 0, this.h(200) + this.h(200) * 3, 40);
        g.drawString("0", this.w(333) + this.w(333) * 1, this.h(200) + this.h(200) * 3, 40);
        g.drawString("#", this.w(333) + this.w(333) * 2, this.h(200) + this.h(200) * 3, 40);
        g.setColor(255, 255, 0);
        g.drawString("\u041e\u043a\u0442\u0430\u0432\u0430", this.w(166), this.h(800), 17);
        g.drawString("\u041f\u043e\u043b\u0443\u0442\u043e\u043d", this.w(834), this.h(800), 17);
        g.drawString("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", this.w(500), this.h(800), 17);
        g.setColor(0, 0, 64);
        g.drawString(String.valueOf(this.octava / 12), this.w(166), this.h(890), 17);
        g.drawString(String.valueOf(this.semitono), this.w(834), this.h(890), 17);
        g.drawString(String.valueOf(this.msg), this.w(500), this.h(890), 17);
        if (this.help) {
            this.drawHelp(g);
        }
        if (this.about) {
            this.drawAbout(g);
        }
        if (this.error.length() > 0) {
            g.setColor(196, 0, 0);
            g.drawString(this.error, this.w(500), this.h(100), 17);
            this.error = "";
        }
    }

    private void drawHelp(Graphics g) {
        g.setColor(120, 120, 0);
        g.drawRect(2, 2, this.w(1000) - 4, this.h(800) - 4);
        g.setColor(220, 220, 0);
        g.fillRect(2, 2, this.w(1000) - 4, this.h(800) - 4);
        g.setColor(90, 90, 0);
        g.drawString("\u041e\u043a\u0442\u0430\u0432\u0430 + : \u0412\u0432\u0435\u0440\u0445", this.w(500), this.h(50), 17);
        g.drawString("\u041e\u043a\u0442\u0430\u0432\u0430 - : \u0412\u043d\u0438\u0437", this.w(500), this.h(150), 17);
        g.drawString("\u041f\u043e\u043b\u0443\u0442\u043e\u043d + : \u0412\u043f\u0440\u0430\u0432\u043e", this.w(500), this.h(250), 17);
        g.drawString("\u041f\u043e\u043b\u0443\u0442\u043e\u043d - : \u0412\u043b\u0435\u0432\u043e", this.w(500), this.h(350), 17);
        this.help = false;
    }

    private void drawAbout(Graphics g) {
        g.setColor(120, 120, 0);
        g.drawRect(2, 2, this.w(1000) - 4, this.h(800) - 4);
        g.setColor(220, 220, 0);
        g.fillRect(2, 2, this.w(1000) - 4, this.h(800) - 4);
        g.setColor(90, 90, 0);
        g.drawString("SoundGenerator", this.w(500), this.h(50), 17);
        g.drawString("Version 1.0", this.w(500), this.h(150), 17);
        g.drawString("by IgorSoft", this.w(500), this.h(250), 17);
        g.drawString("igorsw@gmail.com", this.w(500), this.h(350), 17);
        this.about = false;
    }

    public void keyReleased(int keyCode) {
        if (this.instrument == -1) {
            return;
        }
        int notaf = this.getNote(keyCode);
        int keyp = this.getKey(keyCode);
        this.tono = this.basetone + notaf + this.octava + this.semitono;
        try {
            MIDIControl mc = this.getMIDIControl();
            if (notaf >= 0) {
                mc.shortMidiEvent(144, this.tono, 0);
            }
        }
        catch (Exception ex) {
            this.error = ex.getMessage();
        }
    }

    public void keyPressed(int keyCode) {
        int notaf = 0;
        this.msg = "";
        this.key = keyCode;
        if (this.key == -1 && this.octava <= 48) {
            this.octava += 12;
            this.msg = "\u041e\u043a\u0442\u0430\u0432\u0430+";
        }
        if (this.key == -2 && this.octava >= -24) {
            this.octava -= 12;
            this.msg = "\u041e\u043a\u0442\u0430\u0432\u0430-";
        }
        if (this.key == -4 && this.semitono < 12) {
            ++this.semitono;
            this.msg = "\u041f\u043e\u043b\u0443\u0442\u043e\u043d+";
        }
        if (this.key == -3 && this.semitono > -12) {
            --this.semitono;
            this.msg = "\u041f\u043e\u043b\u0443\u0442\u043e\u043d-";
        }
        this.keyp = this.getKey(this.key);
        notaf = this.getNote(this.key);
        if (notaf >= 0) {
            this.msg = "\u0422\u043e\u043d";
        }
        this.tono = this.basetone + notaf + this.octava + this.semitono;
        if (this.instrument > -1) {
            try {
                MIDIControl mc = this.getMIDIControl();
                mc.setProgram(0, -1, this.instrument);
                if (notaf >= 0) {
                    mc.shortMidiEvent(144, this.tono, 127);
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                this.error = ex.getMessage();
                this.instrument = -1;
            }
        }
        if (this.instrument == -1) {
            try {
                Manager.playTone((int)this.tono, (int)240, (int)this.volumen);
            }
            catch (MediaException e) {
                this.error = e.getMessage();
            }
        }
        this.repaint();
    }

    public void note(int pos) {
        int i = 10594631;
        int n = 1000;
        for (int x = 1; x <= pos; ++x) {
            n = n * i / 10000000;
        }
    }

    public void setScale(int scale) {
        if (scale == 0) {
            this.nota[0] = 0;
            this.nota[1] = 2;
            this.nota[2] = 4;
            this.nota[3] = 5;
            this.nota[4] = 7;
            this.nota[5] = 9;
            this.nota[6] = 11;
            this.nota[7] = 12;
            this.nota[8] = 14;
            this.nota[9] = 16;
            this.nota[10] = 17;
            this.nota[11] = 19;
        }
        if (scale == 1) {
            for (int i = 0; i < 12; ++i) {
                this.nota[i] = i;
            }
        }
    }

    public int getNote(int key) {
        int pos = this.getKey(key);
        if (pos >= 0) {
            return this.nota[pos];
        }
        return -1;
    }

    public int getKey(int key) {
        if (key >= 49 && key <= 57) {
            return key - 49;
        }
        if (key == 42) {
            return 9;
        }
        if (key == 48) {
            return 10;
        }
        if (key == 35) {
            return 11;
        }
        return -1;
    }

    MIDIControl getMIDIControl() throws Exception {
        if (this.mp == null) {
            this.mp = Manager.createPlayer((String)"device://midi");
            this.mp.prefetch();
        }
        return (MIDIControl)this.mp.getControl("javax.microedition.media.control.MIDIControl");
    }
}

