/*
 * Decompiled with CFR 0.152.
 */
package net.elvum.hpgen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class HPGenPrefs {
    private static HPGenPrefs instance;
    private RecordStore rsDomains;
    private RecordStore rsPrefs;
    public static final byte MD5 = 0;
    public static final byte SHA1 = 1;
    private byte pHashFunction = 1;
    public static final byte HEX_LOWER = 0;
    public static final byte HEX_UPPER = 1;
    public static final byte BASE64 = 2;
    public static final byte BASE64_NO1A = 3;
    private byte pDisplayMode = (byte)2;
    private static final byte PREFS_FORMAT_VERSION = 2;
    private byte pLength = (byte)8;
    public static final byte NO = 0;
    public static final byte YES = 1;
    private byte pStoreDomains = 1;
    private int prefsRecordID = -1;
    private static final int DOMAINS_FORMAT_VERSION = 0;
    private int positionIncrementor = 0;

    private HPGenPrefs() {
        try {
            this.rsDomains = RecordStore.openRecordStore((String)"net.elvum.hpgen.domains", (boolean)true);
            this.rsPrefs = RecordStore.openRecordStore((String)"net.elvum.npgen.prefs", (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        try {
            this.readPrefs();
            this.getDomainList();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized HPGenPrefs getInstance() {
        if (instance == null) {
            instance = new HPGenPrefs();
        }
        return instance;
    }

    private void readPrefs() throws RecordStoreException {
        RecordEnumeration prefs = null;
        if (this.prefsRecordID == -1) {
            prefs = this.rsPrefs.enumerateRecords(null, null, false);
            int id = -1;
            while (prefs.hasNextElement()) {
                id = prefs.nextRecordId();
            }
            if (id == -1) {
                return;
            }
            this.prefsRecordID = id;
        }
        byte[] prefsBytes = this.rsPrefs.getRecord(this.prefsRecordID);
        switch (prefsBytes[0]) {
            case 0: {
                this.pHashFunction = prefsBytes[1];
                this.pDisplayMode = prefsBytes[2];
                break;
            }
            case 1: {
                this.pHashFunction = prefsBytes[1];
                this.pDisplayMode = prefsBytes[2];
                this.pLength = prefsBytes[3];
                break;
            }
            case 2: {
                this.pHashFunction = prefsBytes[1];
                this.pDisplayMode = prefsBytes[2];
                this.pLength = prefsBytes[3];
                this.pStoreDomains = prefsBytes[4];
                break;
            }
            default: {
                return;
            }
        }
        prefs.destroy();
    }

    private void writePrefs() throws RecordStoreException {
        if (this.prefsRecordID != -1) {
            this.rsPrefs.deleteRecord(this.prefsRecordID);
        }
        byte[] encodedPrefs = new byte[]{2, this.pHashFunction, this.pDisplayMode, this.pLength, this.pStoreDomains};
        this.prefsRecordID = this.rsPrefs.addRecord(encodedPrefs, 0, encodedPrefs.length);
    }

    public byte getHashFunction() {
        return this.pHashFunction;
    }

    public void setHashFunction(byte hashFunction) {
        this.pHashFunction = hashFunction;
        try {
            this.writePrefs();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public byte getDisplayMode() {
        return this.pDisplayMode;
    }

    public void setDisplayMode(byte displayMode) {
        this.pDisplayMode = displayMode;
        try {
            this.writePrefs();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public byte getLength() {
        return this.pLength;
    }

    public void setLength(byte length) {
        this.pLength = length;
        try {
            this.writePrefs();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public boolean getStoreDomains() {
        return this.pStoreDomains == 1;
    }

    public void setStoreDomains(boolean storeDomains) {
        this.pStoreDomains = storeDomains ? (byte)1 : 0;
        try {
            this.writePrefs();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public String[] getDomainList() {
        String[] domainList = null;
        RecordComparator comparator = new RecordComparator(){

            public int compare(byte[] rec1, byte[] rec2) {
                int position1 = 0;
                int position2 = 0;
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(rec1);
                    DataInputStream din = new DataInputStream(bin);
                    din.readInt();
                    position1 = din.readInt();
                    bin = new ByteArrayInputStream(rec2);
                    din = new DataInputStream(bin);
                    din.readInt();
                    position2 = din.readInt();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (position1 == position2) {
                    return 0;
                }
                return position1 < position2 ? -1 : 1;
            }
        };
        try {
            RecordEnumeration records = this.rsDomains.enumerateRecords(null, comparator, false);
            domainList = new String[records.numRecords()];
            int dlIndex = 0;
            while (records.hasNextElement()) {
                int id = records.nextRecordId();
                ByteArrayInputStream bin = new ByteArrayInputStream(this.rsDomains.getRecord(id));
                DataInputStream din = new DataInputStream(bin);
                try {
                    switch (din.readInt()) {
                        case 0: {
                            int positionIndex = din.readInt();
                            if (positionIndex >= this.positionIncrementor) {
                                this.positionIncrementor = positionIndex + 1;
                            }
                            domainList[dlIndex++] = din.readUTF();
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            records.destroy();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return domainList;
    }

    public boolean containsDomain(final String domainName) throws RecordStoreException {
        if (domainName == null) {
            return false;
        }
        RecordFilter domainNameMatcher = new RecordFilter(){

            public boolean matches(byte[] candidate) {
                ByteArrayInputStream bin = new ByteArrayInputStream(candidate);
                DataInputStream din = new DataInputStream(bin);
                try {
                    switch (din.readInt()) {
                        case 0: {
                            din.readInt();
                            return domainName.equals(din.readUTF());
                        }
                    }
                    return false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        };
        RecordEnumeration matchingRecords = this.rsDomains.enumerateRecords(domainNameMatcher, null, false);
        return matchingRecords.numRecords() > 0;
    }

    public void addDomain(String newDomain) throws RecordStoreException {
        if (!this.containsDomain(newDomain)) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.writeInt(0);
                dout.writeInt(this.positionIncrementor++);
                dout.writeUTF(newDomain);
                byte[] recordBytes = bout.toByteArray();
                this.rsDomains.addRecord(recordBytes, 0, recordBytes.length);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteDomain(final String domainName) throws RecordStoreException {
        RecordFilter domainNameMatcher = new RecordFilter(){

            public boolean matches(byte[] candidate) {
                ByteArrayInputStream bin = new ByteArrayInputStream(candidate);
                DataInputStream din = new DataInputStream(bin);
                try {
                    switch (din.readInt()) {
                        case 0: {
                            din.readInt();
                            return domainName.equals(din.readUTF());
                        }
                    }
                    return false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
        };
        RecordEnumeration matchingRecords = this.rsDomains.enumerateRecords(domainNameMatcher, null, false);
        while (matchingRecords.hasNextElement()) {
            this.rsDomains.deleteRecord(matchingRecords.nextRecordId());
        }
    }

    public void exclusiveAddDomain(String domainString) throws RecordStoreException {
        try {
            this.deleteDomain(domainString);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        this.addDomain(domainString);
    }
}

