/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import java.util.Enumeration;
import java.util.Vector;
import multime.MultiME;
import org.netbeans.microedition.lcdui.TableModel;
import org.netbeans.microedition.lcdui.TableModelListener;

public class SimpleTableModel
implements TableModel {
    private Vector modelListeners = new Vector();
    private String[][] values = new String[0][0];
    private String[] columnNames = new String[0];
    private int cols;
    private int rows;

    public SimpleTableModel(String[][] values, String[] columnNames) throws IllegalArgumentException {
        this.setValues(values);
        this.setColumnNames(columnNames);
    }

    public SimpleTableModel(int rows, int cols) throws IllegalArgumentException {
        if (rows < 0) {
            throw new IllegalArgumentException("row size cannot be negative");
        }
        if (cols < 0) {
            throw new IllegalArgumentException("column size cannot be negative");
        }
        String[][] newValues = new String[rows][cols];
        for (int i2 = 0; i2 < rows; ++i2) {
            newValues[i2] = new String[cols];
        }
        this.setValues(newValues);
        this.setColumnNames(new String[cols]);
    }

    public SimpleTableModel() {
    }

    public int getColumnCount() {
        return this.cols;
    }

    public int getRowCount() {
        return this.rows;
    }

    public void setValue(int col, int row, String value) throws IllegalArgumentException {
        if (this.values == null) {
            throw new IllegalArgumentException("No values set to the model");
        }
        if (this.values.length < row) {
            throw new IllegalArgumentException("Specified row (" + row + ") is larger than the number of rows available in values (" + this.values.length + ").");
        }
        if (this.values[row].length < col) {
            throw new IllegalArgumentException("Specified column (" + col + ") is larger than the number of columns available in values (" + this.values[row].length + ").");
        }
        this.values[row][col] = value;
    }

    public void setValues(String[][] values) throws IllegalArgumentException {
        this.checkValues(values);
        this.values = values;
        this.fireTableModelChanged();
    }

    public String[][] getValues() {
        return this.values;
    }

    public Object getValue(int col, int row) {
        return this.values[row][col];
    }

    public boolean isUsingHeaders() {
        return this.columnNames != null;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.fireTableModelChanged();
    }

    public String getColumnName(int column) {
        if (this.columnNames != null && column < this.columnNames.length) {
            return this.columnNames[column];
        }
        return null;
    }

    public void fireTableModelChanged() {
        Enumeration e2 = this.modelListeners.elements();
        while (e2.hasMoreElements()) {
            ((TableModelListener)e2.nextElement()).tableModelChanged(this);
        }
    }

    public synchronized void addTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.modelListeners.addElement(listener);
        }
    }

    public synchronized void removeTableModelListener(TableModelListener listener) {
        this.modelListeners.removeElement(listener);
    }

    private void checkValues(String[][] values) throws IllegalArgumentException {
        this.rows = 0;
        this.cols = 0;
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null.");
        }
        this.rows = values.length;
        if (this.rows > 0) {
            this.cols = values[0].length;
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            String[] row = values[i2];
            if (row == null) {
                throw new IllegalArgumentException("Data cannot contain null rows (row " + i2 + ").");
            }
            if (values[0].length == row.length) continue;
            throw new IllegalArgumentException("Data cannot contain different row lengths (row " + i2 + ").");
        }
    }

    static {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.SimpleTableModel");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.SimpleTableModel");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

