/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import multime.FakeDisplay;
import multime.MultiME;
import org.netbeans.microedition.lcdui.TableModel;
import org.netbeans.microedition.lcdui.TableModelListener;
import org.netbeans.microedition.lcdui.laf.ColorSchema;
import org.netbeans.microedition.lcdui.laf.SystemColorSchema;

public class TableItem
extends CustomItem
implements TableModelListener {
    private static final boolean DEBUG = false;
    private int tableRows = 0;
    private int tableCols = 0;
    private String title = null;
    private boolean borders = true;
    private boolean usingHeaders = false;
    private final FakeDisplay display;
    private static final Font STATIC_TEXT_FONT;
    private static final Font DEFAULT_TITLE_FONT;
    private static final Font DEFAULT_HEADERS_FONT;
    private static final Font DEFAULT_VALUES_FONT;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private Font headersFont = DEFAULT_HEADERS_FONT;
    private Font valuesFont = DEFAULT_VALUES_FONT;
    private TableModel model;
    private int[] colWidths;
    private int[] rowHeights;
    private int totalColWidth;
    private int defaultCellWidth;
    private int defaultCellHeight;
    private static final int CELL_PADDING = 2;
    private static final int DOUBLE_CELL_PADDING = 4;
    private static final int BORDER_LINE_WIDTH = 1;
    private boolean cursorOn = false;
    private int cursorCellX;
    private int cursorCellY;
    private int viewCellX = 0;
    private int viewCellX2 = 0;
    private boolean tableFitsHorizontally = true;
    private boolean firstPaint = true;
    private int sizeWidth = 0;
    private int sizeHeight = 0;
    private ColorSchema colorSchema;

    public TableItem(FakeDisplay display, String label) throws IllegalArgumentException {
        this(display, label, null);
    }

    public TableItem(FakeDisplay display, String label, TableModel model) throws IllegalArgumentException {
        this(display, label, model, null);
    }

    public TableItem(FakeDisplay display, String label, TableModel model, ColorSchema colorSchema) throws IllegalArgumentException {
        super(label);
        if (display == null) {
            throw new IllegalArgumentException("display parameter cannot be null");
        }
        this.display = display;
        this.updateDefaultCellSize();
        if (model != null) {
            this.setModel(model);
        } else {
            this.recomputeModelValues();
        }
        this.setColorSchemaImpl(display, colorSchema);
    }

    public void setColorSchema(ColorSchema colorSchema) {
        this.setColorSchemaImpl(this.display, colorSchema);
        this.repaint();
    }

    public ColorSchema getColorSchema() {
        return this.colorSchema;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String tableTitle) {
        if (this.title != tableTitle) {
            this.title = tableTitle;
            this.repaint();
        }
    }

    public boolean isBorders() {
        return this.borders;
    }

    public void setBorders(boolean showBorders) {
        if (this.borders != showBorders) {
            this.borders = showBorders;
            this.repaint();
        }
    }

    public void setModel(TableModel model) throws IllegalArgumentException {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        if (model == null) {
            throw new IllegalArgumentException("model parameter cannot be null");
        }
        if (model != null) {
            if (model.getRowCount() < 0) {
                throw new IllegalArgumentException("model cannot have negative number of rows");
            }
            if (model.getColumnCount() < 0) {
                throw new IllegalArgumentException("model cannot have negative number of cols");
            }
            model.addTableModelListener(this);
        }
        this.model = model;
        this.recomputeModelValues();
        this.invalidateTable();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        if (this.titleFont != titleFont) {
            this.titleFont = titleFont != null ? titleFont : DEFAULT_TITLE_FONT;
            this.repaint();
        }
    }

    public Font getValuesFont() {
        return this.valuesFont;
    }

    public void setValuesFont(Font valuesFont) {
        if (this.valuesFont != valuesFont) {
            this.valuesFont = valuesFont != null ? valuesFont : DEFAULT_VALUES_FONT;
            this.updateDefaultCellSize();
            this.recomputeModelValues();
            this.repaint();
        }
    }

    public Font getHeadersFont() {
        return this.headersFont;
    }

    public void setHeadersFont(Font headersFont) {
        if (this.headersFont != headersFont) {
            this.headersFont = headersFont != null ? headersFont : DEFAULT_HEADERS_FONT;
            this.repaint();
        }
    }

    public int getSelectedCellRow() {
        return this.cursorCellY;
    }

    public int getSelectedCellColumn() {
        return this.cursorCellX;
    }

    protected int getMinContentHeight() {
        int sum = this.tableRows * (this.defaultCellHeight + 1) + 1;
        if (this.title != null) {
            sum += this.getTitleFont().getHeight() + 4 + 1;
        }
        if (this.usingHeaders) {
            sum += this.getHeadersFont().getHeight() + 4 + 1;
        }
        return sum;
    }

    protected int getMinContentWidth() {
        return -1;
    }

    protected int getPrefContentHeight(int width) {
        return this.getMinContentHeight();
    }

    protected int getPrefContentWidth(int height) {
        int titleWidth;
        Displayable currentDisplayable = this.display.getCurrent();
        int displayWidth = currentDisplayable == null ? -1 : currentDisplayable.getWidth();
        int sum = this.colWidths.length * 1 + 1;
        int result = 0;
        for (int i2 = 0; i2 < this.colWidths.length; ++i2) {
            sum += this.colWidths[i2];
        }
        result = sum;
        if (this.title != null && (titleWidth = this.getTitleFont().stringWidth(this.title)) > result) {
            result = titleWidth + 4;
        }
        if (displayWidth > 0 && result > displayWidth) {
            result = displayWidth;
        }
        return result;
    }

    protected void paint(Graphics g2, int width, int height) {
        this.firstPaint = false;
        int paintWidth = this.sizeWidth > 0 ? this.sizeWidth : width;
        int paintHeight = this.sizeHeight > 0 ? this.sizeHeight : height;
        this.tableFitsHorizontally = this.totalColWidth <= paintWidth;
        boolean rightmostColumnFullyVisible = true;
        int currentColor = g2.getColor();
        this.getColorSchema().paintBackground(g2, false);
        int hy = paintHeight - 1;
        int wx = paintWidth - 1;
        int titleHeight = 0;
        if (this.title != null) {
            titleHeight = this.getTitleFont().getHeight() + 4;
        }
        int headersHeight = 0;
        if (this.usingHeaders) {
            headersHeight = this.getHeadersFont().getHeight() + 4;
        }
        int viewWidth = wx;
        int actualTableWidth = paintWidth;
        if (this.model != null && this.tableRows != 0 && this.tableCols != 0) {
            if (this.viewCellX2 < this.tableCols - 1) {
                viewWidth = wx;
            } else {
                viewWidth = 0;
                for (int i2 = this.viewCellX; i2 <= this.viewCellX2 && i2 < this.tableCols; ++i2) {
                    viewWidth += this.colWidths[i2];
                }
                if (viewWidth > wx) {
                    viewWidth = wx;
                }
            }
            if (this.cursorOn) {
                int x = this.getCursorX();
                int y = this.getCursorY() + 1;
                if (this.title != null) {
                    y += titleHeight + 1;
                }
                if (this.usingHeaders) {
                    y += headersHeight + 1;
                }
                int w = this.colWidths[this.cursorCellX];
                int h2 = this.defaultCellHeight;
                g2.setColor(this.getColorSchema().getColor(2));
                g2.fillRect(x, y, w, h2);
            }
            int y = 0;
            if (this.title != null) {
                y += titleHeight + 1;
            }
            if (this.usingHeaders) {
                g2.setColor(this.getColorSchema().getColor(1));
                g2.setFont(this.getHeadersFont());
                int x = 1;
                int gy = y + 2 + 1;
                for (int j2 = this.viewCellX; j2 < this.model.getColumnCount(); ++j2) {
                    this.viewCellX2 = j2;
                    String value = this.model.getColumnName(j2);
                    int colWidth = this.colWidths[j2];
                    if (value != null) {
                        g2.drawString(value.toString(), x + colWidth / 2, gy, 17);
                    }
                    if ((x += colWidth + 1) <= paintWidth) continue;
                    rightmostColumnFullyVisible = false;
                    break;
                }
                y += headersHeight + 1;
            }
            g2.setColor(this.getColorSchema().getColor(1));
            g2.setFont(this.getValuesFont());
            for (int i3 = 0; i3 < this.model.getRowCount(); ++i3) {
                int x = 3;
                int gy = y + 2 + 1;
                for (int j3 = this.viewCellX; j3 < this.model.getColumnCount(); ++j3) {
                    this.viewCellX2 = j3;
                    Object value = this.model.getValue(j3, i3);
                    if (value != null) {
                        if (this.cursorOn && j3 == this.cursorCellX && i3 == this.cursorCellY) {
                            g2.setColor(this.getColorSchema().getColor(3));
                            g2.drawString(value.toString(), x, gy, 20);
                            g2.setColor(this.getColorSchema().getColor(1));
                        } else {
                            g2.drawString(value.toString(), x, gy, 20);
                        }
                    }
                    if ((x += this.colWidths[j3] + 1) <= width) continue;
                    rightmostColumnFullyVisible = false;
                    break;
                }
                y += this.defaultCellHeight + 1;
            }
            if (this.isBorders()) {
                int i4;
                g2.setColor(this.getColorSchema().getColor(4));
                int currentStrokeStyle = g2.getStrokeStyle();
                g2.setStrokeStyle(this.display.getBorderStyle(false));
                y = titleHeight;
                int totalTableHeight = this.tableRows * (this.defaultCellHeight + 1) + titleHeight;
                if (this.usingHeaders) {
                    totalTableHeight += headersHeight + 1;
                }
                int x = 0;
                for (i4 = this.viewCellX; i4 < this.tableCols && x < width; ++i4) {
                    g2.drawLine(x += this.colWidths[i4] + 1, titleHeight, x, totalTableHeight);
                    actualTableWidth = x;
                }
                if (titleHeight > 0 && rightmostColumnFullyVisible) {
                    g2.drawLine(x, 0, x, titleHeight);
                }
                g2.drawLine(0, 0, actualTableWidth, 0);
                if (this.usingHeaders) {
                    g2.drawLine(0, y, actualTableWidth, y);
                    y += headersHeight + 1;
                }
                for (i4 = 0; i4 <= this.tableRows && y <= totalTableHeight; ++i4, y += this.defaultCellHeight + 1) {
                    g2.drawLine(0, y, actualTableWidth, y);
                }
                g2.drawLine(0, 0, 0, totalTableHeight);
                g2.setStrokeStyle(currentStrokeStyle);
            }
        }
        if (this.title != null) {
            g2.setColor(this.getColorSchema().getColor(1));
            g2.setFont(this.titleFont);
            g2.drawString(this.title, actualTableWidth / 2, 3, 17);
            int half = titleHeight / 2;
            if (this.viewCellX > 0) {
                g2.drawLine(2, half, 5, half - 2);
                g2.drawLine(2, half, 5, half + 2);
            }
            if (!rightmostColumnFullyVisible) {
                int rx = actualTableWidth - 2;
                g2.drawLine(rx, half, rx - 3, half - 2);
                g2.drawLine(rx, half, rx - 3, half + 2);
            }
        }
        g2.setColor(currentColor);
    }

    protected void sizeChanged(int w, int h2) {
        if (!this.firstPaint && w > 0 && h2 > 0 && w != this.sizeWidth && h2 != this.sizeHeight) {
            this.sizeWidth = w;
            this.sizeHeight = h2;
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        int visibleWidth = visRect_inout[2];
        int visibleHeight = visRect_inout[3];
        if (this.model == null) {
            return false;
        }
        boolean retValue = false;
        boolean repaint = false;
        if (!this.cursorOn) {
            if (dir == 1) {
                this.cursorCellY = this.tableRows - 1;
            } else if (dir == 6) {
                this.cursorCellY = 0;
            } else if (dir == 5) {
                this.cursorCellY = 0;
                this.cursorCellX = 0;
            } else if (dir == 2) {
                this.cursorCellY = this.tableRows - 1;
                this.viewCellX2 = this.cursorCellX = this.tableCols - 1;
            }
            this.cursorOn = true;
            retValue = true;
            repaint = true;
        } else {
            if (dir == 1) {
                --this.cursorCellY;
            } else if (dir == 6) {
                ++this.cursorCellY;
            } else if (dir == 2) {
                --this.cursorCellX;
            } else if (dir == 5) {
                ++this.cursorCellX;
            }
            if (this.cursorCellX < 0) {
                this.cursorCellX = 0;
                retValue = true;
                repaint = false;
            } else if (this.cursorCellX >= this.tableCols) {
                this.cursorCellX = this.tableCols - 1;
                retValue = true;
                repaint = false;
            }
            if (this.cursorCellY >= 0 && this.cursorCellY < this.tableRows) {
                retValue = true;
                repaint = true;
            } else {
                retValue = false;
                repaint = false;
                this.cursorCellY = this.cursorCellY < 0 ? 0 : this.tableRows - 1;
            }
        }
        int cursorY = this.getCursorY();
        int cursorHeight = this.defaultCellHeight;
        int headersHeight = 0;
        if (this.title != null) {
            headersHeight += this.getTitleFont().getHeight() + 4 + 1;
        }
        if (this.usingHeaders) {
            headersHeight += this.getHeadersFont().getHeight() + 4 + 1;
        }
        visRect_inout[1] = cursorY + headersHeight + 2;
        visRect_inout[3] = this.defaultCellHeight;
        visRect_inout[0] = this.getCursorX();
        visRect_inout[2] = this.defaultCellWidth;
        if (!this.tableFitsHorizontally) {
            repaint = true;
            if (this.cursorCellX >= this.viewCellX2) {
                int i2;
                int sum = 3;
                for (i2 = this.viewCellX2; sum <= visibleWidth && i2 >= 0; sum += this.colWidths[i2] + 1, --i2) {
                }
                this.viewCellX = i2 + 2;
                if (this.viewCellX > this.viewCellX2) {
                    this.viewCellX = this.cursorCellX;
                }
            } else if (this.cursorCellX < this.viewCellX) {
                --this.viewCellX;
            }
        }
        if (repaint) {
            this.repaint();
        }
        return retValue;
    }

    protected void traverseOut() {
        super.traverseOut();
        this.cursorOn = false;
        this.repaint();
    }

    private int getCursorX() {
        int x = 1;
        for (int i2 = this.viewCellX; i2 < this.cursorCellX; ++i2) {
            x += this.colWidths[i2] + 1;
        }
        return x;
    }

    private int getCursorY() {
        return this.cursorCellY * (this.defaultCellHeight + 1);
    }

    private void recomputeModelValues() {
        int i2;
        if (this.model != null) {
            this.tableRows = this.model.getRowCount();
            this.tableCols = this.model.getColumnCount();
        } else {
            this.tableCols = 0;
            this.tableRows = 0;
            this.usingHeaders = false;
        }
        this.colWidths = new int[this.tableCols];
        for (i2 = 0; i2 < this.tableCols; ++i2) {
            this.colWidths[i2] = this.defaultCellWidth;
        }
        if (this.model != null) {
            int i3;
            int columnCount = this.model.getColumnCount();
            int rowCount = this.model.getRowCount();
            for (i3 = 0; i3 < columnCount; ++i3) {
                for (int j2 = 0; j2 < rowCount; ++j2) {
                    int width;
                    Object value = this.model.getValue(i3, j2);
                    if (value == null || (width = this.getValuesFont().stringWidth(value.toString()) + 4) <= this.colWidths[i3]) continue;
                    this.colWidths[i3] = width;
                }
            }
            this.usingHeaders = this.model.isUsingHeaders();
            if (this.model.isUsingHeaders()) {
                for (i3 = 0; i3 < columnCount; ++i3) {
                    int width;
                    String columnName = this.model.getColumnName(i3);
                    if (columnName == null || (width = this.getHeadersFont().stringWidth(columnName.toString()) + 4) <= this.colWidths[i3]) continue;
                    this.colWidths[i3] = width;
                }
            }
        }
        this.totalColWidth = 1;
        for (i2 = 0; i2 < this.colWidths.length; ++i2) {
            this.totalColWidth += this.colWidths[i2] + 1;
        }
    }

    private void updateDefaultCellSize() {
        this.defaultCellWidth = this.getValuesFont().stringWidth("X") + 4;
        this.defaultCellHeight = this.getValuesFont().getHeight() + 4;
    }

    private void setColorSchemaImpl(FakeDisplay display, ColorSchema colorSchema) {
        this.colorSchema = colorSchema != null ? colorSchema : SystemColorSchema.getForDisplay(display);
    }

    private void invalidateTable() {
        if (this.sizeWidth > 0 && this.sizeHeight > 0) {
            this.invalidate();
        }
    }

    public void tableModelChanged(TableModel changedModel) {
        if (changedModel == this.model) {
            this.recomputeModelValues();
            this.invalidateTable();
        }
    }

    static {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.TableItem");
        STATIC_TEXT_FONT = Font.getFont((int)0);
        DEFAULT_TITLE_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
        DEFAULT_HEADERS_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
        DEFAULT_VALUES_FONT = STATIC_TEXT_FONT;
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("org.netbeans.microedition.lcdui.TableItem");
        STATIC_TEXT_FONT = Font.getFont((int)0);
        DEFAULT_TITLE_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
        DEFAULT_HEADERS_FONT = Font.getFont((int)STATIC_TEXT_FONT.getFace(), (int)(STATIC_TEXT_FONT.getStyle() | 1), (int)STATIC_TEXT_FONT.getSize());
        DEFAULT_VALUES_FONT = STATIC_TEXT_FONT;
    }

    public static void staticSuperCleaningRoutine() {
    }
}

