/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDletStateChangeException;
import sudokusolver.AboutScreen;
import sudokusolver.Cell;
import sudokusolver.CellIndexes;
import sudokusolver.Location;
import sudokusolver.Rectangle;
import sudokusolver.SSMidlet;
import sudokusolver.control.Alert;
import sudokusolver.control.Control;
import sudokusolver.control.event.ActionListener;
import sudokusolver.control.menu.Menu;
import sudokusolver.control.menu.MenuBar;
import sudokusolver.control.menu.MenuItem;
import sudokusolver.util.Util;

public class MainCanvas
extends GameCanvas
implements Control,
Runnable {
    public static final int KEY_MIDDLE = -5;
    public static final int KEY_SOFT1 = -6;
    public static final int KEY_SOFT2 = -7;
    public static final int KEY_CLEAR = -8;
    public static final int KEY_LEFT = 0;
    public static final int KEY_RIGHT = 1;
    public static final int KEY_UP = 2;
    public static final int KEY_DOWN = 3;
    public static final Font messageFont = Font.getFont((int)64, (int)0, (int)8);
    public static final Font titleBarFont = Font.getFont((int)64, (int)0, (int)8);
    public static final int cellLightColor1 = 13554679;
    public static final int cellLightColor2 = 12436726;
    public static final int cellDarkColor1 = 12301292;
    public static final int cellDarkColor2 = 11313643;
    public static final int backgroundColor = 0xBB44FF;
    public static final int statusBarColor = 8998625;
    public static final int titleBarColor = -7778591;
    public static final int progressBarColor1 = 8998625;
    public static final int progressBarColor2 = 7875775;
    public static final int resultNavigationKeyColor = 11313643;
    public static final int selectedCellBackgroundColor1 = -1997545210;
    public static final int selectedCellBackgroundColor2 = -1998071546;
    public static final int selectedCellForegroundColor = 0xBB44FF;
    public static final int enteredNumbersColor = 3416921;
    public static final int determinedNumbersColor = 0xC63333;
    public static final int testingNumbersColor = 9653985;
    public static final int solvedNumbersColor = 9653985;
    public static final int backgroundGradientColor = 0xCC00FF;
    public static final int cellRectSmallGapSize = 1;
    public static final int cellRectBigGapSize = 2;
    public static final int titleBarTopGapSize = 5;
    public static final int titleBarBottomGapSize = 5;
    public static final int leftGap = 1;
    public static final int rightGap = 1;
    public static final int topGap = 1;
    public static final int bottomGap = 1;
    public static final long solvingProgressShowTimeInterval = 200L;
    public static final double solvingProgressShowValueInterval = 0.01;
    public static final int resultsViewHorizontalIncrementValue = 1;
    public static final int resultsViewVerticalIncrementValue = 10;
    public static final int resultViewFastNavigationDelay = 1000;
    public static final int VIEW_MODE_NORMAL = 0;
    public static final int VIEW_MODE_RESULT = 1;
    public static final int VIEW_MODE_MENU = 2;
    public static final int VIEW_MODE_ABOUT_SCREEN = 3;
    public int viewMode;
    private int lastViewMode;
    public static final boolean selectedCellIsOpaque = false;
    private int locationIndicatorColor1;
    private int conflictIndicatorColor1;
    private int locationIndicatorColor2;
    private int conflictIndicatorColor2;
    private double numOfStatusesMustCheck;
    private double numOfStatusesChecked;
    private double progressValue;
    private double lastProgressValue;
    private long lastSolutionShowTime;
    private String statusBarMessageText;
    private String titleBarText;
    public boolean inputEnabled;
    private boolean lastInputEnabled;
    private boolean showSolvingProgressDetails;
    private boolean errorReasonHighlighted;
    private boolean solverThreadCanceled;
    private int width;
    private int height;
    private int statusBarVerticalInset;
    public int statusBarHeight;
    private Rectangle titleBarRect;
    private Rectangle clientRect;
    private Rectangle cellsRect;
    private Cell[] cells;
    private byte[] cellsValuesCopy;
    private Cell[] emptyCells;
    byte[] rowValuesArray;
    byte[] columnValuesArray;
    byte[] squareValuesArray;
    Cell[] rowCellsArray;
    Cell[] columnCellsArray;
    Cell[] squareCellsArray;
    boolean[] isKeyDown;
    private Thread solverThread;
    private Thread resultViewerThread;
    private int solutionCounter;
    private int statusBarMessageColor;
    private int statusBarMessageShadowColor;
    Vector enteredValues;
    Vector determinedValues;
    Vector solvedValuesCollections;
    MenuItem solveMenuItem;
    MenuItem aboutMenuItem;
    MenuItem exitMenuItem;
    Menu leftMenu;
    Menu rightMenu;
    public MenuBar menuBar;
    Alert alert;
    private AboutScreen aboutScreen;
    private byte selectedCellIndex;
    private int currentResultViewIndex;
    private final int aboutScreenExitKeyHints;
    private int aboutScreenExitKeyHintsCounter;
    private SSMidlet parentMidlet;

    public MainCanvas(boolean bl, SSMidlet sSMidlet) {
        super(bl);
        this.lastViewMode = this.viewMode = 0;
        this.locationIndicatorColor1 = 16371549;
        this.conflictIndicatorColor1 = 0xF96666;
        this.locationIndicatorColor2 = 16562695;
        this.conflictIndicatorColor2 = 15672613;
        this.numOfStatusesChecked = 0.0;
        this.lastProgressValue = this.progressValue = 0.0;
        this.statusBarMessageText = null;
        this.titleBarText = "Mobile Sudoku Solver";
        this.inputEnabled = true;
        this.lastInputEnabled = false;
        this.showSolvingProgressDetails = false;
        this.errorReasonHighlighted = false;
        this.solverThreadCanceled = false;
        this.statusBarVerticalInset = 6;
        this.statusBarHeight = messageFont.getHeight() + 2 * this.statusBarVerticalInset;
        this.titleBarRect = null;
        this.clientRect = null;
        this.cellsRect = null;
        this.cells = new Cell[81];
        this.cellsValuesCopy = new byte[81];
        this.emptyCells = null;
        this.rowValuesArray = new byte[9];
        this.columnValuesArray = new byte[9];
        this.squareValuesArray = new byte[9];
        this.rowCellsArray = new Cell[9];
        this.columnCellsArray = new Cell[9];
        this.squareCellsArray = new Cell[9];
        this.isKeyDown = new boolean[4];
        this.solverThread = null;
        this.resultViewerThread = null;
        this.statusBarMessageColor = 13554679;
        this.statusBarMessageShadowColor = 3416921;
        this.enteredValues = new Vector();
        this.determinedValues = new Vector();
        this.solvedValuesCollections = new Vector();
        this.solveMenuItem = null;
        this.aboutMenuItem = null;
        this.exitMenuItem = null;
        this.leftMenu = null;
        this.rightMenu = null;
        this.menuBar = null;
        this.alert = null;
        this.aboutScreen = null;
        this.selectedCellIndex = 0;
        this.currentResultViewIndex = 0;
        this.aboutScreenExitKeyHints = 2;
        this.aboutScreenExitKeyHintsCounter = 0;
        this.parentMidlet = null;
        this.parentMidlet = sSMidlet;
        this.alert = new Alert(this);
        this.aboutScreen = new AboutScreen(this);
        this.initialize();
    }

    private void initialize() {
        this.setFullScreenMode(true);
        this.initializeMenuBar();
        this.initializeCells();
    }

    private MenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new MenuItem("\u0412\u044b\u0445\u043e\u0434");
            this.exitMenuItem.AddActionListener(new ActionListener(){

                public void doAction() {
                    MainCanvas.this.leftMenu.closeMenu();
                    MainCanvas.this.showAlert("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", "\u0412\u044b\u0439\u0442\u0438?", "\u041d\u0435\u0442", "\u0414\u0430");
                }
            });
        }
        return this.exitMenuItem;
    }

    private MenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new MenuItem("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435");
            this.aboutMenuItem.AddActionListener(new ActionListener(){

                public void doAction() {
                    MainCanvas.this.leftMenu.closeMenu();
                    MainCanvas.this.showAboutScreen();
                }
            });
        }
        return this.aboutMenuItem;
    }

    private MenuItem getSolveMenuItem() {
        if (this.solveMenuItem == null) {
            this.solveMenuItem = new MenuItem("\u0421\u0447\u0438\u0442\u0430\u0442\u044c");
            this.solveMenuItem.AddActionListener(new ActionListener(){

                public void doAction() {
                    MainCanvas.this.leftMenu.closeMenu();
                    if (MainCanvas.this.solveMenuItem.text.equals("\u0421\u0447\u0438\u0442\u0430\u0442\u044c")) {
                        MainCanvas.this.startSolving();
                    } else if (MainCanvas.this.solveMenuItem.text.equals("Cancel solving")) {
                        MainCanvas.this.showAlert("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435?", "\u041d\u0435\u0442", "\u0414\u0430");
                    } else if (MainCanvas.this.solveMenuItem.text.equals("\u041d\u0430\u0437\u0430\u0434")) {
                        MainCanvas.this.enterNormalMode();
                    } else if (MainCanvas.this.solveMenuItem.text.equals("\u041d\u043e\u0432\u044b\u0439")) {
                        MainCanvas.this.showAlert("\u0421\u0431\u0440\u043e\u0441", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u043b\u0435\u0442\u043a\u0438?", "\u041d\u0435\u0442", "\u0414\u0430");
                    }
                }
            });
        }
        return this.solveMenuItem;
    }

    private Menu getLeftMenu() {
        if (this.leftMenu == null) {
            this.leftMenu = new Menu(1, "\u041c\u0435\u043d\u044e", 8998625);
            this.exitMenuItem = this.getExitMenuItem();
            this.aboutMenuItem = this.getAboutMenuItem();
            this.solveMenuItem = this.getSolveMenuItem();
            this.leftMenu.addMenuItem(this.exitMenuItem);
            this.leftMenu.addMenuItem(this.aboutMenuItem);
            this.leftMenu.addMenuItem(this.solveMenuItem);
            this.leftMenu.AddActionListener(new ActionListener(){

                public void doAction() {
                    if (MainCanvas.this.leftMenu.text.equals("\u041c\u0435\u043d\u044e")) {
                        MainCanvas.this.leftMenu.openMenu();
                    } else if (MainCanvas.this.leftMenu.text.equals("\u0414\u0430")) {
                        MainCanvas.this.hideAlert();
                        if (MainCanvas.this.alert.title.equals("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c")) {
                            MainCanvas.this.endSolving();
                        } else if (MainCanvas.this.alert.title.equals("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b")) {
                            MainCanvas.this.exit();
                        } else if (MainCanvas.this.alert.title.equals("\u0421\u0431\u0440\u043e\u0441")) {
                            MainCanvas.this.reset();
                        }
                    } else if (MainCanvas.this.leftMenu.text.equals("\u041d\u0435\u0442")) {
                        MainCanvas.this.hideAlert();
                    } else if (MainCanvas.this.leftMenu.text.equals("\u0412\u044b\u0431\u043e\u0440")) {
                        MainCanvas.this.leftMenu.getCurrentItem().performAction();
                    }
                }
            });
        }
        return this.leftMenu;
    }

    private Menu getRightMenu() {
        if (this.rightMenu == null) {
            this.rightMenu = new Menu(2, "\u0421\u0447\u0438\u0442\u0430\u0442\u044c", 8998625);
            this.rightMenu.AddActionListener(new ActionListener(){

                public void doAction() {
                    if (MainCanvas.this.rightMenu.text.equals("\u0421\u0447\u0438\u0442\u0430\u0442\u044c")) {
                        MainCanvas.this.startSolving();
                    } else if (MainCanvas.this.rightMenu.text.equals("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")) {
                        if (MainCanvas.this.viewMode == 0) {
                            MainCanvas.this.showAlert("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435?", "\u0414\u0430", "\u041d\u0435\u0442");
                        } else if (MainCanvas.this.viewMode == 2) {
                            MainCanvas.this.leftMenu.closeMenu();
                            MainCanvas.this.restoreViewMode();
                        }
                    } else if (MainCanvas.this.rightMenu.text.equals("\u0414\u0430")) {
                        MainCanvas.this.hideAlert();
                        if (MainCanvas.this.alert.title.equals("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c")) {
                            MainCanvas.this.endSolving();
                        } else if (MainCanvas.this.alert.title.equals("\u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b")) {
                            MainCanvas.this.exit();
                        } else if (MainCanvas.this.alert.title.equals("\u0421\u0431\u0440\u043e\u0441")) {
                            MainCanvas.this.reset();
                        }
                    } else if (MainCanvas.this.rightMenu.text.equals("\u041d\u0435\u0442")) {
                        MainCanvas.this.hideAlert();
                    } else if (MainCanvas.this.rightMenu.text.equals("\u041d\u0430\u0437\u0430\u0434")) {
                        MainCanvas.this.enterNormalMode();
                    } else if (MainCanvas.this.rightMenu.text.equals("\u041d\u043e\u0432\u044b\u0439")) {
                        MainCanvas.this.showAlert("\u0421\u0431\u0440\u043e\u0441", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u043b\u0435\u0442\u043a\u0438?", "\u0414\u0430", "\u041d\u0435\u0442");
                    }
                }
            });
        }
        return this.rightMenu;
    }

    private void initializeMenuBar() {
        this.leftMenu = this.getLeftMenu();
        this.rightMenu = this.getRightMenu();
        this.menuBar = new MenuBar(this, this.leftMenu, this.rightMenu);
    }

    private void initializeCells() {
        for (byte by = 0; by < this.cells.length; by = (byte)(by + 1)) {
            this.cells[by] = new Cell(by, this, 0, 0);
            byte by2 = this.getCellRowIndex(by);
            byte by3 = this.getCellColumnIndex(by);
            byte by4 = this.get3x3SquareIndex(by2, by3);
            this.cells[by].originalBackgroundColor1 = by4 % 2 == 0 ? 13554679 : 12301292;
            this.cells[by].originalBackgroundColor2 = by4 % 2 == 0 ? 12436726 : 11313643;
            this.cells[by].currentBackgroundColor1 = this.cells[by].originalBackgroundColor1;
            this.cells[by].currentBackgroundColor2 = this.cells[by].originalBackgroundColor2;
            this.cells[by].value = 0;
            this.cells[by].type = 0;
        }
    }

    public void storeViewMode() {
        this.lastViewMode = this.viewMode;
    }

    public void restoreViewMode() {
        this.viewMode = this.lastViewMode;
    }

    private void showAlert(String string, String string2, String string3, String string4) {
        this.lastInputEnabled = this.inputEnabled;
        this.inputEnabled = false;
        this.alert.title = string;
        this.alert.text = string2;
        this.alert.show();
        this.menuBar.storeMenusText();
        this.menuBar.leftMenu.text = string3;
        this.menuBar.rightMenu.text = string4;
        this.repaintCanvas();
    }

    private void hideAlert() {
        this.alert.hide();
        this.menuBar.restoreMenusText();
        this.repaintCanvas();
        if (!this.inputEnabled) {
            this.inputEnabled = this.lastInputEnabled;
        }
    }

    private void setCellColor(byte by, byte by2, int n, int n2) {
        byte by3 = this.getCellIndex(by, by2);
        if (by3 != this.selectedCellIndex) {
            this.cells[by3].currentBackgroundColor1 = n;
            this.cells[by3].currentBackgroundColor2 = n2;
        }
    }

    private void setRowColor(byte by, int n, int n2) {
        for (byte by2 = 0; by2 < 9; by2 = (byte)(by2 + 1)) {
            byte by3 = by2;
            byte by4 = this.getCellIndex(by, by3);
            if (by4 == this.selectedCellIndex) continue;
            this.cells[by4].currentBackgroundColor1 = n;
            this.cells[by4].currentBackgroundColor2 = n2;
        }
    }

    private void setColumnColor(byte by, int n, int n2) {
        for (byte by2 = 0; by2 < 9; by2 = (byte)(by2 + 1)) {
            byte by3 = by2;
            byte by4 = this.getCellIndex(by3, by);
            if (by4 == this.selectedCellIndex) continue;
            this.cells[by4].currentBackgroundColor1 = n;
            this.cells[by4].currentBackgroundColor2 = n2;
        }
    }

    private void set3x3SquareColor(byte by, int n, int n2) {
        byte by2 = (byte)(by / 3 * 3);
        byte by3 = (byte)(by % 3 * 3);
        for (byte by4 = by2; by4 < by2 + 3; by4 = (byte)(by4 + 1)) {
            for (byte by5 = by3; by5 < by3 + 3; by5 = (byte)(by5 + 1)) {
                byte by6 = this.getCellIndex(by4, by5);
                if (by6 == this.selectedCellIndex) continue;
                this.cells[by6].currentBackgroundColor1 = n;
                this.cells[by6].currentBackgroundColor2 = n2;
            }
        }
    }

    private CellIndexes getCellIndexes(Cell cell) {
        return new CellIndexes(this.getCellRowIndex(cell.index), this.getCellColumnIndex(cell.index));
    }

    private void getCellIndexes(Location location, byte by, CellIndexes cellIndexes) {
        if (1 == location.type) {
            cellIndexes.rowIndex = location.index;
            cellIndexes.columnIndex = by;
        } else if (2 == location.type) {
            cellIndexes.rowIndex = by;
            cellIndexes.columnIndex = location.index;
        } else if (3 == location.type) {
            cellIndexes.rowIndex = (byte)(location.index / 3 * 3 + by / 3);
            cellIndexes.columnIndex = (byte)(location.index % 3 * 3 + by % 3);
        }
    }

    private CellIndexes getCellIndexes(Location location, byte by) {
        CellIndexes cellIndexes = new CellIndexes();
        this.getCellIndexes(location, by, cellIndexes);
        return cellIndexes;
    }

    private void resetCellBackgroundColors() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].currentBackgroundColor1 = this.cells[i].originalBackgroundColor1;
            this.cells[i].currentBackgroundColor2 = this.cells[i].originalBackgroundColor2;
        }
    }

    private void highLightErrorReason(byte by, byte by2, byte by3) {
        byte by4;
        byte by5 = this.getIndexOfElement((byte)1, by, by3);
        if (by5 >= 0) {
            this.setRowColor(by, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(by, by2, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
            this.setCellColor(by, by5, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        if ((by5 = this.getIndexOfElement((byte)2, by2, by3)) >= 0) {
            this.setColumnColor(by2, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(by, by2, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
            this.setCellColor(by5, by2, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        if ((by5 = this.getIndexOfElement((byte)3, by4 = this.get3x3SquareIndex(by, by2), by3)) >= 0) {
            this.set3x3SquareColor(by4, this.locationIndicatorColor1, this.locationIndicatorColor2);
            this.setCellColor(by, by2, this.conflictIndicatorColor1, this.locationIndicatorColor2);
            CellIndexes cellIndexes = this.getCellIndexes(new Location(3, by4), by5);
            this.setCellColor(cellIndexes.rowIndex, cellIndexes.columnIndex, this.conflictIndicatorColor1, this.conflictIndicatorColor2);
        }
        this.setMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f!");
        this.errorReasonHighlighted = true;
    }

    byte getCellRowIndex(byte by) {
        return (byte)(by / 9);
    }

    byte getCellColumnIndex(byte by) {
        return (byte)(by % 9);
    }

    private byte getCellIndex(byte by, byte by2) {
        return (byte)(by * 9 + by2);
    }

    private Cell getCell(byte by, byte by2) {
        return this.cells[this.getCellIndex(by, by2)];
    }

    public byte get3x3SquareIndex(byte by, byte by2) {
        if (by >= 0 && by < 9 && by2 >= 0 && by2 < 9) {
            return (byte)(by / 3 * 3 + by2 / 3);
        }
        return -1;
    }

    private void paintTitlebar(Graphics graphics) {
        Util.fillRect(graphics, this.titleBarRect.x, this.titleBarRect.y, this.titleBarRect.width, this.titleBarRect.height, -7778591, 1);
        int n = titleBarFont.getHeight();
        int n2 = this.cellsRect.x;
        int n3 = this.titleBarRect.y + (this.titleBarRect.height - n) / 2;
        graphics.setFont(titleBarFont);
        graphics.setColor(this.statusBarMessageShadowColor);
        graphics.drawString(this.titleBarText, n2 + 1, n3 + 1, 20);
        graphics.setColor(this.statusBarMessageColor);
        graphics.drawString(this.titleBarText, n2, n3, 20);
    }

    private void paintBackground(Graphics graphics) {
        graphics.setColor(0xBB44FF);
        graphics.fillRect(0, 0, this.width, this.height);
    }

    private void paintCells(Graphics graphics) {
        graphics.setColor(this.menuBar.backgroundColor);
        graphics.fillRect(this.cellsRect.x, this.cellsRect.y, this.cellsRect.width, this.cellsRect.height);
        Cell cell = null;
        for (int i = 0; i < this.cells.length; ++i) {
            cell = this.cells[i];
            boolean bl = cell.type != 0 && (this.showSolvingProgressDetails || cell.type != 4);
            cell.paint(graphics, bl);
        }
        if (this.selectedCellIndex >= 0 && this.inputEnabled && this.viewMode == 0) {
            this.cells[this.selectedCellIndex].currentBackgroundColor1 = -1997545210;
            this.cells[this.selectedCellIndex].currentBackgroundColor2 = -1998071546;
            this.cells[this.selectedCellIndex].paintBackground(graphics);
            this.cells[this.selectedCellIndex].paintForeground(graphics);
            graphics.setColor(this.menuBar.backgroundColor);
            graphics.drawRect(this.cells[this.selectedCellIndex].x - 2, this.cells[this.selectedCellIndex].y - 2, Cell.getSize() + 3, Cell.getSize() + 3);
            graphics.drawRect(this.cells[this.selectedCellIndex].x - 3, this.cells[this.selectedCellIndex].y - 3, Cell.getSize() + 5, Cell.getSize() + 5);
        }
    }

    private void paintProgressBar(Graphics graphics) {
        int n = (int)((double)this.width * this.progressValue);
        graphics.setColor(7875775);
        graphics.fillRect(0, this.height - this.menuBar.height - this.statusBarHeight, n, this.statusBarHeight);
        graphics.setColor(8998625);
        graphics.fillRect(n, this.height - this.menuBar.height - this.statusBarHeight, this.width - n, this.statusBarHeight);
    }

    private void paintStatusBar(Graphics graphics) {
        this.paintProgressBar(graphics);
        if (this.statusBarMessageText != null) {
            graphics.setFont(messageFont);
            int n = (this.width - messageFont.stringWidth(this.statusBarMessageText)) / 2;
            int n2 = this.height - this.menuBar.height - this.statusBarVerticalInset;
            graphics.setColor(this.statusBarMessageShadowColor);
            graphics.drawString(this.statusBarMessageText, n + 1, n2 + 1, 36);
            graphics.setColor(this.statusBarMessageColor);
            graphics.drawString(this.statusBarMessageText, n, n2, 36);
            if (this.viewMode == 1 && this.solutionCounter > 1) {
                int n3;
                int n4 = 4;
                int n5 = 4;
                int n6 = messageFont.stringWidth(this.statusBarMessageText);
                int n7 = (this.width - n6) / 2 - n4;
                int n8 = this.width - (this.width - n6) / 2 + n5;
                int n9 = this.height - this.menuBar.height - this.statusBarHeight / 2;
                int n10 = n3 = this.statusBarHeight / 3;
                graphics.setColor(11313643);
                graphics.fillTriangle(n7 - n10, n9, n7, n9 - n3 / 2, n7, n9 + n3 / 2);
                graphics.fillTriangle(n8 + n10, n9, n8, n9 + n3 / 2, n8, n9 - n3 / 2);
            }
        }
    }

    private void paintMenuBar(Graphics graphics) {
        this.menuBar.paint(graphics);
    }

    private void paintConfirmMessage(Graphics graphics) {
        this.alert.paint(graphics);
    }

    private void paintAboutScreen(Graphics graphics) {
        this.aboutScreen.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.aboutScreen.isVisible()) {
            this.paintBackground(graphics);
            this.paintTitlebar(graphics);
            this.paintCells(graphics);
            this.paintStatusBar(graphics);
            this.paintConfirmMessage(graphics);
            this.paintMenuBar(graphics);
        } else {
            this.paintAboutScreen(graphics);
        }
    }

    private synchronized void repaintProgressBar() {
        Graphics graphics = this.getGraphics();
        this.paintStatusBar(graphics);
        this.paintConfirmMessage(graphics);
        this.paintMenuBar(graphics);
        this.flushGraphics(0, this.height - this.menuBar.height - this.statusBarHeight, this.width, this.statusBarHeight);
    }

    public synchronized void repaintCanvas() {
        this.paint(this.getGraphics());
        this.flushGraphics();
    }

    private void calculatePosOfCells() {
        short s = 1;
        int n = 2;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].x = (short)(this.cellsRect.x + n + i % 9 / 3 * (3 * (Cell.getSize() + s) + (n - s)) + i % 9 % 3 * (Cell.getSize() + s));
            this.cells[i].y = (short)(this.cellsRect.y + n + i / 9 / 3 * (3 * (Cell.getSize() + s) + (n - s)) + i / 9 % 3 * (Cell.getSize() + s));
        }
    }

    protected void sizeChanged(int n, int n2) {
        super.sizeChanged(n, n2);
        this.width = n;
        this.height = n2;
        this.statusBarHeight = messageFont.getHeight() + 2 * this.statusBarVerticalInset;
        this.menuBar.height = (int)(this.menuBar.heightFactor * (float)n2);
        int n3 = titleBarFont.getHeight();
        int n4 = n - 1 - 1;
        int n5 = n2 - 1 - n3 - 1 - this.statusBarHeight - this.menuBar.height;
        this.clientRect = new Rectangle(1, 1 + n3, n4, n5);
        int n6 = Math.min(n4, n5);
        Cell.setSize((short)((n6 - 6 - 8) / 9));
        int n7 = 9 * Cell.getSize() + 6 + 8;
        this.cellsRect = new Rectangle(this.clientRect.x + (this.clientRect.width - n7) / 2, this.clientRect.y + this.clientRect.height - n7, n7, n7);
        int n8 = this.width;
        int n9 = 1 + (this.width - 1 - 1 - n8) / 2;
        int n10 = 6;
        int n11 = this.cellsRect.y - 5 - n10;
        this.titleBarRect = new Rectangle(n9, n10, n8, n11);
        this.calculatePosOfCells();
    }

    private void selectCell(byte by) {
        this.selectedCellIndex = by;
    }

    private Cell[] getLocationCells(Location location) {
        Cell[] cellArray = null;
        if (1 == location.type) {
            cellArray = this.getRowCells(location.index);
        } else if (2 == location.type) {
            cellArray = this.getColumnCells(location.index);
        } else if (3 == location.type) {
            cellArray = this.get3x3SquareCells(location.index);
        }
        return cellArray;
    }

    private byte[] getLocationValues(Location location) {
        Cell[] cellArray = this.getLocationCells(location);
        byte[] byArray = new byte[cellArray.length];
        for (int n = 0; n < byArray.length; n = (int)((byte)(n + 1))) {
            byArray[n] = cellArray[n].value;
        }
        return byArray;
    }

    private Cell[] get3x3SquareCells(byte by) {
        if (by >= 0 && by < 9) {
            byte by2 = (byte)(by / 3 * 3);
            byte by3 = (byte)(by % 3 * 3);
            int n = 0;
            for (byte by4 = by2; by4 < by2 + 3; by4 = (byte)(by4 + 1)) {
                for (byte by5 = by3; by5 < by3 + 3; by5 = (byte)(by5 + 1)) {
                    int n2 = n;
                    n = (byte)(n + 1);
                    this.squareCellsArray[n2] = this.getCell(by4, by5);
                }
            }
            return this.squareCellsArray;
        }
        return null;
    }

    public byte[] get3x3SquareValues(byte by) {
        Cell[] cellArray = this.get3x3SquareCells(by);
        for (int n = 0; n < this.squareValuesArray.length; n = (int)((byte)(n + 1))) {
            this.squareValuesArray[n] = cellArray[n].value;
        }
        return this.squareValuesArray;
    }

    public void set3x3SquareValues(byte by, byte[] byArray) {
        Cell[] cellArray = this.get3x3SquareCells(by);
        for (int n = 0; n < cellArray.length; n = (int)((byte)(n + 1))) {
            cellArray[n].value = byArray[n];
        }
    }

    private Cell[] getRowCells(byte by) {
        if (by >= 0 && by < 9) {
            for (byte by2 = 0; by2 < 9; by2 = (byte)(by2 + 1)) {
                this.rowCellsArray[by2] = this.getCell(by, by2);
            }
            return this.rowCellsArray;
        }
        return null;
    }

    public byte[] getRowValues(byte by) {
        Cell[] cellArray = this.getRowCells(by);
        for (int n = 0; n < this.rowValuesArray.length; n = (int)((byte)(n + 1))) {
            this.rowValuesArray[n] = cellArray[n].value;
        }
        return this.rowValuesArray;
    }

    public void setRowValues(byte by, byte[] byArray) {
        Cell[] cellArray = this.getRowCells(by);
        for (int n = 0; n < cellArray.length; n = (int)((byte)(n + 1))) {
            cellArray[n].value = byArray[n];
        }
    }

    private Cell[] getColumnCells(byte by) {
        if (by >= 0 && by < 9) {
            for (byte by2 = 0; by2 < 9; by2 = (byte)(by2 + 1)) {
                this.columnCellsArray[by2] = this.getCell(by2, by);
            }
            return this.columnCellsArray;
        }
        return null;
    }

    public byte[] getColumnValues(byte by) {
        Cell[] cellArray = this.getColumnCells(by);
        for (int n = 0; n < this.columnValuesArray.length; n = (int)((byte)(n + 1))) {
            this.columnValuesArray[n] = cellArray[n].value;
        }
        return this.columnValuesArray;
    }

    public void setColumnValues(byte by, byte[] byArray) {
        Cell[] cellArray = this.getColumnCells(by);
        for (int n = 0; n < cellArray.length; n = (int)((byte)(n + 1))) {
            cellArray[n].value = byArray[n];
        }
    }

    public boolean isCompleted() {
        for (int n = 0; n < this.cells.length; n = (int)((byte)(n + 1))) {
            if (this.cells[n].value != 0) continue;
            return false;
        }
        return true;
    }

    private void setMessage(String string) {
        this.statusBarMessageText = string;
    }

    private void indicateInvalidValue(byte by, byte by2, byte by3) {
        this.highLightErrorReason(by, by2, by3);
        this.setMessage("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u044f!");
    }

    public boolean setCellValue(byte by, byte by2, byte by3, boolean bl) {
        if (this.isAValidNumber(by, by2, by3)) {
            this.getCell((byte)by, (byte)by2).currentForegroundColor = bl ? 3416921 : 0xC63333;
            this.getCell((byte)by, (byte)by2).value = by3;
            return true;
        }
        this.indicateInvalidValue(by, by2, by3);
        return false;
    }

    private byte getIndexOfElement(byte by, byte by2, byte by3) {
        byte by4 = 0;
        for (byte by5 = 0; by5 < 9; by5 = (byte)(by5 + 1)) {
            switch (by) {
                case 1: {
                    by4 = this.getCell((byte)by2, (byte)by5).value;
                    break;
                }
                case 2: {
                    by4 = this.getCell((byte)by5, (byte)by2).value;
                    break;
                }
                case 3: {
                    byte by6 = (byte)(by2 / 3 * 3);
                    byte by7 = (byte)(by2 % 3 * 3);
                    byte by8 = (byte)(by6 + by5 / 3);
                    byte by9 = (byte)(by7 + by5 % 3);
                    by4 = this.getCell((byte)by8, (byte)by9).value;
                }
            }
            if (by4 != by3) continue;
            return by5;
        }
        return -1;
    }

    public boolean isAValidNumber(byte by, byte by2, byte by3) {
        if (by3 == 0) {
            return true;
        }
        byte by4 = this.get3x3SquareIndex(by, by2);
        return this.getCell((byte)by, (byte)by2).value == by3 || this.getIndexOfElement((byte)1, by, by3) < 0 && this.getIndexOfElement((byte)2, by2, by3) < 0 && this.getIndexOfElement((byte)3, by4, by3) < 0;
    }

    public boolean setSelectedCellValue(byte by) {
        if (this.selectedCellIndex >= 0) {
            Cell cell = this.cells[this.selectedCellIndex];
            CellIndexes cellIndexes = this.getCellIndexes(cell);
            boolean bl = this.setCellValue(cellIndexes.rowIndex, cellIndexes.columnIndex, by, true);
            if (bl) {
                this.caculatePossibleValues(this.selectedCellIndex);
                if (by > 0) {
                    cell.type = 1;
                    cell.currentForegroundColor = 3416921;
                } else {
                    cell.type = 0;
                }
            }
            return bl;
        }
        return true;
    }

    private void exit() {
        try {
            this.parentMidlet.destroyApp(true);
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            mIDletStateChangeException.printStackTrace();
        }
    }

    private void leftKeyPressed() {
        this.isKeyDown[0] = true;
        if (this.viewMode == 1) {
            this.currentResultViewIndex = (this.currentResultViewIndex - 1 + this.solutionCounter) % this.solutionCounter;
            this.showCurrentResult();
            this.startViewingResults();
        } else if (this.viewMode == 0) {
            byte by = (byte)((this.selectedCellIndex - 1 + 81) % 81);
            this.selectCell(by);
            if (!this.isCompleted()) {
                this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
            }
        }
    }

    private void rightKeyPressed() {
        this.isKeyDown[1] = true;
        if (this.viewMode == 1) {
            this.currentResultViewIndex = (this.currentResultViewIndex + 1) % this.solutionCounter;
            this.showCurrentResult();
            this.startViewingResults();
        } else if (this.viewMode == 0) {
            byte by = (byte)((this.selectedCellIndex + 1 + 81) % 81);
            this.selectCell(by);
            if (!this.isCompleted()) {
                this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
            }
        }
    }

    private void upKeyPressed() {
        this.isKeyDown[2] = true;
        if (this.viewMode == 1) {
            this.currentResultViewIndex = (this.currentResultViewIndex + 10) % this.solutionCounter;
            this.showCurrentResult();
            this.startViewingResults();
        } else if (this.viewMode == 0) {
            byte by;
            if (this.selectedCellIndex == 0) {
                by = 80;
            } else {
                by = (byte)(this.selectedCellIndex - 9);
                if (by < 0) {
                    by = (byte)(by + 80);
                }
            }
            this.selectCell(by);
            if (!this.isCompleted()) {
                this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
            }
        } else if (this.viewMode == 2) {
            Menu menu = this.menuBar.getOpenMenu();
            menu.IncreaseCurrentMenuItemIndex();
            this.repaintCanvas();
        }
    }

    private void downKeyPressed() {
        this.isKeyDown[3] = true;
        if (this.viewMode == 1) {
            this.currentResultViewIndex = (this.currentResultViewIndex - 10 + this.solutionCounter) % this.solutionCounter;
            if (this.currentResultViewIndex < 0) {
                this.currentResultViewIndex = (this.currentResultViewIndex + this.solutionCounter) % this.solutionCounter;
            }
            this.showCurrentResult();
            this.startViewingResults();
        } else if (this.viewMode == 0) {
            byte by;
            if (this.selectedCellIndex == 80) {
                by = 0;
            } else {
                by = (byte)(this.selectedCellIndex + 9);
                if (by > 80) {
                    by = (byte)(by - 80);
                }
            }
            this.selectCell(by);
            if (!this.isCompleted()) {
                this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
            }
        } else if (this.viewMode == 2) {
            Menu menu = this.menuBar.getOpenMenu();
            menu.DecreaseCurrentMenuItemIndex();
            this.repaintCanvas();
        }
    }

    private void showPossibleValues() {
        if (this.selectedCellIndex >= 0) {
            Cell cell = this.cells[this.selectedCellIndex];
            String string = new String();
            Vector vector = cell.getPossibleValues();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                string = string + String.valueOf(vector.elementAt(i));
                if (i >= n - 1) continue;
                string = string + ", ";
            }
            this.setMessage(string);
        }
    }

    private void toggleSolvingProgressDetailsShowingStatus() {
        this.showSolvingProgressDetails = !this.showSolvingProgressDetails;
        this.repaintCanvas();
    }

    protected void keyPressed(int n) {
        if (this.aboutScreen.isVisible()) {
            if (n == -6 || n == -7) {
                this.hideAboutScreen();
                this.repaintCanvas();
            }
            return;
        }
        if (!this.errorReasonHighlighted && this.inputEnabled) {
            this.resetCellBackgroundColors();
            if (this.viewMode == 0) {
                this.setMessage(null);
            }
        }
        if (this.getGameAction(n) == 2 && n != 52) {
            this.leftKeyPressed();
        } else if (this.getGameAction(n) == 5 && n != 54) {
            this.rightKeyPressed();
        } else if (this.getGameAction(n) == 1 && n != 50) {
            this.upKeyPressed();
        } else if (this.getGameAction(n) == 6 && n != 56) {
            this.downKeyPressed();
        } else if (n == 35) {
            this.toggleSolvingProgressDetailsShowingStatus();
        } else if (n >= 49 && n <= 57) {
            if (this.inputEnabled && this.viewMode == 0 && this.setSelectedCellValue((byte)(n - 48))) {
                if (this.isCompleted()) {
                    this.rightMenu.text = "\u041d\u0430\u0437\u0430\u0434";
                    this.solveMenuItem.text = "\u041d\u0430\u0437\u0430\u0434";
                    this.setMessage("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0440\u0435\u0448\u0435\u043d\u0430.");
                } else {
                    this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
                    this.solveMenuItem.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
                }
            }
        } else if (n == 48 || n == -8) {
            if (this.inputEnabled && this.viewMode == 0) {
                this.setSelectedCellValue((byte)0);
                this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
                this.solveMenuItem.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
                this.setMessage(null);
            }
        } else if (n == -6) {
            this.softKey1Pressed();
        } else if (n == -7) {
            this.softKey2Pressed();
        } else if (n == -5) {
            if (this.leftMenu.isOpened) {
                this.softKey1Pressed();
            } else if (this.rightMenu.isOpened) {
                this.softKey2Pressed();
            }
        }
        if (this.errorReasonHighlighted) {
            this.errorReasonHighlighted = false;
        }
        if (this.inputEnabled) {
            this.repaintCanvas();
        }
    }

    protected void keyReleased(int n) {
        if (this.getGameAction(n) == 2 && n != 52) {
            this.isKeyDown[0] = false;
        } else if (this.getGameAction(n) == 5 && n != 54) {
            this.isKeyDown[1] = false;
        } else if (this.getGameAction(n) == 1 && n != 50) {
            this.isKeyDown[2] = false;
        } else if (this.getGameAction(n) == 6 && n != 56) {
            this.isKeyDown[3] = false;
        }
    }

    private void getCellsValuesCopy() {
        for (int n = 0; n < this.cells.length; n = (int)((byte)(n + 1))) {
            this.cellsValuesCopy[n] = this.cells[n].value;
        }
    }

    private int getLocationValidPositionsNo(Location location, byte by) {
        int n = 0;
        byte[] byArray = this.getLocationValues(location);
        CellIndexes cellIndexes = new CellIndexes();
        for (byte by2 = 0; by2 < byArray.length; by2 = (byte)(by2 + 1)) {
            this.getCellIndexes(location, by2, cellIndexes);
            if (this.getCell((byte)cellIndexes.rowIndex, (byte)cellIndexes.columnIndex).value != 0 || !this.isAValidNumber(cellIndexes.rowIndex, cellIndexes.columnIndex, by)) continue;
            n = (byte)(n + 1);
        }
        return n;
    }

    private boolean getNextLocation(Location location, Location location2) {
        if (location.index < 8) {
            location2.type = location.type;
            location2.index = (byte)(location.index + 1);
        } else if (1 == location.type) {
            location2.type = (byte)2;
            location2.index = 0;
        } else if (2 == location.type) {
            location2.type = (byte)3;
            location2.index = 0;
        } else if (3 == location.type) {
            return false;
        }
        return true;
    }

    private boolean areValuesEqual(byte[] byArray, Cell[] cellArray) {
        for (int n = 0; n < 81; n = (int)((byte)(n + 1))) {
            if (byArray[n] == cellArray[n].value) continue;
            return false;
        }
        return true;
    }

    private boolean solveDeterminableCells() {
        Location location = new Location();
        CellIndexes cellIndexes = new CellIndexes();
        while (!this.isCompleted()) {
            location.type = 1;
            location.index = 0;
            this.getCellsValuesCopy();
            Cell cell = null;
            do {
                for (byte by = 0; by < 9; by = (byte)(by + 1)) {
                    this.getCellIndexes(location, by, cellIndexes);
                    for (byte by2 = 1; by2 <= 9; by2 = (byte)((byte)(by2 + 1))) {
                        cell = this.getCell(cellIndexes.rowIndex, cellIndexes.columnIndex);
                        if (cell.value != 0 || !this.isAValidNumber(cellIndexes.rowIndex, cellIndexes.columnIndex, by2) || 1 != this.getLocationValidPositionsNo(location, by2) || !this.setCellValue(cellIndexes.rowIndex, cellIndexes.columnIndex, by2, false)) continue;
                        this.caculatePossibleValues(cell.index);
                        this.storeDeterminedValue(cell.index);
                    }
                }
            } while (this.getNextLocation(location, location));
            if (!this.areValuesEqual(this.cellsValuesCopy, this.cells)) continue;
            return false;
        }
        return true;
    }

    private void caculatePossibleValues(byte by) {
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        if (by != -1) {
            by2 = this.getCellRowIndex(by);
            by3 = this.getCellColumnIndex(by);
            by4 = this.get3x3SquareIndex(by2, by3);
        }
        for (byte by8 = 0; by8 < this.cells.length; by8 = (byte)(by8 + 1)) {
            if (by != -1) {
                by5 = this.getCellRowIndex(by8);
                by6 = this.getCellColumnIndex(by8);
                by7 = this.get3x3SquareIndex(by5, by6);
            }
            if (by != -1 && (by == -1 || by2 != by5 && by3 != by6 && by4 != by7)) continue;
            this.cells[by8].calculatePossibleValues();
        }
    }

    private Cell[] getEmptyCells() {
        Vector<Cell> vector = new Vector<Cell>();
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i].value != 0) continue;
            vector.addElement(this.cells[i]);
        }
        this.emptyCells = new Cell[vector.size()];
        vector.copyInto(this.emptyCells);
        return this.emptyCells;
    }

    private byte[] getCellsValues(Cell[] cellArray) {
        byte[] byArray = new byte[cellArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = cellArray[i].value;
        }
        return byArray;
    }

    private void setCellsValues(Cell[] cellArray, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            cellArray[i].setValue(byArray[i]);
        }
    }

    private double calculateNumOfStatuses(Cell[] cellArray, int n) {
        double d = 1.0;
        for (int i = n; i < cellArray.length; ++i) {
            d *= (double)cellArray[i].possibleValues.size();
        }
        return d;
    }

    private int check(Cell[] cellArray, int n) {
        if (this.solverThreadCanceled) {
            return this.solutionCounter;
        }
        Cell cell = cellArray[n];
        int n2 = cellArray.length;
        Vector vector = cell.getPossibleValues();
        int n3 = vector.size();
        CellIndexes cellIndexes = this.getCellIndexes(cell);
        cell.type = (byte)4;
        for (int i = 0; i < n3; ++i) {
            byte by = (Byte)vector.elementAt(i);
            if (this.isAValidNumber(cellIndexes.rowIndex, cellIndexes.columnIndex, by)) {
                byte[] byArray = this.getCellsValues(cellArray);
                cell.currentForegroundColor = 9653985;
                cell.setValue(by);
                if (n == n2 - 1) {
                    this.numOfStatusesChecked += 1.0;
                    this.solutionFound();
                    this.repaintCanvas();
                    this.lastSolutionShowTime = System.currentTimeMillis();
                } else {
                    this.check(cellArray, n + 1);
                }
                this.setCellsValues(cellArray, byArray);
            } else {
                this.numOfStatusesChecked += this.calculateNumOfStatuses(cellArray, n + 1);
            }
            this.progressValue = this.numOfStatusesChecked / this.numOfStatusesMustCheck;
            if (this.showSolvingProgressDetails && System.currentTimeMillis() - this.lastSolutionShowTime >= 200L) {
                this.repaintCanvas();
                this.lastSolutionShowTime = System.currentTimeMillis();
                continue;
            }
            if (!(this.progressValue - this.lastProgressValue >= 0.01)) continue;
            this.repaintProgressBar();
            this.lastProgressValue = this.progressValue;
        }
        return this.solutionCounter;
    }

    private int check(Cell[] cellArray) {
        this.numOfStatusesMustCheck = this.calculateNumOfStatuses(cellArray, 0);
        this.numOfStatusesChecked = 0.0;
        return this.check(cellArray, 0);
    }

    private short getCellInfoCode(byte by) {
        return (short)((by << 4) + this.cells[by].value);
    }

    private void storeSolvedValues() {
        if (this.emptyCells != null) {
            byte[] byArray = new byte[this.emptyCells.length];
            for (int n = 0; n < this.emptyCells.length; n = (int)((byte)(n + 1))) {
                byArray[n] = this.emptyCells[n].value;
                this.emptyCells[n].type = (byte)3;
            }
            this.solvedValuesCollections.addElement(byArray);
        }
    }

    private void storeDeterminedValue(byte by) {
        this.cells[by].type = (byte)2;
        short s = this.getCellInfoCode(by);
        this.determinedValues.addElement(new Short(s));
    }

    private void storeEnteredValues() {
        for (byte by = 0; by < this.cells.length; by = (byte)((byte)(by + 1))) {
            if (this.cells[by].value <= 0) continue;
            this.cells[by].type = 1;
            short s = this.getCellInfoCode(by);
            this.enteredValues.addElement(new Short(s));
        }
    }

    private void solutionFound() {
        ++this.solutionCounter;
        this.storeSolvedValues();
        this.setMessage("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435... [ " + this.solutionCounter + " " + "\u0440\u0435\u0448\u0435\u043d\u0438\u0435" + (this.solutionCounter > 1 ? "" : "") + " ]");
    }

    private boolean isSolvable() {
        for (int n = 0; n < this.cells.length; n = (int)((byte)(n + 1))) {
            if (!this.cells[n].possibleValues.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void indicateEnteredNumbers() {
        for (int n = 0; n < this.cells.length; n = (int)((byte)(n + 1))) {
            if (this.cells[n].value <= 0) continue;
            this.cells[n].currentForegroundColor = 3416921;
        }
    }

    public int solve() {
        this.solutionCounter = 0;
        this.emptyCells = null;
        this.indicateEnteredNumbers();
        if (!this.isSolvable()) {
            return 0;
        }
        this.enteredValues.removeAllElements();
        this.determinedValues.removeAllElements();
        this.solvedValuesCollections.removeAllElements();
        this.storeEnteredValues();
        this.caculatePossibleValues((byte)-1);
        if (this.solveDeterminableCells()) {
            this.solutionFound();
            this.repaintCanvas();
            return this.solutionCounter;
        }
        this.repaintCanvas();
        this.emptyCells = this.getEmptyCells();
        return this.check(this.emptyCells);
    }

    private void startSolving() {
        this.inputEnabled = false;
        this.solveMenuItem.text = "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c";
        this.rightMenu.text = "\u0417\u0430\u043a\u0440\u044b\u0442\u044c";
        this.setMessage("\u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435...");
        this.repaintCanvas();
        this.solverThreadCanceled = false;
        if (this.solverThread == null) {
            this.solverThread = new Thread(this);
            this.solverThread.start();
        }
    }

    public void endSolving() {
        if (this.solverThread != null) {
            this.solverThreadCanceled = true;
            try {
                this.solverThread.join();
                this.solverThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.solutionCounter == 0) {
            this.setMessage("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e [ \u041d\u0435\u0442 \u0440\u0435\u0448\u0435\u043d\u0438\u0439 ]");
            this.solveMenuItem.text = "\u041d\u043e\u0432\u044b\u0439";
        } else {
            this.enterViewMode();
        }
        this.inputEnabled = true;
    }

    public void startViewingResults() {
        if (this.resultViewerThread == null) {
            this.resultViewerThread = new Thread(this);
            this.resultViewerThread.start();
        }
    }

    private void solveAndShowSolutions() {
        this.solve();
        if (this.emptyCells != null) {
            for (int i = 0; i < this.emptyCells.length; ++i) {
                this.emptyCells[i].type = (byte)3;
            }
        }
        this.enterViewMode();
        this.solverThread = null;
        this.inputEnabled = true;
        this.repaintCanvas();
    }

    private void viewResultsFastly() {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 1000L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.isKeyDown[0] || this.isKeyDown[1] || this.isKeyDown[2] || this.isKeyDown[3]) continue;
            this.resultViewerThread = null;
            return;
        }
        while (true) {
            if (this.isKeyDown[0]) {
                this.currentResultViewIndex = (this.currentResultViewIndex - 1 + this.solutionCounter) % this.solutionCounter;
            } else if (this.isKeyDown[1]) {
                this.currentResultViewIndex = (this.currentResultViewIndex + 1) % this.solutionCounter;
            } else if (this.isKeyDown[2]) {
                this.currentResultViewIndex = (this.currentResultViewIndex + 10) % this.solutionCounter;
            } else {
                if (!this.isKeyDown[3]) break;
                this.currentResultViewIndex = (this.currentResultViewIndex - 10 + this.solutionCounter) % this.solutionCounter;
            }
            this.showCurrentResult();
            this.repaintCanvas();
        }
        this.resultViewerThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        if (thread == this.solverThread) {
            this.solveAndShowSolutions();
        } else if (thread == this.resultViewerThread) {
            this.viewResultsFastly();
        }
    }

    private void reset() {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].initialize();
        }
        this.setMessage(null);
        if (this.alert.visible) {
            this.leftMenu.lastText = "\u041c\u0435\u043d\u044e";
            this.rightMenu.lastText = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
        } else {
            this.leftMenu.text = "\u041c\u0435\u043d\u044e";
            this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
        }
        this.solveMenuItem.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
        this.selectedCellIndex = 0;
        this.progressValue = 0.0;
        this.viewMode = 0;
    }

    private void restoreEnteredValues() {
        int n = this.enteredValues.size();
        for (int i = 0; i < n; ++i) {
            byte by;
            short s = (Short)this.enteredValues.elementAt(i);
            byte by2 = (byte)(s >> 4);
            this.cells[by2].value = by = (byte)(s & 0xF);
            this.cells[by2].currentForegroundColor = 3416921;
        }
    }

    private void restoreDeterminedValues() {
        int n = this.determinedValues.size();
        for (int i = 0; i < n; ++i) {
            byte by;
            short s = (Short)this.determinedValues.elementAt(i);
            byte by2 = (byte)(s >> 4);
            this.cells[by2].value = by = (byte)(s & 0xF);
            this.cells[by2].currentForegroundColor = 0xC63333;
        }
    }

    private void restoreCurrentSolvedValues() {
        if (this.solvedValuesCollections.size() > 0) {
            byte[] byArray = (byte[])this.solvedValuesCollections.elementAt(this.currentResultViewIndex);
            for (int i = 0; i < byArray.length; ++i) {
                this.emptyCells[i].value = byArray[i];
                this.emptyCells[i].currentForegroundColor = 9653985;
            }
        }
    }

    private void showCurrentResult() {
        this.restoreCurrentSolvedValues();
        if (this.solutionCounter == 1) {
            this.setMessage("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0440\u0435\u0448\u0435\u043d\u0430.");
        } else {
            String string = this.solverThreadCanceled ? "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e" : "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e";
            this.setMessage(string + " [ " + (this.currentResultViewIndex + 1) + " " + "\u0438\u0437" + " " + this.solutionCounter + " ]");
        }
    }

    private void enterViewMode() {
        if (this.solutionCounter == 0) {
            if (this.alert.visible) {
                this.rightMenu.lastText = "\u041d\u043e\u0432\u044b\u0439";
            } else {
                this.rightMenu.text = "\u041d\u043e\u0432\u044b\u0439";
            }
            this.setMessage("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0448\u0435\u043d\u0438\u0435.");
            this.solveMenuItem.text = "\u041d\u043e\u0432\u044b\u0439";
        } else {
            this.viewMode = 1;
            this.restoreEnteredValues();
            this.restoreDeterminedValues();
            this.showCurrentResult();
            if (this.alert.visible) {
                this.rightMenu.lastText = "\u041d\u0430\u0437\u0430\u0434";
            } else {
                this.rightMenu.text = "\u041d\u0430\u0437\u0430\u0434";
            }
            this.solveMenuItem.text = "\u041d\u0430\u0437\u0430\u0434";
        }
        if (!this.solverThreadCanceled) {
            this.progressValue = 0.0;
        }
    }

    private void showAboutScreen() {
        this.storeViewMode();
        this.viewMode = 3;
        this.aboutScreen.setVisible(true);
    }

    private void hideAboutScreen() {
        this.restoreViewMode();
        this.aboutScreen.setVisible(false);
    }

    private void enterNormalMode() {
        this.viewMode = 0;
        this.currentResultViewIndex = 0;
        this.progressValue = 0.0;
        this.setMessage(null);
        if (this.isCompleted()) {
            this.rightMenu.text = "\u041d\u043e\u0432\u044b\u0439";
            this.solveMenuItem.text = "\u041d\u043e\u0432\u044b\u0439";
        } else {
            this.rightMenu.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
            this.solveMenuItem.text = "\u0421\u0447\u0438\u0442\u0430\u0442\u044c";
        }
    }

    private void softKey1Pressed() {
        this.leftMenu.performAction();
    }

    private void softKey2Pressed() {
        this.rightMenu.performAction();
    }
}

