/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sudokusolver.MainCanvas;
import sudokusolver.Rectangle;
import sudokusolver.control.Control;
import sudokusolver.util.Util;

public class AboutScreen
implements Control,
Runnable {
    private boolean visible = false;
    public MainCanvas ownerCanvas = null;
    public int backgroundColor;
    public int gradientColor = this.backgroundColor = -13360295;
    public final int descriptionColor;
    int gradientWidth;
    int gradientHeight;
    private Rectangle descriptionRect = null;
    private final String description;
    public final Font descriptionTitleFont = Font.getFont((int)64, (int)1, (int)8);
    public final Font descriptionFont = Font.getFont((int)64, (int)0, (int)8);
    public final float widthGradientFactor;
    public final float heightGradientFactor;
    private int descriptionTextVPos;
    private Thread animationThread = null;
    private boolean isAnimating = false;
    private int textHeight;
    private Vector textLines = null;

    public AboutScreen(MainCanvas mainCanvas) {
        this.descriptionColor = 0xFFFFFF;
        this.description = "Mobile Sudoku Solver \u044d\u0442\u043e Java (J2ME) \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f, \u043f\u0440\u043e\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0438\u0433\u0440\u044b \u0432 Sudoku. \u041c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0432\u0441\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0445 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438. \u041f\u043e\u0442\u043e\u043c  \u0438\u0445 \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c, \u0438 \u0441\u043d\u043e\u0432\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c.\n\u041f\u0435\u0440\u0435\u0432\u043e\u0434: [M.A.X]\n\u0421\u0430\u0439\u0442: www.java-max.wup.ru";
        this.widthGradientFactor = 0.1f;
        this.heightGradientFactor = 0.3f;
        this.ownerCanvas = mainCanvas;
        int n = mainCanvas.getWidth();
        int n2 = mainCanvas.getHeight();
        this.gradientWidth = (int)((float)n * 0.1f);
        this.gradientHeight = (int)((float)n2 * 0.3f);
        this.descriptionRect = new Rectangle(this.gradientWidth, this.gradientHeight, n - 2 * this.gradientWidth, n2 - 2 * this.gradientHeight);
        this.descriptionTextVPos = this.descriptionRect.y;
        this.textHeight = this.descriptionFont.getHeight();
        this.textLines = this.getWrappedTextLineStrings("Mobile Sudoku Solver \u044d\u0442\u043e Java (J2ME) \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f, \u043f\u0440\u043e\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0438\u0433\u0440\u044b \u0432 Sudoku. \u041c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0432\u0441\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0445 \u0432 \u043f\u0430\u043c\u044f\u0442\u0438. \u041f\u043e\u0442\u043e\u043c  \u0438\u0445 \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c, \u0438 \u0441\u043d\u043e\u0432\u0430 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438 \u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c.\n\u041f\u0435\u0440\u0435\u0432\u043e\u0434: [M.A.X]\n\u0421\u0430\u0439\u0442: www.java-max.wup.ru", this.descriptionRect.width);
    }

    private void paintBackground(Graphics graphics) {
        int n = this.ownerCanvas.getWidth();
        int n2 = this.ownerCanvas.getHeight();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, n, n2);
    }

    private void paintDescription(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.descriptionTitleFont);
        graphics.drawString("Mobile Sudoku Solver 1.6", this.descriptionRect.x, this.descriptionTextVPos, 20);
        graphics.setFont(this.descriptionFont);
        for (int i = 0; i < this.textLines.size(); ++i) {
            graphics.drawString((String)this.textLines.elementAt(i), this.descriptionRect.x, this.descriptionTextVPos + this.descriptionTitleFont.getHeight() + this.descriptionFont.getHeight() + i * this.textHeight, 20);
        }
    }

    private void paintGradients(Graphics graphics) {
        int n = this.ownerCanvas.getWidth();
        int n2 = this.ownerCanvas.getHeight();
        Util.fillRect(graphics, 0, 0, n, this.gradientHeight, this.gradientColor, 4);
        Util.fillRect(graphics, 0, n2 - this.gradientHeight, n, this.gradientHeight, this.gradientColor, 8);
    }

    public void paint(Graphics graphics) {
        if (this.visible) {
            this.paintBackground(graphics);
            this.paintDescription(graphics);
            this.paintGradients(graphics);
        }
    }

    private Vector getWrappedTextLineStrings(String string, int n) {
        Vector<String> vector = new Vector<String>();
        String string2 = string;
        int n2 = 0;
        int n3 = 0;
        while (n2 >= 0) {
            n2 = this.calculateMaxTextIndexForWidth(string2, n);
            if (n2 < 0) {
                vector.addElement(string2);
            } else {
                vector.addElement(string2.substring(0, n2));
                string2 = string2.substring(n2).trim();
            }
            ++n3;
        }
        return vector;
    }

    private int calculateMaxTextIndexForWidth(String string, int n) {
        int n2;
        int n3 = n2 = string.indexOf(32, 0);
        if (n2 >= 0) {
            String string2 = string.substring(0, n2);
            int n4 = this.descriptionFont.stringWidth(string2);
            while (n4 < n) {
                n3 = n2;
                if ((n2 = string.indexOf(32, n3 + 1)) < 0) {
                    n3 = -1;
                    break;
                }
                string2 = string.substring(0, n2);
                n4 = this.descriptionFont.stringWidth(string2);
            }
        }
        return n3;
    }

    public void run() {
        if (Thread.currentThread() == this.animationThread) {
            this.isAnimating = true;
            int n = this.descriptionTitleFont.getHeight() + this.descriptionFont.getHeight() + this.textLines.size() * this.textHeight;
            int n2 = this.ownerCanvas.getHeight();
            while (this.isAnimating) {
                --this.descriptionTextVPos;
                if (this.descriptionTextVPos + n == 0) {
                    this.descriptionTextVPos = n2;
                }
                this.ownerCanvas.repaintCanvas();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (bl) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        } else {
            this.isAnimating = false;
            try {
                this.animationThread.join();
                this.descriptionTextVPos = this.descriptionRect.y;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

