/*
 * Decompiled with CFR 0.152.
 */
package sudokusolver.control.menu;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import sudokusolver.MainCanvas;
import sudokusolver.control.Control;
import sudokusolver.control.menu.AbstractMenu;
import sudokusolver.control.menu.MenuBar;
import sudokusolver.control.menu.MenuItem;
import sudokusolver.util.Util;

public class Menu
extends AbstractMenu
implements Control {
    public static final Font font = Font.getFont((int)64, (int)1, (int)0);
    public static final int LEFT_INSET = 1;
    public static final int RIGHT_INSET = 1;
    public static final int TOP_INSET = 1;
    public static final int BOTTOM_INSET = 1;
    public static final int LEFT_TEXT_INSET = 1;
    public static final int RIGHT_TEXT_INSET = 1;
    public static final int TOP_TEXT_INSET = 1;
    public static final int BOTTOM_TEXT_INSET = 1;
    public static final int MENU_POSITION_LEFT = 1;
    public static final int MENU_POSITION_RIGHT = 2;
    public static final int MENU_ITEMS_TOP_INSET = 4;
    public static final int MENU_ITEMS_BOTTOM_INSET = 4;
    public int menuItemsBackgroundColor = -1147835393;
    public int foregroundColor = 8998625;
    MenuBar ownerMenuBar = null;
    public int position;
    public String text = null;
    public String lastText = null;
    private Vector items = null;
    public boolean isOpened = false;
    public int currentItemIndex;

    public Menu(int n, String string, int n2) {
        this.position = n;
        this.text = string;
        this.foregroundColor = n2;
        this.items = new Vector();
    }

    public int getTextWidth() {
        return font.stringWidth(this.text) + 1 + 1;
    }

    public int getTextHeight() {
        return font.getHeight() + 1 + 1;
    }

    public int getItemsWidth() {
        int n = this.items.size();
        MenuItem menuItem = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            menuItem = (MenuItem)this.items.elementAt(i);
            int n3 = menuItem.getTextWidth();
            if (i == 0) {
                n2 = n3;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        int n4 = Math.max(n2, this.getTextWidth());
        return n4;
    }

    public int getItemsHeight() {
        int n = this.items.size();
        MenuItem menuItem = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            menuItem = (MenuItem)this.items.elementAt(i);
            n2 += menuItem.getTextHeight();
        }
        int n3 = n2 + 4 + 4;
        return n3;
    }

    public int getWidth() {
        return this.getItemsWidth();
    }

    public int getHeight() {
        return this.getItemsHeight();
    }

    public void paintItems(Graphics graphics) {
        if (!this.items.isEmpty() && this.isOpened) {
            int n = this.getHeight();
            int n2 = this.getWidth();
            int n3 = 0;
            int n4 = this.ownerMenuBar.ownerCanvas.getHeight() - this.ownerMenuBar.height - n;
            if (this.position == 1) {
                n3 = 0;
            } else if (this.position == 2) {
                n3 = this.ownerMenuBar.ownerCanvas.getWidth() - n2;
            }
            Util.fillRect(graphics, n3 + 2, n4 + 2, n2, n, 1714692953, 0);
            Util.fillRect(graphics, n3, n4, n2, n, this.menuItemsBackgroundColor, 0);
            graphics.setColor(this.ownerMenuBar.backgroundColor);
            graphics.drawRect(n3, n4, n2, n);
            MenuItem menuItem = null;
            int n5 = this.items.size();
            for (int i = 0; i < n5; ++i) {
                menuItem = (MenuItem)this.items.elementAt(i);
                menuItem.paint(graphics);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.position == 1) {
            graphics.setColor(this.isOpened ? this.menuItemsBackgroundColor : this.foregroundColor);
            graphics.setFont(font);
            graphics.drawString(this.text, 2, this.ownerMenuBar.ownerCanvas.getHeight() - 1 - 1, 36);
        } else if (this.position == 2) {
            graphics.setColor(this.isOpened ? this.menuItemsBackgroundColor : this.foregroundColor);
            graphics.setFont(font);
            graphics.drawString(this.text, this.ownerMenuBar.ownerCanvas.getWidth() - 1 - 1, this.ownerMenuBar.ownerCanvas.getHeight() - 1 - 1, 40);
        }
    }

    private void updateIndexOfMenuItems() {
        int n = this.items.size();
        MenuItem menuItem = null;
        int n2 = 0;
        while (n2 < n) {
            menuItem = (MenuItem)this.items.elementAt(n2);
            menuItem.index = n2++;
        }
    }

    public void insertMenuItem(MenuItem menuItem, int n) {
        menuItem.ownerMenu = this;
        this.items.insertElementAt(menuItem, n);
        this.updateIndexOfMenuItems();
    }

    public void addMenuItem(MenuItem menuItem) {
        this.insertMenuItem(menuItem, this.items.size());
    }

    public void removeMenuItem(MenuItem menuItem) {
        this.items.removeElement(menuItem);
        this.updateIndexOfMenuItems();
    }

    public MenuItem menuItemAt(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public void storeText() {
        this.lastText = this.text;
    }

    public void restoreText() {
        this.text = this.lastText;
    }

    public void openMenu() {
        this.ownerMenuBar.ownerCanvas.storeViewMode();
        MainCanvas cfr_ignored_0 = this.ownerMenuBar.ownerCanvas;
        this.ownerMenuBar.ownerCanvas.viewMode = 2;
        this.storeText();
        this.text = "\u0412\u044b\u0431\u043e\u0440";
        this.getOtherMenu().storeText();
        this.getOtherMenu().text = "\u0417\u0430\u043a\u0440\u044b\u0442\u044c";
        this.currentItemIndex = this.items.size() - 1;
        this.isOpened = true;
    }

    public void closeMenu() {
        this.restoreText();
        this.getOtherMenu().restoreText();
        this.ownerMenuBar.ownerCanvas.restoreViewMode();
        this.isOpened = false;
    }

    public Menu getOtherMenu() {
        return this == this.ownerMenuBar.leftMenu ? this.ownerMenuBar.rightMenu : this.ownerMenuBar.leftMenu;
    }

    public boolean toggleMenuStatus() {
        if (this.isOpened) {
            this.closeMenu();
        } else {
            this.openMenu();
        }
        return this.isOpened;
    }

    public int getNumberOfItems() {
        return this.items.size();
    }

    public void IncreaseCurrentMenuItemIndex() {
        int n = this.getNumberOfItems();
        this.currentItemIndex = (this.currentItemIndex + 1) % n;
    }

    public void DecreaseCurrentMenuItemIndex() {
        int n = this.getNumberOfItems();
        this.currentItemIndex = (this.currentItemIndex - 1 + n) % n;
    }

    public MenuItem getCurrentItem() {
        return (MenuItem)this.items.elementAt(this.currentItemIndex);
    }
}

