/*
 * Decompiled with CFR 0.152.
 */
package mquest.gui;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import mquest.Midlet;
import mquest.gui.gutil.Colors;
import mquest.gui.gutil.GamesCanvas;
import mquest.gui.gutil.KeysCodes;
import mquest.io.File;
import mquest.util.Parser;

public class QuestPlayer
extends GamesCanvas
implements Colors,
Runnable,
CommandListener,
KeysCodes {
    public static final int STATE_TEXT = 1;
    public static final int STATE_INVERTORY = 2;
    public static final int STATE_MENU = 3;
    public static final int STATE_IMAGE = 4;
    public static final int STATE_MESSAGE = 5;
    public static final int STATE_ACTIONS = 6;
    public static final int STATE_ITEMACTION = 7;
    public static int LEFT_SOFTKEY;
    public static int RIGHT_SOFTKEY;
    public static final char[] win1251ToUtf8;
    int state = 1;
    String path;
    Parser parser;
    boolean coding;
    InputStream inputStream;
    StreamConnection connection;
    Hashtable var;
    Hashtable label;
    Hashtable invertory;
    Displayable previous;
    Vector buttons;
    Vector buttonId;
    Vector strings;
    int textHeight;
    int lastWidth;
    int textWidth;
    int lineStart;
    int lineCount;
    int invertoryWidth;
    int invertoryHeight;
    int invertoryCount;
    int invertorySelect;
    int invertoryStart;
    Font textFont;
    Font actionFont;
    Font listFont;
    Timer timer;
    StringBuffer actions;
    int menuWidth;
    int menuHeight;
    int menuCount;
    int menuStart;
    int menuSelect;
    Vector menuStrings;
    Vector menuData;
    int actionsWidth;
    int actionsHeight;
    int actionsCount;
    int actionsStart;
    int actionsSelect;
    Random random;
    boolean finishReading;
    Hashtable itemUsages;
    int itemActionStart;
    int itemActionSelect;
    boolean stopped;
    TextBox inputTextBox;
    boolean inputCompleted;
    boolean commonState;
    boolean messagesFlag;
    String inputsBuff = new String();

    static {
        win1251ToUtf8 = new char[]{'\u0080', '\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};
    }

    public void showNotify() throws  {
    }

    public void painter(Graphics graphics) throws  {
        int n = 0xDEDEDE;
        if (this.state == 2) {
            this.textHeight = this.getHeight() * 20 / 100;
            this.lineCount = this.textHeight / this.textFont.getHeight();
            this.invertoryHeight = this.getHeight() - this.textHeight - this.actionFont.getHeight() - 15;
            this.invertoryCount = this.invertoryHeight / this.listFont.getHeight();
        } else {
            this.textHeight = this.getHeight() * 70 / 100;
            this.lineCount = this.textHeight / this.textFont.getHeight();
            this.invertoryHeight = this.getHeight() - this.textHeight - this.actionFont.getHeight() - 15;
            this.invertoryCount = this.invertoryHeight / this.listFont.getHeight();
        }
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        QuestPlayer.draw3DRects$(this, graphics, 3, 3, this.getWidth() - 6, this.textHeight + 4, n, this.state == 1 ? 2 : 1, false);
        graphics.setFont(this.textFont);
        QuestPlayer.drawStrings$(this, graphics, 5, 5, this.textWidth, this.textHeight, 0, this.strings, this.lineStart);
        QuestPlayer.drawScroll$(this, graphics, this.getWidth() - 9, 5, 4, this.textHeight, 0x909090, this.lineStart, this.lineCount, this.strings.size());
        QuestPlayer.draw3DRects$(this, graphics, 3, this.textHeight + 8, this.getWidth() - 6, this.getHeight() - this.textHeight - 11 - this.actionFont.getHeight(), n, this.state == 2 ? 2 : 1, false);
        QuestPlayer.drawInvertoryList$(this, graphics, 5, this.textHeight + 10, this.invertoryWidth, this.invertoryHeight, this.invertory, this.invertoryStart, this.invertorySelect);
        QuestPlayer.drawScroll$(this, graphics, this.getWidth() - 9, this.textHeight + 10, 4, this.invertoryHeight, 0x909090, this.invertoryStart, this.invertoryCount, this.invertory.size());
        graphics.setColor(QuestPlayer.multipleColor$(this, n, 102, false));
        graphics.drawLine(1, this.getHeight() - 2 - this.actionFont.getHeight(), this.getWidth() - 2, this.getHeight() - 2 - this.actionFont.getHeight());
        graphics.setFont(this.actionFont);
        graphics.drawString("\u041c\u0435\u043d\u044e", 1, this.getHeight() - 2, 36);
        graphics.drawString("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f", this.getWidth() - 2, this.getHeight() - 2, 40);
        switch (this.state) {
            case 2: {
                graphics.drawString("Use", this.getWidth() >> 1, this.getHeight() - 2, 33);
                break;
            }
            case 3: {
                graphics.setColor(197379);
                graphics.drawRect(1, this.getHeight() - this.menuHeight - 3, this.menuWidth + 2, this.menuHeight + 2);
                graphics.setColor(0xDEDEDE);
                graphics.fillRect(2, this.getHeight() - this.menuHeight - 2, this.menuWidth, this.menuHeight);
                QuestPlayer.drawList$(this, graphics, 2, this.getHeight() - this.menuHeight - 2, this.menuWidth, this.menuHeight, this.menuData.elements(), this.menuStart, this.menuSelect);
                QuestPlayer.drawScroll$(this, graphics, this.menuWidth - 2, this.getHeight() - this.menuHeight - 2, 4, this.menuHeight, 0x909090, this.menuStart, this.menuCount, this.menuData.size());
            }
            default: {
                break;
            }
            case 5: {
                this.state = 2;
                break;
            }
            case 6: {
                graphics.setColor(197379);
                graphics.drawRect(this.getWidth() - this.actionsWidth - 3, this.getHeight() - this.actionsHeight - 3, this.actionsWidth + 2, this.actionsHeight + 2);
                graphics.setColor(0xDEDEDE);
                graphics.fillRect(this.getWidth() - this.actionsWidth - 2, this.getHeight() - this.actionsHeight - 2, this.actionsWidth, this.actionsHeight);
                QuestPlayer.drawList$(this, graphics, this.getWidth() - this.actionsWidth - 2, this.getHeight() - this.actionsHeight - 2, this.actionsWidth, this.actionsHeight, this.buttons.elements(), this.actionsStart, this.actionsSelect);
                QuestPlayer.drawScroll$(this, graphics, this.getWidth() - 6, this.getHeight() - this.actionsHeight - 2, 4, this.actionsHeight, 0x909090, this.actionsStart, this.actionsCount, this.buttons.size());
                break;
            }
            case 7: {
                graphics.setColor(197379);
                graphics.drawRect(this.getWidth() - this.actionsWidth - 3, this.getHeight() - this.actionsHeight - 3, this.actionsWidth + 2, this.actionsHeight + 2);
                graphics.setColor(0xDEDEDE);
                graphics.fillRect(this.getWidth() - this.actionsWidth - 2, this.getHeight() - this.actionsHeight - 2, this.actionsWidth, this.actionsHeight);
                QuestPlayer.drawList$(this, graphics, this.getWidth() - this.actionsWidth - 2, this.getHeight() - this.actionsHeight - 2, this.actionsWidth, this.actionsHeight, this.itemUsages.keys(), this.itemActionStart, this.itemActionSelect);
                QuestPlayer.drawScroll$(this, graphics, this.getWidth() - 6, this.getHeight() - this.actionsHeight - 2, 4, this.actionsHeight, 0x909090, this.itemActionStart, this.actionsCount, this.itemUsages.size());
            }
        }
    }

    static void primiMessage$(QuestPlayer questPlayer, String string) throws  {
    }

    public void keyPressed(int n) throws  {
        if (n == LEFT_SOFTKEY) {
            n = -6;
        } else if (n == RIGHT_SOFTKEY) {
            n = -7;
        }
        if (this.messagesFlag) {
            this.messagesFlag = false;
            this.flushGraphics(this);
            return;
        }
        if (n == 49) {
            QuestPlayer.debugVars$(this);
            this.flushGraphics(this);
        }
        if ((n == 52 || n == -3) && this.state == 1 && this.lineStart > this.textHeight / this.textFont.getHeight()) {
            this.lineStart -= this.textHeight / this.textFont.getHeight();
            this.flushGraphics(this);
            return;
        }
        if ((n == 54 || n == -4) && this.state == 1 && this.lineStart + this.lineCount < this.strings.size() - this.textHeight / this.textFont.getHeight()) {
            this.lineStart += this.textHeight / this.textFont.getHeight();
            this.flushGraphics(this);
            return;
        }
        switch (this.getGameAction(n)) {
            case 1: {
                switch (this.state) {
                    case 1: {
                        if (this.lineStart <= 0) break;
                        --this.lineStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        if (this.invertorySelect > 0) {
                            --this.invertorySelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.invertoryStart <= 0) break;
                        --this.invertoryStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 3: {
                        if (this.menuSelect > 0) {
                            --this.menuSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.menuStart > 0) {
                            --this.menuStart;
                            this.flushGraphics(this);
                        }
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        break;
                    }
                    case 6: {
                        if (this.actionsSelect > 0) {
                            --this.actionsSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.actionsStart <= 0) break;
                        --this.actionsStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 7: {
                        if (this.itemActionSelect > 0) {
                            --this.itemActionSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.itemActionStart <= 0) break;
                        --this.itemActionStart;
                        this.flushGraphics(this);
                    }
                }
                return;
            }
            case 6: {
                switch (this.state) {
                    case 1: {
                        if (this.lineStart + this.lineCount >= this.strings.size()) break;
                        ++this.lineStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        if (this.invertorySelect + 1 < this.invertoryCount) {
                            if (this.invertoryStart + this.invertorySelect + 1 >= this.invertory.size()) break;
                            ++this.invertorySelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.invertoryStart + this.invertoryCount >= this.invertory.size()) break;
                        ++this.invertoryStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 3: {
                        if (this.menuSelect + 1 < this.menuCount) {
                            if (this.menuStart + this.menuSelect + 1 >= this.menuData.size()) break;
                            ++this.menuSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.menuStart + this.menuCount < this.menuData.size()) {
                            ++this.menuStart;
                            this.flushGraphics(this);
                        }
                    }
                    default: {
                        break;
                    }
                    case 6: {
                        if (this.actionsSelect + 1 < this.actionsCount) {
                            if (this.actionsStart + this.actionsSelect + 1 >= this.buttons.size()) break;
                            ++this.actionsSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.actionsStart + this.actionsCount >= this.buttons.size()) break;
                        ++this.actionsStart;
                        this.flushGraphics(this);
                        break;
                    }
                    case 7: {
                        if (this.itemActionSelect + 1 < this.actionsCount) {
                            if (this.itemActionStart + this.itemActionSelect + 1 >= this.itemUsages.size()) break;
                            ++this.itemActionSelect;
                            this.flushGraphics(this);
                            break;
                        }
                        if (this.itemActionStart + this.actionsCount >= this.itemUsages.size()) break;
                        ++this.itemActionStart;
                        this.flushGraphics(this);
                    }
                }
                return;
            }
            case 8: {
                switch (this.state) {
                    case 1: {
                        this.state = 6;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        QuestPlayer.invertoryAction$(this);
                        break;
                    }
                    case 3: {
                        QuestPlayer.menuAction$(this);
                    }
                    default: {
                        break;
                    }
                    case 6: {
                        QuestPlayer.buttonAction$(this);
                        break;
                    }
                    case 7: {
                        QuestPlayer.itemUsageAction$(this);
                    }
                }
                return;
            }
        }
        switch (n) {
            case -7: {
                switch (this.state) {
                    case 1: {
                        this.state = 6;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        this.state = 6;
                        this.flushGraphics(this);
                        break;
                    }
                    case 3: {
                        this.close();
                    }
                    default: {
                        break;
                    }
                    case 6: {
                        QuestPlayer.buttonAction$(this);
                        break;
                    }
                    case 7: {
                        QuestPlayer.itemUsageAction$(this);
                    }
                }
                return;
            }
            case -6: {
                switch (this.state) {
                    case 1: {
                        this.state = 3;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        this.state = 3;
                        this.flushGraphics(this);
                        break;
                    }
                    case 3: {
                        this.state = 1;
                        this.flushGraphics(this);
                    }
                    default: {
                        break;
                    }
                    case 6: {
                        this.state = 1;
                        this.flushGraphics(this);
                        break;
                    }
                    case 7: {
                        this.state = 2;
                        this.flushGraphics(this);
                    }
                }
                return;
            }
            case 48: {
                switch (this.state) {
                    case 1: {
                        this.state = 2;
                        this.flushGraphics(this);
                        break;
                    }
                    case 2: {
                        this.state = 1;
                        this.flushGraphics(this);
                    }
                }
                return;
            }
        }
    }

    public void keyRepeated(int n) throws  {
        this.keyPressed(n);
    }

    public void println(String string) throws  {
        this.print(string);
        this.print("\n");
    }

    /*
     * Unable to fully structure code
     */
    public void print(String var1_1) throws  {
        var2_2 = 0;
        while (var2_2 < var1_1.length()) {
            var3_3 = Math.min(Math.min(QuestPlayer.indexOfChar$(this, var1_1, 32, var2_2), QuestPlayer.indexOfChar$(this, var1_1, 9, var2_2)), QuestPlayer.indexOfChar$(this, var1_1, 10, var2_2));
            if (var3_3 == var2_2) {
                switch (var1_1.charAt(var3_3)) {
                    case '\t': {
                        if (this.lastWidth + this.textFont.charWidth(' ') > this.textWidth - 16) {
                            QuestPlayer.newLine$(this);
                            break;
                        }
                        QuestPlayer.putString$(this, "    ");
                        break;
                    }
                    case '\n': {
                        QuestPlayer.newLine$(this);
                        break;
                    }
                    case ' ': {
                        if (this.lastWidth + this.textFont.charWidth(' ') > this.textWidth - 4) {
                            QuestPlayer.newLine$(this);
                            break;
                        }
                        QuestPlayer.putString$(this, " ");
                    }
                }
                ++var2_2;
                continue;
            }
            if (this.lastWidth + this.textFont.substringWidth(var1_1, var2_2, var3_3 - var2_2) <= this.textWidth - 4) {
                QuestPlayer.putString$(this, var1_1.substring(var2_2, var3_3));
                var2_2 = var3_3;
                continue;
            }
            if (((String)this.strings.lastElement()).length() == 0) {
                while (var2_2 < var3_3) {
                    var4_4 = 0;
                    while (var2_2 + var4_4 < var3_3 && this.lastWidth + this.textFont.substringWidth(var1_1, var2_2, var4_4) < this.textWidth - 4) {
                        ++var4_4;
                    }
                    if (var2_2 + var4_4 < var3_3) {
                        --var4_4;
                    }
                    QuestPlayer.putString$(this, var1_1.substring(var2_2, var2_2 + var4_4));
                    if (var2_2 + var4_4 < var3_3) {
                        QuestPlayer.newLine$(this);
                    }
                    var2_2 += var4_4;
                }
                continue;
            }
            QuestPlayer.newLine$(this);
            if (this.lastWidth + this.textFont.substringWidth(var1_1, var2_2, var3_3 - var2_2) > this.textWidth - 4) ** GOTO lbl52
            QuestPlayer.putString$(this, var1_1.substring(var2_2, var3_3));
            var2_2 = var3_3;
            continue;
lbl-1000:
            // 1 sources

            {
                var4_4 = 0;
                while (var2_2 + var4_4 < var3_3 && this.lastWidth + this.textFont.substringWidth(var1_1, var2_2, var4_4) < this.textWidth - 4) {
                    ++var4_4;
                }
                QuestPlayer.putString$(this, var1_1.substring(var2_2, --var4_4));
                QuestPlayer.newLine$(this);
                var2_2 += var4_4;
lbl52:
                // 2 sources

                ** while (var2_2 < var3_3)
            }
lbl53:
            // 1 sources

        }
    }

    static void putString$(QuestPlayer questPlayer, String string) throws  {
        String string2 = (String)questPlayer.strings.lastElement();
        questPlayer.strings.setElementAt(String.valueOf(string2).concat(String.valueOf(string)), questPlayer.strings.size() - 1);
        questPlayer.lastWidth += questPlayer.textFont.stringWidth(string);
    }

    public void close() throws  {
        try {
            this.inputStream.close();
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Display.getDisplay((MIDlet)Midlet.midlet).setCurrent(this.previous);
    }

    static void newLine$(QuestPlayer questPlayer) throws  {
        questPlayer.strings.addElement("");
        questPlayer.lastWidth = 2;
    }

    static void clearText$(QuestPlayer questPlayer) throws  {
        questPlayer.strings.removeAllElements();
        questPlayer.strings.addElement("");
        questPlayer.lastWidth = 2;
        questPlayer.lineStart = 0;
    }

    static int indexOfChar$(QuestPlayer questPlayer, String string, int n, int n2) throws  {
        int n3 = string.indexOf(n, n2);
        return n3 < 0 ? string.length() : n3;
    }

    static void draw3DRects$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) throws  {
        while (n6 > 0) {
            QuestPlayer.draw3DRect$(questPlayer, graphics, n, n2, n3, n4, n5, bl);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
            --n6;
        }
    }

    static void draw3DRect$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) throws  {
        int n6 = QuestPlayer.multipleColor$(questPlayer, n5, 34, bl);
        int n7 = QuestPlayer.multipleColor$(questPlayer, n5, 34, !bl);
        graphics.setColor(n6);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.setColor(n7);
        graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
    }

    static int multipleColor$(QuestPlayer questPlayer, int n, int n2, boolean bl) throws  {
        if (!bl) {
            n2 = -n2;
        }
        return Math.max(Math.min((n & 0xFF) + n2, 255), 0) | Math.max(Math.min((n >> 8 & 0xFF) + n2, 255), 0) << 8 | Math.max(Math.min((n >> 16 & 0xFF) + n2, 255), 0) << 16;
    }

    static void drawScroll$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws  {
        if (n7 < n8) {
            graphics.setColor(n5);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(QuestPlayer.multipleColor$(questPlayer, n5, 102, false));
            graphics.fillRect(n, n2 + n4 * n6 / n8, n3, n4 * n7 / n8);
        }
    }

    static void drawStrings$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, int n5, Vector vector, int n6) throws  {
        graphics.setClip(n, n2, n3, n4);
        graphics.setFont(questPlayer.textFont);
        graphics.setColor(n5);
        int n7 = 0;
        int n8 = n6;
        while (n7 <= n4 && n8 < vector.size()) {
            graphics.drawString((String)vector.elementAt(n8), n + 1, n2 + n7, 20);
            n7 += questPlayer.textFont.getHeight();
            ++n8;
        }
        graphics.setClip(0, 0, questPlayer.getWidth(), questPlayer.getHeight());
    }

    static void drawInvertoryList$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, Hashtable hashtable, int n5, int n6) throws  {
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        int n7 = 0;
        while (n7++ < n5) {
            enumeration.nextElement();
            enumeration2.nextElement();
        }
        graphics.setClip(n, n2, n3, n4);
        graphics.setColor(0);
        while (n4 > 0 && enumeration.hasMoreElements()) {
            if (n6 == 0) {
                graphics.setColor(0x797979);
                graphics.fillRect(n, n2, n3, questPlayer.listFont.getHeight());
                graphics.setColor(0);
            }
            String string = (String)enumeration.nextElement();
            graphics.drawString(String.valueOf(((Integer)enumeration2.nextElement()).toString()).concat(" cnt. ").concat(String.valueOf(string.equals("Inv") ? "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c" : string)), n, n2, 20);
            n2 += questPlayer.listFont.getHeight();
            n4 -= questPlayer.listFont.getHeight();
            --n6;
        }
        graphics.setClip(0, 0, questPlayer.getWidth(), questPlayer.getHeight());
    }

    static void drawList$(QuestPlayer questPlayer, Graphics graphics, int n, int n2, int n3, int n4, Enumeration enumeration, int n5, int n6) throws  {
        int n7 = 0;
        while (n7++ < n5) {
            enumeration.nextElement();
        }
        graphics.setClip(n, n2, n3 + 1, n4);
        graphics.setColor(0);
        while (n4 > 0 && enumeration.hasMoreElements()) {
            if (n6 == 0) {
                graphics.setColor(0x797979);
                graphics.fillRect(n, n2, n3 + 1, questPlayer.listFont.getHeight());
                graphics.setColor(0);
            }
            graphics.drawString((String)enumeration.nextElement(), n, n2, 20);
            n2 += questPlayer.listFont.getHeight();
            n4 -= questPlayer.listFont.getHeight();
            --n6;
        }
        graphics.setClip(0, 0, questPlayer.getWidth(), questPlayer.getHeight());
    }

    static String decode$(QuestPlayer questPlayer, byte[] byArray) throws  {
        return QuestPlayer.decode$(questPlayer, byArray, 0, byArray.length);
    }

    static String decode$(QuestPlayer questPlayer, byte[] byArray, int n, int n2) throws  {
        int n3;
        if (questPlayer.coding) {
            int n4 = 0;
            n3 = n;
            while (n4 < n2) {
                if ((byArray[n3] & 0xFF) >= 32) {
                    byArray[n3] = (byte)(287 - byArray[n3]);
                }
                ++n4;
                ++n3;
            }
        }
        char[] cArray = new char[n2];
        n3 = 0;
        while (n3 < n2) {
            int n5 = byArray[n + n3] & 0xFF;
            cArray[n + n3] = n5 > 128 ? win1251ToUtf8[n5 - 128] : (short)n5;
            ++n3;
        }
        return new String(cArray);
    }

    public void run() throws  {
        this.stopped = true;
        while (QuestPlayer.nextLine$(this)) {
        }
        this.flushGraphics(this);
        System.gc();
    }

    static boolean nextLine$(QuestPlayer questPlayer) throws  {
        try {
            if (questPlayer.parser.eof()) {
                questPlayer.finishReading = false;
                return false;
            }
            String string = QuestPlayer.decode$(questPlayer, questPlayer.parser.readLine());
            int n = string.indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            string = string.trim();
            return QuestPlayer.parseLine$(questPlayer, string, questPlayer.parser.toLowerCase(string));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static boolean parseLine$(QuestPlayer questPlayer, String string, String string2) throws  {
        string = QuestPlayer.prepareString$(questPlayer, string);
        string2 = QuestPlayer.prepareString$(questPlayer, string2);
        String string3 = string;
        String string4 = string2;
        int n = string3.indexOf(38);
        if (n >= 0 && !string4.startsWith("if")) {
            boolean bl = QuestPlayer.parseLine$(questPlayer, string3.substring(0, n).trim(), string4.substring(0, n).trim());
            return !bl ? false : QuestPlayer.parseLine$(questPlayer, string3.substring(n + 1).trim(), string4.substring(n + 1).trim());
        }
        string4 = questPlayer.parser.toLowerCase(string3);
        if (string4.startsWith("if ")) {
            n = string4.indexOf(" then ");
            int n2 = string4.indexOf("else ");
            if (n2 >= 0) {
                return n >= 0 && QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string3.substring(3, n).trim())) ? QuestPlayer.parseLine$(questPlayer, string3.substring(n + 6, n2).trim(), string4.substring(n + 6, n2).trim()) : QuestPlayer.parseLine$(questPlayer, string3.substring(n2 + 5).trim(), string4.substring(n2 + 5).trim());
            }
            return n >= 0 && QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string3.substring(3, n).trim())) ? QuestPlayer.parseLine$(questPlayer, string3.substring(n + 6).trim(), string4.substring(n + 6).trim()) : true;
        }
        if (string4.equals("anykey")) {
            questPlayer.buttonId.addElement("mobile_quest_next");
            questPlayer.buttons.addElement("*\u0414\u0430\u043b\u0435\u0435");
            return false;
        }
        if (string4.equals("cls")) {
            QuestPlayer.clearText$(questPlayer);
            return true;
        }
        if (string4.equals("save")) {
            questPlayer.save("null");
            return true;
        }
        if (string4.startsWith("save ")) {
            questPlayer.save(string4.substring(5).trim());
            return true;
        }
        if (string4.equals("pln")) {
            QuestPlayer.newLine$(questPlayer);
            return true;
        }
        if (string4.startsWith("print ")) {
            questPlayer.print(QuestPlayer.prepareString$(questPlayer, string3.substring(6)));
            return true;
        }
        if (string4.startsWith("p ")) {
            questPlayer.print(QuestPlayer.prepareString$(questPlayer, string3.substring(2)));
            return true;
        }
        if (string4.startsWith("println ")) {
            questPlayer.println(QuestPlayer.prepareString$(questPlayer, string3.substring(8)));
            return true;
        }
        if (string4.startsWith("pln ")) {
            questPlayer.println(QuestPlayer.prepareString$(questPlayer, string3.substring(4)));
            return true;
        }
        if (string4.startsWith("btn ")) {
            n = string3.indexOf(44);
            if (n >= 0) {
                questPlayer.buttonId.addElement(QuestPlayer.prepareString$(questPlayer, string4.substring(4, n).trim()));
            }
            questPlayer.buttons.addElement(QuestPlayer.prepareString$(questPlayer, string3.substring(n + 1).trim()));
            return true;
        }
        if (string4.startsWith("inv+ ")) {
            n = string3.indexOf(44);
            if (n >= 0) {
                try {
                    QuestPlayer.addInvertory$(questPlayer, ((Double)QuestPlayer.parseValue$(questPlayer, string4.substring(4, n).trim())).intValue(), QuestPlayer.prepareString$(questPlayer, string3.substring(n + 1).trim()));
                }
                catch (Exception exception) {
                    questPlayer.println(exception.toString());
                }
            } else {
                QuestPlayer.addInvertory$(questPlayer, 1, QuestPlayer.prepareString$(questPlayer, string3.substring(4).trim()));
            }
            return true;
        }
        if (string4.startsWith("inv- ")) {
            n = string3.indexOf(44);
            if (n >= 0) {
                try {
                    QuestPlayer.removeInvertory$(questPlayer, ((Double)QuestPlayer.parseValue$(questPlayer, string4.substring(4, n).trim())).intValue(), string3.substring(n + 1).trim());
                }
                catch (Exception exception) {
                    questPlayer.println(exception.toString());
                }
            } else {
                QuestPlayer.removeInvertory$(questPlayer, 1, string3.substring(4).trim());
            }
            return true;
        }
        if (string4.startsWith("invkill ")) {
            questPlayer.invertory.remove(string4.substring(8).trim());
            if (questPlayer.invertoryStart + questPlayer.invertorySelect >= questPlayer.invertory.size()) {
                questPlayer.invertoryStart = 0;
                questPlayer.invertorySelect = 0;
            }
            questPlayer.flushGraphics(questPlayer);
            return true;
        }
        if (string4.equals("invkill")) {
            questPlayer.invertory.clear();
            questPlayer.invertory.put("Inv", new Integer(1));
            questPlayer.invertoryStart = 0;
            questPlayer.invertorySelect = 0;
            questPlayer.flushGraphics(questPlayer);
            return true;
        }
        if (string4.equals("perkill")) {
            questPlayer.var.clear();
            return true;
        }
        if (string4.startsWith("goto ")) {
            return QuestPlayer.jumpRuntime$(questPlayer, string4.substring(5).trim());
        }
        if (string4.startsWith("proc ")) {
            QuestPlayer.invokeCommon$(questPlayer);
            int n3 = questPlayer.parser.getPosition();
            if (QuestPlayer.jumpRuntime$(questPlayer, string4.substring(5).trim())) {
                questPlayer.run();
            }
            QuestPlayer.jumpRuntime$(questPlayer, n3);
            return true;
        }
        if (!string4.startsWith("input ")) {
            if (string4.startsWith("instr ")) {
                n = string4.indexOf(61);
                if (n >= 0) {
                    questPlayer.var.put(QuestPlayer.prepareString$(questPlayer, string4.substring(6, n).trim()), QuestPlayer.prepareString$(questPlayer, string3.substring(n + 1).trim()));
                }
                return true;
            }
            if (string4.startsWith(":")) {
                String string5 = questPlayer.parser.toLowerCase(string3.substring(1).trim());
                if (!questPlayer.var.contains("current_loc")) {
                    questPlayer.var.put("current_loc", string5);
                }
                if (!questPlayer.label.contains(string5)) {
                    questPlayer.label.put(string5, new Integer(questPlayer.parser.getPosition()));
                }
                return true;
            }
            if (string4.startsWith("pause ")) {
                try {
                    questPlayer.flushGraphics(questPlayer);
                    long l = Long.parseLong(string4.substring(6).trim());
                    questPlayer.stopped = false;
                    Thread.sleep(l);
                    if (questPlayer.stopped) {
                        questPlayer.stopped = false;
                    }
                    return true;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            if (string4.equals("end")) {
                return false;
            }
            n = string4.indexOf(61);
            if (n >= 0) {
                questPlayer.var.put(QuestPlayer.prepareString$(questPlayer, string4.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string3.substring(n + 1).trim()));
            }
            return true;
        }
        questPlayer.buttonId.addElement("mobile_quest_input");
        questPlayer.buttons.addElement("*\u0412\u0432\u0435\u0441\u0442\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        questPlayer.inputsBuff = string4.substring(6).trim();
        Object object = questPlayer.var.get(questPlayer.inputsBuff);
        if (object == null) {
            object = new String();
        }
        try {
            questPlayer.inputTextBox.setString(object.toString());
        }
        catch (Exception exception) {
            questPlayer.inputTextBox.setString(object.toString());
        }
        return false;
    }

    static void invokeCommon$(QuestPlayer questPlayer) throws  {
        if (!questPlayer.commonState) {
            try {
                int n = questPlayer.parser.getPosition();
                Double d = (Double)questPlayer.var.get("common");
                int n2 = d == null ? 0 : (int)d.doubleValue();
                String string = "common".concat(String.valueOf(n2 == 0 ? "" : "_".concat(String.valueOf(n2))));
                if (QuestPlayer.jumpRuntime$(questPlayer, string)) {
                    questPlayer.commonState = true;
                    questPlayer.run();
                    questPlayer.commonState = false;
                }
                QuestPlayer.jumpRuntime$(questPlayer, n);
                questPlayer.var.put("common", new Double(n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) throws  {
        Display.getDisplay((MIDlet)Midlet.midlet).setCurrent((Displayable)this);
        String string = this.inputTextBox.getString();
        try {
            this.var.put(this.inputsBuff, new Double(Integer.parseInt(string)));
        }
        catch (Exception exception) {
            this.var.put(this.inputsBuff, string);
        }
        this.buttons.removeElement("*\u0412\u0432\u0435\u0441\u0442\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        this.buttonId.removeElement("mobile_quest_input");
        this.actionsStart = 0;
        this.actionsSelect = 0;
        this.state = 1;
        new Thread(this).start();
    }

    static String replace$(QuestPlayer questPlayer, String string, String string2, String string3) throws  {
        int n;
        while ((n = string.indexOf(string2)) >= 0) {
            string = String.valueOf(string.substring(0, n)).concat(String.valueOf(string3)).concat(String.valueOf(string.substring(n + string2.length())));
        }
        return string;
    }

    static String prepareString$(QuestPlayer questPlayer, String string) throws  {
        string = QuestPlayer.replace$(questPlayer, string, "#/$", "\n");
        if ((string = QuestPlayer.replace$(questPlayer, string, "#$", " ")).indexOf(35) >= 0 && string.indexOf(36) >= 0) {
            String string2 = string.substring(string.indexOf(35), string.lastIndexOf(36) + 1);
            String string3 = string.substring(0, string.indexOf(35));
            String string4 = string.substring(string.lastIndexOf(36) + 1);
            int n = 0;
            String string5 = new String();
            boolean bl = true;
            int n2 = 0;
            while (n2 < string2.length()) {
                char c = string2.charAt(n2);
                if (c == '#') {
                    ++n;
                    bl = true;
                }
                if (c == '$') {
                    --n;
                }
                if (n == 0 && bl) {
                    string3 = String.valueOf(string3).concat(String.valueOf(QuestPlayer.preparedString$(questPlayer, QuestPlayer.prepareString$(questPlayer, string5))));
                    string5 = new String();
                    bl = false;
                }
                if (bl) {
                    string5 = String.valueOf(string5).concat(String.valueOf(c));
                } else if (c != '#' && c != '$') {
                    string3 = String.valueOf(string3).concat(String.valueOf(c));
                }
                ++n2;
            }
            string = String.valueOf(string3).concat(String.valueOf(string4));
        }
        return string;
    }

    static String preparedString$(QuestPlayer questPlayer, String string) throws  {
        string = QuestPlayer.replace$(questPlayer, string, "#", " ").trim();
        if (questPlayer.itNumber(string = QuestPlayer.replace$(questPlayer, string, "$", " ").trim())) {
            try {
                char c = (short)Double.parseDouble(string);
                return "".concat(String.valueOf(c));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.startsWith("%")) {
            try {
                string = QuestPlayer.toString$(questPlayer, QuestPlayer.parseValue$(questPlayer, questPlayer.parser.toLowerCase(string.substring(1)).trim()));
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            string = QuestPlayer.toString$(questPlayer, QuestPlayer.parseValue$(questPlayer, questPlayer.parser.toLowerCase(string).trim()));
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    static void addInvertory$(QuestPlayer questPlayer, int n, String string) throws  {
        Integer n2 = (Integer)questPlayer.invertory.get(string);
        n2 = n2 == null ? new Integer(n) : new Integer(n2 + n);
        questPlayer.invertory.put(string, n2);
        questPlayer.actions.append("You has take ").append(n).append(" ").append(string).append('\n');
    }

    static void removeInvertory$(QuestPlayer questPlayer, int n, String string) throws  {
        Integer n2 = (Integer)questPlayer.invertory.get(string);
        if (n2 != null) {
            if ((n2 = new Integer(n2 - n)) < 1) {
                questPlayer.invertory.remove(string);
            } else {
                questPlayer.invertory.put(string, n2);
                questPlayer.actions.append("You has drop ").append(n).append(" ").append(string).append('\n');
            }
        }
    }

    static int getInvertory$(QuestPlayer questPlayer, String string) throws  {
        string = questPlayer.parser.toLowerCase(string);
        Enumeration enumeration = questPlayer.invertory.keys();
        Enumeration enumeration2 = questPlayer.invertory.elements();
        while (enumeration.hasMoreElements()) {
            if (questPlayer.parser.toLowerCase((String)enumeration.nextElement()).equals(string)) {
                return (Integer)enumeration2.nextElement();
            }
            enumeration2.nextElement();
        }
        return 0;
    }

    static void buttonAction$(QuestPlayer questPlayer) throws  {
        int n = questPlayer.actionsStart + questPlayer.actionsSelect;
        if (n < questPlayer.buttonId.size()) {
            QuestPlayer.clearText$(questPlayer);
            String string = (String)questPlayer.buttonId.elementAt(n);
            if (string.equals("mobile_quest_input")) {
                questPlayer.inputCompleted = true;
                Display.getDisplay((MIDlet)Midlet.midlet).setCurrent((Displayable)questPlayer.inputTextBox);
            } else if (string.equals("mobile_quest_next")) {
                questPlayer.buttons.removeAllElements();
                questPlayer.buttonId.removeAllElements();
                questPlayer.actionsStart = 0;
                questPlayer.actionsSelect = 0;
                questPlayer.state = 1;
                new Thread(questPlayer).start();
            } else {
                QuestPlayer.invokeCommon$(questPlayer);
                if (QuestPlayer.jumpRuntime$(questPlayer, QuestPlayer.prepareString$(questPlayer, string))) {
                    questPlayer.var.put("current_loc", QuestPlayer.prepareString$(questPlayer, string));
                    questPlayer.buttons.removeAllElements();
                    questPlayer.buttonId.removeAllElements();
                    questPlayer.actionsStart = 0;
                    questPlayer.actionsSelect = 0;
                    questPlayer.state = 1;
                    new Thread(questPlayer).start();
                }
            }
        }
    }

    static boolean jumpRuntime$(QuestPlayer questPlayer, String string) throws  {
        Double d = (Double)questPlayer.var.get(string = questPlayer.parser.toLowerCase(QuestPlayer.prepareString$(questPlayer, string)));
        if (d == null) {
            questPlayer.var.put(string, new Double(1.0));
            questPlayer.var.put("count_".concat(String.valueOf(string)), new Double(1.0));
        } else {
            questPlayer.var.put(string, new Double(d + 1.0));
            questPlayer.var.put("count_".concat(String.valueOf(string)), new Double(d + 1.0));
        }
        Integer n = (Integer)questPlayer.label.get(string);
        if (n != null) {
            try {
                questPlayer.inputStream.close();
                questPlayer.inputStream = questPlayer.connection.openInputStream();
                questPlayer.inputStream.skip(n.intValue());
                questPlayer.parser.reset(questPlayer.inputStream, n);
                return true;
            }
            catch (IOException iOException) {
                questPlayer.println("\nURQ Critical ERROR: an i/o exception has thrown!");
                return false;
            }
        }
        try {
            if (!questPlayer.finishReading) {
                while (!questPlayer.parser.eof()) {
                    String string2 = QuestPlayer.decode$(questPlayer, questPlayer.parser.readLine()).trim();
                    int n2 = string2.indexOf(59);
                    if (n2 >= 0) {
                        string2 = string2.substring(0, n2).trim();
                    }
                    if (!string2.startsWith(":")) continue;
                    String string3 = questPlayer.parser.toLowerCase(string2.substring(1).trim());
                    if (!questPlayer.label.contains(string3)) {
                        questPlayer.label.put(string3, new Integer(questPlayer.parser.getPosition()));
                    }
                    if (!string.equals(QuestPlayer.prepareString$(questPlayer, string3))) continue;
                    return true;
                }
            }
            questPlayer.finishReading = true;
            if (!string.equals("common")) {
                questPlayer.println("\nWarning! Label not found: ".concat(String.valueOf(string)));
            }
            return false;
        }
        catch (IOException iOException) {
            questPlayer.println("\nURQ Critical ERROR: an i/o exception has thrown!");
            return false;
        }
    }

    static boolean jumpRuntime$(QuestPlayer questPlayer, int n) throws  {
        try {
            questPlayer.inputStream.close();
            questPlayer.inputStream = questPlayer.connection.openInputStream();
            questPlayer.inputStream.skip(n);
            questPlayer.parser.reset(questPlayer.inputStream, n);
            return true;
        }
        catch (IOException iOException) {
            questPlayer.println("\nURQ Critical ERROR: an i/o exception has thrown!");
            return false;
        }
    }

    static Object parseValue$(QuestPlayer questPlayer, String string) throws  {
        int n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, " and ");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, new Double((double)(QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim())) & QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(n + 5).trim())))));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, " or ");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, new Double((double)(QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim())) | QuestPlayer.isTrue$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(n + 4).trim())))));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, ">=");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.aboveEqual$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 2).trim())));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "<=");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.belowEqual$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 2).trim())));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "<>");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.notEqual$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 2).trim())));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "=");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.equal$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim())));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, ">");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.above$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim())));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "<");
        if (n >= 0) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.below$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim())));
        }
        if (string.startsWith("not ")) {
            return QuestPlayer.isDoubleTrue$(questPlayer, QuestPlayer.equal$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(4).trim()), new Double(0.0)));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "+");
        if (n >= 0) {
            return QuestPlayer.addite$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim()));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "-");
        if (n >= 0) {
            return QuestPlayer.substracte$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim()));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "*");
        if (n >= 0) {
            return QuestPlayer.multiplicate$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim()));
        }
        n = QuestPlayer.indexSkippedBrackets$(questPlayer, string, "/");
        if (n >= 0) {
            return QuestPlayer.divide$(questPlayer, QuestPlayer.parseValue$(questPlayer, string.substring(0, n).trim()), QuestPlayer.parseValue$(questPlayer, string.substring(n + 1).trim()));
        }
        if (string.startsWith("(")) {
            return QuestPlayer.parseValue$(questPlayer, string.substring(1, string.length() - 1).trim());
        }
        try {
            int n2;
            n = string.indexOf(32);
            if (n >= 0 && (n2 = Integer.parseInt(string.substring(0, n).trim())) <= QuestPlayer.getInvertory$(questPlayer, string.substring(n + 1).trim())) {
                return new Double(1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.startsWith("inv_")) {
            return new Double(QuestPlayer.getInvertory$(questPlayer, string.substring(4)));
        }
        if (string.equals("rnd")) {
            return new Double(QuestPlayer.generateRandomDouble$(questPlayer));
        }
        if (string.equals("time")) {
            return new Double(System.currentTimeMillis() / 1000L % 86400L);
        }
        try {
            return new Double(Double.parseDouble(string));
        }
        catch (Exception exception) {
            try {
                Object v = questPlayer.var.get(questPlayer.parser.toLowerCase(string));
                if (v != null) {
                    return v;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                return new Double(QuestPlayer.getInvertory$(questPlayer, string));
            }
            catch (Exception exception3) {
                return new Double(0.0);
            }
        }
    }

    static Double isDoubleTrue$(QuestPlayer questPlayer, Object object) throws  {
        return object instanceof Double ? (QuestPlayer.compareDouble$(questPlayer, (Double)object, 0.0) != 0 ? new Double(1.0) : new Double(0.0)) : (object instanceof String ? (((String)object).length() != 0 ? new Double(1.0) : new Double(0.0)) : new Double(0.0));
    }

    static boolean isTrue$(QuestPlayer questPlayer, Object object) throws  {
        return object instanceof Double ? QuestPlayer.compareDouble$(questPlayer, (Double)object, 0.0) != 0 : (object instanceof String ? ((String)object).length() != 0 : false);
    }

    static Object equal$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).trim().equals(((String)object2).trim()) ? new Double(1.0) : new Double(0.0);
        }
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return QuestPlayer.compareDouble$(questPlayer, (Double)object, (Double)object2) == 0 ? new Double(1.0) : new Double(0.0);
            }
            if (object2 instanceof String) {
                Double d;
                try {
                    double d2 = Double.parseDouble((String)object2);
                    d = QuestPlayer.compareDouble$(questPlayer, (Double)object, d2) == 0 ? new Double(1.0) : new Double(0.0);
                }
                catch (Exception exception) {
                    return new Double(0.0);
                }
                return d;
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    Double d;
                    try {
                        double d3 = Double.parseDouble((String)object);
                        d = QuestPlayer.compareDouble$(questPlayer, d3, (Double)object2) == 0 ? new Double(1.0) : new Double(0.0);
                    }
                    catch (Exception exception) {
                        return new Double(0.0);
                    }
                    return d;
                }
                if (object2 instanceof String) {
                    return ((String)object).equals((String)object2) ? new Double(1.0) : new Double(0.0);
                }
            }
        }
        return new Double(0.0);
    }

    static Object above$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return QuestPlayer.compareDouble$(questPlayer, (Double)object, (Double)object2) > 0 ? new Double(1.0) : new Double(0.0);
            }
            if (object2 instanceof String) {
                Double d;
                try {
                    double d2 = Double.parseDouble((String)object2);
                    d = QuestPlayer.compareDouble$(questPlayer, (Double)object, d2) > 0 ? new Double(1.0) : new Double(0.0);
                }
                catch (Exception exception) {
                    return new Double(0.0);
                }
                return d;
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    Double d;
                    try {
                        double d3 = Double.parseDouble((String)object);
                        d = QuestPlayer.compareDouble$(questPlayer, d3, (Double)object2) > 0 ? new Double(1.0) : new Double(0.0);
                    }
                    catch (Exception exception) {
                        return new Double(0.0);
                    }
                    return d;
                }
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2) > 0 ? new Double(1.0) : new Double(0.0);
                }
            }
        }
        return new Double(0.0);
    }

    static Object below$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return QuestPlayer.compareDouble$(questPlayer, (Double)object, (Double)object2) < 0 ? new Double(1.0) : new Double(0.0);
            }
            if (object2 instanceof String) {
                Double d;
                try {
                    double d2 = Double.parseDouble((String)object2);
                    d = QuestPlayer.compareDouble$(questPlayer, (Double)object, d2) < 0 ? new Double(1.0) : new Double(0.0);
                }
                catch (Exception exception) {
                    return new Double(0.0);
                }
                return d;
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    Double d;
                    try {
                        double d3 = Double.parseDouble((String)object);
                        d = QuestPlayer.compareDouble$(questPlayer, d3, (Double)object2) < 0 ? new Double(1.0) : new Double(0.0);
                    }
                    catch (Exception exception) {
                        return new Double(0.0);
                    }
                    return d;
                }
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2) < 0 ? new Double(1.0) : new Double(0.0);
                }
            }
        }
        return new Double(0.0);
    }

    static Object notEqual$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        return QuestPlayer.compareDouble$(questPlayer, (Double)QuestPlayer.equal$(questPlayer, object, object2), 0.0) == 0 ? new Double(1.0) : new Double(0.0);
    }

    static Object aboveEqual$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        return QuestPlayer.compareDouble$(questPlayer, (Double)QuestPlayer.below$(questPlayer, object, object2), 0.0) == 0 ? new Double(1.0) : new Double(0.0);
    }

    static Object belowEqual$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        return QuestPlayer.compareDouble$(questPlayer, (Double)QuestPlayer.above$(questPlayer, object, object2), 0.0) == 0 ? new Double(1.0) : new Double(0.0);
    }

    static int compareDouble$(QuestPlayer questPlayer, double d, double d2) throws  {
        double d3 = d - d2;
        return d3 < -1.0E-9 ? -1 : (d3 < 1.0E-9 ? 0 : 1);
    }

    static Object addite$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return new Double((Double)object + (Double)object2);
            }
            if (object2 instanceof String) {
                try {
                    double d = Double.parseDouble((String)object2);
                    return new Double((Double)object + d);
                }
                catch (Exception exception) {
                    return String.valueOf(object.toString()).concat(String.valueOf((String)object2));
                }
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    try {
                        double d = Double.parseDouble((String)object);
                        return new Double(d + (Double)object2);
                    }
                    catch (Exception exception) {
                        return String.valueOf((String)object).concat(String.valueOf(object2.toString()));
                    }
                }
                if (object2 instanceof String) {
                    return ((String)object).concat((String)object2);
                }
            }
        }
        return new Double(0.0);
    }

    static Object substracte$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return new Double((Double)object - (Double)object2);
            }
            if (object2 instanceof String) {
                try {
                    double d = Double.parseDouble((String)object2);
                    return new Double((Double)object - d);
                }
                catch (Exception exception) {
                    return String.valueOf(object.toString()).concat(" - ").concat(String.valueOf((String)object2));
                }
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    try {
                        double d = Double.parseDouble((String)object);
                        return new Double(d - (Double)object2);
                    }
                    catch (Exception exception) {
                        return String.valueOf((String)object).concat(" - ").concat(String.valueOf(object2.toString()));
                    }
                }
                if (object2 instanceof String) {
                    return String.valueOf((String)object).concat(" - ").concat(String.valueOf((String)object2));
                }
            }
        }
        return new Double(0.0);
    }

    static Object multiplicate$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return new Double((Double)object * (Double)object2);
            }
            if (object2 instanceof String) {
                try {
                    double d = Double.parseDouble((String)object2);
                    return new Double((Double)object * d);
                }
                catch (Exception exception) {
                    return String.valueOf(object.toString()).concat(" * ").concat(String.valueOf((String)object2));
                }
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    try {
                        double d = Double.parseDouble((String)object);
                        return new Double(d * (Double)object2);
                    }
                    catch (Exception exception) {
                        return String.valueOf((String)object).concat(" * ").concat(String.valueOf(object2.toString()));
                    }
                }
                if (object2 instanceof String) {
                    return String.valueOf((String)object).concat(" * ").concat(String.valueOf((String)object2));
                }
            }
        }
        return new Double(0.0);
    }

    static Object divide$(QuestPlayer questPlayer, Object object, Object object2) throws  {
        if (object instanceof Double) {
            if (object2 instanceof Double) {
                return new Double((Double)object / (Double)object2);
            }
            if (object2 instanceof String) {
                try {
                    double d = Double.parseDouble((String)object2);
                    return new Double((Double)object / d);
                }
                catch (Exception exception) {
                    return String.valueOf(object.toString()).concat(" / ").concat(String.valueOf((String)object2));
                }
            }
            if (object instanceof String) {
                if (object2 instanceof Double) {
                    try {
                        double d = Double.parseDouble((String)object);
                        return new Double(d / (Double)object2);
                    }
                    catch (Exception exception) {
                        return String.valueOf((String)object).concat(" / ").concat(String.valueOf(object2.toString()));
                    }
                }
                if (object2 instanceof String) {
                    return String.valueOf((String)object).concat(" / ").concat(String.valueOf((String)object2));
                }
            }
        }
        return new Double(0.0);
    }

    static double generateRandomDouble$(QuestPlayer questPlayer) throws  {
        double d = 0.0;
        double d2 = 0.1;
        while (!(d2 <= 1.0E-8)) {
            d += (double)QuestPlayer.generateRandomInt$(questPlayer, 0, 10) * d2;
            d2 /= 10.0;
        }
        return d;
    }

    static int generateRandomInt$(QuestPlayer questPlayer, int n, int n2) throws  {
        int n3 = questPlayer.random.nextInt() % (n2 - n);
        return n3 < 0 ? n - n3 : n + n3;
    }

    static int indexSkippedBrackets$(QuestPlayer questPlayer, String string, String string2) throws  {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length() - string2.length()) {
            switch (string.charAt(n2)) {
                case '(': {
                    ++n;
                    break;
                }
                case ')': {
                    --n;
                    break;
                }
                default: {
                    if (n != 0 || !string.startsWith(string2, n2)) break;
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    static void debugVars$(QuestPlayer questPlayer) throws  {
        questPlayer.println("================ debug vars ================");
        Enumeration enumeration = questPlayer.var.elements();
        Enumeration enumeration2 = questPlayer.var.keys();
        while (enumeration.hasMoreElements()) {
            questPlayer.println(String.valueOf(enumeration2.nextElement().toString()).concat(" = ").concat(String.valueOf(enumeration.nextElement().toString())));
        }
        questPlayer.println("============================================");
    }

    static void invertoryAction$(QuestPlayer questPlayer) throws  {
        int n;
        if (!questPlayer.finishReading) {
            n = questPlayer.parser.getPosition();
            QuestPlayer.jumpRuntime$(questPlayer, "\n");
            QuestPlayer.jumpRuntime$(questPlayer, n);
        }
        n = questPlayer.invertoryStart + questPlayer.invertorySelect;
        Enumeration enumeration = questPlayer.invertory.keys();
        int n2 = n;
        while (n2 > 0 & enumeration.hasMoreElements()) {
            --n2;
            enumeration.nextElement();
        }
        if (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = questPlayer.parser.toLowerCase(string).replace(' ', '_');
            questPlayer.itemUsages = new Hashtable();
            Enumeration enumeration2 = questPlayer.label.keys();
            Enumeration enumeration3 = questPlayer.label.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                String string4 = questPlayer.parser.toLowerCase(string3).replace(' ', '_');
                Integer n3 = (Integer)enumeration3.nextElement();
                if (!string4.startsWith("use_") || !string4.startsWith(string2, 4)) continue;
                if (string4.length() == string2.length() + 4) {
                    questPlayer.itemUsages.put("* Use Item", n3);
                    continue;
                }
                questPlayer.itemUsages.put(string3.substring(string2.length() + 5).replace('_', ' '), n3);
            }
            if (questPlayer.itemUsages.size() != 0) {
                if (questPlayer.itemUsages.size() == 1 && questPlayer.itemUsages.containsKey("* Use Item")) {
                    n = (Integer)questPlayer.itemUsages.get("* Use Item");
                    QuestPlayer.jumpRuntime$(questPlayer, n);
                    new Thread(questPlayer).start();
                } else {
                    questPlayer.state = 7;
                    questPlayer.itemActionStart = 0;
                    questPlayer.itemActionSelect = 0;
                    questPlayer.flushGraphics(questPlayer);
                }
            }
        }
    }

    static void menuAction$(QuestPlayer questPlayer) throws  {
        switch (questPlayer.menuStart + questPlayer.menuSelect) {
            case 0: {
                questPlayer.close();
                break;
            }
            case 1: {
                questPlayer.save("null");
                break;
            }
            case 2: {
                questPlayer.loadSave();
                break;
            }
            case 3: {
                Midlet.midlet.notifyDestroyed();
                break;
            }
        }
    }

    static void itemUsageAction$(QuestPlayer questPlayer) throws  {
        int n = questPlayer.itemActionStart + questPlayer.itemActionSelect;
        if (n < questPlayer.itemUsages.size()) {
            Enumeration enumeration = questPlayer.itemUsages.elements();
            int n2 = n;
            while (n2 > 0 && enumeration.hasMoreElements()) {
                enumeration.nextElement();
                --n2;
            }
            if (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                QuestPlayer.jumpRuntime$(questPlayer, n3);
                questPlayer.state = 1;
                new Thread(questPlayer).start();
            }
        }
    }

    static String toString$(QuestPlayer questPlayer, Object object) throws  {
        String string = object.toString();
        return string.endsWith(".0") ? string.substring(0, string.length() - 2) : string;
    }

    public void save(String string) throws  {
        String string2 = String.valueOf(this.path.substring(0, this.path.length() - 4)).concat(".qsv");
        Object object = new Object();
        try {
            if (File.isExists(string2)) {
                File.delete(string2);
                File.createFile(string2);
            } else {
                File.createFile(string2);
            }
            StreamConnection streamConnection = File.openConnection(string2, 2);
            OutputStream outputStream = streamConnection.openOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.flush();
            dataOutputStream.writeInt(0x555251);
            if (string.equals("null")) {
                string = (String)this.var.get("current_loc");
                if (string == null) {
                    dataOutputStream.writeBoolean(true);
                    dataOutputStream.writeInt(this.parser.getPosition());
                } else {
                    dataOutputStream.writeBoolean(false);
                    dataOutputStream.writeUTF(string);
                }
            } else {
                dataOutputStream.writeBoolean(false);
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.writeInt(this.var.size());
            Enumeration enumeration = this.var.keys();
            Enumeration enumeration2 = this.var.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                dataOutputStream.writeUTF(object.toString());
                if (this.var.get(object) instanceof Double) {
                    dataOutputStream.writeByte(0);
                    dataOutputStream.writeUTF(enumeration2.nextElement().toString());
                    continue;
                }
                dataOutputStream.writeByte(1);
                dataOutputStream.writeUTF(enumeration2.nextElement().toString());
            }
            dataOutputStream.writeInt(this.invertory.size());
            enumeration = this.invertory.keys();
            enumeration2 = this.invertory.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                dataOutputStream.writeUTF(object.toString());
                dataOutputStream.writeUTF(enumeration2.nextElement().toString());
            }
            dataOutputStream.writeInt(this.label.size());
            enumeration = this.label.keys();
            enumeration2 = this.label.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                dataOutputStream.writeUTF(object.toString());
                dataOutputStream.writeUTF(enumeration2.nextElement().toString());
            }
            dataOutputStream.close();
            this.state = 1;
            this.println("\u0418\u0433\u0440\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430");
            this.flushGraphics(this);
        }
        catch (Exception exception) {
            this.println("");
            this.println("".concat(String.valueOf(exception.toString())));
            this.flushGraphics(this);
        }
    }

    public void loadSave() throws  {
        Byte by = new Byte(-1);
        String string = "book";
        String string2 = "book";
        String string3 = "book";
        boolean bl = false;
        int n = 0;
        String string4 = String.valueOf(this.path.substring(0, this.path.length() - 4)).concat(".qsv");
        try {
            if (File.isExists(string4)) {
                StreamConnection streamConnection = File.openConnection(string4, 1);
                InputStream inputStream = streamConnection.openInputStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                if (dataInputStream.readInt() == 0x555251) {
                    if (dataInputStream.readBoolean()) {
                        bl = true;
                        n = dataInputStream.readInt();
                    } else {
                        bl = false;
                        string3 = dataInputStream.readUTF();
                    }
                    int n2 = dataInputStream.readInt();
                    this.var.clear();
                    int n3 = 0;
                    while (n3 < n2) {
                        string = dataInputStream.readUTF();
                        by = new Byte(dataInputStream.readByte());
                        string2 = dataInputStream.readUTF();
                        if (by == 0) {
                            this.var.put(string, new Double(Double.parseDouble(string2)));
                        } else {
                            this.var.put(string, string2);
                        }
                        ++n3;
                    }
                    n2 = dataInputStream.readInt();
                    this.invertory.clear();
                    n3 = 0;
                    while (n3 < n2) {
                        string = dataInputStream.readUTF();
                        string2 = dataInputStream.readUTF();
                        this.invertory.put(string, new Integer((int)Double.parseDouble(string2)));
                        ++n3;
                    }
                    n2 = dataInputStream.readInt();
                    this.label.clear();
                    n3 = 0;
                    while (n3 < n2) {
                        string = dataInputStream.readUTF();
                        string2 = dataInputStream.readUTF();
                        this.label.put(string, new Integer((int)Double.parseDouble(string2)));
                        ++n3;
                    }
                    dataInputStream.close();
                    QuestPlayer.clearText$(this);
                    this.buttons.removeAllElements();
                    this.buttonId.removeAllElements();
                    this.actionsStart = 0;
                    this.actionsSelect = 0;
                    this.state = 1;
                    if (bl) {
                        if (QuestPlayer.jumpRuntime$(this, n)) {
                            this.run();
                        }
                    } else if (QuestPlayer.jumpRuntime$(this, string3)) {
                        this.run();
                    }
                    this.println("\u0418\u0433\u0440\u0430 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                } else {
                    this.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
                    this.flushGraphics(this);
                }
            } else {
                this.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
                this.flushGraphics(this);
            }
        }
        catch (Exception exception) {
            this.println(exception.toString());
            this.flushGraphics(this);
        }
    }

    public boolean itNumber(String string) throws  {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            boolean bl2 = bl = "0123456789.".indexOf(cArray[n]) >= 0;
            if (!bl) {
                return bl;
            }
            ++n;
        }
        return bl;
    }

    public QuestPlayer(Displayable displayable, String string, boolean bl) throws IOException {
        super(true, true);
        this.path = string;
        this.previous = displayable;
        this.coding = bl;
        this.invertory = new Hashtable();
        this.invertory.put("Inv", new Integer(1));
        this.label = new Hashtable();
        this.buttons = new Vector();
        this.buttonId = new Vector();
        this.var = new Hashtable();
        this.connection = File.openConnection(string, 1);
        this.inputStream = this.connection.openInputStream();
        this.parser = new Parser(this.inputStream);
        this.textHeight = this.getHeight() * 70 / 100;
        this.strings = new Vector();
        this.strings.addElement("");
        this.lastWidth = 2;
        this.textWidth = this.getWidth() - 8;
        this.textFont = Font.getFont((int)64, (int)0, (int)8);
        this.actionFont = Font.getFont((int)64, (int)0, (int)8);
        this.listFont = Font.getFont((int)64, (int)0, (int)8);
        this.lineCount = this.textHeight / this.textFont.getHeight();
        this.invertoryWidth = this.getWidth() - 10;
        this.invertoryHeight = this.getHeight() - this.textHeight - this.actionFont.getHeight() - 15;
        this.invertoryCount = this.invertoryHeight / this.listFont.getHeight();
        this.state = 1;
        this.timer = new Timer();
        this.actions = new StringBuffer();
        this.menuHeight = this.listFont.getHeight() * 4 + 20;
        this.menuWidth = this.getWidth() * 95 / 100;
        this.menuCount = this.menuHeight / this.listFont.getHeight();
        this.menuStrings = new Vector();
        this.menuStrings.addElement("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b");
        this.menuStrings.addElement("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.menuStrings.addElement("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
        this.menuStrings.addElement("\u0412\u044b\u0445\u043e\u0434");
        this.menuData = this.menuStrings;
        this.actionsHeight = this.getHeight() * 95 / 100;
        this.actionsWidth = this.getWidth() * 95 / 100;
        this.actionsCount = this.actionsHeight / this.listFont.getHeight();
        this.finishReading = false;
        this.random = new Random(System.currentTimeMillis());
        this.inputTextBox = new TextBox("Input text", " ", 128, 0);
        this.inputTextBox.addCommand(new Command("\u0412\u0432\u0435\u0441\u0442\u0438", 4, 1));
        this.inputTextBox.setCommandListener((CommandListener)this);
        new Thread(this).start();
    }
}

