/*
 * Decompiled with CFR 0.152.
 */
package mquest.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Parser {
    InputStream source;
    byte[] buffer;
    byte[] readbuf;
    char[] chars = new char[128];
    byte[] bytes = new byte[128];
    int position;
    int offset;
    int line;
    public static final String LOWER_CASE_TABLE = "\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u042a\u044b\u044c\u044d\u044e\u044f";
    public static final String UPPER_CASE_TABLE = "\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f";

    public String toLowerCase(String string) throws  {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            int n2 = UPPER_CASE_TABLE.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.setCharAt(n, LOWER_CASE_TABLE.charAt(n2));
            } else {
                stringBuffer.setCharAt(n, Character.toLowerCase(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toUpperCase(String string) throws  {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            int n2 = LOWER_CASE_TABLE.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.setCharAt(n, UPPER_CASE_TABLE.charAt(n2));
            } else {
                stringBuffer.setCharAt(n, Character.toUpperCase(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void reset(InputStream inputStream) throws  {
        this.reset(inputStream, 0);
    }

    public void reset(InputStream inputStream, int n) throws  {
        this.source = inputStream;
        this.line = 1;
        this.position = n;
        this.offset = this.buffer.length;
    }

    public boolean isChar(char c) throws IOException {
        Parser.skipSpaces$(this);
        try {
            boolean bl;
            boolean bl2 = bl = this.buffer[this.offset] == c;
            if (bl) {
                ++this.offset;
            }
            return bl;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            boolean bl;
            if (Parser.readBuffer$(this) == 0) {
                return false;
            }
            boolean bl3 = bl = this.buffer[this.offset] == c;
            if (bl) {
                ++this.offset;
            }
            return bl;
        }
    }

    public byte[] readLine() throws IOException {
        byte[] byArray;
        while ((byArray = Parser.readUnifiedLine$(this)).length == 0 && !this.eof()) {
        }
        return byArray;
    }

    static byte[] readUnifiedLine$(Parser parser) throws IOException {
        int n = 0;
        while (true) {
            byte by;
            try {
                by = parser.buffer[parser.offset];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Parser.readBuffer$(parser) != 0) continue;
                break;
            }
            ++parser.offset;
            if (by == 10 || by == 13) break;
            try {
                parser.bytes[n] = by;
                ++n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                byte[] byArray = new byte[parser.bytes.length << 1];
                System.arraycopy(parser.bytes, 0, byArray, 0, n);
                parser.bytes = byArray;
                parser.bytes[n++] = by;
            }
        }
        byte[] byArray = new byte[n];
        System.arraycopy(parser.bytes, 0, byArray, 0, n);
        return byArray;
    }

    public char getChar() throws IOException {
        Parser.skipSpaces$(this);
        try {
            byte by = this.buffer[this.offset];
            ++this.offset;
            return (char)by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Parser.readBuffer$(this) == 0) {
                throw new EOFException();
            }
            return (char)this.buffer[this.offset++];
        }
    }

    public String getTo(char c) throws IOException {
        int n = 0;
        while (true) {
            char c2;
            try {
                c2 = this.buffer[this.offset];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Parser.readBuffer$(this) != 0) continue;
                break;
            }
            if (c2 == c) break;
            ++this.offset;
            try {
                this.chars[n] = c2;
                ++n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                char[] cArray = new char[this.chars.length << 1];
                System.arraycopy(this.chars, 0, cArray, 0, n);
                this.chars = cArray;
                this.chars[n++] = c2;
            }
        }
        return new String(this.chars, 0, n);
    }

    public boolean isWord() throws IOException {
        boolean bl;
        Parser.skipSpaces$(this);
        try {
            bl = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_".indexOf(this.buffer[this.offset]) >= 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Parser.readBuffer$(this) == 0) {
                return false;
            }
            return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_".indexOf(this.buffer[this.offset]) >= 0;
        }
        return bl;
    }

    public boolean isNumber() throws IOException {
        boolean bl;
        Parser.skipSpaces$(this);
        try {
            bl = "0123456789".indexOf(this.buffer[this.offset]) >= 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Parser.readBuffer$(this) == 0) {
                return false;
            }
            return "0123456789".indexOf(this.buffer[this.offset]) >= 0;
        }
        return bl;
    }

    public int readNumber() throws IOException {
        try {
            return Integer.parseInt(this.readWord());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    boolean isLongWord(String string) throws IOException {
        Parser.skipSpaces$(this);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            byte by;
            try {
                by = this.buffer[this.offset];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Parser.readBuffer$(this) != 0) continue;
                return false;
            }
            if (by == string.charAt(n)) continue;
            return false;
        }
        return true;
    }

    public boolean isWord(String string) throws IOException {
        Parser.skipSpaces$(this);
        int n = this.buffer.length - this.offset;
        int n2 = string.length();
        if (n < n2 && n + Parser.readBuffer$(this) < n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.buffer[this.offset + n3] == string.charAt(n3)) {
                return false;
            }
            ++n3;
        }
        this.offset += n2;
        return true;
    }

    public String readWord() throws IOException {
        Parser.skipSpaces$(this);
        int n = 0;
        while (true) {
            char c;
            try {
                c = this.buffer[this.offset];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Parser.readBuffer$(this) != 0) continue;
                break;
            }
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_".indexOf(c) < 0) break;
            ++this.offset;
            try {
                this.chars[n] = c;
                ++n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                char[] cArray = new char[this.chars.length << 1];
                System.arraycopy(this.chars, 0, cArray, 0, n);
                this.chars = cArray;
                this.chars[n++] = c;
            }
        }
        return new String(this.chars, 0, n);
    }

    public boolean eof() throws IOException {
        return this.buffer.length - this.offset == 0 && Parser.readBuffer$(this) < 1;
    }

    public int getLine() throws  {
        return this.line;
    }

    public int getPosition() throws  {
        return this.position - (this.buffer.length - this.offset);
    }

    static void skipSpaces$(Parser parser) throws IOException {
        while (true) {
            byte by;
            try {
                by = parser.buffer[parser.offset];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Parser.readBuffer$(parser) == 0) break;
                continue;
            }
            if (by > 32) break;
            ++parser.offset;
        }
    }

    static int readBuffer$(Parser parser) throws IOException {
        int n = parser.source.read(parser.readbuf, 0, parser.offset);
        if (n < 1) {
            return 0;
        }
        System.arraycopy(parser.buffer, parser.offset, parser.buffer, parser.offset - n, parser.buffer.length - parser.offset);
        System.arraycopy(parser.readbuf, 0, parser.buffer, parser.buffer.length - n, n);
        parser.offset -= n;
        parser.position += n;
        return n;
    }

    public Parser(InputStream inputStream) throws  {
        this.source = inputStream;
        this.line = 1;
        this.buffer = new byte[1024];
        this.readbuf = new byte[1024];
        this.offset = this.buffer.length;
    }
}

