/*
 * Decompiled with CFR 0.152.
 */
package mquest.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import mquest.util.Instruments;

public class SpkReader {
    InputStream source;
    byte[] buffer = new byte[4];
    String name;
    int length;

    public boolean hasMoreElements() throws  {
        return this.source != null && this.name != null;
    }

    public String getName() throws  {
        return this.name;
    }

    public int getLength() throws  {
        return this.length;
    }

    public byte[] readData() throws IOException {
        byte[] byArray = new byte[this.length];
        if (this.source.read(byArray) != byArray.length) {
            throw new EOFException();
        }
        SpkReader.getNextRecord$(this);
        return byArray;
    }

    public int readData(byte[] byArray) throws IOException {
        if (byArray.length != this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.source.read(byArray) != byArray.length) {
            throw new EOFException();
        }
        SpkReader.getNextRecord$(this);
        return byArray.length;
    }

    public int readData(byte[] byArray, int n, int n2) throws IOException {
        if (this.length != n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.source.read(byArray, n, n2) != n2) {
            throw new EOFException();
        }
        SpkReader.getNextRecord$(this);
        return n2;
    }

    static void getNextRecord$(SpkReader spkReader) throws  {
        if (spkReader.source != null && spkReader.length >= 0) {
            spkReader.name = null;
            spkReader.length = -1;
            try {
                if (spkReader.source.read(spkReader.buffer, 0, 2) != 2) {
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
            int n = (int)Instruments.makeReversed(spkReader.buffer, 0, 2);
            byte[] byArray = new byte[n << 1];
            try {
                if (spkReader.source.read(byArray) != byArray.length) {
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
            String string = new String(Instruments.bytesToCharsReversed(byArray));
            try {
                if (spkReader.source.read(spkReader.buffer, 0, 4) != 4) {
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
            spkReader.length = (int)Instruments.makeReversed(spkReader.buffer, 0, 4);
            spkReader.name = string;
        }
    }

    SpkReader() throws  {
    }

    public SpkReader(InputStream inputStream) throws  {
        this();
        this.source = inputStream;
        SpkReader.getNextRecord$(this);
    }
}

