/*
 * Decompiled with CFR 0.152.
 */
package db_ware.games.bottle;

import db_ware.games.bottle.BottleGame;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BottleScreen
extends Canvas
implements Runnable {
    BottleGame parent;
    int mode = 0;
    int width;
    int height;
    Image logoImage;
    int logoImageX = 0;
    int logoImageY = 0;
    Image[] blastixImages = new Image[12];
    int blastixImagesX = 0;
    int blastixImagesY = 0;
    Image[] bottleImages = new Image[8];
    int bottleImagesX = 0;
    int bottleImagesY = 0;
    Image gameLogo;
    int gameLogoX = 0;
    int gameLogoY = 0;
    boolean cleanup = true;
    int currentFrame = 0;
    int paintedFrame = 0;
    int maxFrame = 24;
    boolean animated = true;
    int sleeptime = 50;
    static Random rand = new Random();

    public BottleScreen(BottleGame game) {
        this.parent = game;
        try {
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.logoImage = Image.createImage((String)"/icomx.png");
            this.logoImageX = (this.width - this.logoImage.getWidth()) / 2;
            this.logoImageY = (this.height - this.logoImage.getHeight()) / 2;
            this.repaint();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        if (this.cleanup) {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.width, this.height);
            this.cleanup = false;
        }
        if (this.mode == 0) {
            g.drawImage(this.logoImage, this.logoImageX, this.logoImageY, 20);
        } else if (this.mode == 1) {
            g.drawImage(this.blastixImages[this.currentFrame], this.blastixImagesX, this.blastixImagesY, 20);
        } else if (this.mode == 2) {
            g.drawImage(this.bottleImages[this.currentFrame], this.bottleImagesX, this.bottleImagesY, 20);
        } else if (this.mode == 3) {
            g.drawImage(this.gameLogo, this.gameLogoX, this.gameLogoY, 20);
        }
    }

    void loadBlastixImages() {
        try {
            this.blastixImages[0] = Image.createImage((String)"/icomx.png");
            this.blastixImages[1] = Image.createImage((String)"/icomx.png");
            this.blastixImages[2] = Image.createImage((String)"/icomx.png");
            this.blastixImages[3] = Image.createImage((String)"/icomx.png");
            this.blastixImages[4] = Image.createImage((String)"/icomx.png");
            this.blastixImages[5] = Image.createImage((String)"/icomx.png");
            this.blastixImages[6] = Image.createImage((String)"/icomx.png");
            this.blastixImages[7] = this.blastixImages[5];
            this.blastixImages[8] = this.blastixImages[4];
            this.blastixImages[9] = this.blastixImages[3];
            this.blastixImages[10] = this.blastixImages[2];
            this.blastixImages[11] = this.blastixImages[1];
            this.blastixImagesX = (this.width - this.blastixImages[0].getWidth()) / 2;
            this.blastixImagesY = (this.height - this.blastixImages[0].getHeight()) / 2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void loadBottleImages() {
        try {
            this.bottleImages[0] = Image.createImage((String)"/b00.png");
            this.bottleImages[1] = Image.createImage((String)"/b01.png");
            this.bottleImages[2] = Image.createImage((String)"/b02.png");
            this.bottleImages[3] = Image.createImage((String)"/b03.png");
            this.bottleImages[4] = Image.createImage((String)"/b04.png");
            this.bottleImages[5] = Image.createImage((String)"/b05.png");
            this.bottleImages[6] = Image.createImage((String)"/b06.png");
            this.bottleImages[7] = Image.createImage((String)"/b07.png");
            this.bottleImagesX = (this.width - this.bottleImages[0].getWidth()) / 2;
            this.bottleImagesY = (this.height - this.bottleImages[0].getHeight()) / 2;
            this.gameLogo = Image.createImage((String)"/logo.png");
            this.gameLogoX = (this.width - this.gameLogo.getWidth()) / 2;
            this.gameLogoY = (this.height - this.gameLogo.getHeight()) / 2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.loadBlastixImages();
        this.mode = 1;
        this.cleanup = true;
        while (this.animated) {
            ++this.currentFrame;
            ++this.paintedFrame;
            if (this.currentFrame == this.blastixImages.length) {
                this.currentFrame = 0;
            }
            if (this.paintedFrame == this.maxFrame) {
                this.animated = false;
            }
            this.repaint();
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loadBottleImages();
        this.animated = true;
        this.cleanup = true;
        this.mode = 2;
        this.currentFrame = 0;
        this.paintedFrame = 0;
        this.maxFrame = 16;
        while (this.animated) {
            ++this.currentFrame;
            ++this.paintedFrame;
            if (this.currentFrame == this.bottleImages.length) {
                this.currentFrame = 0;
            }
            if (this.paintedFrame == this.maxFrame) {
                this.animated = false;
            }
            this.repaint();
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mode = 3;
        this.cleanup = true;
        this.parent.addMenu();
        this.repaint();
        while (true) {
            if (!this.animated) {
                continue;
            }
            ++this.currentFrame;
            ++this.paintedFrame;
            if (this.currentFrame == this.bottleImages.length) {
                this.currentFrame = 0;
            }
            if (this.paintedFrame == this.maxFrame) {
                this.animated = false;
            }
            this.repaint();
            try {
                this.sleeptime = (40 - this.maxFrame + this.paintedFrame) * 5;
                if (this.sleeptime < 20) {
                    this.sleeptime = 20;
                }
                Thread.sleep(this.sleeptime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void turnAgain() {
        this.animated = true;
        this.cleanup = true;
        this.mode = 2;
        this.currentFrame = 0;
        this.paintedFrame = 0;
        this.maxFrame = Math.abs(rand.nextInt()) % 30 + 40;
    }
}

