/*
 * Decompiled with CFR 0.152.
 */
package voxtr.ui;

import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import voxtr.controller.AudioController;
import voxtr.data.Recording;
import voxtr.service.RecordingService;
import voxtr.ui.MoreUI;
import voxtr.ui.RecorderUI;
import voxtr.ui.Showable;
import voxtr.util.Logger;

public class MainUI
implements CommandListener,
Showable {
    protected MIDlet mMidlet;
    protected Command mSelectCommand;
    protected Command mMoreCommand;
    protected List mList;
    protected Showable mRecorderUI;
    protected MoreUI mMoreUI;
    protected AudioController mAudioController;
    protected Recording[] mRecMeta;
    protected Image playImage;
    protected Image recordImage;

    public MainUI(MIDlet pMidlet) {
        this.mMidlet = pMidlet;
        this.mSelectCommand = new Command("Select", 4, 10);
        this.mMoreCommand = new Command("More", 6, 10);
        this.mList = new List("Voxtr (v0.4.0)", 3);
        this.mList.setSelectCommand(this.mSelectCommand);
        this.mList.addCommand(this.mMoreCommand);
        this.mList.setCommandListener((CommandListener)this);
        this.mAudioController = new AudioController();
        this.mMoreUI = new MoreUI(this.mMidlet, this);
        this.mRecorderUI = new RecorderUI(this.mMidlet, this, this.mAudioController);
        try {
            this.recordImage = Image.createImage((String)"/record.png");
            this.playImage = Image.createImage((String)"/play.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void show() {
        Displayable ui = this.updateUI();
        Display.getDisplay((MIDlet)this.mMidlet).setCurrent(ui);
    }

    public void commandAction(Command pCommand, Displayable pDisplayable) {
        if (pCommand == this.mSelectCommand) {
            int selected = this.mList.getSelectedIndex();
            if (selected == 0) {
                this.mRecorderUI.show();
            } else {
                int index = selected - 1;
                Recording meta = this.mRecMeta[index];
                long timestamp = meta.getStartTimeMillis();
                Recording rec = RecordingService.getRecording(timestamp);
                this.mAudioController.playSound(rec.getContentType(), rec.getData());
            }
        } else if (pCommand == this.mMoreCommand) {
            int selected = this.mList.getSelectedIndex();
            if (selected > 0) {
                Recording rec = this.mRecMeta[selected - 1];
                this.mMoreUI.setRecording(rec);
            } else {
                this.mMoreUI.setRecording(null);
            }
            this.mMoreUI.show();
        } else {
            this.log("WARNING! Unknown command was executed.");
        }
    }

    protected Displayable updateUI() {
        this.mList.deleteAll();
        this.mList.append("Record", this.recordImage);
        this.mRecMeta = RecordingService.getAllRecordingsMeta();
        int len = this.mRecMeta.length;
        for (int i = 0; i < len; ++i) {
            String name = this.mRecMeta[i].getName();
            this.mList.append(name, this.playImage);
        }
        return this.mList;
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

