/*
 * Decompiled with CFR 0.152.
 */
package voxtr.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import voxtr.util.Logger;

public class Recording {
    protected long mStartTimeMillis;
    protected long mStopTimeMillis;
    protected String mName;
    protected String mContentType;
    protected int mSize;
    protected byte[] mData;

    public Recording(long pStartTimeMillis, long pStopTimeMillis, String pName, String pContentType, byte[] pData) {
        this.mStartTimeMillis = pStartTimeMillis;
        this.mStopTimeMillis = pStopTimeMillis;
        this.mName = pName;
        this.mContentType = pContentType;
        this.mData = pData;
        this.mSize = pData != null ? pData.length : 0;
    }

    public Recording(byte[] pData, boolean pReadFully) {
        this.deserialize(pData, pReadFully);
    }

    public long getStartTimeMillis() {
        return this.mStartTimeMillis;
    }

    public long getStopTimeMillis() {
        return this.mStopTimeMillis;
    }

    public String getName() {
        return this.mName;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public int getSize() {
        return this.mSize;
    }

    public byte[] getData() {
        return this.mData;
    }

    public byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(this.mStartTimeMillis);
            dos.writeLong(this.mStopTimeMillis);
            dos.writeUTF(this.mName);
            dos.writeUTF(this.mContentType);
            if (this.mData != null) {
                dos.writeInt(this.mSize);
                dos.writeBoolean(true);
                dos.write(this.mData, 0, this.mSize);
            } else {
                dos.writeInt(0);
                dos.writeBoolean(false);
                this.log("WARNING! Recording has no data, only metadata.");
            }
            return baos.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void deserialize(byte[] pRawData, boolean pReadFully) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pRawData);
        DataInputStream dis = new DataInputStream(bais);
        try {
            this.mStartTimeMillis = dis.readLong();
            this.mStopTimeMillis = dis.readLong();
            this.mName = dis.readUTF();
            this.mContentType = dis.readUTF();
            this.mSize = dis.readInt();
            boolean isDataAvailable = dis.readBoolean();
            if (isDataAvailable && pReadFully) {
                this.mData = new byte[this.mSize];
                int len = dis.read(this.mData, 0, this.mSize);
                if (len != this.mSize) {
                    this.log("WARNING. Less bytes read than expected.");
                }
            } else {
                this.mData = null;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

