/*
 * Decompiled with CFR 0.152.
 */
package voxtr.ui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.sf.microinstall.SmsInstaller;
import voxtr.ui.Showable;
import voxtr.util.Logger;

public class SendUI
implements CommandListener,
Showable {
    protected static final String SMS_TEXT = "Your friend recommends you to try out Voxtr, The Voice Recorder. Follow this link to install Voxtr:   ";
    protected static final String URL_TO_JAD_FILE = "http://voxtr.googlecode.com/files/voxtr.jad";
    protected MIDlet mMidlet;
    protected Showable mBackUI;
    protected Form mForm;
    protected TextField mPhoneTextField;
    protected Command mSendCommand;
    protected Command mBackCommand;
    protected SmsInstaller installer;

    public SendUI(MIDlet pMidlet, Showable pBackUI) {
        this.mMidlet = pMidlet;
        this.mBackUI = pBackUI;
        this.mForm = new Form("Share Voxtr");
        this.mForm.append("To share Voxtr via SMS enter your friend's phone number and press Send.");
        this.mPhoneTextField = new TextField("Phone number", "", 30, 3);
        this.mForm.append((Item)this.mPhoneTextField);
        this.mSendCommand = new Command("Send", 4, 10);
        this.mBackCommand = new Command("Back", 2, 10);
        this.mForm.addCommand(this.mSendCommand);
        this.mForm.addCommand(this.mBackCommand);
        this.mForm.setCommandListener((CommandListener)this);
        this.installer = new SmsInstaller();
    }

    public void show() {
        Displayable ui = this.updateUI();
        Display.getDisplay((MIDlet)this.mMidlet).setCurrent(ui);
    }

    public void commandAction(Command pCommand, Displayable pDisplayable) {
        if (pCommand == this.mSendCommand) {
            String phoneNo = this.mPhoneTextField.getString();
            if (phoneNo != null && phoneNo.length() > 1) {
                this.installer.install(phoneNo, SMS_TEXT, URL_TO_JAD_FILE);
                this.info("SMS Info", "SMS is now being sent to your friend.");
            } else {
                this.info("Attention", "Phone number missing. Please enter a phone number.");
            }
        } else if (pCommand == this.mBackCommand) {
            this.mBackUI.show();
        } else {
            this.log("WARNING! Unknown command was executed.");
        }
    }

    protected Displayable updateUI() {
        return this.mForm;
    }

    protected void info(String pTitle, String pMessage) {
        Alert info = new Alert(pTitle, pMessage, null, AlertType.INFO);
        info.setTimeout(-2);
        Display.getDisplay((MIDlet)this.mMidlet).setCurrent((Displayable)info);
    }

    protected void log(String pMessage) {
        Logger.log(this, pMessage);
    }
}

