/*
 * Decompiled with CFR 0.152.
 */
package zip;

public class IntShortHashMap {
    public static final int DEFAULT_LOAD_FACTOR = 75;
    public static final int SUB_ELEMENT_SIZE = 3;
    private final int loadFactor;
    private Element[] buckets;
    private final boolean isPowerOfTwo;
    private int size;

    public IntShortHashMap(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public IntShortHashMap(int initialCapacity, int loadFactor) {
        initialCapacity = initialCapacity * 100 / loadFactor;
        int capacity = 1;
        while (initialCapacity > capacity) {
            capacity <<= 1;
        }
        this.isPowerOfTwo = capacity == initialCapacity;
        this.buckets = new Element[initialCapacity];
        this.loadFactor = loadFactor;
    }

    public boolean put(int key, short value) {
        int index;
        Element element;
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        if ((element = this.buckets[index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length]) == null) {
            element = new Element(key, new short[3]);
            element.values[0] = value;
            element.size = (short)(element.size + 1);
            this.buckets[index] = element;
            ++this.size;
            return true;
        }
        Element lastElement = element;
        do {
            if (element.key == key) {
                element.size = (short)(element.size + 1);
                if (element.size == element.values.length) {
                    short[] newValues = new short[element.values.length * 2];
                    System.arraycopy(element.values, 0, newValues, 0, element.values.length);
                    element.values = newValues;
                }
                element.values[element.size - 1] = value;
                return true;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        element = new Element(key, new short[3]);
        element.values[0] = value;
        element.size = (short)(element.size + 1);
        this.buckets[index] = element;
        ++this.size;
        lastElement.next = element;
        return true;
    }

    public Element get(int key) {
        int index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        do {
            if (element.key != key) continue;
            return element;
        } while ((element = element.next) != null);
        return null;
    }

    public short remove(int key) {
        int index = this.isPowerOfTwo ? key & Integer.MAX_VALUE & this.buckets.length - 1 : (key & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return -1;
        }
        Element lastElement = null;
        do {
            if (element.key == key) {
                if (lastElement == null) {
                    this.buckets[index] = element.next;
                } else {
                    lastElement.next = element.next;
                }
                --this.size;
                return 1;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    public void clear() {
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public int[] keys() {
        int[] keys = new int[this.size];
        int index = 0;
        int i = 0;
        while (i < this.buckets.length) {
            Element element = this.buckets[i];
            while (element != null) {
                keys[index] = element.key;
                ++index;
                element = element.next;
            }
            ++i;
        }
        return keys;
    }

    /*
     * Unable to fully structure code
     */
    private void increaseSize() {
        newCapacity = this.isPowerOfTwo != false ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        newBuckets = new Element[newCapacity];
        i = 0;
        while (i < this.buckets.length) {
            element = this.buckets[i];
            while (element != null) {
                block3: {
                    index = this.isPowerOfTwo != false ? element.key & 0x7FFFFFFF & newCapacity - 1 : (element.key & 0x7FFFFFFF) % newCapacity;
                    newElement = newBuckets[index];
                    if (newElement != null) ** GOTO lbl13
                    newBuckets[index] = element;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        newElement = newElement.next;
lbl13:
                        // 2 sources

                        ** while (newElement.next != null)
                    }
lbl14:
                    // 1 sources

                    newElement.next = element;
                }
                lastElement = element;
                element = element.next;
                lastElement.next = null;
            }
            ++i;
        }
        this.buckets = newBuckets;
    }

    public static final class Element {
        public final int key;
        public short[] values;
        public short size;
        public Element next;

        public Element(int key, short[] value) {
            this.key = key;
            this.values = value;
        }
    }
}

