/*
 * Decompiled with CFR 0.152.
 */
package cn.agrj.rsRk.zip;

import cn.agrj.rsRk.zip.HuffmanTree;
import cn.agrj.rsRk.zip.PendingBuffer;

class DeflaterHuffman {
    private static final byte[] BL_ORDER;
    private static final byte[] bit4Reverse;
    private static short[] staticLCodes;
    private static short[] staticDCodes;
    private static byte[] staticLLength;
    private static byte[] staticDLength;
    private PendingBuffer pending;
    private HuffmanTree literalTree;
    private HuffmanTree distTree;
    private HuffmanTree blTree;
    private short[] d_buf;
    private byte[] l_buf;
    private int last_lit;
    private int extra_bits;
    public int litMax = 3884;

    static {
        byte[] byArray = new byte[19];
        byArray[0] = 16;
        byArray[1] = 17;
        byArray[2] = 18;
        byArray[4] = 8;
        byArray[5] = 7;
        byArray[6] = 9;
        byArray[7] = 6;
        byArray[8] = 10;
        byArray[9] = 5;
        byArray[10] = 11;
        byArray[11] = 4;
        byArray[12] = 12;
        byArray[13] = 3;
        byArray[14] = 13;
        byArray[15] = 2;
        byArray[16] = 14;
        byArray[17] = 1;
        byArray[18] = 15;
        BL_ORDER = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[1] = 8;
        byArray2[2] = 4;
        byArray2[3] = 12;
        byArray2[4] = 2;
        byArray2[5] = 10;
        byArray2[6] = 6;
        byArray2[7] = 14;
        byArray2[8] = 1;
        byArray2[9] = 9;
        byArray2[10] = 5;
        byArray2[11] = 13;
        byArray2[12] = 3;
        byArray2[13] = 11;
        byArray2[14] = 7;
        byArray2[15] = 15;
        bit4Reverse = byArray2;
        staticLCodes = new short[286];
        staticLLength = new byte[286];
        int i = 0;
        while (i < 144) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(48 + i << 8);
            DeflaterHuffman.staticLLength[i++] = 8;
        }
        while (i < 256) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(256 + i << 7);
            DeflaterHuffman.staticLLength[i++] = 9;
        }
        while (i < 280) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(-256 + i << 9);
            DeflaterHuffman.staticLLength[i++] = 7;
        }
        while (i < 286) {
            DeflaterHuffman.staticLCodes[i] = DeflaterHuffman.bitReverse(-88 + i << 8);
            DeflaterHuffman.staticLLength[i++] = 8;
        }
        staticDCodes = new short[30];
        staticDLength = new byte[30];
        i = 0;
        while (i < 30) {
            DeflaterHuffman.staticDCodes[i] = DeflaterHuffman.bitReverse(i << 11);
            DeflaterHuffman.staticDLength[i] = 5;
            ++i;
        }
    }

    static short bitReverse(int value) {
        return (short)(bit4Reverse[value & 0xF] << 12 | bit4Reverse[value >> 4 & 0xF] << 8 | bit4Reverse[value >> 8 & 0xF] << 4 | bit4Reverse[value >> 12]);
    }

    public DeflaterHuffman(PendingBuffer pen) {
        this.pending = pen;
        this.literalTree = new HuffmanTree(286, 257, 15, this.pending);
        this.distTree = new HuffmanTree(30, 1, 15, this.pending);
        this.blTree = new HuffmanTree(19, 4, 7, this.pending);
        this.d_buf = new short[this.litMax];
        this.l_buf = new byte[this.litMax];
    }

    public void reset() {
        this.last_lit = 0;
        this.extra_bits = 0;
        this.literalTree.reset();
        this.distTree.reset();
        this.blTree.reset();
    }

    private int l_code(int len) {
        if (len == 255) {
            return 285;
        }
        int code = 257;
        while (len >= 8) {
            code += 4;
            len >>= 1;
        }
        return code + len;
    }

    private int d_code(int distance) {
        int code = 0;
        while (distance >= 4) {
            code += 2;
            distance >>= 1;
        }
        return code + distance;
    }

    public void sendAllTrees(int blTreeCodes) {
        this.blTree.buildCodes();
        this.literalTree.buildCodes();
        this.distTree.buildCodes();
        this.pending.writeBits(this.literalTree.numCodes - 257, 5);
        this.pending.writeBits(this.distTree.numCodes - 1, 5);
        this.pending.writeBits(blTreeCodes - 4, 4);
        int rank = 0;
        while (rank < blTreeCodes) {
            this.pending.writeBits(this.blTree.length[BL_ORDER[rank]], 3);
            ++rank;
        }
        this.literalTree.writeTree(this.blTree);
        this.distTree.writeTree(this.blTree);
    }

    public void compressBlock() {
        int i = 0;
        while (i < this.last_lit) {
            int litlen = this.l_buf[i] & 0xFF;
            int dist = this.d_buf[i];
            if (dist-- != 0) {
                int lc = this.l_code(litlen);
                this.literalTree.writeSymbol(lc);
                int bits = (lc - 261) / 4;
                if (bits > 0 && bits <= 5) {
                    this.pending.writeBits(litlen & (1 << bits) - 1, bits);
                }
                int dc = this.d_code(dist);
                this.distTree.writeSymbol(dc);
                bits = dc / 2 - 1;
                if (bits > 0) {
                    this.pending.writeBits(dist & (1 << bits) - 1, bits);
                }
            } else {
                this.literalTree.writeSymbol(litlen);
            }
            ++i;
        }
        this.literalTree.writeSymbol(256);
    }

    public void flushStoredBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        this.pending.writeBits(lastBlock ? 1 : 0, 3);
        this.pending.alignToByte();
        this.pending.writeShort(stored_len);
        this.pending.writeShort(~stored_len);
        this.pending.writeBlock(stored, stored_offset, stored_len);
        this.reset();
    }

    public void flushBlock(byte[] stored, int stored_offset, int stored_len, boolean lastBlock) {
        this.literalTree.freqs[256] = (short)(this.literalTree.freqs[256] + 1);
        this.literalTree.buildTree();
        this.distTree.buildTree();
        this.literalTree.calcBLFreq(this.blTree);
        this.distTree.calcBLFreq(this.blTree);
        this.blTree.buildTree();
        int blTreeCodes = 4;
        int i = 18;
        while (i > blTreeCodes) {
            if (this.blTree.length[BL_ORDER[i]] > 0) {
                blTreeCodes = i + 1;
            }
            --i;
        }
        int opt_len = 14 + blTreeCodes * 3 + this.blTree.getEncodedLength() + this.literalTree.getEncodedLength() + this.distTree.getEncodedLength() + this.extra_bits;
        int static_len = this.extra_bits;
        int i2 = 0;
        while (i2 < 286) {
            static_len += this.literalTree.freqs[i2] * staticLLength[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 30) {
            static_len += this.distTree.freqs[i2] * staticDLength[i2];
            ++i2;
        }
        if (opt_len >= static_len) {
            opt_len = static_len;
        }
        if (stored_offset >= 0 && stored_len + 4 < opt_len >> 3) {
            this.flushStoredBlock(stored, stored_offset, stored_len, lastBlock);
        } else if (opt_len == static_len) {
            this.pending.writeBits(2 + (lastBlock ? 1 : 0), 3);
            this.literalTree.setStaticCodes(staticLCodes, staticLLength);
            this.distTree.setStaticCodes(staticDCodes, staticDLength);
            this.compressBlock();
            this.reset();
        } else {
            this.pending.writeBits(4 + (lastBlock ? 1 : 0), 3);
            this.sendAllTrees(blTreeCodes);
            this.compressBlock();
            this.reset();
        }
    }

    public boolean isFull() {
        return this.last_lit == this.litMax;
    }

    public boolean tallyLit(int lit) {
        this.d_buf[this.last_lit] = 0;
        this.l_buf[this.last_lit++] = (byte)lit;
        int n = lit;
        this.literalTree.freqs[n] = (short)(this.literalTree.freqs[n] + 1);
        return this.last_lit == this.litMax;
    }

    public boolean tallyDist(int dist, int len) {
        int dc;
        int lc;
        this.d_buf[this.last_lit] = (short)dist;
        this.l_buf[this.last_lit++] = (byte)(len - 3);
        int n = lc = this.l_code(len - 3);
        this.literalTree.freqs[n] = (short)(this.literalTree.freqs[n] + 1);
        if (lc >= 265 && lc < 285) {
            this.extra_bits += (lc - 261) / 4;
        }
        int n2 = dc = this.d_code(dist - 1);
        this.distTree.freqs[n2] = (short)(this.distTree.freqs[n2] + 1);
        if (dc >= 4) {
            this.extra_bits += dc / 2 - 1;
        }
        return this.last_lit == 16384;
    }
}

