package com.mobilebasic;

/*
 * Mobile BASIC 1.9 Copyright (c) 2003-2010, David Firth
 *
 * This software is released as Open Source and you are free to modify it
 * and build derived versions for your own use. If you have made any changes
 * that you would like included in the main version then they should be
 * sent to the address below.
 *
 * Patches: E-mail to david@mobilebasic.com
 * Website: http://www.mobilebasic.com/
 */

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Date;
import java.util.Enumeration;

public abstract interface BasicSupport
{
    /*
     * GUI Callback Methods
     */

    abstract void Message(String msg);
    abstract void Error(String msg);

    /*
     * BASIC Program's Callback Methods
     */

    abstract void OpenFile(int iocb, String filename, boolean readOnly);
    abstract void CloseFile(int iocb);
    abstract void CloseAllFiles();
    abstract int Note(int iocb);
    abstract void Point(int iocb, int record);
    abstract DataInput GetDataInputChannel(int iocb);
    abstract DataOutput GetDataOutputChannel(int iocb);
    abstract void PutByte (int iocb, int byteValue);
    abstract void PutInt (int iocb, int intValue);
    abstract void PutString(int iocb, String s);
    abstract int GetByte (int iocb);
    abstract int GetInt (int iocb);
    abstract String GetString (int iocb);
    abstract void PrintString(String string);   // canvas.printString(string)
    abstract void CLS();
    abstract void DrawLine(int fromX, int fromY, int toX, int toY);
    abstract void FillRect(int x, int y, int w, int h);
    abstract void DrawRect(int x, int y, int w, int h);
    abstract void FillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight);
    abstract void DrawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight);
    abstract void FillArc(int x, int y, int w, int h, int startAngle, int arcAngle);
    abstract void DrawArc(int x, int y, int w, int h, int startAngle, int arcAngle);
    abstract void SetColor(int r, int g, int b);
    abstract void GelLoad(String gelName, String resourceName);
    abstract void GelGrab(String gelName, int x, int y, int w, int h);
    abstract int GelWidth(String gelName);
    abstract int GelHeight(String gelName);
    abstract void DrawGel(String gelName, int x, int y);
    abstract void SpriteGEL(String spriteName, String gelName);
    abstract void SpriteMove(String spriteName, int x, int y);
    abstract int SpriteHit(String spriteName1, String spriteName2);
    abstract void Blit(int fromX, int fromY, int w, int h, int toX, int toY);
    abstract void DrawString(String s, int x, int y);
    abstract int ScreenWidth();
    abstract int ScreenHeight();
    abstract int isColor();
    abstract int NumColors();
    abstract int StringWidth(String s);
    abstract int StringHeight(String s);
    abstract int Up();
    abstract int Down();
    abstract int Left();
    abstract int Right();
    abstract int Fire();
    abstract int GameA();
    abstract int GameB();
    abstract int GameC();
    abstract int GameD();
    abstract int Year(Date date);
    abstract int Month(Date date);
    abstract int Day(Date date);
    abstract int Hour(Date date);
    abstract int Minute(Date date);
    abstract int Second(Date date);
    abstract int Millisecond(Date date);
    abstract Enumeration Directory(String filter);
    abstract String GetLine(String prompt, String defaultText);
    abstract void Bye();
    abstract void Delete(String filename);
    abstract String EditForm(String formTitle, String proceedText, String cancelText, String label, String defaultText, int maxLen, int mode);
    abstract Date DateForm(String formTitle, String proceedText, String cancelText, String label, Date date, int mode);
    abstract int ChoiceForm(String formTitle, String proceedText, String cancelText, String label, String[] stringArray, int mode);
    abstract int GaugeForm(String formTitle, String proceedText, String cancelText, String label, int maxValue, int initialValue, int mode);
    abstract int MessageForm(String formTitle, String proceedText, String cancelText, String label, String msg);
}
