/*
 * Decompiled with CFR 0.152.
 */
public class QuickLZ {
    public final int QLZ_COMPRESSION_LEVEL;
    public final int QLZ_STREAMING_BUFFER;
    public final int QLZ_MEMORY_SAFE;
    public final int QLZ_VERSION_MAJOR;
    public final int QLZ_VERSION_MINOR;
    public final int QLZ_VERSION_REVISION;
    private static final int HASH_VALUES = 4096;
    private static final int MINOFFSET = 2;
    private static final int UNCONDITIONAL_MATCHLEN = 6;
    private static final int UNCOMPRESSED_END = 4;
    private static final int CWORD_LEN = 4;
    private static final int HEADER_LEN = 9;

    public QuickLZ() {
        this.QLZ_COMPRESSION_LEVEL = 1;
        this.QLZ_STREAMING_BUFFER = 0;
        this.QLZ_MEMORY_SAFE = 0;
        this.QLZ_VERSION_MAJOR = 1;
        this.QLZ_VERSION_MINOR = 4;
        this.QLZ_VERSION_REVISION = -1;
    }

    public byte[] Compress(byte[] source) {
        int src = 0;
        int dst = 13;
        long cword_val = 0x80000000L;
        int cword_ptr = 9;
        byte[] destination = new byte[source.length + 400];
        int[] hashtable = new int[4096];
        int[] cachetable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int last_matchstart = source.length - 6 - 4 - 1;
        int fetch = (int)this.fastreadN(source, src, 3);
        while (src <= last_matchstart) {
            if ((cword_val & 1L) == 1L) {
                if (src > 3 * (source.length >> 2) && dst > src - (src >> 5)) {
                    byte[] d2 = new byte[source.length + 9];
                    d2[0] = 2;
                    this.fastwriteN(d2, 1, source.length + 9, 4);
                    this.fastwriteN(d2, 5, source.length, 4);
                    System.arraycopy(source, 0, d2, 9, source.length);
                    return d2;
                }
                this.fastwriteN(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            int hash = (fetch >>> 12 ^ fetch) & 0xFFF;
            int o = hashtable[hash];
            int cache = cachetable[hash] ^ fetch;
            cachetable[hash] = fetch;
            hashtable[hash] = src;
            if (cache == 0 && src - o > 2 && hash_counter[hash] != 0) {
                cword_val = cword_val >>> 1 | 0x80000000L;
                if (source[o + 3] != source[src + 3]) {
                    int f = 1 | hash << 4;
                    destination[dst + 0] = (byte)(f >>> 0);
                    destination[dst + 1] = (byte)(f >>> 8);
                    src += 3;
                    dst += 2;
                } else {
                    int f;
                    int remaining;
                    int old_src = src;
                    int n = remaining = source.length - 4 - src + 1 - 1 > 255 ? 255 : source.length - 4 - src + 1 - 1;
                    if (source[o + (src += 4) - old_src] == source[src] && source[o + ++src - old_src] == source[src]) {
                        ++src;
                        while (source[o + (src - old_src)] == source[src] && src - old_src < remaining) {
                            ++src;
                        }
                    }
                    int matchlen = src - old_src;
                    hash <<= 4;
                    if (matchlen < 18) {
                        f = hash | matchlen - 2;
                        destination[dst + 0] = (byte)(f >>> 0);
                        destination[dst + 1] = (byte)(f >>> 8);
                        dst += 2;
                    } else {
                        f = hash | matchlen << 16;
                        this.fastwriteN(destination, dst, f, 3);
                        dst += 3;
                    }
                }
                fetch = (int)this.fastreadN(source, src, 3);
                continue;
            }
            hash_counter[hash] = 1;
            destination[dst] = source[src];
            cword_val >>>= 1;
            ++dst;
            fetch = fetch >>> 8 & 0xFFFF | (source[++src + 2] & 0xFF) << 16;
        }
        while (src <= source.length - 1) {
            if ((cword_val & 1L) == 1L) {
                this.fastwriteN(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
                cword_ptr = dst;
                dst += 4;
                cword_val = 0x80000000L;
            }
            destination[dst] = source[src];
            ++src;
            ++dst;
            cword_val >>>= 1;
        }
        while ((cword_val & 1L) != 1L) {
            cword_val >>>= 1;
        }
        this.fastwriteN(destination, cword_ptr, cword_val >>> 1 | 0x80000000L, 4);
        destination[0] = 3;
        this.fastwriteN(destination, 1, dst, 4);
        this.fastwriteN(destination, 5, source.length, 4);
        byte[] d2 = new byte[dst];
        System.arraycopy(destination, 0, d2, 0, dst);
        return d2;
    }

    long fastreadN(byte[] a, int i, int n) {
        long l = 0L;
        switch (n) {
            case 3: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                l |= ((long)a[i + 2] & 0xFFL) << 16;
                break;
            }
            case 2: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                break;
            }
            case 1: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                break;
            }
            case 4: {
                l |= ((long)a[i + 0] & 0xFFL) << 0;
                l |= ((long)a[i + 1] & 0xFFL) << 8;
                l |= ((long)a[i + 2] & 0xFFL) << 16;
                l |= ((long)a[i + 3] & 0xFFL) << 24;
            }
        }
        return l;
    }

    void fastwriteN(byte[] a, int i, long N, int n) {
        switch (n) {
            case 3: {
                a[i] = (byte)N;
                a[i + 1] = (byte)(N >>> 8);
                a[i + 2] = (byte)(N >>> 16);
                break;
            }
            case 2: {
                a[i] = (byte)N;
                a[i + 1] = (byte)(N >>> 8);
                break;
            }
            case 4: {
                a[i] = (byte)N;
                a[i + 1] = (byte)(N >>> 8);
                a[i + 2] = (byte)(N >>> 16);
                a[i + 3] = (byte)(N >>> 24);
            }
        }
    }

    public byte[] Decompress(byte[] source) {
        int size = (int)this.fastreadN(source, 5, 4);
        int src = 9;
        int dst = 0;
        long cword_val = 1L;
        byte[] destination = new byte[size];
        int[] hashtable = new int[4096];
        byte[] hash_counter = new byte[4096];
        int last_matchstart = size - 6 - 4 - 1;
        int last_hashed = -1;
        int fetch = 0;
        if ((source[0] & 1) != 1) {
            byte[] d2 = new byte[size];
            System.arraycopy(source, 9, d2, 0, size);
            return d2;
        }
        while (true) {
            int hash;
            if (cword_val == 1L) {
                cword_val = this.fastreadN(source, src, 4);
                fetch = (int)this.fastreadN(source, src += 4, 3);
            }
            if ((cword_val & 1L) == 1L) {
                int matchlen;
                cword_val >>>= 1;
                hash = fetch >>> 4 & 0xFFF;
                int offset2 = hashtable[hash];
                if ((fetch & 0xF) != 0) {
                    matchlen = (fetch & 0xF) + 2;
                    src += 2;
                } else {
                    matchlen = source[src + 2] & 0xFF;
                    src += 3;
                }
                destination[dst + 0] = destination[offset2 + 0];
                destination[dst + 1] = destination[offset2 + 1];
                destination[dst + 2] = destination[offset2 + 2];
                for (int i = 3; i < matchlen; ++i) {
                    destination[dst + i] = destination[offset2 + i];
                }
                dst += matchlen;
                fetch = (int)this.fastreadN(destination, last_hashed + 1, 3);
                while (last_hashed < dst - matchlen) {
                    hash = (fetch >>> 12 ^ fetch) & 0xFFF;
                    hashtable[hash] = ++last_hashed;
                    hash_counter[hash] = 1;
                    fetch = fetch >>> 8 & 0xFFFF | (destination[last_hashed + 3] & 0xFF) << 16;
                }
                last_hashed = dst - 1;
                fetch = (int)this.fastreadN(source, src, 3);
                continue;
            }
            if (dst > last_matchstart) break;
            destination[dst] = source[src];
            ++dst;
            ++src;
            cword_val >>>= 1;
            while (last_hashed < dst - 3) {
                int fetch2 = (int)this.fastreadN(destination, ++last_hashed, 3);
                hash = (fetch2 >>> 12 ^ fetch2) & 0xFFF;
                hashtable[hash] = last_hashed;
                hash_counter[hash] = 1;
            }
            fetch = fetch >> 8 & 0xFFFF | (source[src + 2] & 0xFF) << 16;
        }
        while (dst <= size - 1) {
            if (cword_val == 1L) {
                src += 4;
                cword_val = 0x80000000L;
            }
            destination[dst] = source[src];
            ++dst;
            ++src;
            cword_val >>>= 1;
        }
        byte[] d2 = new byte[size];
        System.arraycopy(destination, 0, d2, 0, size);
        return d2;
    }
}

