/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.driver.SoundDriver;

public final class Sound {
    public static final int GAMEBOY_CLOCK = 0x100000;
    public static final int SOUND_CLOCK = 256;
    public static final int NR10 = 65296;
    public static final int NR11 = 65297;
    public static final int NR12 = 65298;
    public static final int NR13 = 65299;
    public static final int NR14 = 65300;
    public static final int NR21 = 65302;
    public static final int NR22 = 65303;
    public static final int NR23 = 65304;
    public static final int NR24 = 65305;
    public static final int NR30 = 65306;
    public static final int NR31 = 65307;
    public static final int NR32 = 65308;
    public static final int NR33 = 65309;
    public static final int NR34 = 65310;
    public static final int NR41 = 65312;
    public static final int NR42 = 65313;
    public static final int NR43 = 65314;
    public static final int NR44 = 65315;
    public static final int NR50 = 65316;
    public static final int NR51 = 65317;
    public static final int NR52 = 65318;
    public static final int AUD3WAVERAM = 65328;
    private int nr10;
    private int nr11;
    private int nr12;
    private int nr13;
    private int nr14;
    private int audio1Index;
    private int audio1Length;
    private int audio1Volume;
    private int audio1EnvelopeLength;
    private int audio1SweepLength;
    private int audio1Frequency;
    private int nr21;
    private int nr22;
    private int nr23;
    private int nr24;
    private int audio2Index;
    private int audio2Length;
    private int audio2Volume;
    private int audio2EnvelopeLength;
    private int audio2Frequency;
    private int nr30;
    private int nr31;
    private int nr32;
    private int nr33;
    private int nr34;
    private int audio3Index;
    private int audio3Length;
    private int audio3Frequency;
    private byte[] audio3WavePattern = new byte[16];
    private int nr41;
    private int nr42;
    private int nr43;
    private int nr44;
    private int audio4Index;
    private int audio4Length;
    private int audio4Volume;
    private int audio4EnvelopeLength;
    private int audio4Frequency;
    private int nr50;
    private int nr51;
    private int nr52;
    private SoundDriver driver;
    private byte[] buffer = new byte[512];
    private int frames;
    private int cycles;
    private int[] frequencyTable = new int[2048];
    private int[] noiseFreqRatioTable = new int[8];
    private int[] noiseStep7Table = new int[4];
    private int[] noiseStep15Table = new int[1024];

    public Sound(SoundDriver soundDriver) {
        this.driver = soundDriver;
        this.generateFrequencyTables();
        this.generateNoiseTables();
        this.reset();
    }

    public final void start() {
        this.driver.start();
    }

    public final void stop() {
        this.driver.stop();
    }

    public final int cycles() {
        return this.cycles;
    }

    public final void emulate(int ticks) {
        this.cycles -= ticks;
        while (this.cycles <= 0) {
            this.updateAudio();
            if (this.driver.isEnabled()) {
                this.frames += this.driver.getSampleRate();
                int length = this.frames / 256 << 1;
                this.mixAudio(this.buffer, length);
                this.driver.write(this.buffer, length);
                this.frames %= 256;
            }
            this.cycles += 4096;
        }
    }

    public final void reset() {
        this.cycles = 4096;
        this.frames = 0;
        this.audio4Index = 0;
        this.audio3Index = 0;
        this.audio2Index = 0;
        this.audio1Index = 0;
        this.write(65296, 128);
        this.write(65297, 63);
        this.write(65298, 0);
        this.write(65299, 255);
        this.write(65300, 191);
        this.write(65302, 63);
        this.write(65303, 0);
        this.write(65304, 255);
        this.write(65305, 191);
        this.write(65306, 127);
        this.write(65307, 255);
        this.write(65308, 159);
        this.write(65309, 255);
        this.write(65310, 191);
        this.write(65312, 255);
        this.write(65313, 0);
        this.write(65314, 0);
        this.write(65315, 191);
        this.write(65316, 0);
        this.write(65317, 240);
        this.write(65318, 255);
        for (int address = 65328; address <= 65343; ++address) {
            this.write(address, (address & 1) == 0 ? 0 : 255);
        }
    }

    public final int read(int address) {
        switch (address) {
            case 65296: {
                return this.getAudio1Sweep();
            }
            case 65297: {
                return this.getAudio1Length();
            }
            case 65298: {
                return this.getAudio1Envelope();
            }
            case 65299: {
                return this.getAudio1Frequency();
            }
            case 65300: {
                return this.getAudio1Playback();
            }
            case 65302: {
                return this.getAudio2Length();
            }
            case 65303: {
                return this.getAudio2Envelope();
            }
            case 65304: {
                return this.getAudio2Frequency();
            }
            case 65305: {
                return this.getAudio2Playback();
            }
            case 65306: {
                return this.getAudio3Enable();
            }
            case 65307: {
                return this.getAudio3Length();
            }
            case 65308: {
                return this.getAudio3Level();
            }
            case 65309: {
                return this.getAudio4Frequency();
            }
            case 65310: {
                return this.getAudio3Playback();
            }
            case 65312: {
                return this.getAudio4Length();
            }
            case 65313: {
                return this.getAudio4Envelope();
            }
            case 65314: {
                return this.getAudio4Polynomial();
            }
            case 65315: {
                return this.getAudio4Playback();
            }
            case 65316: {
                return this.getOutputLevel();
            }
            case 65317: {
                return this.getOutputTerminal();
            }
            case 65318: {
                return this.getOutputEnable();
            }
        }
        if (address >= 65328 && address <= 65391) {
            return this.getAudio3WavePattern(address);
        }
        return 255;
    }

    public final void write(int address, int data) {
        switch (address) {
            case 65296: {
                this.setAudio1Sweep(data);
                break;
            }
            case 65297: {
                this.setAudio1Length(data);
                break;
            }
            case 65298: {
                this.setAudio1Envelope(data);
                break;
            }
            case 65299: {
                this.setAudio1Frequency(data);
                break;
            }
            case 65300: {
                this.setAudio1Playback(data);
                break;
            }
            case 65302: {
                this.setAudio2Length(data);
                break;
            }
            case 65303: {
                this.setAudio2Envelope(data);
                break;
            }
            case 65304: {
                this.setAudio2Frequency(data);
                break;
            }
            case 65305: {
                this.setAudio2Playback(data);
                break;
            }
            case 65306: {
                this.setAudio3Enable(data);
                break;
            }
            case 65307: {
                this.setAudio3Length(data);
                break;
            }
            case 65308: {
                this.setAudio3Level(data);
                break;
            }
            case 65309: {
                this.setAudio3Frequency(data);
                break;
            }
            case 65310: {
                this.setAudio3Playback(data);
                break;
            }
            case 65312: {
                this.setAudio4Length(data);
                break;
            }
            case 65313: {
                this.setAudio4Envelope(data);
                break;
            }
            case 65314: {
                this.setAudio4Polynomial(data);
                break;
            }
            case 65315: {
                this.setAudio4Playback(data);
                break;
            }
            case 65316: {
                this.setOutputLevel(data);
                break;
            }
            case 65317: {
                this.setOutputTerminal(data);
                break;
            }
            case 65318: {
                this.setOutputEnable(data);
                break;
            }
            default: {
                if (address < 65328 || address > 65391) break;
                this.setAudio3WavePattern(address, data);
            }
        }
    }

    private final void updateAudio() {
        if ((this.nr52 & 0x80) != 0) {
            if ((this.nr52 & 1) != 0) {
                this.updateAudio1();
            }
            if ((this.nr52 & 2) != 0) {
                this.updateAudio2();
            }
            if ((this.nr52 & 4) != 0) {
                this.updateAudio3();
            }
            if ((this.nr52 & 8) != 0) {
                this.updateAudio4();
            }
        }
    }

    private final void mixAudio(byte[] buffer, int length) {
        for (int index = 0; index < length; ++index) {
            buffer[index] = 0;
        }
        if ((this.nr52 & 0x80) != 0) {
            if ((this.nr52 & 1) != 0) {
                this.mixAudio1(buffer, length);
            }
            if ((this.nr52 & 2) != 0) {
                this.mixAudio2(buffer, length);
            }
            if ((this.nr52 & 4) != 0) {
                this.mixAudio3(buffer, length);
            }
            if ((this.nr52 & 8) != 0) {
                this.mixAudio4(buffer, length);
            }
        }
    }

    private final int getAudio1Sweep() {
        return this.nr10;
    }

    private final int getAudio1Length() {
        return this.nr11;
    }

    private final int getAudio1Envelope() {
        return this.nr12;
    }

    private final int getAudio1Frequency() {
        return this.nr13;
    }

    private final int getAudio1Playback() {
        return this.nr14;
    }

    private final void setAudio1Sweep(int data) {
        this.nr10 = data;
        this.audio1SweepLength = 2 * (this.nr10 >> 4 & 7);
    }

    private final void setAudio1Length(int data) {
        this.nr11 = data;
        this.audio1Length = 1 * (64 - (this.nr11 & 0x3F));
    }

    private final void setAudio1Envelope(int data) {
        this.nr12 = data;
        if ((this.nr14 & 0x40) == 0) {
            this.audio1Volume = this.nr12 >> 4 == 0 ? 0 : (this.audio1EnvelopeLength == 0 && (this.nr12 & 7) == 0 ? this.audio1Volume + 1 & 0xF : this.audio1Volume + 2 & 0xF);
        }
    }

    private final void setAudio1Frequency(int data) {
        this.nr13 = data;
        this.audio1Frequency = this.frequencyTable[this.nr13 + ((this.nr14 & 7) << 8)];
    }

    private final void setAudio1Playback(int data) {
        this.nr14 = data;
        this.audio1Frequency = this.frequencyTable[this.nr13 + ((this.nr14 & 7) << 8)];
        if ((this.nr14 & 0x80) != 0) {
            this.nr52 |= 1;
            if ((this.nr14 & 0x40) != 0 && this.audio1Length == 0) {
                this.audio1Length = 1 * (64 - (this.nr11 & 0x3F));
            }
            this.audio1SweepLength = 2 * (this.nr10 >> 4 & 7);
            this.audio1Volume = this.nr12 >> 4;
            this.audio1EnvelopeLength = 4 * (this.nr12 & 7);
        }
    }

    private final void updateAudio1() {
        if ((this.nr14 & 0x40) != 0 && this.audio1Length > 0) {
            --this.audio1Length;
            if (this.audio1Length <= 0) {
                this.nr52 &= 0xFFFFFFFE;
            }
        }
        if (this.audio1EnvelopeLength > 0) {
            --this.audio1EnvelopeLength;
            if (this.audio1EnvelopeLength <= 0) {
                if ((this.nr12 & 8) != 0) {
                    if (this.audio1Volume < 15) {
                        ++this.audio1Volume;
                    }
                } else if (this.audio1Volume > 0) {
                    --this.audio1Volume;
                }
                this.audio1EnvelopeLength += 4 * (this.nr12 & 7);
            }
        }
        if (this.audio1SweepLength > 0) {
            --this.audio1SweepLength;
            if (this.audio1SweepLength <= 0) {
                int sweepSteps = this.nr10 & 7;
                if (sweepSteps != 0) {
                    int frequency = ((this.nr14 & 7) << 8) + this.nr13;
                    frequency = (this.nr10 & 8) != 0 ? (frequency -= frequency >> sweepSteps) : (frequency += frequency >> sweepSteps);
                    if (frequency < 2048) {
                        this.audio1Frequency = this.frequencyTable[frequency];
                        this.nr13 = frequency & 0xFF;
                        this.nr14 = (this.nr14 & 0xF8) + (frequency >> 8 & 7);
                    } else {
                        this.audio1Frequency = 0;
                        this.nr52 &= 0xFFFFFFFE;
                    }
                }
                this.audio1SweepLength += 2 * (this.nr10 >> 4 & 7);
            }
        }
    }

    private final void mixAudio1(byte[] buffer, int length) {
        int wavePattern = ((this.nr11 & 0xC0) == 0 ? 4 : ((this.nr11 & 0xC0) == 64 ? 8 : ((this.nr11 & 0xC0) == 128 ? 16 : 24))) << 22;
        for (int index = 0; index < length; index += 2) {
            this.audio1Index += this.audio1Frequency;
            if ((this.audio1Index & 0x7C00000) >= wavePattern) {
                if ((this.nr51 & 0x10) != 0) {
                    int n = index + 0;
                    buffer[n] = (byte)(buffer[n] - this.audio1Volume);
                }
                if ((this.nr51 & 1) == 0) continue;
                int n = index + 1;
                buffer[n] = (byte)(buffer[n] - this.audio1Volume);
                continue;
            }
            if ((this.nr51 & 0x10) != 0) {
                int n = index + 0;
                buffer[n] = (byte)(buffer[n] + this.audio1Volume);
            }
            if ((this.nr51 & 1) == 0) continue;
            int n = index + 1;
            buffer[n] = (byte)(buffer[n] + this.audio1Volume);
        }
    }

    private final int getAudio2Length() {
        return this.nr21;
    }

    private final int getAudio2Envelope() {
        return this.nr22;
    }

    private final int getAudio2Frequency() {
        return this.nr23;
    }

    private final int getAudio2Playback() {
        return this.nr24;
    }

    private final void setAudio2Length(int data) {
        this.nr21 = data;
        this.audio2Length = 1 * (64 - (this.nr21 & 0x3F));
    }

    private final void setAudio2Envelope(int data) {
        this.nr22 = data;
        if ((this.nr24 & 0x40) == 0) {
            this.audio2Volume = this.nr22 >> 4 == 0 ? 0 : (this.audio2EnvelopeLength == 0 && (this.nr22 & 7) == 0 ? this.audio2Volume + 1 & 0xF : this.audio2Volume + 2 & 0xF);
        }
    }

    private final void setAudio2Frequency(int data) {
        this.nr23 = data;
        this.audio2Frequency = this.frequencyTable[this.nr23 + ((this.nr24 & 7) << 8)];
    }

    private final void setAudio2Playback(int data) {
        this.nr24 = data;
        this.audio2Frequency = this.frequencyTable[this.nr23 + ((this.nr24 & 7) << 8)];
        if ((this.nr24 & 0x80) != 0) {
            this.nr52 |= 2;
            if ((this.nr24 & 0x40) != 0 && this.audio2Length == 0) {
                this.audio2Length = 1 * (64 - (this.nr21 & 0x3F));
            }
            this.audio2Volume = this.nr22 >> 4;
            this.audio2EnvelopeLength = 4 * (this.nr22 & 7);
        }
    }

    private final void updateAudio2() {
        if ((this.nr24 & 0x40) != 0 && this.audio2Length > 0) {
            --this.audio2Length;
            if (this.audio2Length <= 0) {
                this.nr52 &= 0xFFFFFFFD;
            }
        }
        if (this.audio2EnvelopeLength > 0) {
            --this.audio2EnvelopeLength;
            if (this.audio2EnvelopeLength <= 0) {
                if ((this.nr22 & 8) != 0) {
                    if (this.audio2Volume < 15) {
                        ++this.audio2Volume;
                    }
                } else if (this.audio2Volume > 0) {
                    --this.audio2Volume;
                }
                this.audio2EnvelopeLength += 4 * (this.nr22 & 7);
            }
        }
    }

    private final void mixAudio2(byte[] buffer, int length) {
        int wavePattern = ((this.nr21 & 0xC0) == 0 ? 4 : ((this.nr21 & 0xC0) == 64 ? 8 : ((this.nr21 & 0xC0) == 128 ? 16 : 24))) << 22;
        for (int index = 0; index < length; index += 2) {
            this.audio2Index += this.audio2Frequency;
            if ((this.audio2Index & 0x7C00000) >= wavePattern) {
                if ((this.nr51 & 0x20) != 0) {
                    int n = index + 0;
                    buffer[n] = (byte)(buffer[n] - this.audio2Volume);
                }
                if ((this.nr51 & 2) == 0) continue;
                int n = index + 1;
                buffer[n] = (byte)(buffer[n] - this.audio2Volume);
                continue;
            }
            if ((this.nr51 & 0x20) != 0) {
                int n = index + 0;
                buffer[n] = (byte)(buffer[n] + this.audio2Volume);
            }
            if ((this.nr51 & 2) == 0) continue;
            int n = index + 1;
            buffer[n] = (byte)(buffer[n] + this.audio2Volume);
        }
    }

    private final int getAudio3Enable() {
        return this.nr30;
    }

    private final int getAudio3Length() {
        return this.nr31;
    }

    private final int getAudio3Level() {
        return this.nr32;
    }

    private final int getAudio4Frequency() {
        return this.nr33;
    }

    private final int getAudio3Playback() {
        return this.nr34;
    }

    private final void setAudio3Enable(int data) {
        this.nr30 = data & 0x80;
        if ((this.nr30 & 0x80) == 0) {
            this.nr52 &= 0xFFFFFFFB;
        }
    }

    private final void setAudio3Length(int data) {
        this.nr31 = data;
        this.audio3Length = 1 * (256 - this.nr31);
    }

    private final void setAudio3Level(int data) {
        this.nr32 = data;
    }

    private final void setAudio3Frequency(int data) {
        this.nr33 = data;
        this.audio3Frequency = this.frequencyTable[((this.nr34 & 7) << 8) + this.nr33] >> 1;
    }

    private final void setAudio3Playback(int data) {
        this.nr34 = data;
        this.audio3Frequency = this.frequencyTable[((this.nr34 & 7) << 8) + this.nr33] >> 1;
        if ((this.nr34 & 0x80) != 0 && (this.nr30 & 0x80) != 0) {
            this.nr52 |= 4;
            if ((this.nr34 & 0x40) != 0 && this.audio3Length == 0) {
                this.audio3Length = 1 * (256 - this.nr31);
            }
        }
    }

    private final void setAudio3WavePattern(int address, int data) {
        this.audio3WavePattern[address & 0xF] = (byte)data;
    }

    private final int getAudio3WavePattern(int address) {
        return this.audio3WavePattern[address & 0xF] & 0xFF;
    }

    private final void updateAudio3() {
        if ((this.nr34 & 0x40) != 0 && this.audio3Length > 0) {
            --this.audio3Length;
            if (this.audio3Length <= 0) {
                this.nr52 &= 0xFFFFFFFB;
            }
        }
    }

    private final void mixAudio3(byte[] buffer, int length) {
        int level = (this.nr32 & 0x60) == 0 ? 8 : ((this.nr32 & 0x60) == 32 ? 0 : ((this.nr32 & 0x60) == 64 ? 1 : 2));
        for (int index = 0; index < length; index += 2) {
            this.audio3Index += this.audio3Frequency;
            int sample = this.audio3WavePattern[this.audio3Index >> 23 & 0xF];
            sample = (this.audio3Index & 0x400000) != 0 ? sample >> 0 & 0xF : sample >> 4 & 0xF;
            sample = sample - 8 << 1 >> level;
            if ((this.nr51 & 0x40) != 0) {
                int n = index + 0;
                buffer[n] = (byte)(buffer[n] + sample);
            }
            if ((this.nr51 & 4) == 0) continue;
            int n = index + 1;
            buffer[n] = (byte)(buffer[n] + sample);
        }
    }

    private final int getAudio4Length() {
        return this.nr41;
    }

    private final int getAudio4Envelope() {
        return this.nr42;
    }

    private final int getAudio4Polynomial() {
        return this.nr43;
    }

    private final int getAudio4Playback() {
        return this.nr44;
    }

    private final void setAudio4Length(int data) {
        this.nr41 = data;
        this.audio4Length = 1 * (64 - (this.nr41 & 0x3F));
    }

    private final void setAudio4Envelope(int data) {
        this.nr42 = data;
        if ((this.nr44 & 0x40) == 0) {
            this.audio4Volume = this.nr42 >> 4 == 0 ? 0 : (this.audio4EnvelopeLength == 0 && (this.nr42 & 7) == 0 ? this.audio4Volume + 1 & 0xF : this.audio4Volume + 2 & 0xF);
        }
    }

    private final void setAudio4Polynomial(int data) {
        this.nr43 = data;
        this.audio4Frequency = this.nr43 >> 4 <= 12 ? this.noiseFreqRatioTable[this.nr43 & 7] >> (this.nr43 >> 4) + 1 : 0;
    }

    private final void setAudio4Playback(int data) {
        this.nr44 = data;
        if ((this.nr44 & 0x80) != 0) {
            this.nr52 |= 8;
            if ((this.nr44 & 0x40) != 0 && this.audio4Length == 0) {
                this.audio4Length = 1 * (64 - (this.nr41 & 0x3F));
            }
            this.audio4Volume = this.nr42 >> 4;
            this.audio4EnvelopeLength = 4 * (this.nr42 & 7);
            this.audio4Index = 0;
        }
    }

    private final void updateAudio4() {
        if ((this.nr44 & 0x40) != 0 && this.audio4Length > 0) {
            --this.audio4Length;
            if (this.audio4Length <= 0) {
                this.nr52 &= 0xFFFFFFF7;
            }
        }
        if (this.audio4EnvelopeLength > 0) {
            --this.audio4EnvelopeLength;
            if (this.audio4EnvelopeLength <= 0) {
                if ((this.nr42 & 8) != 0) {
                    if (this.audio4Volume < 15) {
                        ++this.audio4Volume;
                    }
                } else if (this.audio4Volume > 0) {
                    --this.audio4Volume;
                }
                this.audio4EnvelopeLength += 4 * (this.nr42 & 7);
            }
        }
    }

    private final void mixAudio4(byte[] buffer, int length) {
        for (int index = 0; index < length; index += 2) {
            int polynomial;
            this.audio4Index += this.audio4Frequency;
            if ((this.nr43 & 8) != 0) {
                this.audio4Index &= 0x7FFFFF;
                polynomial = this.noiseStep7Table[this.audio4Index >> 21] >> (this.audio4Index >> 16 & 0x1F);
            } else {
                this.audio4Index &= Integer.MAX_VALUE;
                polynomial = this.noiseStep15Table[this.audio4Index >> 21] >> (this.audio4Index >> 16 & 0x1F);
            }
            if ((polynomial & 1) != 0) {
                if ((this.nr51 & 0x80) != 0) {
                    int n = index + 0;
                    buffer[n] = (byte)(buffer[n] - this.audio4Volume);
                }
                if ((this.nr51 & 8) == 0) continue;
                int n = index + 1;
                buffer[n] = (byte)(buffer[n] - this.audio4Volume);
                continue;
            }
            if ((this.nr51 & 0x80) != 0) {
                int n = index + 0;
                buffer[n] = (byte)(buffer[n] + this.audio4Volume);
            }
            if ((this.nr51 & 8) == 0) continue;
            int n = index + 1;
            buffer[n] = (byte)(buffer[n] + this.audio4Volume);
        }
    }

    private final int getOutputLevel() {
        return this.nr50;
    }

    private final int getOutputTerminal() {
        return this.nr51;
    }

    private final int getOutputEnable() {
        return this.nr52;
    }

    private final void setOutputLevel(int data) {
        this.nr50 = data;
    }

    private final void setOutputTerminal(int data) {
        this.nr51 = data;
    }

    private final void setOutputEnable(int data) {
        this.nr52 = this.nr52 & 0x7F | data & 0x80;
        if ((this.nr52 & 0x80) == 0) {
            this.nr52 &= 0xF0;
        }
    }

    private final void generateFrequencyTables() {
        int sampleRate = this.driver.getSampleRate();
        for (int period = 0; period < 2048; ++period) {
            int skip = (0x40000000 / sampleRate << 14) / (2048 - period);
            this.frequencyTable[period] = skip >= 0x8000000 ? 0 : skip;
        }
        for (int ratio = 0; ratio < 8; ++ratio) {
            this.noiseFreqRatioTable[ratio] = 0x100000 / (ratio == 0 ? 1 : 2 * ratio) * (65536 / sampleRate);
        }
    }

    private final void generateNoiseTables() {
        int index;
        int polynomial = 127;
        for (index = 0; index <= 127; ++index) {
            polynomial = (polynomial << 6 ^ polynomial << 5) & 0x40 | polynomial >> 1;
            if ((index & 0x1F) == 0) {
                this.noiseStep7Table[index >> 5] = 0;
            }
            int n = index >> 5;
            this.noiseStep7Table[n] = this.noiseStep7Table[n] | (polynomial & 1) << (index & 0x1F);
        }
        polynomial = Short.MAX_VALUE;
        for (index = 0; index <= Short.MAX_VALUE; ++index) {
            polynomial = (polynomial << 14 ^ polynomial << 13) & 0x4000 | polynomial >> 1;
            if ((index & 0x1F) == 0) {
                this.noiseStep15Table[index >> 5] = 0;
            }
            int n = index >> 5;
            this.noiseStep15Table[n] = this.noiseStep15Table[n] | (polynomial & 1) << (index & 0x1F);
        }
    }
}

