/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.MBC;

public class MBC1
implements MBC {
    private byte[] rom;
    private byte[] ram;
    private int romSize;
    private int ramSize;
    private int romBank;
    private int ramBank;
    private int memoryModel;
    private boolean ramEnable;

    public MBC1(byte[] rom, byte[] ram) {
        this.setROM(rom);
        this.setRAM(ram);
    }

    public final void reset() {
        this.romBank = 16384;
        this.ramBank = 0;
        this.memoryModel = 0;
        this.ramEnable = false;
    }

    public final int read(int address) {
        if (address <= 16383) {
            return this.rom[address] & 0xFF;
        }
        if (address <= Short.MAX_VALUE) {
            return this.rom[this.romBank + (address & 0x3FFF)] & 0xFF;
        }
        if (address >= 40960 && address <= 49151 && this.ramEnable) {
            return this.ram[this.ramBank + (address & 0x1FFF)] & 0xFF;
        }
        return 255;
    }

    public final void write(int address, int data) {
        if (address <= 8191) {
            if (this.ramSize > 0) {
                this.ramEnable = (data & 0xA) == 10;
            }
        } else if (address <= 16383) {
            if ((data & 0x1F) == 0) {
                data = 1;
            }
            this.romBank = this.memoryModel == 0 ? (this.romBank & 0x180000) + ((data & 0x1F) << 14) & this.romSize : (data & 0x1F) << 14 & this.romSize;
        } else if (address <= 24575) {
            if (this.memoryModel == 0) {
                this.romBank = (this.romBank & 0x7FFFF) + ((data & 3) << 19) & this.romSize;
            } else {
                this.ramBank = (data & 3) << 13 & this.ramSize;
            }
        } else if (address <= Short.MAX_VALUE) {
            this.memoryModel = data & 1;
        } else if (address >= 40960 && address <= 49151 && this.ramEnable) {
            this.ram[this.ramBank + (address & 0x1FFF)] = (byte)data;
        }
    }

    private void setROM(byte[] buffer) {
        int banks = buffer.length / 16384;
        if (banks < 2 || banks > 128) {
            throw new RuntimeException("Invalid MBC1 ROM size");
        }
        this.rom = buffer;
        this.romSize = 16384 * banks - 1;
    }

    private void setRAM(byte[] buffer) {
        int banks = buffer.length / 8192;
        if (banks < 0 || banks > 4) {
            throw new RuntimeException("Invalid MBC1 RAM size");
        }
        this.ram = buffer;
        this.ramSize = 8192 * banks - 1;
    }
}

