/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.MBC;
import gameboy.core.driver.ClockDriver;

public class MBC3
implements MBC {
    private ClockDriver clock;
    private byte[] rom;
    private byte[] ram;
    private int romSize;
    private int ramSize;
    private int romBank;
    private int ramBank;
    private boolean ramEnable;
    private int clockRegister;
    private int clockLatch;
    private long clockTime;
    private int clockSeconds;
    private int clockMinutes;
    private int clockHours;
    private int clockDays;
    private int clockControl;
    private int clockLSeconds;
    private int clockLMinutes;
    private int clockLHours;
    private int clockLDays;
    private int clockLControl;

    public MBC3(byte[] rom, byte[] ram, ClockDriver clock) {
        this.clock = clock;
        this.setROM(rom);
        this.setRAM(ram);
    }

    public final void reset() {
        this.romBank = 16384;
        this.ramBank = 0;
        this.ramEnable = false;
        this.clockTime = this.clock.getTime();
        this.clockRegister = 0;
        this.clockLatch = 0;
        this.clockControl = 0;
        this.clockDays = 0;
        this.clockHours = 0;
        this.clockMinutes = 0;
        this.clockSeconds = 0;
        this.clockLControl = 0;
        this.clockLDays = 0;
        this.clockLHours = 0;
        this.clockLMinutes = 0;
        this.clockLSeconds = 0;
    }

    public final int read(int address) {
        if (address <= 16383) {
            return this.rom[address] & 0xFF;
        }
        if (address <= Short.MAX_VALUE) {
            return this.rom[this.romBank + (address & 0x3FFF)] & 0xFF;
        }
        if (address >= 40960 && address <= 49151) {
            if (this.ramBank >= 0) {
                return this.ram[this.ramBank + (address & 0x1FFF)] & 0xFF;
            }
            if (this.clockRegister == 8) {
                return this.clockLSeconds;
            }
            if (this.clockRegister == 9) {
                return this.clockLMinutes;
            }
            if (this.clockRegister == 10) {
                return this.clockLHours;
            }
            if (this.clockRegister == 11) {
                return this.clockLDays;
            }
            if (this.clockRegister == 12) {
                return this.clockLControl;
            }
        }
        return 255;
    }

    public final void write(int address, int data) {
        if (address <= 8191) {
            if (this.ramSize > 0) {
                this.ramEnable = (data & 0xA) == 10;
            }
        } else if (address <= 16383) {
            if (data == 0) {
                data = 1;
            }
            this.romBank = (data & 0x7F) << 14 & this.romSize;
        } else if (address <= 24575) {
            if (data >= 0 && data <= 3) {
                this.ramBank = data << 13 & this.ramSize;
            } else {
                this.ramBank = -1;
                this.clockRegister = data;
            }
        } else if (address <= Short.MAX_VALUE) {
            if (this.clockLatch == 0 && data == 1) {
                this.latchClock();
            }
            if (data == 0 || data == 1) {
                this.clockLatch = data;
            }
        } else if (address >= 40960 && address <= 49151 && this.ramEnable) {
            if (this.ramBank >= 0) {
                this.ram[this.ramBank + (address & 0x1FFF)] = (byte)data;
            } else {
                this.updateClock();
                if (this.clockRegister == 8) {
                    this.clockSeconds = data;
                }
                if (this.clockRegister == 9) {
                    this.clockMinutes = data;
                }
                if (this.clockRegister == 10) {
                    this.clockHours = data;
                }
                if (this.clockRegister == 11) {
                    this.clockDays = data;
                }
                if (this.clockRegister == 12) {
                    this.clockControl = this.clockControl & 0x80 | data;
                }
            }
        }
    }

    private final void latchClock() {
        this.updateClock();
        this.clockLSeconds = this.clockSeconds;
        this.clockLMinutes = this.clockMinutes;
        this.clockLHours = this.clockHours;
        this.clockLDays = this.clockDays & 0xFF;
        this.clockLControl = this.clockControl & 0xFE | this.clockDays >> 8 & 1;
    }

    private final void updateClock() {
        long now = this.clock.getTime();
        if ((this.clockControl & 0x40) == 0) {
            long elapsed = now - this.clockTime;
            while (elapsed >= 86400L) {
                elapsed -= 86400L;
                ++this.clockDays;
            }
            while (elapsed >= 3600L) {
                elapsed -= 3600L;
                ++this.clockHours;
            }
            while (elapsed >= 60L) {
                elapsed -= 60L;
                ++this.clockMinutes;
            }
            this.clockSeconds = (int)((long)this.clockSeconds + elapsed);
            while (this.clockSeconds >= 60) {
                this.clockSeconds -= 60;
                ++this.clockMinutes;
            }
            while (this.clockMinutes >= 60) {
                this.clockMinutes -= 60;
                ++this.clockHours;
            }
            while (this.clockHours >= 24) {
                this.clockHours -= 24;
                ++this.clockDays;
            }
            while (this.clockDays >= 512) {
                this.clockDays -= 512;
                this.clockControl |= 0x80;
            }
        }
        this.clockTime = now;
    }

    private void setROM(byte[] buffer) {
        int banks = buffer.length / 16384;
        if (banks < 2 || banks > 128) {
            throw new RuntimeException("Invalid MCB3 ROM size");
        }
        this.rom = buffer;
        this.romSize = 16384 * banks - 1;
    }

    private void setRAM(byte[] buffer) {
        int banks = buffer.length / 8192;
        if (banks < 0 || banks > 4) {
            throw new RuntimeException("Invalid MBC3 RAM size");
        }
        this.ram = buffer;
        this.ramSize = 8192 * banks - 1;
    }
}

