/*
 * Decompiled with CFR 0.152.
 */
package gameboy.ui;

import gameboy.core.driver.VideoDriver;
import gameboy.ui.Emulator;
import javax.microedition.lcdui.Graphics;

public class Video
implements VideoDriver {
    private Graphics graphics;
    private Emulator emulator;
    private int[] pixels;
    private int x;
    private int y;
    private int width;
    private int height;

    public Video(Emulator emulator, int width, int height) {
        this.emulator = emulator;
        this.width = width;
        this.height = height;
        this.pixels = new int[width * height];
        for (int offset = 0; offset < this.pixels.length; ++offset) {
            this.pixels[offset] = 0;
        }
        this.graphics = emulator.getGraphics();
        this.graphics.setColor(0xFFFFFF);
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int[] getPixels() {
        return this.pixels;
    }

    public final void clearScreen() {
        for (int offset = 0; offset < this.pixels.length; ++offset) {
            this.pixels[offset] = 0;
        }
        this.graphics.fillRect(0, 0, this.emulator.getWidth(), this.emulator.getHeight());
    }

    public final void display() {
        this.graphics.drawRGB(this.pixels, 0, this.width, this.x, this.y, this.width, this.height, false);
        this.emulator.flushGraphics();
    }
}

