/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

public class Interrupt {
    public static final int IE = 65535;
    public static final int IF = 65295;
    public static final int VBLANK = 1;
    public static final int LCD = 2;
    public static final int TIMER = 4;
    public static final int SERIAL = 8;
    public static final int JOYPAD = 16;
    private int enable;
    private int flag;

    public Interrupt() {
        this.reset();
    }

    public final void setEnable(int enable) {
        this.enable = enable;
    }

    public final void setFlag(int flag) {
        this.flag = flag;
    }

    public final int getEnable() {
        return this.enable;
    }

    public final int getFlag() {
        return this.flag;
    }

    public final void reset() {
        this.enable = 0;
        this.flag = 1;
    }

    public final boolean isPending() {
        return (this.enable & this.flag) != 0;
    }

    public final boolean isPending(int mask) {
        return (this.enable & this.flag & mask) != 0;
    }

    public final void raise(int mask) {
        this.flag |= mask;
    }

    public final void lower(int mask) {
        this.flag &= ~mask;
    }

    public final void write(int address, int data) {
        switch (address) {
            case 65535: {
                this.setInterruptEnable(data);
                break;
            }
            case 65295: {
                this.setInterruptFlag(data);
            }
        }
    }

    public final int read(int address) {
        switch (address) {
            case 65535: {
                return this.getInterruptEnable();
            }
            case 65295: {
                return this.getInterruptFlag();
            }
        }
        return 255;
    }

    private final int getInterruptEnable() {
        return this.enable;
    }

    private final int getInterruptFlag() {
        return 0xE0 | this.flag;
    }

    private final void setInterruptEnable(int data) {
        this.enable = data;
    }

    private final void setInterruptFlag(int data) {
        this.flag = data;
    }

    public final String toString() {
        return "IE=" + Integer.toHexString(this.enable) + " IF=" + Integer.toHexString(this.flag);
    }
}

