/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.io;

import de.joergjahnke.common.io.Serializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerializationUtils {
    public static void setMarker(DataOutputStream out) throws IOException {
        out.writeInt(Integer.MAX_VALUE);
    }

    public static void verifyMarker(DataInputStream in) throws IOException {
        if (in.readInt() != Integer.MAX_VALUE) {
            throw new IOException("Serialization marked not found!");
        }
    }

    public static void serialize(DataOutputStream out, byte[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeByte(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, byte[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readByte();
        }
    }

    public static void serialize(DataOutputStream out, short[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeShort(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, short[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readShort();
        }
    }

    public static void serialize(DataOutputStream out, int[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeInt(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, int[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readInt();
        }
    }

    public static void serialize(DataOutputStream out, long[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeLong(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, long[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readLong();
        }
    }

    public static void serialize(DataOutputStream out, boolean[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeBoolean(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, boolean[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readBoolean();
        }
    }

    public static void serialize(DataOutputStream out, String[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            out.writeUTF(data[i]);
        }
    }

    public static void deserialize(DataInputStream in, String[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i] = in.readUTF();
        }
    }

    public static void serialize(DataOutputStream out, Serializable[] data) throws IOException {
        out.writeInt(data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i].serialize(out);
        }
    }

    public static void deserialize(DataInputStream in, Serializable[] data) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            data[i].deserialize(in);
        }
    }
}

