/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.emulation.WaveDataProducer;
import de.joergjahnke.common.util.Observer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class WavePlayer
implements PlayerListener,
Observer {
    private static final short[] WAV_HEADER = new short[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 16, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    protected final Vector players = new Vector();
    private byte[][] buffers = new byte[3][];
    private int currentBuffer = 0;
    private int currentBufferPos = WAV_HEADER.length;
    private Player currentPlayer = null;
    private final WaveDataProducer producer;

    public WavePlayer(WaveDataProducer producer) {
        this.producer = producer;
        WavePlayer.WAV_HEADER[22] = (short)producer.getChannels();
        WavePlayer.WAV_HEADER[32] = (short)producer.getChannels();
        WavePlayer.WAV_HEADER[34] = (short)producer.getBitsPerSample();
        int defaultBufferSize = producer.getSampleRate() / 10;
        int bs = defaultBufferSize + WAV_HEADER.length;
        int i = 0;
        int shift = 0;
        while (i < 4) {
            WavePlayer.WAV_HEADER[4 + i] = (short)(bs >> shift & 0xFF);
            WavePlayer.WAV_HEADER[40 + i] = (short)(defaultBufferSize >> shift & 0xFF);
            WavePlayer.WAV_HEADER[24 + i] = (short)(producer.getSampleRate() >> shift & 0xFF);
            WavePlayer.WAV_HEADER[28 + i] = (short)(producer.getSampleRate() * producer.getChannels() * producer.getBitsPerSample() / 8 >> shift & 0xFF);
            ++i;
            shift += 8;
        }
        for (i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new byte[bs];
            this.initBuffer(this.buffers[i]);
        }
    }

    private final void initBuffer(byte[] buffer) {
        for (int i = 0; i < WAV_HEADER.length; ++i) {
            buffer[i] = (byte)(WAV_HEADER[i] & 0xFF);
        }
    }

    public void update(Object observed, Object obj) {
        if (observed instanceof WaveDataProducer && obj instanceof byte[]) {
            byte[] buffer = (byte[])obj;
            this.update(buffer, 0, buffer.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(byte[] buffer, int offset, int numBytes) {
        byte[] cb = this.buffers[this.currentBuffer];
        int n = Math.min(numBytes, cb.length - this.currentBufferPos);
        WavePlayer wavePlayer = this;
        synchronized (wavePlayer) {
            System.arraycopy(buffer, offset, cb, this.currentBufferPos, n);
            this.currentBufferPos += n;
            if (this.currentBufferPos >= cb.length) {
                try {
                    Player player = Manager.createPlayer((InputStream)new ByteArrayInputStream(cb), (String)"audio/x-wav");
                    try {
                        player.realize();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        player.prefetch();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    player.addPlayerListener((PlayerListener)this);
                    if (null == this.currentPlayer) {
                        this.currentPlayer = player;
                        this.currentPlayer.start();
                    } else {
                        this.players.addElement(player);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.producer.deleteObservers();
                }
                ++this.currentBuffer;
                this.currentBuffer %= this.buffers.length;
                this.currentBufferPos = WAV_HEADER.length;
            }
        }
        if (n < numBytes) {
            this.update(buffer, offset + n, numBytes - n);
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if ("endOfMedia".equals(event)) {
            if (!this.players.isEmpty()) {
                this.currentPlayer = (Player)this.players.elementAt(0);
                this.players.removeElementAt(0);
                try {
                    this.currentPlayer.start();
                }
                catch (Exception e) {
                    this.producer.deleteObservers();
                }
            } else {
                this.currentPlayer = null;
            }
        }
    }
}

