/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.util;

import de.joergjahnke.common.util.Cache;
import java.util.Enumeration;
import java.util.Hashtable;

public class LRUCache
implements Cache {
    private final int capacity;
    private final Hashtable objectMap = new Hashtable();
    private LRUNode first = null;
    private LRUNode last = null;

    public LRUCache(int capacity) {
        if (capacity < 2) {
            throw new IllegalArgumentException("LRUCache capacity needs to be > 1!");
        }
        this.capacity = capacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        this.objectMap.clear();
        this.first = null;
    }

    public boolean contains(Object obj) {
        Enumeration en = this.elements();
        while (en.hasMoreElements()) {
            if (obj != en.nextElement()) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.objectMap.containsKey(key);
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Enumeration en;
            {
                this.en = LRUCache.this.objectMap.elements();
            }

            public boolean hasMoreElements() {
                return this.en.hasMoreElements();
            }

            public Object nextElement() {
                return ((LRUNode)this.en.nextElement()).data;
            }
        };
    }

    public Object get(Object key) {
        LRUNode node = (LRUNode)this.objectMap.get(key);
        if (node == null) {
            return null;
        }
        if (this.last != node) {
            this.last.next = node;
            if (this.first == node) {
                this.first = node.next;
                this.first.previous = null;
            } else {
                node.previous.next = node.next;
                node.next.previous = node.previous;
            }
            node.previous = this.last;
            node.next = null;
            this.last = node;
        }
        return node.data;
    }

    public Enumeration keys() {
        return this.objectMap.keys();
    }

    public void put(Object key, Object obj) {
        LRUNode node = null;
        if (this.size() >= this.capacity()) {
            this.objectMap.remove(this.first.key);
            node = this.first;
            this.first = this.first.next;
            this.first.previous = null;
        }
        if (this.first == null) {
            this.first = this.last = (node = new LRUNode(key, obj, null, null));
        } else {
            if (node != null) {
                node.key = key;
                node.data = obj;
                node.previous = this.last;
                node.next = null;
            } else {
                node = new LRUNode(key, obj, this.last, null);
            }
            this.last.next = node;
            this.last = node;
        }
        this.objectMap.put(key, node);
    }

    public void remove(Object key) {
        LRUNode node = (LRUNode)this.objectMap.get(key);
        this.objectMap.remove(key);
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.first = node.next;
            this.first.previous = null;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.last = node.previous;
            this.last.next = null;
        }
    }

    public int size() {
        return this.objectMap.size();
    }

    static class LRUNode {
        public Object key;
        public Object data;
        public LRUNode previous;
        public LRUNode next;

        public LRUNode(Object key, Object data, LRUNode previous, LRUNode next) {
            this.key = key;
            this.data = data;
            this.previous = previous;
            this.next = next;
        }
    }
}

