/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.common.util.DefaultObservable;
import de.joergjahnke.common.util.Observer;
import de.joergjahnke.gameboy.core.CPU;
import de.joergjahnke.gameboy.core.ColorPalette;
import de.joergjahnke.gameboy.core.Gameboy;
import de.joergjahnke.gameboy.core.Sprite;
import de.joergjahnke.gameboy.core.Tile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VideoChip
extends DefaultObservable
implements Serializable,
Observer {
    private static final boolean DEBUG = false;
    public static final Integer SIGNAL_NEW_FRAME = new Integer(1);
    public static final int NUM_PALETTES = 8;
    public static final int NUM_COLORS = 32;
    public static final int PALETTE_BACKGROUND = 0;
    public static final int PALETTE_SPRITES = 8;
    public static final int NUM_TILES = 768;
    public static final int NUM_SPRITES = 40;
    public static final int TILE_WIDTH = 8;
    public static final int TILE_HEIGHT = 8;
    public static final int TILES_PER_LINE = 20;
    public static final int SCREEN_WIDTH = 160;
    public static final int TILES_PER_COLUMN = 18;
    public static final int SCREEN_HEIGHT = 144;
    public static final int VBLANK_COLUMNS = 10;
    private static final int HBLANK_PERIOD = 200;
    private static final int OAM_PERIOD = 80;
    private static final int OAM_VRAM_PERIOD_START = 48;
    private static final int OAM_VRAM_PERIOD_END = 128;
    private static final int LCD_LINE_PERIOD = 456;
    private static final int VBLANK_PERIOD = 456;
    private static final int VBLANK_PERIOD_START = 32;
    private static final int VBLANK_PERIOD_END = 4;
    protected static final int MODE_OAM = 2;
    protected static final int MODE_OAM_VRAM = 3;
    protected static final int MODE_OAM_VRAM_END = 7;
    protected static final int MODE_VBLANK_START = 5;
    protected static final int MODE_VBLANK = 1;
    protected static final int MODE_HBLANK = 0;
    private static final int GBCVRAM_BANK_SIZE = 8192;
    private static final int NUM_VRAM_BANKS = 2;
    public static final int SCALING_FAST = 0;
    public static final int SCALING_AVERAGING = 1;
    public static final int SCALING_QUALITY = 2;
    public static final int SCALING_PLUS50PERCENT = 3;
    public static final int SCALING_MULTIPLIER = 1024;
    public static final int SCALING_MULTIPLIER_BITS = 10;
    private static final int MAX_SPRITES_VISIBLE = 10;
    private static final boolean USE_BACKGROUND_CACHE = Runtime.getRuntime().totalMemory() >= 3000000L;
    protected final Gameboy gameboy;
    private int mode = 2;
    private long nextUpdate = 0L;
    private int frames = 0;
    private int frameSkip = 3;
    private int currentLine = 0;
    private boolean isLCDEnabled = true;
    private boolean isWindowEnabled = false;
    private int tileDataArea;
    private int bgTileMapAdr;
    private int windowTileMapAdr;
    private int spriteHeight = 8;
    private boolean areSpritesEnabled;
    private boolean isBGBlank = false;
    private boolean haveSpritesPriority = false;
    private final ColorPalette[] palettes = new ColorPalette[16];
    private final int[] colorBytes = new int[128];
    private int scrollX;
    private int scrollY;
    private int windowX;
    private int windowY;
    private int nextWindowY;
    private int windowLine;
    private boolean isHBlankIRQEnabled;
    private boolean isVBlankIRQEnabled;
    private boolean isOAMIRQEnabled;
    private boolean isCoincidenceIRQEnabled;
    private final Tile[] tiles = new Tile[768];
    private boolean areAllTilesInvalid = true;
    private final Sprite[] sprites = new Sprite[40];
    protected int[] pixels;
    private int[] backgroundPixelsBuffer;
    private int[] blankLine;
    private int currentVRAMBank = 0;
    private int currentVRAMOffset = 0;
    protected final byte[] vRAM = new byte[16384];
    protected int scalingMult;
    private boolean isPaintFrame;
    private int scalingType = 2;
    private final boolean[] wasLineModified = new boolean[144];
    private final boolean[] allLinesModified = new boolean[144];
    private final boolean[] wasSpritePainted = new boolean[144];
    private boolean areAllLinesModified = false;
    protected final byte[] backgroundPriorities = new byte[160];
    protected int scaledWidth = 160;
    private int cpuSpeedMult = 1024;

    public VideoChip(Gameboy gameboy) {
        this.gameboy = gameboy;
        for (int i = 0; i < this.allLinesModified.length; ++i) {
            this.allLinesModified[i] = true;
        }
        this.setScaling(1024);
    }

    public final int[] getRGBData() {
        return this.pixels;
    }

    public final int getScalingType() {
        return this.scalingType;
    }

    public final void setScalingType(int scalingType) {
        this.scalingType = scalingType;
    }

    public final long getNextUpdate() {
        return this.nextUpdate;
    }

    public final int getVideoMode() {
        return this.mode & 3;
    }

    public final int getLCDLine() {
        return this.currentLine;
    }

    public final boolean isLCDEnabled() {
        return this.isLCDEnabled;
    }

    public final void setLCDEnabled(boolean isLCDEnabled) {
        if (isLCDEnabled != this.isLCDEnabled) {
            this.isLCDEnabled = isLCDEnabled;
            this.currentLine = 0;
            this.setSpriteHeight(isLCDEnabled ? 16 : 8);
            this.invalidateLines();
        }
    }

    private boolean isWindowEnabled() {
        return this.isWindowEnabled;
    }

    public final void setWindowEnabled(boolean isWindowEnabled) {
        if (isWindowEnabled != this.isWindowEnabled) {
            this.isWindowEnabled = isWindowEnabled;
            if (isWindowEnabled && this.windowLine == 0 && this.currentLine > this.getWindowY()) {
                this.windowLine = 144;
            }
            this.invalidateLines();
        }
    }

    public final Tile[] getTiles() {
        return this.tiles;
    }

    public final void setBackgroundTileArea(int bgTileMapAdr) {
        if (this.bgTileMapAdr != (bgTileMapAdr & 0x1FFF)) {
            this.bgTileMapAdr = bgTileMapAdr & 0x1FFF;
            this.invalidateLines();
        }
    }

    public final void setWindowTileArea(int windowTileMapAdr) {
        if (this.windowTileMapAdr != (windowTileMapAdr & 0x1FFF)) {
            this.windowTileMapAdr = windowTileMapAdr & 0x1FFF;
            this.invalidateLines();
        }
    }

    private int getTileDataArea() {
        return this.tileDataArea;
    }

    public final void setTileDataArea(int tileDataArea) {
        if (this.tileDataArea != (tileDataArea & 0x1FFF)) {
            this.tileDataArea = tileDataArea & 0x1FFF;
            this.invalidateTiles();
            this.invalidateLines();
        }
    }

    public void setGBCVRAMBank(int vRAMBank) {
        if (vRAMBank != this.currentVRAMBank) {
            this.currentVRAMBank = vRAMBank;
            this.currentVRAMOffset = vRAMBank * 8192;
        }
    }

    public final Sprite[] getSprites() {
        return this.sprites;
    }

    public final int getSpriteHeight() {
        return this.spriteHeight;
    }

    public final void setSpriteHeight(int spriteSize) {
        if (spriteSize != this.spriteHeight) {
            this.spriteHeight = spriteSize;
            for (int i = 0; i < this.sprites.length; ++i) {
                this.sprites[i].updateTile();
            }
        }
    }

    private boolean areSpritesEnabled() {
        return this.areSpritesEnabled;
    }

    public final void setSpritesEnabled(boolean areSpritesEnabled) {
        if (areSpritesEnabled != this.areSpritesEnabled) {
            this.invalidateLines();
        }
        this.areSpritesEnabled = areSpritesEnabled;
    }

    private boolean isBackgroundBlank() {
        return this.isBGBlank;
    }

    public final void setBackgroundBlank(boolean isBGBlank) {
        if (isBGBlank != this.isBGBlank) {
            this.isBGBlank = isBGBlank;
            this.invalidateLines();
        }
    }

    public boolean isHaveSpritesPriority() {
        return this.haveSpritesPriority;
    }

    public final void setHaveSpritesPriority(boolean haveSpritesPriority) {
        this.haveSpritesPriority = haveSpritesPriority;
    }

    public final int getColorByte(int n) {
        return this.colorBytes[n];
    }

    public final void setColorByte(int n, int b) {
        if (this.colorBytes[n] != b) {
            this.colorBytes[n] = b;
            int gbColor = this.colorBytes[n & 0xFE] + ((this.colorBytes[(n & 0xFE) + 1] & 0xFF) << 8);
            this.palettes[n >> 3].setColor(n >> 1 & 3, 0xFF000000 | (gbColor & 0x1F) << 19 | (gbColor & 0x3E0) << 6 | (gbColor & 0x7C00) >> 7);
        }
    }

    public final ColorPalette[] getColorPalettes() {
        return this.palettes;
    }

    private int getScrollX() {
        return this.scrollX;
    }

    public final void setScrollX(int scrollX) {
        if (scrollX != this.scrollX) {
            this.scrollX = scrollX;
            this.invalidateLines();
        }
    }

    private int getScrollY() {
        return this.scrollY;
    }

    public final void setScrollY(int scrollY) {
        if (scrollY != this.scrollY) {
            this.scrollY = scrollY;
            this.invalidateLines();
        }
    }

    private int getWindowX() {
        return this.windowX;
    }

    public final void setWindowX(int windowX) {
        if (windowX != this.windowX) {
            this.windowX = windowX;
            this.invalidateWindowLines();
        }
    }

    private int getWindowY() {
        return this.windowY;
    }

    public final void setWindowY(int windowY) {
        if (windowY != this.windowY) {
            this.nextWindowY = windowY;
        }
    }

    public int getFrameSkip() {
        return this.frameSkip;
    }

    public void setFrameSkip(int frameSkip) {
        if (frameSkip < 1) {
            throw new IllegalArgumentException("Frameskip value must be > 0!");
        }
        this.frameSkip = frameSkip;
    }

    private boolean isHBlankIRQEnabled() {
        return this.isHBlankIRQEnabled;
    }

    public final void setHBlankIRQEnabled(boolean isHBlankIRQEnabled) {
        this.isHBlankIRQEnabled = isHBlankIRQEnabled;
    }

    private boolean isVBlankIRQEnabled() {
        return this.isVBlankIRQEnabled;
    }

    public final void setVBlankIRQEnabled(boolean isVBlankIRQEnabled) {
        this.isVBlankIRQEnabled = isVBlankIRQEnabled;
    }

    private boolean isOAMIRQEnabled() {
        return this.isOAMIRQEnabled;
    }

    public final void setOAMIRQEnabled(boolean isOAMIRQEnabled) {
        this.isOAMIRQEnabled = isOAMIRQEnabled;
    }

    private boolean isCoincidenceIRQEnabled() {
        return this.isCoincidenceIRQEnabled;
    }

    public final void setCoincidenceIRQEnabled(boolean isCoincidenceIRQEnabled) {
        this.isCoincidenceIRQEnabled = isCoincidenceIRQEnabled;
    }

    public final int getScaling() {
        return this.scalingMult;
    }

    public final void setScaling(int scalingMult) {
        int modScalingMult = scalingMult;
        modScalingMult /= 128;
        if ((modScalingMult *= 128) == 0) {
            throw new RuntimeException("Scaling factor cannot be 0!");
        }
        if (modScalingMult != this.scalingMult) {
            this.scalingMult = modScalingMult;
            this.scaledWidth = 160 * this.scalingMult >> 10;
            this.setScalingType(this.scalingMult % 1024 == 0 ? 0 : (this.scalingMult == 1536 ? 3 : 2));
            this.initializeScreen();
        }
    }

    public final int getScaledWidth() {
        return this.scaledWidth;
    }

    public final int getScaledHeight() {
        return 144 * this.scalingMult >> 10;
    }

    public final int readByte(int adr) {
        return this.vRAM[this.currentVRAMOffset + adr] & 0xFF;
    }

    public final void writeByte(int adr, byte data) {
        int vRAMAdr = this.currentVRAMOffset + adr;
        if (data != this.vRAM[vRAMAdr]) {
            this.vRAM[vRAMAdr] = data;
            if (adr < 6144) {
                this.tiles[this.currentVRAMBank * 384 + (adr >> 4)].invalidate();
            }
            this.invalidateLines();
        }
    }

    public final void update(long cycles) {
        int lcdCycles;
        switch (this.mode) {
            case 2: {
                lcdCycles = this.onOAM();
                break;
            }
            case 3: {
                lcdCycles = this.onTransfer();
                break;
            }
            case 7: {
                lcdCycles = this.onOAMEnd();
                break;
            }
            case 0: {
                lcdCycles = this.onHBlank();
                break;
            }
            case 5: {
                lcdCycles = this.onVBlankStart();
                break;
            }
            case 1: {
                lcdCycles = this.onVBlank();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal video mode: " + this.mode);
            }
        }
        this.nextUpdate = cycles + (long)(this.cpuSpeedMult * lcdCycles >> 10);
    }

    private int onOAM() {
        this.mode = 3;
        return 48;
    }

    private int onTransfer() {
        if (this.isPaintFrame) {
            if (this.isLCDEnabled()) {
                this.drawLine(this.currentLine);
            } else {
                int to = (this.currentLine + 1) * this.getScaling() >> 10;
                for (int i = this.currentLine * this.getScaling() >> 10; i < to; ++i) {
                    System.arraycopy(this.blankLine, 0, this.pixels, i * this.getScaledWidth(), this.getScaledWidth());
                }
            }
        }
        this.mode = 7;
        return 128;
    }

    private int onOAMEnd() {
        if (this.isLCDEnabled()) {
            CPU cpu = this.gameboy.getCPU();
            if (this.isHBlankIRQEnabled() && (cpu.memory[65345] & 0x44) != 68) {
                cpu.requestIRQ(2);
            }
        }
        this.mode = 0;
        return 200;
    }

    private int onHBlank() {
        int lcdCycles = 0;
        ++this.currentLine;
        if (this.isLCDEnabled()) {
            this.checkCoincidenceIRQ();
        }
        if (this.currentLine < 144) {
            if (this.isLCDEnabled()) {
                this.checkOAMIRQ();
            }
            lcdCycles = 80;
            this.mode = 2;
        } else {
            this.onFrameFinished();
            this.windowY = this.nextWindowY;
            this.mode = 5;
            lcdCycles = 32;
        }
        return lcdCycles;
    }

    private int onVBlankStart() {
        CPU cpu = this.gameboy.getCPU();
        if (this.isLCDEnabled()) {
            cpu.requestIRQ(1);
            if (this.isVBlankIRQEnabled()) {
                cpu.requestIRQ(2);
            }
        }
        this.mode = 1;
        return 424;
    }

    private int onVBlank() {
        int lcdCycles = 0;
        if (this.currentLine == 0) {
            if (this.isLCDEnabled()) {
                this.checkOAMIRQ();
            }
            if (this.windowY != this.nextWindowY) {
                int firstInvalid = Math.max(0, Math.min(this.nextWindowY, this.getWindowY()));
                if (firstInvalid < 144) {
                    this.invalidateLines(firstInvalid, 144 - firstInvalid);
                }
                this.windowY = this.nextWindowY;
            }
            lcdCycles = 80;
            this.mode = 2;
        } else {
            if (this.currentLine < 153) {
                ++this.currentLine;
                lcdCycles = this.currentLine == 153 ? 4 : 456;
            } else {
                this.windowLine = 0;
                this.currentLine = 0;
                lcdCycles = 452;
            }
            if (this.isLCDEnabled()) {
                this.checkCoincidenceIRQ();
            }
        }
        return lcdCycles;
    }

    private void onFrameFinished() {
        ++this.frames;
        if (this.isPaintFrame) {
            this.setChanged(true);
            this.notifyObservers(SIGNAL_NEW_FRAME);
        }
        this.isPaintFrame = this.frames % this.getFrameSkip() == 0;
    }

    protected void checkCoincidenceIRQ() {
        CPU cpu = this.gameboy.getCPU();
        if (this.isCoincidenceIRQEnabled() && this.currentLine == cpu.readIO(65349)) {
            cpu.memory[65345] = (byte)(cpu.memory[65345] | 4);
            cpu.requestIRQ(2);
        } else {
            cpu.memory[65345] = (byte)(cpu.memory[65345] & 0xFB);
        }
    }

    protected void checkOAMIRQ() {
        CPU cpu = this.gameboy.getCPU();
        if (this.isOAMIRQEnabled() && (cpu.memory[65345] & 0x44) != 68) {
            cpu.requestIRQ(2);
        }
    }

    private void drawLine(int line) {
        int oldLine = this.currentLine;
        this.currentLine = line;
        if (this.wasLineModified[line]) {
            this.drawBackgroundLine();
            this.drawWindowLine();
            this.wasLineModified[line] = false;
            this.wasSpritePainted[line] = false;
            this.areAllLinesModified = false;
        } else if (this.wasSpritePainted[line]) {
            int svy = line * this.getScaling() >> 10;
            int svystop = (line + 1) * this.getScaling() >> 10;
            int spos = svy * this.getScaledWidth();
            System.arraycopy(this.backgroundPixelsBuffer, spos, this.pixels, spos, svystop * this.getScaledWidth() - spos);
            this.wasSpritePainted[line] = false;
        }
        this.drawSpriteLine();
        this.currentLine = oldLine;
    }

    private void drawSpriteLine() {
        if (this.areSpritesEnabled()) {
            int left;
            Sprite[] sprites_ = this.sprites;
            int line_ = this.currentLine;
            boolean[] wasSpritePainted_ = USE_BACKGROUND_CACHE ? this.wasSpritePainted : this.wasLineModified;
            int sh = this.getSpriteHeight();
            int n = left = this.gameboy.getCartridge().isGBC() ? 10 : 40;
            for (int i = 0; i < 40 && left > 0; ++i) {
                Sprite sprite = sprites_[i];
                int sy = sprite.getY();
                if (!sprite.isDisplayable() || line_ < sy || line_ >= sy + sh) continue;
                if (sprite.isVisible()) {
                    if (!wasSpritePainted_[line_]) {
                        if (USE_BACKGROUND_CACHE) {
                            int svy = line_ * this.getScaling() >> 10;
                            int svystop = (line_ + 1) * this.getScaling() >> 10;
                            int spos = svy * this.getScaledWidth();
                            System.arraycopy(this.pixels, spos, this.backgroundPixelsBuffer, spos, svystop * this.getScaledWidth() - spos);
                        }
                        wasSpritePainted_[line_] = true;
                    }
                    sprite.drawLine(line_ - sy);
                    this.areAllTilesInvalid = false;
                }
                --left;
            }
        }
    }

    private void drawBackgroundLine() {
        if (!(this.isBackgroundBlank() && !this.gameboy.getCartridge().isGBC() || this.isWindowEnabled() && this.currentLine >= this.getWindowY() && this.getWindowX() == 0)) {
            int memStart = (this.bgTileMapAdr & 0x1FFF) + ((this.currentLine + this.getScrollY() >> 3 & 0x1F) << 5);
            int vystart = (this.currentLine + this.getScrollY()) % 8;
            this.drawTileMapLine(this.getScrollX() >> 3, -(this.getScrollX() & 7), vystart, memStart);
            this.areAllTilesInvalid = false;
        }
    }

    private void drawWindowLine() {
        if (this.isWindowEnabled() && this.currentLine >= this.getWindowY() && this.getWindowX() < 160 && this.windowLine < 144) {
            int memStart = (this.windowTileMapAdr & 0x1FFF) + (this.windowLine >> 3 << 5);
            int vystart = (this.currentLine - this.getWindowY()) % 8;
            this.drawTileMapLine(0, this.getWindowX(), vystart, memStart);
            ++this.windowLine;
            this.areAllTilesInvalid = false;
        }
    }

    private void drawTileMapLine(int txstart, int vxstart, int tline, int memStart) {
        Tile[] tiles_ = this.getTiles();
        byte[] vRAM_ = this.vRAM;
        boolean isGBC = this.gameboy.getCPU().cartridge.isGBC();
        boolean isLowerTileDataArea = this.getTileDataArea() == 0;
        int line_ = this.currentLine;
        int txi = txstart;
        for (int vxi = vxstart; vxi < 160; vxi += 8) {
            int adr = memStart + (txi & 0x1F);
            byte data = vRAM_[adr];
            int attributes = isGBC ? vRAM_[adr + 8192] & 0xFF : 0;
            int tileNumOffset = (attributes & 8) == 0 ? 0 : 384;
            int tileId = tileNumOffset + (isLowerTileDataArea ? data & 0xFF : 256 + data);
            tiles_[tileId].drawLine(tline, vxi, line_, attributes);
            ++txi;
        }
    }

    protected final void invalidateTiles() {
        if (!this.areAllTilesInvalid) {
            Tile[] tiles_ = this.tiles;
            int to = tiles_.length;
            for (int i = 0; i < to; ++i) {
                tiles_[i].invalidate();
            }
            this.areAllTilesInvalid = true;
        }
    }

    protected final void invalidateLines() {
        this.invalidateLines(0, 144);
        this.areAllLinesModified = true;
    }

    private void invalidateLines(int from, int len) {
        if (!this.areAllLinesModified) {
            System.arraycopy(this.allLinesModified, 0, this.wasLineModified, from, len);
        }
    }

    private void invalidateWindowLines() {
        int firstInvalid = Math.max(0, this.getWindowY());
        if (firstInvalid < 144) {
            this.invalidateLines(firstInvalid, 144 - firstInvalid);
        }
    }

    public void reset() {
        int i;
        this.currentLine = 0;
        this.frames = 0;
        this.mode = 2;
        this.isLCDEnabled = true;
        this.isWindowEnabled = false;
        this.isBGBlank = false;
        this.tileDataArea = 0;
        this.windowTileMapAdr = 0;
        this.bgTileMapAdr = 0;
        this.spriteHeight = 8;
        this.haveSpritesPriority = false;
        this.areSpritesEnabled = false;
        this.currentVRAMBank = 0;
        this.currentVRAMOffset = 0;
        this.nextUpdate = 0L;
        this.windowY = 0;
        this.windowX = 0;
        this.scrollY = 0;
        this.scrollX = 0;
        this.nextWindowY = 0;
        this.isVBlankIRQEnabled = false;
        this.isOAMIRQEnabled = false;
        this.isHBlankIRQEnabled = false;
        this.isCoincidenceIRQEnabled = false;
        this.cpuSpeedMult = 1024;
        for (i = 0; i < this.vRAM.length; ++i) {
            this.vRAM[i] = 0;
        }
        this.initializeScreen();
        for (i = 0; i < this.sprites.length; ++i) {
            this.sprites[i].reset();
        }
    }

    private void initializeScreen() {
        int i;
        for (i = 0; i < this.colorBytes.length / 2; i += 2) {
            this.colorBytes[i] = 255;
            this.colorBytes[i + 1] = 127;
        }
        for (i = this.colorBytes.length / 2; i < this.colorBytes.length; i += 2) {
            this.colorBytes[i] = -1;
            this.colorBytes[i + 1] = -1;
        }
        for (i = 0; i < this.palettes.length; ++i) {
            this.palettes[i] = new ColorPalette(this, i < 8 ? -1 : 0);
        }
        for (i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = new Tile(this, i < 384 ? i * 16 : 8192 + (i - 384) * 16);
        }
        for (i = 0; i < this.sprites.length; ++i) {
            this.sprites[i] = new Sprite(this);
            this.sprites[i].setTile(0);
        }
        this.invalidateLines();
        this.pixels = null;
        System.gc();
        this.pixels = new int[(this.getScaledWidth() + this.tiles[0].getScaledWidth()) * (this.getScaledHeight() + this.tiles[0].getScaledHeight())];
        if (USE_BACKGROUND_CACHE) {
            this.backgroundPixelsBuffer = new int[(this.getScaledWidth() + this.tiles[0].getScaledWidth()) * (this.getScaledHeight() + this.tiles[0].getScaledHeight())];
        }
        this.blankLine = new int[this.getScaledWidth()];
        for (i = 0; i < this.blankLine.length; ++i) {
            this.blankLine[i] = -16777216;
        }
        this.bgTileMapAdr = 0;
        this.windowTileMapAdr = 0;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeLong(this.nextUpdate);
        out.writeInt(this.mode);
        out.writeInt(this.currentLine);
        out.writeBoolean(this.isLCDEnabled);
        out.writeBoolean(this.isWindowEnabled);
        out.writeInt(this.tileDataArea);
        out.writeInt(this.spriteHeight);
        out.writeBoolean(this.areSpritesEnabled);
        out.writeBoolean(this.isBGBlank);
        out.writeBoolean(this.haveSpritesPriority);
        out.writeInt(this.scrollX);
        out.writeInt(this.scrollY);
        out.writeInt(this.windowX);
        out.writeInt(this.windowY);
        out.writeInt(this.nextWindowY);
        out.writeInt(this.windowLine);
        out.writeBoolean(this.isHBlankIRQEnabled);
        out.writeBoolean(this.isVBlankIRQEnabled);
        out.writeBoolean(this.isOAMIRQEnabled);
        out.writeBoolean(this.isCoincidenceIRQEnabled);
        out.writeInt(this.currentVRAMBank);
        SerializationUtils.serialize(out, this.vRAM);
        out.writeInt(this.scalingMult);
        out.writeBoolean(this.isPaintFrame);
        out.writeInt(this.bgTileMapAdr);
        out.writeInt(this.windowTileMapAdr);
        out.writeInt(this.cpuSpeedMult);
        SerializationUtils.serialize(out, this.colorBytes);
        SerializationUtils.serialize(out, this.palettes);
        SerializationUtils.serialize(out, this.tiles);
        SerializationUtils.serialize(out, this.sprites);
        SerializationUtils.serialize(out, this.backgroundPriorities);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.nextUpdate = in.readLong();
        this.mode = in.readInt();
        this.currentLine = in.readInt();
        this.isLCDEnabled = in.readBoolean();
        this.isWindowEnabled = in.readBoolean();
        this.tileDataArea = in.readInt();
        this.spriteHeight = in.readInt();
        this.areSpritesEnabled = in.readBoolean();
        this.isBGBlank = in.readBoolean();
        this.haveSpritesPriority = in.readBoolean();
        this.scrollX = in.readInt();
        this.scrollY = in.readInt();
        this.windowX = in.readInt();
        this.windowY = in.readInt();
        this.nextWindowY = in.readInt();
        this.windowLine = in.readInt();
        this.isHBlankIRQEnabled = in.readBoolean();
        this.isVBlankIRQEnabled = in.readBoolean();
        this.isOAMIRQEnabled = in.readBoolean();
        this.isCoincidenceIRQEnabled = in.readBoolean();
        this.setGBCVRAMBank(in.readInt());
        SerializationUtils.deserialize(in, this.vRAM);
        in.readInt();
        this.isPaintFrame = in.readBoolean();
        this.bgTileMapAdr = in.readInt();
        this.windowTileMapAdr = in.readInt();
        this.cpuSpeedMult = in.readInt();
        SerializationUtils.deserialize(in, this.colorBytes);
        SerializationUtils.deserialize(in, this.palettes);
        SerializationUtils.deserialize(in, this.tiles);
        SerializationUtils.deserialize(in, this.sprites);
        SerializationUtils.deserialize(in, this.backgroundPriorities);
        this.areAllTilesInvalid = false;
        this.invalidateTiles();
        this.invalidateLines();
    }

    public void update(Object observed, Object arg) {
        if (observed == this.gameboy.getCPU() && arg instanceof Long) {
            long newSpeed = (Long)arg;
            this.cpuSpeedMult = (int)(newSpeed * 1024L / 0x400000L);
        }
    }
}

