/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.emulation;

import de.joergjahnke.common.emulation.ThrottleableCPU;
import de.joergjahnke.common.util.DefaultObservable;

public class PerformanceMeter
extends DefaultObservable {
    private static final int SPEED_TARGET_PERCENTAGE = 100;
    private static final int MINIMUM_WAIT_TIME = 30;
    private static final long PERFORMANCE_MEASUREMENT_INTERVAL_SECONDS = 10000L;
    private final ThrottleableCPU cpu;
    private int targetSpeed;
    private int lastThrottle = 0;
    private long lastCorrectionTime = 0L;
    private long lastCorrectionCycles = 0L;
    private long nextPerformanceMeasurementTime;
    private long started;
    private int lastPerformance = 0;
    private boolean doThrottling = true;

    public PerformanceMeter(ThrottleableCPU cpu, int targetSpeed) {
        this.cpu = cpu;
        this.targetSpeed = targetSpeed;
    }

    public int getTargetSpeed() {
        return this.targetSpeed;
    }

    public void setTargetSpeed(int targetSpeed) {
        this.targetSpeed = targetSpeed;
    }

    public void measure(long cycles) {
        if (this.lastCorrectionTime == 0L) {
            this.setupNextMeasurement(cycles);
        } else {
            long waitTime;
            long timeDiff;
            long expectedCycles;
            long cyclesDiff;
            if (this.isDoThrottling() && (cyclesDiff = cycles - this.lastCorrectionCycles) > (expectedCycles = (timeDiff = System.currentTimeMillis() - this.lastCorrectionTime) * (long)this.getTargetSpeed() / 1000L * 100L / 100L) && (waitTime = 1000L * (cyclesDiff - expectedCycles) / (long)this.getTargetSpeed()) >= 30L) {
                this.cpu.throttle(waitTime);
            }
            if (System.currentTimeMillis() > this.nextPerformanceMeasurementTime) {
                long executed = cycles - this.started;
                this.lastThrottle = (int)(100.0 * (double)this.cpu.getThrottledTime() / 10000.0);
                this.cpu.resetThrottleTime();
                this.lastPerformance = (int)(100.0 * (double)executed / (double)this.getTargetSpeed() / 10.0);
                this.setChanged(true);
                this.notifyObservers("Emulator working at " + this.lastPerformance + "% of original CPU performance" + (this.lastThrottle > 0 ? ", " + this.lastThrottle + "% idle time" : ""));
                this.setupNextMeasurement(cycles);
            }
        }
    }

    public int getLastPerformance() {
        return this.lastPerformance;
    }

    public int getThrottlePercentage() {
        return this.lastThrottle;
    }

    public void resetThrottleMeasurement(long cycles) {
        this.lastCorrectionTime = System.currentTimeMillis();
        this.lastCorrectionCycles = cycles;
    }

    public void setupNextMeasurement(long cycles) {
        this.resetThrottleMeasurement(cycles);
        this.started = cycles;
        this.nextPerformanceMeasurementTime = System.currentTimeMillis() + 10000L;
    }

    public boolean isDoThrottling() {
        return this.doThrottling;
    }

    public void setDoThrottling(boolean doThrottling) {
        this.doThrottling = doThrottling;
    }
}

