/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.LocalizationSupport;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ButtonAssignmentCanvas
extends Canvas
implements CommandListener {
    public static final int MASK_REPEAT_KEY = Integer.MIN_VALUE;
    private final Command backCommand;
    private final Command skipCommand;
    private final Command defaultsCommand;
    private final Display display;
    private final Displayable parent;
    private final Vector buttons;
    private final Hashtable result = new Hashtable();
    private int currentButton = 0;
    private String errorMessage = null;
    private int state = 3;

    public ButtonAssignmentCanvas(Display display, Vector buttons) {
        if (buttons.size() < 1) {
            throw new IllegalArgumentException("At least one button must be provided");
        }
        this.display = display;
        this.parent = display.getCurrent();
        this.buttons = buttons;
        this.backCommand = new Command(LocalizationSupport.getMessage("Back"), 2, 99);
        this.skipCommand = new Command(LocalizationSupport.getMessage("Skip"), 8, 1);
        this.defaultsCommand = new Command(LocalizationSupport.getMessage("Defaults"), 8, 2);
        this.addCommand(this.backCommand);
        this.addCommand(this.skipCommand);
        this.addCommand(this.defaultsCommand);
        this.setCommandListener(this);
    }

    protected void paint(Graphics g) {
        g.setColor(-1);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(-16777216);
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        g.drawString(LocalizationSupport.getMessage("AssignKey"), this.getWidth() / 2, 0, 17);
        g.setFont(Font.getFont((int)0, (int)0, (int)16));
        g.drawString(this.buttons.elementAt(this.currentButton).toString(), this.getWidth() / 2, this.getHeight() / 2, 17);
        if (null != this.errorMessage) {
            g.setColor(-65536);
            g.setFont(Font.getFont((int)0, (int)1, (int)0));
            g.drawString(this.errorMessage, this.getWidth() / 2, this.getHeight(), 65);
        }
    }

    protected void keyReleased(int keyCode) {
        this.assignButton(keyCode);
    }

    protected void keyRepeated(int keyCode) {
        this.assignButton(Integer.MIN_VALUE + keyCode);
    }

    private void assignButton(int keyCode) {
        if (!this.result.containsKey(new Integer(keyCode)) && !this.result.containsKey(new Integer(keyCode + Integer.MIN_VALUE))) {
            try {
                if (this.getKeyName(keyCode).indexOf("SOFT") < 0) {
                    this.result.put(new Integer(keyCode), this.buttons.elementAt(this.currentButton));
                    this.errorMessage = null;
                    this.nextButton();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.errorMessage = "The key is already in use!";
            this.repaint();
        }
    }

    private void nextButton() {
        ++this.currentButton;
        if (this.currentButton < this.buttons.size()) {
            this.repaint();
        } else {
            this.state = 4;
            this.onFinished();
        }
    }

    public Hashtable getAssignments() {
        return this.result;
    }

    public int getState() {
        return this.state;
    }

    public void onFinished() {
        this.display.setCurrent(this.parent);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.skipCommand) {
            this.nextButton();
        } else if (c == this.backCommand) {
            this.onFinished();
        } else if (c == this.defaultsCommand) {
            this.result.clear();
            this.state = 4;
            this.onFinished();
        }
    }
}

