/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import java.io.IOException;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ImageButton
extends CustomItem {
    private static final int PADDING = 1;
    private final Image image;
    private boolean hasFocus = false;
    private boolean isPressed = false;

    public ImageButton(String imageName) throws IOException {
        super("");
        this.image = Image.createImage((String)imageName);
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    private void setPressed(boolean isPressed) {
        if (this.isPressed != isPressed) {
            this.isPressed = isPressed;
            if (isPressed) {
                this.onButtonPressed();
            }
        }
    }

    protected int getMinContentWidth() {
        return this.image.getWidth();
    }

    protected int getMinContentHeight() {
        return this.image.getHeight();
    }

    protected int getPrefContentWidth(int width) {
        return this.getMinContentWidth() + 2;
    }

    protected int getPrefContentHeight(int height) {
        return this.getMinContentHeight() + 2;
    }

    protected void paint(Graphics g, int w, int h) {
        g.setColor(this.hasFocus ? 0xE0E0E0 : 0xC0C0C0);
        g.fillRect(1, 1, w - 2, h - 2);
        g.drawImage(this.image, w / 2 + 1, h / 2 + 1, 3);
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            this.setPressed(true);
        } else {
            super.keyPressed(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            this.setPressed(false);
        } else {
            super.keyPressed(keyCode);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.setPressed(true);
    }

    protected void pointerReleased(int x, int y) {
        this.setPressed(false);
    }

    protected boolean traverse(int dir, int w, int h, int[] visRect_inout) {
        this.hasFocus = true;
        this.repaint();
        return false;
    }

    protected void traverseOut() {
        this.hasFocus = false;
        this.repaint();
    }

    public abstract void onButtonPressed();
}

