/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.util.DefaultObservable;
import de.joergjahnke.gameboy.core.Gameboy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Joypad
extends DefaultObservable
implements Serializable {
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int UP = 4;
    public static final int DOWN = 8;
    public static final int A = 1;
    public static final int B = 2;
    public static final int SELECT = 4;
    public static final int START = 8;
    private final Gameboy gameboy;
    private int directions = 0;
    private int buttons = 0;

    public Joypad(Gameboy gameboy) {
        this.gameboy = gameboy;
    }

    public int getDirections() {
        return this.directions;
    }

    public void setDirections(int directions) {
        if (directions != this.directions) {
            this.directions = directions;
            this.gameboy.getCPU().writeIO(65280, (byte)(16 + directions));
            this.setChanged(true);
            this.notifyObservers(new Integer(directions));
        }
    }

    public int getButtons() {
        return this.buttons;
    }

    public void setButtons(int buttons) {
        if (buttons != this.buttons) {
            this.buttons = buttons;
            this.gameboy.getCPU().writeIO(65280, (byte)(32 + buttons));
            this.setChanged(true);
            this.notifyObservers(new Integer(buttons));
        }
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.directions);
        out.writeInt(this.buttons);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.directions = in.readInt();
        this.buttons = in.readInt();
    }
}

