/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.gameboy.core.Tile;
import de.joergjahnke.gameboy.core.VideoChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Sprite
implements Serializable {
    protected final VideoChip video;
    private int tileId = 0;
    private Tile tile = null;
    private int attributes;
    private boolean hasPriority = true;
    private int x = -8;
    private int y = -16;
    private boolean isVisible = false;
    private boolean isDisplayable = false;

    public Sprite(VideoChip video) {
        this.video = video;
    }

    public final void setTile(int n) {
        this.tileId = n + ((this.attributes & 8) != 0 ? 384 : 0);
        this.tile = this.video.getTiles()[this.tileId];
    }

    public final void updateTile() {
        this.setTile(this.tileId & (this.video.getSpriteHeight() > 8 ? 254 : 255));
    }

    public final void setAttributes(int attributes) {
        if (attributes != this.attributes) {
            this.attributes = attributes;
            this.hasPriority = (this.attributes & 0x80) == 0;
            this.updateTile();
        }
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int x) {
        this.x = x;
        this.checkVisible();
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int y) {
        this.y = y;
        this.checkVisible();
    }

    public final int getScaledX() {
        return this.getX() * this.video.getScaling() >> 10;
    }

    public final int getScaledY() {
        return this.getY() * this.video.getScaling() >> 10;
    }

    public final int getWidth() {
        return this.tile.getWidth();
    }

    public final int getHeight() {
        return this.video.getSpriteHeight();
    }

    public final int getScaledWidth() {
        return this.getWidth() * this.video.getScaling() >> 10;
    }

    public final int getScaledHeight() {
        return this.getHeight() * this.video.getScaling() >> 10;
    }

    public final boolean hasPriority() {
        return this.hasPriority;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final boolean isDisplayable() {
        return this.isDisplayable;
    }

    private final void checkVisible() {
        this.isDisplayable = this.y + 16 >= 0 && this.y < 144;
        this.isVisible = this.isDisplayable && this.y + this.getHeight() >= 0 && this.x + this.getWidth() >= 0 && this.x < 160;
    }

    public final void drawLine(int sline) {
        VideoChip video_ = this.video;
        int scalingMult = video_.getScaling();
        int[] videoPixels = video_.getRGBData();
        byte[] backgroundPriorities_ = video_.backgroundPriorities;
        boolean hasPriority_ = this.hasPriority() || video_.isHaveSpritesPriority();
        int ssw = this.getScaledWidth();
        int[] spritePixels = sline < 8 ? this.tile.getPixels(this.attributes, true) : video_.getTiles()[this.tileId + 1].getPixels(this.attributes, true);
        int lineOffset = sline < 8 ? 0 : 8;
        int ssx = this.getScaledX();
        int ssxstart = ssx < 0 ? -ssx : 0;
        int ssystart = (sline - lineOffset) * scalingMult >> 10;
        int svw = video_.getScaledWidth();
        int svystart = (this.getY() + sline) * scalingMult >> 10;
        int svystop = (this.getY() + sline + 1) * scalingMult >> 10;
        int ssyi = ssystart;
        for (int svyi = svystart; svyi < svystop; ++svyi) {
            int offset = svyi * svw;
            int ssxi = ssxstart;
            int svx = ssx + ssxstart;
            int vx = Math.max(0, this.getX()) << 10;
            int vxinc = 1024 / scalingMult;
            while (ssxi < ssw && svx < svw) {
                int col = spritePixels[ssyi * ssw + ssxi];
                if (col != 0 && (hasPriority_ || backgroundPriorities_[vx >> 10] == 0)) {
                    videoPixels[offset + svx] = col;
                }
                ++ssxi;
                ++svx;
                vx += vxinc;
            }
            ++ssyi;
        }
    }

    public void reset() {
        this.x = -8;
        this.y = -16;
        this.isVisible = false;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.tileId);
        out.writeInt(this.attributes);
        out.writeBoolean(this.hasPriority);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeBoolean(this.isVisible);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.setTile(in.readInt());
        this.attributes = in.readInt();
        this.hasPriority = in.readBoolean();
        this.x = in.readInt();
        this.y = in.readInt();
        this.isVisible = in.readBoolean();
    }
}

