/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.Serializable;
import de.joergjahnke.common.ui.Color;
import de.joergjahnke.common.util.LRUCache;
import de.joergjahnke.gameboy.core.ColorPalette;
import de.joergjahnke.gameboy.core.TileData;
import de.joergjahnke.gameboy.core.VideoChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Tile
implements Serializable {
    public static final int TRANSPARENT = 0;
    private static final int VARIANTS = 64;
    private static final boolean RECALCULATE_SIZE_ON_INVALIDATE = false;
    private static boolean useCache = false;
    private static int cacheSize = 0;
    private static LRUCache tileCache = null;
    protected final VideoChip video;
    private final int[][] pixels = new int[64][];
    private final TileData tileData;
    private int scaledWidth;
    private int scaledHeight;
    private boolean areAllVariantsInvalid = true;

    public Tile(VideoChip video, TileData tileData) {
        this.video = video;
        this.tileData = tileData;
        this.recalculateScaledWidth();
        this.recalculateScaledHeight();
    }

    public Tile(VideoChip video, int tileDataAdr) {
        this(video, new TileData(video, tileDataAdr));
    }

    public static void resetCache() {
        if (null != tileCache) {
            tileCache.clear();
        }
    }

    public static void initializeCache() {
        long freeMem = Runtime.getRuntime().freeMemory();
        boolean bl = useCache = freeMem >= 262144L;
        cacheSize = freeMem < 262144L ? 0 : (freeMem < 524288L ? 100 : (freeMem < 0x200000L ? 500 : 1000));
        tileCache = cacheSize > 1 ? new LRUCache(cacheSize) : null;
    }

    public final int getWidth() {
        return 8;
    }

    public final int getHeight() {
        return 8;
    }

    public final int getScaledWidth() {
        return this.scaledWidth;
    }

    public final int getScaledHeight() {
        return this.scaledHeight;
    }

    private void recalculateScaledWidth() {
        this.scaledWidth = this.getWidth() * this.video.getScaling() >> 10;
    }

    private void recalculateScaledHeight() {
        this.scaledHeight = this.getHeight() * this.video.getScaling() >> 10;
    }

    public final void invalidate() {
        this.tileData.invalidate();
        if (!this.areAllVariantsInvalid) {
            int[][] pixels_ = this.pixels;
            int to = pixels_.length;
            for (int i = 0; i < to; ++i) {
                pixels_[i] = null;
            }
            this.areAllVariantsInvalid = true;
        }
    }

    public final void invalidatePalette(int palette) {
        int i = 0;
        int p = palette;
        while (i < 4) {
            this.pixels[p] = null;
            ++i;
            p += 16;
        }
    }

    public final int[] getPixels(int attributes, boolean isSprite) {
        int variant = (isSprite ? 8 : 0) + (attributes & 7) + ((attributes & 0x60) >> 1);
        int[] variantPixels = this.pixels[variant];
        return variantPixels != null ? variantPixels : this.createPixels(attributes, isSprite);
    }

    private int[] createPixels(int attributes, boolean isSprite) {
        ColorPalette palette = this.video.getColorPalettes()[(attributes & 7) + (isSprite ? 8 : 0)];
        int[] result = null;
        Integer hc = null;
        if (useCache) {
            hc = new Integer(palette.hashCode() ^ this.tileData.hashCode() ^ attributes);
            result = (int[])tileCache.get(hc);
        }
        if (result == null) {
            int height_ = this.getHeight();
            int width_ = this.getWidth();
            byte[][] colorIdxs_ = this.tileData.getColorIndexes();
            int[] rgbData_ = new int[height_ * width_];
            boolean isFlipHorizontally = (attributes & 0x20) != 0;
            boolean isFlipVertically = (attributes & 0x40) != 0;
            int cyAdd = isFlipVertically ? -1 : 1;
            int cxAdd = isFlipHorizontally ? -1 : 1;
            int y = 0;
            int cy = isFlipVertically ? height_ - 1 : 0;
            int yidx = 0;
            while (y < height_) {
                int cx;
                int x = 0;
                int n = cx = isFlipHorizontally ? width_ - 1 : 0;
                while (x < width_) {
                    byte colIdx = colorIdxs_[cy][cx];
                    rgbData_[yidx + x] = isSprite && colIdx == 0 ? 0 : palette.getColor(colIdx);
                    ++x;
                    cx += cxAdd;
                }
                ++y;
                cy += cyAdd;
                yidx += width_;
            }
            result = this.scale(rgbData_);
            if (useCache) {
                tileCache.put(hc, result);
            }
        }
        this.areAllVariantsInvalid = false;
        return result;
    }

    private int[] scale(int[] source) {
        int h;
        int sh = this.getScaledHeight();
        if (sh == (h = this.getHeight())) {
            return source;
        }
        int scalingType = this.video.getScalingType();
        int sw = this.getScaledWidth();
        int w = this.getWidth();
        int[] scaled = new int[sh * sw];
        int inc1024 = 0x100000 / this.video.getScaling();
        int y = 0;
        int sY1024 = inc1024 >> 4;
        int maxSY = h - 1;
        int yidx = 0;
        while (y < sh) {
            int x = 0;
            int sX1024 = inc1024 >> 4;
            int maxSX = w - 1;
            while (x < sw) {
                int sX1024Next = sX1024 + inc1024;
                int sY1024Next = sY1024 + inc1024;
                switch (scalingType) {
                    case 2: {
                        int x1 = sX1024 >> 10;
                        int x2 = Math.min(maxSX, sX1024Next >> 10);
                        int y2 = Math.min(maxSY, sY1024Next >> 10);
                        int offsetY1 = (sY1024 >> 10) * w;
                        int offsetY2 = y2 * w;
                        int col11 = source[offsetY1 + x1];
                        int col12 = source[offsetY1 + x2];
                        int col21 = source[offsetY2 + x1];
                        int col22 = source[offsetY2 + x2];
                        if (col11 == 0) {
                            col11 = col12;
                        } else if (col12 == 0) {
                            col12 = col11;
                        }
                        if (col21 == 0) {
                            col21 = col22;
                        } else if (col22 == 0) {
                            col22 = col21;
                        }
                        if (col11 == 0) {
                            col11 = col21;
                        } else if (col21 == 0) {
                            col21 = col11;
                        }
                        int fracX = 1024 - sX1024 % 1024;
                        int fracY = 1024 - sY1024 % 1024;
                        int fraction11 = fracX * fracY >> 10;
                        int fraction12 = (1024 - fracX) * fracY >> 10;
                        int fraction21 = fracX * (1024 - fracY) >> 10;
                        int fraction22 = (1024 - fracX) * (1024 - fracY) >> 10;
                        scaled[yidx + x] = Color.mix(col11, fraction11, col12, fraction12, col21, fraction21, col22, fraction22);
                        break;
                    }
                    case 1: {
                        int x1 = sX1024 >> 10;
                        int x2 = Math.min(maxSX, sX1024Next >> 10);
                        int y2 = Math.min(maxSY, sY1024Next >> 10);
                        int offsetY1 = (sY1024 >> 10) * w;
                        int offsetY2 = y2 * w;
                        int col11 = source[offsetY1 + x1];
                        int col12 = source[offsetY1 + x2];
                        int col21 = source[offsetY2 + x1];
                        int col22 = source[offsetY2 + x2];
                        if (col11 == 0) {
                            col11 = col12;
                        } else if (col12 == 0) {
                            col12 = col11;
                        }
                        if (col21 == 0) {
                            col21 = col22;
                        } else if (col22 == 0) {
                            col22 = col21;
                        }
                        if (col11 == 0) {
                            col11 = col21;
                        } else if (col21 == 0) {
                            col21 = col11;
                        }
                        scaled[yidx + x] = Color.mix(col11, col12, col21, col22);
                        break;
                    }
                    case 3: {
                        int col22;
                        int col21;
                        int col12;
                        int col11;
                        int offsetY2;
                        int offsetY1;
                        int y2;
                        int x2;
                        int x1;
                        if (x % 3 == 1 || y % 3 == 1) {
                            int offsetY12;
                            if (x % 3 == 1 && y % 3 == 1) {
                                x1 = sX1024 >> 10;
                                x2 = Math.min(maxSX, sX1024Next >> 10);
                                y2 = Math.min(maxSY, sY1024Next >> 10);
                                offsetY1 = (sY1024 >> 10) * w;
                                offsetY2 = y2 * w;
                                col11 = source[offsetY1 + x1];
                                col12 = source[offsetY1 + x2];
                                col21 = source[offsetY2 + x1];
                                col22 = source[offsetY2 + x2];
                                if (col11 == 0) {
                                    col11 = col12;
                                } else if (col12 == 0) {
                                    col12 = col11;
                                }
                                if (col21 == 0) {
                                    col21 = col22;
                                } else if (col22 == 0) {
                                    col22 = col21;
                                }
                                if (col11 == 0) {
                                    col11 = col21;
                                } else if (col21 == 0) {
                                    col21 = col11;
                                }
                                scaled[yidx + x] = Color.mix(col11, col12, col21, col22);
                                break;
                            }
                            if (x % 3 == 1) {
                                x1 = sX1024 >> 10;
                                x2 = Math.min(maxSX, sX1024Next >> 10);
                                offsetY12 = (sY1024 >> 10) * w;
                                int col112 = source[offsetY12 + x1];
                                int col122 = source[offsetY12 + x2];
                                if (col112 == 0) {
                                    scaled[yidx + x] = col122;
                                    break;
                                }
                                if (col122 == 0) {
                                    scaled[yidx + x] = col112;
                                    break;
                                }
                                scaled[yidx + x] = Color.mix(col112, col122);
                                break;
                            }
                            x1 = sX1024 >> 10;
                            int y22 = Math.min(maxSY, sY1024Next >> 10);
                            offsetY12 = (sY1024 >> 10) * w;
                            int offsetY22 = y22 * w;
                            int col113 = source[offsetY12 + x1];
                            int col212 = source[offsetY22 + x1];
                            if (col113 == 0) {
                                scaled[yidx + x] = col212;
                                break;
                            }
                            if (col212 == 0) {
                                scaled[yidx + x] = col113;
                                break;
                            }
                            scaled[yidx + x] = Color.mix(col113, col212);
                            break;
                        }
                        scaled[yidx + x] = source[(sY1024 >> 10) * w + (sX1024 >> 10)];
                        break;
                    }
                    default: {
                        scaled[yidx + x] = source[(sY1024 >> 10) * w + (sX1024 >> 10)];
                    }
                }
                ++x;
                sX1024 += inc1024;
            }
            ++y;
            sY1024 += inc1024;
            yidx += sw;
        }
        return scaled;
    }

    public final void drawLine(int tline, int vx, int vy, int attributes) {
        int[] tilePixels = this.getPixels(attributes, false);
        VideoChip video_ = this.video;
        int[] videoPixels = video_.pixels;
        int scaling1024 = video_.scalingMult;
        int svw = video_.scaledWidth;
        int stw = this.scaledWidth;
        int svx = vx * scaling1024 >> 10;
        int svy = vy * scaling1024 >> 10;
        int svystop = (vy + 1) * scaling1024 >> 10;
        int columns = 8;
        int bppos = vx;
        int bpstart = 0;
        int scolumns = stw;
        int stpos = (tline * scaling1024 >> 10) * stw;
        int svpos = svy * svw + svx;
        if (vx < 0) {
            columns += vx;
            scolumns += svx;
            bppos -= vx;
            bpstart = -vx;
            stpos -= svx;
            svpos -= svx;
        } else if (vx > 152) {
            columns = 160 - vx;
            scolumns = svw - svx;
        }
        for (int svyi = svy; svyi < svystop; ++svyi) {
            System.arraycopy(tilePixels, stpos, videoPixels, svpos, scolumns);
            stpos += stw;
            svpos += svw;
        }
        System.arraycopy(this.tileData.colorsIdxs[tline], bpstart, video_.backgroundPriorities, bppos, columns);
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.scaledWidth);
        out.writeInt(this.scaledHeight);
    }

    public void deserialize(DataInputStream in) throws IOException {
        in.readInt();
        in.readInt();
        this.areAllVariantsInvalid = false;
        this.invalidate();
    }

    static {
        Tile.initializeCache();
    }
}

