/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.gameboy.core.VideoChip;

public class TileData {
    protected final VideoChip video;
    protected final int tileDataAdr;
    private final int height;
    protected byte[][] colorsIdxs;
    private int pixelsCode = Integer.MAX_VALUE;

    public TileData(VideoChip video, int tileDataAdr) {
        this(video, tileDataAdr, 8);
    }

    public TileData(VideoChip video, int tileDataAdr, int height) {
        this.video = video;
        this.tileDataAdr = tileDataAdr;
        this.height = height;
    }

    private int getTileDataAddress() {
        return this.tileDataAdr;
    }

    public final int getWidth() {
        return 8;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void invalidate() {
        this.colorsIdxs = null;
        this.pixelsCode = Integer.MAX_VALUE;
    }

    protected final byte[][] getColorIndexes() {
        if (this.colorsIdxs == null) {
            this.colorsIdxs = this.createColorIndexes();
        }
        return this.colorsIdxs;
    }

    private byte[][] createColorIndexes() {
        byte[] vRAM = this.video.vRAM;
        int height_ = this.getHeight();
        int width_ = this.getWidth();
        byte[][] colorIdxs_ = new byte[height_][width_];
        int adr = this.getTileDataAddress() & (height_ == 8 ? 16383 : 16382);
        for (int y = 0; y < height_; ++y) {
            int data1 = vRAM[adr++] & 0xFF;
            int data2 = vRAM[adr++] & 0xFF;
            int x = 0;
            int mask = 128;
            while (x < width_) {
                colorIdxs_[y][x] = (byte)(((data1 & mask) != 0 ? 1 : 0) + ((data2 & mask) != 0 ? 2 : 0));
                ++x;
                mask >>= 1;
            }
        }
        return colorIdxs_;
    }

    public final int hashCode() {
        if (this.pixelsCode == Integer.MAX_VALUE) {
            int hc = 0;
            byte[][] colorsIdxs_ = this.getColorIndexes();
            int y = 0;
            int y2 = 0;
            int toY = this.colorsIdxs.length;
            while (y < toY) {
                byte[] colorsLine = colorsIdxs_[y];
                int x = 0;
                int x2 = 0;
                int toX = colorsLine.length;
                while (x < toX) {
                    hc ^= colorsLine[x] << (x2 + y2) % 20;
                    ++x;
                    x2 += 19;
                }
                ++y;
                y2 += 7;
            }
            this.pixelsCode = hc;
        }
        return this.pixelsCode;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.hashCode() == ((TileData)obj).hashCode();
    }
}

