/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.gameboy.core;

import de.joergjahnke.common.io.SerializationUtils;
import de.joergjahnke.gameboy.core.SoundChannel;
import de.joergjahnke.gameboy.core.SoundChip;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VoluntaryWaveChannel
extends SoundChannel {
    private static final int BUFFER_SIZE = 32;
    private int volumePercent = 0;
    private boolean active = true;
    private int[] wavePatterns = new int[32];

    public VoluntaryWaveChannel(SoundChip sound) {
        super(sound);
    }

    public boolean isActive() {
        return super.isActive() && this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setOutputLevel(int volume) {
        this.volumePercent = volume;
        this.volume = 15 * volume / 100;
    }

    public void setFrequency(int frequencyGB) {
        this.frequency = 65536 / (2048 - frequencyGB);
    }

    public void setWavePattern(int idx, byte value) {
        this.wavePatterns[idx << 1] = value >> 4;
        this.wavePatterns[(idx << 1) + 1] = value & 0xF;
    }

    public void update() {
        --this.length;
    }

    public void mix(byte[] buffer) {
        int sampleRate = this.sound.getSampleRate();
        boolean isLeftActive = this.isTerminalActive(0);
        boolean isRightActive = this.isTerminalActive(1);
        int to = buffer.length;
        for (int i = 0; i < to; i += 2) {
            int sample;
            int idx = this.audioIndex % sampleRate * 32 / sampleRate;
            int n = sample = this.active ? this.wavePatterns[idx] * this.volumePercent / 100 << 1 : 0;
            if (isLeftActive) {
                int n2 = i + 0;
                buffer[n2] = (byte)(buffer[n2] + sample);
            }
            if (isRightActive) {
                int n3 = i + 1;
                buffer[n3] = (byte)(buffer[n3] + sample);
            }
            this.audioIndex += this.frequency;
            this.audioIndex %= sampleRate;
        }
    }

    public final int getFrequency() {
        return Math.min(12544, this.startFrequency);
    }

    public final int getVolume() {
        return this.hasSound() && this.length > 0 ? this.startVolume * 100 / 15 : 0;
    }

    public final int getType() {
        return 0;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeInt(this.volumePercent);
        out.writeBoolean(this.active);
        SerializationUtils.serialize(out, this.wavePatterns);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.volumePercent = in.readInt();
        this.active = in.readBoolean();
        SerializationUtils.deserialize(in, this.wavePatterns);
    }
}

