/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class EmAppleII
extends Em6502
implements Runnable {
    public static final int physZeroPage = 0;
    public static final int physStack = 256;
    public static final int mainRAM1 = 512;
    public static final int mainRAMText = 1024;
    public static final int mainRAM2 = 2048;
    public static final int mainRAMHires = 8192;
    public static final int mainRAM3 = 16384;
    public static final int mainLC1 = 49152;
    public static final int mainLC2 = 53248;
    public static final int mainLCHigh = 57344;
    public static final int auxZeroPage = 65536;
    public static final int auxStack = 65792;
    public static final int auxRAM1 = 66048;
    public static final int auxRAMText = 66560;
    public static final int auxRAM2 = 67584;
    public static final int auxRAMHires = 73728;
    public static final int auxRAM3 = 81920;
    public static final int auxLC1 = 114688;
    public static final int auxLC2 = 118784;
    public static final int auxLCHigh = 122880;
    public static final int romMain = 131072;
    public static final int romInternal = 143360;
    public static final int romExternal = 147456;
    public static final int mainZeroPage = 151552;
    public static final int mainStack = 151808;
    public static final int memEnd = 152064;
    public boolean[] dirty = new boolean[192];
    public Paddle paddle;
    public Peripheral[] slots;
    public DiskII disk;
    public ProDOSClock prodosClock;
    boolean isCtrlReset;
    public static final int GR_TEXT = 1;
    public static final int GR_MIXMODE = 2;
    public static final int GR_PAGE2 = 4;
    public static final int GR_HIRES = 8;
    public static final int GR_80STORE = 16;
    public static final int GR_80CHAR = 32;
    public static final int GR_ALTCHAR = 64;
    public static final int GR_DHIRES = 128;
    public int keyboardLatch;
    public int graphicsMode;
    protected boolean isLcReadEnable = false;
    protected boolean isLcWriteEnable = false;
    protected boolean isLcBank2 = false;
    protected int lcReadOffset;
    protected int lcReadOffsetHigh;
    protected int lcWriteOffset;
    protected int lcWriteOffsetHigh;
    protected boolean isRomInternal;
    protected boolean isRomC3External;
    protected boolean isAuxRead;
    protected boolean isAuxWrite;
    protected boolean isAuxZeroPage;
    protected boolean isVideoVBL;
    protected int ramReadOffset;
    protected int ramWriteOffset;
    protected int textReadOffset;
    protected int textWriteOffset;
    protected int hiresReadOffset;
    protected int hiresWriteOffset;
    protected int romOffset;
    protected int romC3Offset;
    private Thread thread;
    private boolean threadStop = false;
    private boolean threadPause = true;
    public String threadError = null;
    public long delay100ms;
    private boolean debugMode = false;
    private boolean debugNextStep = false;
    private int debugSteps = 1;

    public EmAppleII() {
        this.initBCD();
        this.mem = new byte[152320];
        this.clock = (int)(System.currentTimeMillis() & 0x3FFFL);
        this.paddle = new Paddle(this);
        this.slots = new Peripheral[8];
        block4: for (int i = 1; i < 8; ++i) {
            switch (i) {
                case 6: {
                    this.disk = new DiskII(this, i);
                    this.slots[i] = this.disk;
                    continue block4;
                }
                case 7: {
                    this.prodosClock = new ProDOSClock(this, i);
                    this.slots[i] = this.prodosClock;
                    continue block4;
                }
                default: {
                    this.slots[i] = new Peripheral(this, i);
                }
            }
        }
        this.thread = new Thread(this);
        this.thread.setPriority(5);
        this.thread.start();
    }

    public void go() {
        this.threadPause = false;
    }

    public void pause() {
        this.threadPause = true;
    }

    public void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public void toggleDebugStep() {
        switch (this.debugSteps) {
            case 1: {
                this.debugSteps = 128;
                break;
            }
            case 128: {
                this.debugSteps = 1;
            }
        }
    }

    public void debugNextStep() {
        this.debugNextStep = true;
    }

    public final int noise() {
        return this.mem[this.clock & 0x3FFF];
    }

    public int memoryRead(int n) {
        switch (n >> 8) {
            case 0: 
            case 1: {
                return this.mem[n] & 0xFF;
            }
            case 2: 
            case 3: {
                return this.mem[n + this.ramReadOffset] & 0xFF;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.mem[n + this.textReadOffset] & 0xFF;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.mem[n + this.ramReadOffset] & 0xFF;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.mem[n + this.hiresReadOffset] & 0xFF;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return this.mem[n + this.ramReadOffset] & 0xFF;
            }
            case 192: {
                return this.ioRead(n);
            }
            case 193: 
            case 194: {
                return this.mem[n + this.romOffset] & 0xFF;
            }
            case 195: {
                return this.mem[n + this.romC3Offset] & 0xFF;
            }
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return this.mem[n + this.romOffset] & 0xFF;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                return this.mem[n + this.lcReadOffset] & 0xFF;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return this.mem[n + this.lcReadOffsetHigh] & 0xFF;
            }
        }
        return 0;
    }

    public void memoryWrite(int n, int n2) {
        switch (n >> 8) {
            case 0: 
            case 1: {
                this.mem[n] = (byte)n2;
                return;
            }
            case 2: 
            case 3: {
                this.mem[n + this.ramWriteOffset] = (byte)n2;
                return;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.mem[n + this.textWriteOffset] = (byte)n2;
                this.dirty[n >> 7] = true;
                return;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.mem[n + this.ramWriteOffset] = (byte)n2;
                this.dirty[n >> 7] = true;
                return;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.mem[n + this.ramWriteOffset] = (byte)n2;
                return;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.mem[n + this.hiresWriteOffset] = (byte)n2;
                this.dirty[n >> 7] = true;
                return;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.mem[n + this.ramWriteOffset] = (byte)n2;
                this.dirty[n >> 7] = true;
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.mem[n + this.ramWriteOffset] = (byte)n2;
                return;
            }
            case 192: {
                this.ioWrite(n, n2);
                return;
            }
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                if (this.isLcWriteEnable) {
                    this.mem[n + this.lcWriteOffset] = (byte)n2;
                }
                return;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                if (this.isLcWriteEnable) {
                    this.mem[n + this.lcWriteOffsetHigh] = (byte)n2;
                }
                return;
            }
        }
    }

    public void updateMemoryMapMain() {
        if ((this.graphicsMode & 0x10) == 0) {
            this.textReadOffset = this.hiresReadOffset = this.ramReadOffset;
            this.textWriteOffset = this.hiresWriteOffset = this.ramWriteOffset;
        } else if ((this.graphicsMode & 8) == 0) {
            if ((this.graphicsMode & 4) == 0) {
                this.textReadOffset = 0;
                this.textWriteOffset = 0;
            } else {
                this.textReadOffset = 65536;
                this.textWriteOffset = 65536;
            }
            this.hiresReadOffset = this.ramReadOffset;
            this.hiresWriteOffset = this.ramWriteOffset;
        } else if ((this.graphicsMode & 4) == 0) {
            this.textReadOffset = 0;
            this.textWriteOffset = 0;
            this.hiresReadOffset = 0;
            this.hiresWriteOffset = 0;
        } else {
            this.textReadOffset = 65536;
            this.textWriteOffset = 65536;
            this.hiresReadOffset = 65536;
            this.hiresWriteOffset = 65536;
        }
    }

    public void updateMemoryMapLC() {
        if (!this.isLcReadEnable) {
            this.lcReadOffset = 77824;
            this.lcReadOffsetHigh = 77824;
        } else {
            this.lcReadOffset = this.isLcBank2 ? 0 : -4096;
            this.lcReadOffsetHigh = 0;
            if (this.isAuxZeroPage) {
                this.lcReadOffset += 65536;
                this.lcReadOffsetHigh += 65536;
            }
        }
        if (this.isLcWriteEnable) {
            this.lcWriteOffset = this.isLcBank2 ? 0 : -4096;
            this.lcWriteOffsetHigh = 0;
            if (this.isAuxZeroPage) {
                this.lcWriteOffset += 65536;
                this.lcWriteOffsetHigh += 65536;
            }
        }
    }

    private final int ioRead(int n) {
        switch (n & 0xFF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.keyboardLatch;
            }
            case 16: {
                this.keyboardLatch &= 0x7F;
                return this.keyboardLatch & 0x7F;
            }
            case 17: {
                return this.keyboardLatch & 0x7F | (this.isLcBank2 ? 128 : 0);
            }
            case 18: {
                return this.keyboardLatch & 0x7F | (this.isLcReadEnable ? 128 : 0);
            }
            case 19: {
                return this.keyboardLatch & 0x7F | (this.isAuxRead ? 128 : 0);
            }
            case 20: {
                return this.keyboardLatch & 0x7F | (this.isAuxWrite ? 128 : 0);
            }
            case 21: {
                return this.keyboardLatch & 0x7F | (this.isRomInternal ? 128 : 0);
            }
            case 22: {
                return this.keyboardLatch & 0x7F | (this.isAuxZeroPage ? 128 : 0);
            }
            case 23: {
                return this.keyboardLatch & 0x7F | (this.isRomC3External ? 128 : 0);
            }
            case 24: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x10) != 0 ? 128 : 0);
            }
            case 25: {
                this.isVideoVBL = !this.isVideoVBL;
                return this.keyboardLatch & 0x7F | (this.isVideoVBL ? 128 : 0);
            }
            case 26: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 1) != 0 ? 128 : 0);
            }
            case 27: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 2) != 0 ? 128 : 0);
            }
            case 28: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 4) != 0 ? 128 : 0);
            }
            case 29: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 8) != 0 ? 128 : 0);
            }
            case 30: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x40) != 0 ? 128 : 0);
            }
            case 31: {
                return this.keyboardLatch & 0x7F | ((this.graphicsMode & 0x20) != 0 ? 128 : 0);
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                break;
            }
            case 80: {
                this.graphicsMode &= 0xFFFFFFFE;
                break;
            }
            case 81: {
                this.graphicsMode |= 1;
                break;
            }
            case 82: {
                this.graphicsMode &= 0xFFFFFFFD;
                break;
            }
            case 83: {
                this.graphicsMode |= 2;
                break;
            }
            case 84: {
                this.graphicsMode &= 0xFFFFFFFB;
                this.updateMemoryMapMain();
                break;
            }
            case 85: {
                this.graphicsMode |= 4;
                this.updateMemoryMapMain();
                break;
            }
            case 86: {
                this.graphicsMode &= 0xFFFFFFF7;
                this.updateMemoryMapMain();
                break;
            }
            case 87: {
                this.graphicsMode |= 8;
                this.updateMemoryMapMain();
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 94: {
                this.graphicsMode |= 0x80;
                break;
            }
            case 95: {
                this.graphicsMode &= 0xFFFFFF7F;
                break;
            }
            case 96: 
            case 104: {
                return this.paddle.getButtonRegister(3);
            }
            case 97: 
            case 105: {
                return this.paddle.getButtonRegister(0);
            }
            case 98: 
            case 106: {
                return this.paddle.getButtonRegister(1);
            }
            case 99: 
            case 107: {
                return this.paddle.getButtonRegister(2);
            }
            case 100: 
            case 108: {
                return this.paddle.getPaddleRegister(0);
            }
            case 101: 
            case 109: {
                return this.paddle.getPaddleRegister(1);
            }
            case 102: 
            case 110: {
                return this.paddle.getPaddleRegister(2);
            }
            case 103: 
            case 111: {
                return this.paddle.getPaddleRegister(3);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.paddle.triggerRegister();
                break;
            }
            case 128: 
            case 132: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 129: 
            case 133: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 130: 
            case 134: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 131: 
            case 135: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 136: 
            case 140: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 137: 
            case 141: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 138: 
            case 142: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 139: 
            case 143: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.slots[1].ioRead(n);
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                return this.slots[2].ioRead(n);
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return this.slots[3].ioRead(n);
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                return this.slots[4].ioRead(n);
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                return this.slots[5].ioRead(n);
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                return this.disk.ioRead(n);
            }
            case 236: {
                return this.disk.ioLatchC();
            }
            case 237: {
                this.disk.ioLatchD(255);
                return 60;
            }
            case 238: {
                return this.disk.ioLatchE();
            }
            case 239: {
                this.disk.ioLatchF(255);
                return 60;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return this.slots[7].ioRead(n);
            }
        }
        return this.noise();
    }

    private final void ioWrite(int n, int n2) {
        switch (n & 0xFF) {
            case 0: {
                this.graphicsMode &= 0xFFFFFFEF;
                this.updateMemoryMapMain();
                return;
            }
            case 1: {
                this.graphicsMode |= 0x10;
                this.updateMemoryMapMain();
                return;
            }
            case 2: {
                this.isAuxRead = false;
                this.ramReadOffset = 0;
                this.updateMemoryMapMain();
                return;
            }
            case 3: {
                this.isAuxRead = true;
                this.ramReadOffset = 65536;
                this.updateMemoryMapMain();
                return;
            }
            case 4: {
                this.isAuxWrite = false;
                this.ramWriteOffset = 0;
                this.updateMemoryMapMain();
                return;
            }
            case 5: {
                this.isAuxWrite = true;
                this.ramWriteOffset = 65536;
                this.updateMemoryMapMain();
                return;
            }
            case 6: {
                this.isRomInternal = false;
                this.romOffset = 98304;
                return;
            }
            case 7: {
                this.isRomInternal = true;
                this.romOffset = 94208;
                return;
            }
            case 8: {
                if (this.isAuxZeroPage) {
                    System.arraycopy(this.mem, 0, this.mem, 65536, 512);
                    System.arraycopy(this.mem, 151552, this.mem, 0, 512);
                }
                this.isAuxZeroPage = false;
                this.updateMemoryMapLC();
                return;
            }
            case 9: {
                if (!this.isAuxZeroPage) {
                    System.arraycopy(this.mem, 0, this.mem, 151552, 512);
                    System.arraycopy(this.mem, 65536, this.mem, 0, 512);
                }
                this.isAuxZeroPage = true;
                this.updateMemoryMapLC();
                return;
            }
            case 10: {
                this.isRomC3External = false;
                this.romC3Offset = 94208;
                return;
            }
            case 11: {
                this.isRomC3External = true;
                this.romC3Offset = 98304;
                return;
            }
            case 12: {
                this.graphicsMode &= 0xFFFFFFDF;
                return;
            }
            case 13: {
                this.graphicsMode |= 0x20;
                return;
            }
            case 14: {
                this.graphicsMode &= 0xFFFFFFBF;
                return;
            }
            case 15: {
                this.graphicsMode |= 0x40;
                return;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.keyboardLatch &= 0x7F;
                return;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                return;
            }
            case 80: {
                this.graphicsMode &= 0xFFFFFFFE;
                return;
            }
            case 81: {
                this.graphicsMode |= 1;
                return;
            }
            case 82: {
                this.graphicsMode &= 0xFFFFFFFD;
                return;
            }
            case 83: {
                this.graphicsMode |= 2;
                return;
            }
            case 84: {
                this.graphicsMode &= 0xFFFFFFFB;
                this.updateMemoryMapMain();
                return;
            }
            case 85: {
                this.graphicsMode |= 4;
                this.updateMemoryMapMain();
                return;
            }
            case 86: {
                this.graphicsMode &= 0xFFFFFFF7;
                this.updateMemoryMapMain();
                return;
            }
            case 87: {
                this.graphicsMode |= 8;
                this.updateMemoryMapMain();
                return;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                return;
            }
            case 94: {
                this.graphicsMode |= 0x80;
                break;
            }
            case 95: {
                this.graphicsMode &= 0xFFFFFF7F;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.paddle.triggerRegister();
                return;
            }
            case 128: 
            case 132: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 129: 
            case 133: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 130: 
            case 134: {
                this.isLcBank2 = true;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 131: 
            case 135: {
                this.isLcBank2 = true;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 136: 
            case 140: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 137: 
            case 141: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 138: 
            case 142: {
                this.isLcBank2 = false;
                this.isLcReadEnable = false;
                this.isLcWriteEnable = false;
                this.updateMemoryMapLC();
                break;
            }
            case 139: 
            case 143: {
                this.isLcBank2 = false;
                this.isLcReadEnable = true;
                this.isLcWriteEnable = true;
                this.updateMemoryMapLC();
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                this.slots[1].ioWrite(n, n2);
                return;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.slots[2].ioWrite(n, n2);
                return;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.slots[3].ioWrite(n, n2);
                return;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                this.slots[4].ioWrite(n, n2);
                return;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                this.slots[5].ioWrite(n, n2);
                return;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                this.disk.ioWrite(n, n2);
                return;
            }
            case 236: {
                this.disk.ioLatchC();
                return;
            }
            case 237: {
                this.disk.ioLatchD(n2);
                return;
            }
            case 238: {
                this.disk.ioLatchE();
                return;
            }
            case 239: {
                this.disk.ioLatchF(n2);
                return;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                this.slots[7].ioWrite(n, n2);
                return;
            }
        }
    }

    public void run() {
        try {
            while (!this.threadStop) {
                long l = System.currentTimeMillis();
                if (!this.threadPause) {
                    if (this.debugMode) {
                        if (this.debugNextStep) {
                            this.debugNextStep = false;
                            this.executeInstructions(this.debugSteps);
                        }
                    } else {
                        int n = this.clock + 100000;
                        while (this.clock < n) {
                            this.executeInstructions(1 + (n - this.clock >> 3));
                        }
                    }
                }
                this.delay100ms = System.currentTimeMillis() - l;
                if (this.delay100ms < 100L) {
                    Thread.sleep(100L - this.delay100ms);
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            this.threadError = throwable.toString();
        }
    }

    public void keyPressed(int n) {
        this.keyboardLatch = n = (n | 0x80) & 0xFF;
    }

    public void resetAssertion() {
        int n;
        this.ioWrite(0, 0);
        this.ioWrite(2, 0);
        this.ioWrite(4, 0);
        this.ioWrite(6, 0);
        this.ioWrite(8, 0);
        this.ioWrite(10, 0);
        this.ioWrite(12, 0);
        this.ioWrite(14, 0);
        this.ioWrite(80, 0);
        this.ioWrite(82, 0);
        this.ioWrite(84, 0);
        this.ioWrite(86, 0);
        this.ioWrite(95, 0);
        this.ioWrite(130, 0);
        if (this.isCtrlReset) {
            for (n = 0; n < 131072; ++n) {
                this.mem[n] = 0;
            }
        }
        for (n = 1; n < 8; ++n) {
            this.slots[n].reset();
        }
    }

    public void reboot() {
        this.isCtrlReset = true;
        this.assertReset();
    }

    public void reset() {
        this.isCtrlReset = false;
        this.assertReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadROM(String string) {
        boolean bl = false;
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return bl;
        }
        try {
            int n = inputStream.read();
            if (n != 111 && n != 169) {
                inputStream.skip(4095L);
                n = inputStream.read();
                if (n != 111 && n != 169) {
                    inputStream.skip(4095L);
                    n = inputStream.read();
                }
            }
            if (n == 111 || n == 169) {
                this.mem[131072] = (byte)n;
                inputStream.read(this.mem, 131073, 12287);
                this.mem[142504] = -87;
                this.mem[142505] = 0;
                this.mem[142506] = 96;
                inputStream.read(this.mem, 143360, 4096);
                System.arraycopy(this.mem, 145408, this.mem, 149504, 2048);
                bl = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }
}

