/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class KeyboardPalette
implements CommandListener {
    private Command selectCommand = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 8, 1);
    private Command backCommand = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
    private Display display;
    private EmAppleII apple;
    private Displayable dispBack;
    private List keyboardPalette;
    private List ctrlPalette;
    private List charPalette;

    public KeyboardPalette(Display display, EmAppleII emAppleII) {
        this.display = display;
        this.apple = emAppleII;
        String[] stringArray = new String[]{"RETURN", "ESC", "CTRL+", "RESET", " 0", ".,1:;?!", "ABC2\"", "DEF3#", "GHI4$", "JKL5%", "MNO6&^", "PQRS7'@", "TUV8(", "WXYZ9)", "*+-/=<>"};
        this.keyboardPalette = new List("\u0420\u0430\u0441\u043a\u043b\u0430\u0434\u043a\u0430 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b", 3, stringArray, null);
        this.keyboardPalette.setSelectCommand(this.selectCommand);
        this.keyboardPalette.addCommand(this.backCommand);
        this.keyboardPalette.setCommandListener((CommandListener)this);
        String[] stringArray2 = new String[]{"CTRL+RESET", "CTRL+A", "CTRL+B", "CTRL+C (BREAK)", "CTRL+D", "CTRL+E", "CTRL+F", "CTRL+G (BELL)", "CTRL+H (LEFT)", "CTRL+I (TAB)", "CTRL+J (DOWN)", "CTRL+K (UP)", "CTRL+L", "CTRL+M (RETURN)", "CTRL+N", "CTRL+O", "CTRL+P", "CTRL+Q", "CTRL+R", "CTRL+S (PAUSE)", "CTRL+T", "CTRL+U (RIGHT)", "CTRL+V", "CTRL+W", "CTRL+X (CANCEL)", "CTRL+Y", "CTRL+Z", "ESC", "FS", "GS", "RS", "US"};
        this.ctrlPalette = new List("\u0420\u0430\u0441\u043a\u043b\u0430\u0434\u043a\u0430 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b", 3, stringArray2, null);
        this.ctrlPalette.setSelectCommand(this.selectCommand);
        this.ctrlPalette.addCommand(this.backCommand);
        this.ctrlPalette.setCommandListener((CommandListener)this);
        this.charPalette = new List("\u0420\u0430\u0441\u043a\u043b\u0430\u0434\u043a\u0430 \u043a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u044b", 3);
        this.charPalette.setSelectCommand(this.selectCommand);
        this.charPalette.addCommand(this.backCommand);
        this.charPalette.setCommandListener((CommandListener)this);
    }

    public void show() {
        this.dispBack = this.display.getCurrent();
        this.display.setCurrent((Displayable)this.keyboardPalette);
    }

    private void buildCharPalette(String string) {
        this.charPalette.deleteAll();
        for (int i = 0; i < string.length(); ++i) {
            this.charPalette.append(string.substring(i, i + 1), null);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable.equals(this.keyboardPalette)) {
            if (command.equals(this.selectCommand)) {
                int n = this.keyboardPalette.getSelectedIndex();
                switch (n) {
                    case 0: {
                        this.apple.keyPressed(13);
                        break;
                    }
                    case 1: {
                        this.apple.keyPressed(27);
                        break;
                    }
                    case 2: {
                        this.display.setCurrent((Displayable)this.ctrlPalette);
                        return;
                    }
                    case 3: {
                        this.apple.reset();
                        break;
                    }
                    default: {
                        this.buildCharPalette(this.keyboardPalette.getString(n));
                        this.display.setCurrent((Displayable)this.charPalette);
                        return;
                    }
                }
                this.display.setCurrent(this.dispBack);
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent(this.dispBack);
            }
        } else if (displayable.equals(this.ctrlPalette)) {
            if (command.equals(this.selectCommand)) {
                int n = this.ctrlPalette.getSelectedIndex();
                if (n == 0) {
                    this.apple.reboot();
                } else {
                    this.apple.keyPressed(n);
                }
                this.display.setCurrent(this.dispBack);
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.keyboardPalette);
            }
        } else if (displayable.equals(this.charPalette)) {
            if (command.equals(this.selectCommand)) {
                String string = this.charPalette.getString(this.charPalette.getSelectedIndex());
                this.apple.keyPressed(string.charAt(0));
                this.display.setCurrent(this.dispBack);
            } else if (command.equals(this.backCommand)) {
                this.display.setCurrent((Displayable)this.keyboardPalette);
            }
        }
    }
}

