/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class GBEmulator
extends GameCanvas
implements CommandListener {
    public final Engine engine = new Engine(this);
    private int[] nativeSCR;
    public final int[] m_aaI = new int[64];
    public long rsm_last_time;
    public int ms_passed;
    public int rsm_fps;
    public String rsm_message = "";
    public static boolean rsm_scaledScreen;
    public InputStream m_aInputStream;
    public int m_cI;
    private Graphics graphics;
    private String rsm_game_name;
    private GB4ME gb4me;
    public static int[] key_map;
    public static int frame_skip;
    public static boolean rsm_fullscr;
    private Command cmdMainMenu;
    private Command cmdSwitchScale;
    private Command cmdSaveState;
    private Command cmdReset;
    private Command cmdPause;
    private Command cmdResume;
    public static boolean show_fps;
    public static int rsm_screenOrientation;
    private Thread thread;
    private int rsm_DX;
    private int rsm_DY;
    private boolean m_dZ;
    private boolean m_eZ;
    private boolean m_fZ;
    private boolean m_gZ;
    private boolean m_hZ;
    private boolean m_iZ;
    private boolean m_jZ;
    private boolean m_kZ;
    private int rsm_canvasW;
    private int rsm_canvasH;
    private int rsm_scaledSW;
    private int rsm_scaledSH;
    private int rsm_SW;
    private int rsm_SH;
    private int native_sw;
    private int[] native_rows;
    private int[] native_cols;
    private int[] scaledSCR;
    private boolean rsm_emulationPaused;
    private boolean saving_state;

    public GBEmulator(String string, GB4ME gB4ME) {
        super(true);
        int n;
        this.rsm_game_name = string;
        this.gb4me = gB4ME;
        this.graphics = this.getGraphics();
        this.setFullScreenMode(rsm_fullscr);
        this.rsm_canvasW = this.getWidth();
        this.rsm_canvasH = this.getHeight();
        this.nativeSCR = new int[23040];
        if (rsm_screenOrientation == 0) {
            this.rsm_SW = 160;
            this.rsm_SH = 144;
            if (this.rsm_canvasH > this.rsm_canvasW * 9 / 10) {
                this.rsm_scaledSH = this.rsm_canvasW * 9 / 10;
                this.rsm_scaledSW = this.rsm_canvasW;
            } else {
                this.rsm_scaledSW = this.rsm_canvasH * 10 / 9;
                this.rsm_scaledSH = this.rsm_canvasH;
            }
        } else {
            this.rsm_SW = 144;
            this.rsm_SH = 160;
            if (this.rsm_canvasW > this.rsm_canvasH * 9 / 10) {
                this.rsm_scaledSW = this.rsm_canvasH * 9 / 10;
                this.rsm_scaledSH = this.rsm_canvasH;
            } else {
                this.rsm_scaledSH = this.rsm_canvasW * 10 / 9;
                this.rsm_scaledSW = this.rsm_canvasW;
            }
        }
        this.native_rows = new int[this.rsm_scaledSH];
        this.native_cols = new int[this.rsm_scaledSW];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.native_rows.length;
        this.native_sw = this.rsm_SH;
        int n7 = this.native_sw > n6 ? this.native_sw : n6;
        for (n = 0; n <= n7; ++n) {
            this.native_rows[n3] = n2++;
            n5 += n6;
            if ((n4 += this.native_sw) > n7) {
                n4 -= n7;
            }
            if (n5 <= n7) continue;
            n5 -= n7;
            ++n3;
        }
        n2 = 0;
        n3 = 0;
        n4 = 0;
        n5 = 0;
        n6 = this.native_cols.length;
        this.native_sw = this.rsm_SW;
        n7 = this.native_sw > n6 ? this.native_sw : n6;
        for (n = 0; n <= n7; ++n) {
            this.native_cols[n3] = n2++;
            n5 += n6;
            if ((n4 += this.native_sw) > n7) {
                n4 -= n7;
            }
            if (n5 <= n7) continue;
            n5 -= n7;
            ++n3;
        }
        if (rsm_scaledScreen) {
            this.rsm_SW = this.rsm_scaledSW;
            this.rsm_SH = this.rsm_scaledSH;
        }
        this.rsm_DX = (this.getWidth() - this.rsm_SW) / 2;
        this.rsm_DY = (this.getHeight() - this.rsm_SH) / 2;
        this.scaledSCR = new int[this.rsm_scaledSW * this.rsm_scaledSH];
        this.cmdMainMenu = new Command("Main Menu", 2, 7);
        this.cmdSwitchScale = new Command("Switch Scale", 2, 8);
        this.cmdSaveState = new Command("Save State", 2, 8);
        this.cmdReset = new Command("Reset", 2, 8);
        this.cmdPause = new Command("Pause", 1, 6);
        this.cmdResume = new Command("Resume", 1, 6);
        this.addCommand(this.cmdSwitchScale);
        this.addCommand(this.cmdMainMenu);
        this.addCommand(this.cmdSaveState);
        this.addCommand(this.cmdReset);
        this.addCommand(this.cmdSwitchScale);
        this.addCommand(this.cmdPause);
        this.setCommandListener(this);
        this.engine._cIV(frame_skip);
        this.engine.rsm_ExtractRomHeader();
        this.engine.rsm_resetGBsystem();
        this.thread = new Thread(this.engine);
        this.thread.start();
    }

    public void rsm_EmptyProc() {
    }

    public void refreshCanvas(int n) {
        int n2;
        this.ms_passed += n;
        if (this.ms_passed >= 60) {
            long l = System.currentTimeMillis();
            this.rsm_fps = 60000 / (int)(l - this.rsm_last_time);
            this.rsm_last_time = l;
            this.ms_passed -= 60;
            this.rsm_message = this.rsm_fps + " fps";
        }
        if (rsm_scaledScreen) {
            boolean bl = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = -1;
            for (int i = 0; i < this.rsm_scaledSH; ++i) {
                if (n5 == this.native_rows[i]) {
                    System.arraycopy(this.scaledSCR, n3 - this.rsm_scaledSW, this.scaledSCR, n3, this.rsm_scaledSW);
                } else {
                    int n6 = 0;
                    for (int j = 0; j < this.rsm_scaledSW; ++j) {
                        this.scaledSCR[n3 + n6] = this.nativeSCR[n4 + this.native_cols[j]];
                        ++n6;
                    }
                    n4 += (this.native_rows[i] - n5) * this.native_sw;
                }
                n5 = this.native_rows[i];
                n3 += this.rsm_scaledSW;
            }
            this.graphics.drawRGB(this.scaledSCR, 0, this.rsm_SW, this.rsm_DX, this.rsm_DY, this.rsm_SW, this.rsm_SH, false);
        } else {
            this.graphics.drawRGB(this.nativeSCR, 0, this.rsm_SW, this.rsm_DX, this.rsm_DY, this.rsm_SW, this.rsm_SH, false);
        }
        this.flushGraphics(this.rsm_DX, this.rsm_DY, this.rsm_SW, this.rsm_SH);
        if (show_fps || this.saving_state) {
            this.graphics.setColor(0);
            this.graphics.fillRect(0, 0, 50, 16);
            if (this.saving_state && this.ms_passed > 0) {
                this.saving_state = false;
            } else {
                this.graphics.setColor(255, 255, 255);
                this.graphics.drawString(this.rsm_message, 1, 0, 20);
            }
            this.flushGraphics(1, 0, 49, 16);
        }
        if (((n2 = this.getKeyStates()) & key_map[0]) != 0) {
            if (!this.m_dZ) {
                this.engine._aIV(4);
                this.m_dZ = true;
            }
        } else if (this.m_dZ) {
            this.engine._bIV(4);
            this.m_dZ = false;
        }
        if ((n2 & key_map[1]) != 0) {
            if (!this.m_eZ) {
                this.engine._aIV(8);
                this.m_eZ = true;
            }
        } else if (this.m_eZ) {
            this.engine._bIV(8);
            this.m_eZ = false;
        }
        if ((n2 & key_map[2]) != 0) {
            if (!this.m_fZ) {
                this.engine._aIV(2);
                this.m_fZ = true;
            }
        } else if (this.m_fZ) {
            this.engine._bIV(2);
            this.m_fZ = false;
        }
        if ((n2 & key_map[3]) != 0) {
            if (!this.m_gZ) {
                this.engine._aIV(1);
                this.m_gZ = true;
            }
        } else if (this.m_gZ) {
            this.engine._bIV(1);
            this.m_gZ = false;
        }
        if ((n2 & key_map[6]) != 0) {
            if (!this.m_hZ) {
                this.engine._aIV(128);
                this.m_hZ = true;
            }
        } else if (this.m_hZ) {
            this.engine._bIV(128);
            this.m_hZ = false;
        }
        if ((n2 & key_map[4]) != 0) {
            if (!this.m_jZ) {
                this.engine._aIV(16);
                this.m_jZ = true;
            }
        } else if (this.m_jZ) {
            this.engine._bIV(16);
            this.m_jZ = false;
        }
        if ((n2 & key_map[5]) != 0) {
            if (!this.m_kZ) {
                this.engine._aIV(32);
                this.m_kZ = true;
            }
        } else if (this.m_kZ) {
            this.engine._bIV(32);
            this.m_kZ = false;
        }
        if ((n2 & key_map[7]) != 0) {
            if (!this.m_iZ) {
                this.engine._aIV(64);
                this.m_iZ = true;
            }
        } else if (this.m_iZ) {
            this.engine._bIV(64);
            this.m_iZ = false;
        }
    }

    public void _aaBIV(byte[] byArray, int n, int n2) {
        block5: {
            int[] nArray;
            block6: {
                block4: {
                    if (n2 < 0 || n2 >= 144) {
                        return;
                    }
                    int[] nArray2 = this.nativeSCR;
                    nArray = this.m_aaI;
                    if (rsm_screenOrientation != 1) break block4;
                    int n3 = 22896 + n2;
                    for (int i = 0; i < 160; ++i) {
                        nArray2[n3 - i * 144] = nArray[byArray[i + n]];
                    }
                    break block5;
                }
                if (rsm_screenOrientation != 2) break block6;
                int n4 = 143 - n2;
                for (int i = 0; i < 160; ++i) {
                    nArray2[i * 144 + n4] = nArray[byArray[i + n]];
                }
                break block5;
            }
            if (rsm_screenOrientation != 0) break block5;
            int n5 = n2 * 160 - n;
            int n6 = 160 + n;
            for (int i = n; i < n6; ++i) {
                nArray2[n5 + i] = nArray[byArray[i]];
            }
        }
    }

    public void _aIIIV(int n, int n2, int n3, int n4) {
        this.m_aaI[n] = ((n2 & 0xFE) << 16) + ((n3 & 0xFE) << 8) + (n4 & 0xFE);
    }

    public byte[] rsm_loadRom4Kbank(int n) {
        try {
            int n2;
            if (n == 0) {
                if (this.m_aInputStream != null) {
                    this.m_aInputStream.close();
                }
                this.m_aInputStream = null;
                this.m_cI = 0;
            }
            if (this.m_aInputStream == null) {
                this.m_aInputStream = this.gb4me.getStream();
            }
            byte[] byArray = new byte[4096];
            int n3 = 0;
            do {
                if ((n2 = this.m_aInputStream.read(byArray, n3, 4096 - n3)) >= 0) continue;
                return null;
            } while ((n3 += n2) < 4096);
            return byArray;
        }
        catch (IOException iOException) {
            System.out.println("load rom error:" + iOException.getMessage());
            return null;
        }
    }

    public byte[][] LoadGameState(int n) {
        byte[][] byArray = new byte[n * 2][4096];
        try {
            RecordEnumeration recordEnumeration;
            int n2;
            RecordStore recordStore = RecordStore.openRecordStore((String)this.rsm_game_name, (boolean)true);
            if (recordStore.getNumRecords() > 0 && recordStore.getRecordSize(n2 = (recordEnumeration = recordStore.enumerateRecords(null, null, false)).nextRecordId()) == n * 8192) {
                byte[] byArray2 = recordStore.getRecord(n2);
                for (int i = 0; i < n * 2; ++i) {
                    for (int j = 0; j < 4096; ++j) {
                        byArray[i][j] = byArray2[i * 4096 + j];
                    }
                }
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("ram_load: " + (Object)((Object)recordStoreException));
        }
        return byArray;
    }

    public void SaveGameState(String string, byte[][] byArray) {
        byte[] byArray2 = new byte[byArray.length * 4096];
        for (int i = 0; i < byArray.length; ++i) {
            for (int j = 0; j < 4096; ++j) {
                byArray2[i * 4096 + j] = byArray[i][j];
            }
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.rsm_game_name, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                int n = recordEnumeration.nextRecordId();
                recordStore.setRecord(n, byArray2, 0, byArray2.length);
            } else {
                recordStore.addRecord(byArray2, 0, byArray2.length);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println("ram_load error:" + (Object)((Object)recordStoreException));
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdMainMenu) {
            this.SaveGameState(this.rsm_game_name, this.engine.rsm_RAM_BANKS);
            this.engine.rsm_stopThread();
            this.gb4me.MainMenu();
        } else if (command == this.cmdSwitchScale) {
            boolean bl = rsm_scaledScreen = !rsm_scaledScreen;
            if (rsm_scaledScreen) {
                this.rsm_SW = this.rsm_scaledSW;
                this.rsm_SH = this.rsm_scaledSH;
            } else if (rsm_screenOrientation == 0) {
                this.rsm_SW = 160;
                this.rsm_SH = 144;
            } else {
                this.rsm_SW = 144;
                this.rsm_SH = 160;
            }
            this.rsm_DX = (this.getWidth() - this.rsm_SW) / 2;
            this.rsm_DY = (this.getHeight() - this.rsm_SH) / 2;
            this.repaint();
        } else if (command == this.cmdSaveState) {
            this.SaveGameState(this.rsm_game_name, this.engine.rsm_RAM_BANKS);
            this.rsm_message = "\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e";
            this.ms_passed = -90;
            this.saving_state = true;
        } else if (command == this.cmdReset) {
            this.engine.rsm_stopThread();
            while (this.thread.isAlive()) {
            }
            this.engine.rsm_resetEngine();
            this.thread = new Thread(this.engine);
            this.thread.start();
            this.rsm_emulationPaused = false;
        } else if (command == this.cmdPause || command == this.cmdResume) {
            boolean bl = this.rsm_emulationPaused = !this.rsm_emulationPaused;
            if (this.rsm_emulationPaused) {
                this.engine.rsm_stopThread();
                this.addCommand(this.cmdResume);
                this.removeCommand(this.cmdPause);
                while (this.thread.isAlive()) {
                }
            } else {
                this.thread = new Thread(this.engine);
                this.thread.start();
                this.addCommand(this.cmdPause);
                this.removeCommand(this.cmdResume);
            }
        }
    }

    static {
        key_map = new int[]{2, 64, 4, 32, 1024, 4096, 256, 2048};
        frame_skip = 3;
    }
}

