/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.jme;

import de.joergjahnke.common.jme.LocalizationSupport;
import de.joergjahnke.common.jme.Settings;
import de.joergjahnke.common.util.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class FileSystemHandler {
    public static final String DELTA_FILE_EXTENSION = ".dlt";
    protected static final String SETTING_PROGRAMS = "Programs";
    private final Logger logger;
    private final Settings settings;
    private final Vector supportedExtensions;

    public FileSystemHandler(Logger logger, Vector supportedExtensions, Settings settings) {
        this.logger = logger;
        this.supportedExtensions = supportedExtensions;
        this.settings = settings;
    }

    public Hashtable getCachedProgramList() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            int ni1;
            String prgsString = this.settings.getString(SETTING_PROGRAMS);
            int index = 0;
            while (index < prgsString.length() && (ni1 = prgsString.indexOf("\n", index)) >= 0) {
                String name = prgsString.substring(index, ni1);
                int ni2 = prgsString.indexOf("\n", ni1 + 1);
                if (ni2 < 0) {
                    ni2 = prgsString.length();
                }
                String url = prgsString.substring(ni1 + 1, ni2);
                index = ni2 + 1;
                result.put(name, url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void readProgramListFromFileSystem(final String fileSearchStartDir, final Hashtable programs, final Display display) {
        Thread fileCrawler = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (null != FileSystemHandler.this.logger) {
                    FileSystemHandler.this.logger.info("Scanning local file system for files...");
                }
                StringBuffer prgsString = new StringBuffer();
                int found = 0;
                try {
                    Vector<String> directories = new Vector<String>();
                    if (fileSearchStartDir != null) {
                        directories.addElement("file:///" + fileSearchStartDir);
                    } else {
                        Enumeration en = FileSystemRegistry.listRoots();
                        while (en.hasMoreElements()) {
                            directories.addElement("file:///" + en.nextElement());
                        }
                    }
                    for (int i = 0; i < directories.size(); ++i) {
                        String directory = directories.elementAt(i).toString();
                        try {
                            FileConnection dirConn = (FileConnection)Connector.open((String)directory, (int)1);
                            if (dirConn.exists()) {
                                Enumeration en = dirConn.list();
                                while (en.hasMoreElements()) {
                                    String extension;
                                    String url = dirConn.getURL() + en.nextElement();
                                    if (url.endsWith("/")) {
                                        directories.addElement(url);
                                        continue;
                                    }
                                    String name = url.indexOf(47) > 0 ? url.substring(url.lastIndexOf(47) + 1) : url;
                                    String string = extension = name.indexOf(46) > 0 ? name.substring(name.lastIndexOf(46) + 1).toLowerCase() : "";
                                    if (!FileSystemHandler.this.supportedExtensions.contains(extension) && !("." + extension).equals(FileSystemHandler.DELTA_FILE_EXTENSION)) continue;
                                    programs.put(name, url);
                                    ++found;
                                    if (prgsString.length() > 0) {
                                        prgsString.append("\n");
                                    }
                                    prgsString.append(name);
                                    prgsString.append("\n");
                                    prgsString.append(url);
                                }
                            }
                            dirConn.close();
                            continue;
                        }
                        catch (Exception e) {
                            if (null == FileSystemHandler.this.logger) continue;
                            FileSystemHandler.this.logger.info("Scanning of local directory '" + directory + "' caused an exception: " + e.getMessage() + "! Proceeding with next directory.");
                        }
                    }
                    if (null != FileSystemHandler.this.logger) {
                        FileSystemHandler.this.logger.info("Scanning of local file system finished, " + found + " file(s) found.");
                    }
                }
                catch (Exception e) {
                    if (null != FileSystemHandler.this.logger) {
                        FileSystemHandler.this.logger.warning("An error occurred while searching for files in the local file system! Search aborted after " + found + " file(s) were found.");
                    }
                    e.printStackTrace();
                }
                finally {
                    display.setCurrent((Displayable)new Alert(LocalizationSupport.getMessage("SearchFinished"), LocalizationSupport.getMessage("FoundNFiles1") + found + " " + LocalizationSupport.getMessage("FoundNFiles2"), null, AlertType.INFO));
                }
                if (prgsString.length() > 0) {
                    try {
                        FileSystemHandler.this.settings.setString(FileSystemHandler.SETTING_PROGRAMS, prgsString.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        fileCrawler.start();
    }

    public void saveDelta(String currentImage, byte[] delta) throws IOException {
        String deltaFilename = currentImage + DELTA_FILE_EXTENSION;
        FileConnection fileConn = (FileConnection)Connector.open((String)deltaFilename, (int)2);
        if (!fileConn.exists()) {
            fileConn.create();
        } else {
            fileConn.truncate(0L);
        }
        OutputStream out = fileConn.openOutputStream();
        for (int i = 0; i < delta.length; ++i) {
            out.write(delta[i]);
        }
        fileConn.close();
        this.logger.info("Saved changes to file '" + deltaFilename + "'!");
    }
}

